/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.rununit;

import com.veryant.cobol.data.CobolString;
import com.veryant.cobol.data.IMemory;
import com.veryant.cobol.exceptions.COBOLRuntimeException;
import com.veryant.cobol.rununit.ICallable;
import com.veryant.cobol.rununit.ModuleInfo;
import com.veryant.cobol.rununit.NativeInterop;
import com.veryant.cobol.rununit.RunUnit;
import com.veryant.cobol.rununit.RunUnitThread;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class EnvironmentBase {
    private static final HashMap<String, Long> LOADED_NATIVE_LIBRARY = new HashMap();
    private static final HashMap<String, Long> LOADED_NATIVE_ENTRYPOINTS = new HashMap();
    private static String[] commandLine = new String[0];
    private static final ConcurrentHashMap<Thread, RunUnitThread> RUN_UNITS = new ConcurrentHashMap();

    public static void storeCommandLine(String[] stringArray) {
        commandLine = stringArray;
    }

    private static IMemory getLocalMemory(RunUnitThread runUnitThread) {
        return runUnitThread.peekCallStack().getLocalMemory();
    }

    private static void setLocalMemory(RunUnitThread runUnitThread, IMemory iMemory) {
        runUnitThread.peekCallStack().setLocalMemory(iMemory);
    }

    public static IMemory allocStack(RunUnitThread runUnitThread, Class<? extends IMemory> clazz, int n2) {
        IMemory iMemory = EnvironmentBase.getLocalMemory(runUnitThread);
        if (iMemory == null) {
            try {
                iMemory = clazz.getConstructor(Integer.TYPE).newInstance(n2);
                EnvironmentBase.setLocalMemory(runUnitThread, iMemory);
            }
            catch (Exception exception) {
                throw new COBOLRuntimeException("Local-storage allocation error");
            }
        }
        return iMemory;
    }

    private static synchronized RunUnitThread getRunUnitThread(Thread thread) {
        RunUnitThread runUnitThread = RUN_UNITS.get(thread);
        if (runUnitThread == null) {
            runUnitThread = new RunUnitThread(new RunUnit(commandLine), thread);
            RUN_UNITS.put(thread, runUnitThread);
        }
        return runUnitThread;
    }

    private static RunUnitThread getCurrentRunUnitThread() {
        return EnvironmentBase.getRunUnitThread(Thread.currentThread());
    }

    public static RunUnit getRunUnit() {
        return EnvironmentBase.getCurrentRunUnitThread().getRunUnit();
    }

    public static RunUnitThread init() {
        RunUnitThread runUnitThread = EnvironmentBase.getCurrentRunUnitThread();
        return runUnitThread;
    }

    private static void destroy(RunUnitThread runUnitThread) {
        runUnitThread.end();
        RUN_UNITS.remove(runUnitThread.getThread());
    }

    public static ICallable load(Class<? extends ICallable> clazz) {
        RunUnitThread runUnitThread = EnvironmentBase.init();
        ICallable iCallable = runUnitThread.getRunUnit().getInstance(clazz);
        return iCallable;
    }

    public static void cancel(RunUnitThread runUnitThread, CobolString cobolString) {
        EnvironmentBase.cancel(runUnitThread, cobolString.toString());
    }

    public static void cancel(RunUnitThread runUnitThread, String string) {
        Long l2 = LOADED_NATIVE_LIBRARY.get(string);
        if (l2 != null) {
            String[] stringArray = NativeInterop.close(l2);
            LOADED_NATIVE_LIBRARY.remove(string);
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    LOADED_NATIVE_ENTRYPOINTS.remove(string2);
                }
            }
            return;
        }
        ModuleInfo moduleInfo = runUnitThread.getRunUnit().getLoadedModuleInfo(string);
        if (moduleInfo != null) {
            moduleInfo.getInstance().cancel();
        }
    }

    protected static long cobolCall(RunUnitThread runUnitThread, String string, Long ... longArray) {
        try {
            ModuleInfo moduleInfo = runUnitThread.getRunUnit().getModuleInfo(string);
            return (Long)moduleInfo.getEntryPoint().getEntry().invoke((Object)moduleInfo.getInstance(), (Object[])longArray);
        }
        catch (ClassNotFoundException | InvocationTargetException reflectiveOperationException) {
            throw new COBOLRuntimeException("Can't load cobol program " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new COBOLRuntimeException("Can't access cobol program " + string);
        }
    }

    protected static long callChain(String string, Function<Long, Long> function, Function<String, Long> function2) {
        Long l2 = LOADED_NATIVE_ENTRYPOINTS.get(string);
        if (l2 != null) {
            return function.apply(l2);
        }
        try {
            return function2.apply(EnvironmentBase.translateToValidJavaIdentifier(string));
        }
        catch (COBOLRuntimeException cOBOLRuntimeException) {
            long l3 = NativeInterop.findSymbol(string);
            if (l3 != 0L) {
                LOADED_NATIVE_ENTRYPOINTS.put(string, l3);
                return function.apply(l3);
            }
            if (LOADED_NATIVE_LIBRARY.containsKey(string)) {
                return 0L;
            }
            long l4 = NativeInterop.open(string);
            if (l4 != 0L) {
                LOADED_NATIVE_LIBRARY.put(string, l4);
                return 0L;
            }
            throw new COBOLRuntimeException("Can't load cobol program " + string);
        }
    }

    public static ICallable load(RunUnitThread runUnitThread, Class<? extends ICallable> clazz) {
        ICallable iCallable = runUnitThread.getRunUnit().getInstance(clazz);
        return iCallable;
    }

    public static void enter(RunUnitThread runUnitThread, ICallable iCallable) {
        runUnitThread.pushCallStack(iCallable.getClass(), iCallable);
    }

    public static void exit(RunUnitThread runUnitThread, ICallable iCallable) {
        if (runUnitThread.popCallStack()) {
            EnvironmentBase.destroy(runUnitThread);
        }
    }

    public static void stop(RunUnitThread runUnitThread, long l2) {
        System.exit((int)l2);
    }

    public static String translateToValidJavaIdentifier(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        char[] cArray = string.toUpperCase().toCharArray();
        if (!Character.isJavaIdentifierStart(cArray[0])) {
            cArray[0] = 95;
        }
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            if (Character.isJavaIdentifierPart(cArray[i2])) continue;
            cArray[i2] = 95;
        }
        return new String(cArray);
    }
}

