/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.rununit;

import com.veryant.cobol.annotations.CCSID;
import com.veryant.cobol.annotations.Encoding;
import com.veryant.cobol.annotations.Entrypoint;
import com.veryant.cobol.annotations.MemoryModel;
import com.veryant.cobol.converters.Raw;
import com.veryant.cobol.data.CobolDataReference;
import com.veryant.cobol.data.IMemory;
import com.veryant.cobol.data.Model;
import com.veryant.cobol.exceptions.COBOLRuntimeException;
import com.veryant.cobol.rununit.EntryPoint;
import com.veryant.cobol.rununit.ICallable;
import com.veryant.cobol.rununit.ModuleInfo;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public class RunUnit {
    private static final AtomicLong GID = new AtomicLong(1L);
    private final long id = GID.getAndIncrement();
    private Model runtimeMemoryModel;
    private Charset runtimeEncoding;
    private String[] arguments;
    private static final long VIRT_SPACE_DATA_ADDR = 0x10000000L;
    private final TreeMap<Long, IMemory> virtualMemory = new TreeMap();
    private final HashMap<IMemory, Long> virtualAddresses = new HashMap();
    private long nextAddress = 0x10000000L;
    private final HashMap<String, ModuleInfo> callables = new HashMap();
    private byte[] lastFileError = new byte[0];

    public long getId() {
        return this.id;
    }

    public boolean isNativeMode() {
        return this.runtimeMemoryModel == Model.Native;
    }

    public Charset getRuntimeEncoding() {
        return this.runtimeEncoding;
    }

    private void processCommandLine(String[] stringArray) {
        this.arguments = stringArray;
    }

    private long register(IMemory iMemory) {
        if (this.virtualAddresses.containsKey(iMemory)) {
            return this.virtualAddresses.get(iMemory);
        }
        long l2 = iMemory.getBaseAddress();
        if (l2 == 0L) {
            l2 = this.nextAddress;
            this.nextAddress += (long)iMemory.getSize();
        }
        this.virtualAddresses.put(iMemory, l2);
        this.virtualMemory.put(l2, iMemory);
        return l2;
    }

    public long getAddress(IMemory iMemory, int n2) {
        return this.register(iMemory) + (long)n2;
    }

    public CobolDataReference getMemory(long l2) {
        Map.Entry<Long, IMemory> entry = this.virtualMemory.floorEntry(l2);
        IMemory iMemory = entry.getValue();
        int n2 = (int)(l2 - entry.getKey());
        return new CobolDataReference(iMemory, n2, iMemory.getSize() - n2);
    }

    public byte[] readDirectBytes(long l2, int n2) {
        CobolDataReference cobolDataReference = this.getMemory(l2);
        return cobolDataReference.getMemory().toArray(cobolDataReference.getOffset(), n2);
    }

    public byte[] readDirectBytesWithTrailingBytes(long l2, int n2, int n3) {
        CobolDataReference cobolDataReference = this.getMemory(l2);
        return cobolDataReference.getMemory().toArrayWithTrailingBytes(cobolDataReference.getOffset(), n2, n3);
    }

    public byte[] readDirectBytesWithLeadingBytes(long l2, int n2, int n3) {
        CobolDataReference cobolDataReference = this.getMemory(l2);
        return cobolDataReference.getMemory().toArrayWithLeadingBytes(cobolDataReference.getOffset(), n2, n3);
    }

    public void writeDirectBytes(byte[] byArray, long l2, int n2, int n3) {
        CobolDataReference cobolDataReference = this.getMemory(l2);
        int n4 = byArray.length - n2;
        if (n3 > n4) {
            n3 = n4;
        }
        cobolDataReference.getMemory().copy(byArray, n2, cobolDataReference.getOffset(), n3);
    }

    public void writeDirectBytes(byte[] byArray, long l2, int n2) {
        CobolDataReference cobolDataReference = this.getMemory(l2);
        int n3 = byArray.length;
        if (n3 > n2) {
            n3 = n2;
        }
        cobolDataReference.getMemory().copy(byArray, 0, cobolDataReference.getOffset(), n3);
        int n4 = n2 - n3;
        if (n4 > 0) {
            Raw.initMemory(cobolDataReference.getMemory(), cobolDataReference.getOffset() + n3, n4, (byte)0);
        }
    }

    public void writeDirectBytes(byte[] byArray, long l2) {
        this.writeDirectBytes(byArray, l2, byArray.length);
    }

    public String readDirectString(long l2, int n2) {
        byte[] byArray = this.readDirectBytes(l2, n2);
        return new String(byArray, this.getRuntimeEncoding());
    }

    public void writeDirectString(String string, long l2, int n2) {
        byte[] byArray = string.getBytes(this.getRuntimeEncoding());
        this.writeDirectBytes(byArray, l2, n2);
    }

    private static EntryPoint[] getEntryPoints(Class<? extends ICallable> clazz) {
        ArrayList<EntryPoint> arrayList = new ArrayList<EntryPoint>(30);
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Entrypoint.class)) continue;
            arrayList.add(new EntryPoint(method.getAnnotation(Entrypoint.class).value(), method));
        }
        return arrayList.toArray(new EntryPoint[0]);
    }

    private static int getCcsid(Class<? extends ICallable> clazz) {
        CCSID cCSID = clazz.getDeclaredAnnotation(CCSID.class);
        if (cCSID != null) {
            return cCSID.value();
        }
        return 0;
    }

    private static Charset getEncoding(Class<? extends ICallable> clazz) {
        Encoding encoding = clazz.getDeclaredAnnotation(Encoding.class);
        if (encoding != null) {
            return Charset.forName(encoding.value());
        }
        return null;
    }

    private static Model getModel(Class<? extends ICallable> clazz) {
        MemoryModel memoryModel = clazz.getDeclaredAnnotation(MemoryModel.class);
        if (memoryModel != null) {
            return memoryModel.value();
        }
        return Model.Target;
    }

    public ModuleInfo getLoadedModuleInfo(String string) {
        return this.callables.get(string);
    }

    public ModuleInfo getModuleInfo(String string) throws ClassNotFoundException {
        if (!this.callables.containsKey(string)) {
            Class<?> clazz = Class.forName(string);
            Class<ICallable> clazz2 = clazz.asSubclass(ICallable.class);
            this.newInstance(clazz2);
        }
        return this.callables.get(string);
    }

    public ICallable getInstance(Class<? extends ICallable> clazz) {
        String string = clazz.getName();
        if (this.callables.containsKey(string)) {
            return this.callables.get(string).getInstance();
        }
        return this.newInstance(clazz);
    }

    private ICallable newInstance(Class<? extends ICallable> clazz) {
        try {
            ICallable iCallable = clazz.newInstance();
            Model model = RunUnit.getModel(clazz);
            if (this.callables.isEmpty()) {
                this.runtimeMemoryModel = model;
            } else if (this.runtimeMemoryModel != model && model != Model.Target) {
                throw new COBOLRuntimeException("Mixed memory-model not allowed");
            }
            int n2 = RunUnit.getCcsid(clazz);
            Charset charset = RunUnit.getEncoding(clazz);
            if (this.runtimeEncoding == null) {
                this.runtimeEncoding = charset;
            } else if (charset != null && !charset.equals(this.runtimeEncoding)) {
                throw new COBOLRuntimeException("Mixed runtime-encoding detected");
            }
            for (EntryPoint entryPoint : RunUnit.getEntryPoints(clazz)) {
                this.callables.put(entryPoint.getName(), new ModuleInfo(clazz, iCallable, n2, charset, model, entryPoint));
            }
            return iCallable;
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new COBOLRuntimeException("Can't load cobol program " + clazz.getName());
        }
    }

    public byte[] getLastFileError() {
        return this.lastFileError;
    }

    public void setLastFileError(byte[] byArray) {
        this.lastFileError = byArray;
    }

    public RunUnit(String[] stringArray) {
        this.processCommandLine(stringArray);
    }
}

