/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.internals.IConfigValidator;

public class ConfigEntry {
    private static final String BASE_PACKAGE = "com.veryant.vision4j";
    private final String name;
    private int integerValue;
    private int defaultIntegerValue;
    private IConfigValidator configValidator;
    private boolean on;
    private boolean defaultBooleanValue;

    public boolean isOff() {
        return !this.on;
    }

    public boolean is(int n2) {
        return this.integerValue == n2;
    }

    private int stringToInteger(String string) {
        if (string == null) {
            return this.defaultIntegerValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.defaultIntegerValue;
        }
    }

    private boolean stringToBoolean(String string) {
        if (string == null) {
            return this.defaultBooleanValue;
        }
        if (string.length() == 1) {
            char c2 = string.charAt(0);
            switch (c2) {
                case '1': 
                case 'T': 
                case 'Y': 
                case 't': 
                case 'y': {
                    return true;
                }
                case '0': 
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    return false;
                }
            }
            return this.defaultBooleanValue;
        }
        if ("on".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string)) {
            return true;
        }
        if ("off".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            return false;
        }
        return this.defaultBooleanValue;
    }

    public void parse(String string) {
        if (string != null) {
            int n2 = this.stringToInteger(string);
            this.integerValue = this.configValidator != null ? this.configValidator.validate(n2) : n2;
            this.on = this.stringToBoolean(string);
        }
    }

    public void set(int n2) {
        this.integerValue = this.configValidator != null ? this.configValidator.validate(n2) : n2;
        this.on = this.integerValue != 0;
    }

    public void set(boolean bl) {
        this.on = bl;
        int n2 = bl ? 1 : 0;
        this.integerValue = this.configValidator != null ? this.configValidator.validate(n2) : n2;
    }

    public ConfigEntry(String string, int n2, IConfigValidator iConfigValidator) {
        this.name = string;
        this.defaultIntegerValue = n2;
        this.configValidator = iConfigValidator;
        String string2 = System.getProperty("com.veryant.vision4j." + string);
        if (string2 == null) {
            this.set(n2);
        } else {
            this.set(this.stringToInteger(string2));
        }
    }

    public ConfigEntry(String string, boolean bl) {
        this.name = string;
        this.defaultBooleanValue = bl;
        String string2 = System.getProperty("com.veryant.vision4j." + string);
        this.set(string2 == null ? bl : this.stringToBoolean(string2));
    }

    public String getName() {
        return this.name;
    }

    public int getIntegerValue() {
        return this.integerValue;
    }

    public boolean isOn() {
        return this.on;
    }
}

