/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.FileSystemCache;
import com.veryant.vision4j.file.IndexFile;
import com.veryant.vision4j.file.SegmentedFile;
import com.veryant.vision4j.file.internals.Block;
import com.veryant.vision4j.file.internals.FileAddress;
import com.veryant.vision4j.file.internals.FileDescriptor;
import com.veryant.vision4j.file.internals.Lock;
import com.veryant.vision4j.file.internals.LogicalAttributes;
import com.veryant.vision4j.file.internals.PhysicalAttributes;
import com.veryant.vision4j.file.internals.PointerState;

class File
extends SegmentedFile {
    private int id;
    private final String name;
    private final int openMode;
    private boolean pendingTransaction;
    private final FileSystemCache fileSystemCache;
    private final int version;
    private final PhysicalAttributes physicalAttributes;
    private final LogicalAttributes logicalAttributes;
    private final short recordOverhead;
    private final long maxSegmentSize;
    private final boolean rollbackable;
    private final int blockSize;
    private boolean headerLocked;
    private boolean unlockedHeaderRead;
    private final Block headerCache;
    private PointerState pointerState = PointerState.NO_CUR_REC;
    private boolean currentIsNext;
    private int currentKeyNum;
    private long currentUniqueId;
    private final Block currentKey = new Block(252);
    private final Block currentPrimaryKey = new Block(250);
    private final FileAddress currentRecord = new FileAddress();
    private final FileAddress currentNode = new FileAddress();
    private final FileAddress lastReadBlock = new FileAddress();
    private long lastReadTreeVersion;
    private final FileAddress[] readNextAddressesCache = new FileAddress[10];
    private final byte[] temporaryRecord;
    private final Block compressedRecord;
    private final Block rewrittenRecord;
    private final Block record;
    private final Block loadedNode;
    private long totalRecords;
    private long deletedRecords;
    private long abandonedRecords;
    private int freeFailures;
    private int openCounter;
    private long treeVersion;
    private long keyRootVersion;
    private long nextUniqueId;
    private int findKeyNum;
    private final Block foundKey = new Block(252);
    private boolean foundExactMatch;
    private int keyEntryOffset;
    private int keyEntryOverhead;
    private final FileAddress[] nodeAddresses = new FileAddress[30];
    private final FileAddress nextRec = new FileAddress();
    private final FileAddress firstRec = new FileAddress();
    private final FileAddress freeRec = new FileAddress();
    private final FileAddress abandonedRec = new FileAddress();
    private final FileAddress firstNode = new FileAddress();
    private final FileAddress freeNode = new FileAddress();
    private final Lock[] locks;
    private final IndexFile indexFile;
    private long usedNodes;
    private long freeNodes;
    private long nodeUsage;
    private final Block collate;

    public long incCurrentUniqueId() {
        return ++this.currentUniqueId;
    }

    public long incTotalRecords() {
        return ++this.totalRecords;
    }

    public long decTotalRecords() {
        return --this.totalRecords;
    }

    public long incDeletedRecords() {
        return ++this.deletedRecords;
    }

    public long decDeletedRecords() {
        return --this.deletedRecords;
    }

    public long incAbandonedRecords() {
        return ++this.abandonedRecords;
    }

    public int incFreeFailures() {
        return ++this.freeFailures;
    }

    public long incOpenCounter() {
        return ++this.openCounter;
    }

    public long decOpenCounter() {
        return --this.openCounter;
    }

    public long incTreeVersion() {
        return ++this.treeVersion;
    }

    public long incKeyRootVersion() {
        return ++this.keyRootVersion;
    }

    public long incNextUniqueId() {
        return ++this.nextUniqueId;
    }

    public long incUsedNodes() {
        return ++this.usedNodes;
    }

    public long decUsedNodes() {
        return --this.usedNodes;
    }

    public long incFreeNodes() {
        return ++this.freeNodes;
    }

    public long decFreeNodes() {
        return --this.freeNodes;
    }

    public long incNodeUsage(long l2) {
        return this.nodeUsage += l2;
    }

    public long decNodeUsage(long l2) {
        return this.nodeUsage -= l2;
    }

    public byte[] copyOfCollate() {
        return this.collate.copy().getBytes();
    }

    public boolean hasCollate() {
        return this.collate != null;
    }

    public byte collate(int n2) {
        return this.collate.get8(n2);
    }

    File(String string, int n2, int n3, Block block, PhysicalAttributes physicalAttributes, LogicalAttributes logicalAttributes, FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, Block block2, short s2, long l2, int n4, boolean bl, FileSystemCache fileSystemCache) {
        this.name = string;
        this.openMode = n2;
        this.version = n3;
        this.headerCache = block;
        this.physicalAttributes = physicalAttributes;
        this.logicalAttributes = logicalAttributes;
        this.blockSize = physicalAttributes.getBlockingFactor() * 512;
        this.addSegment(fileDescriptor);
        if (fileDescriptor2 != null) {
            this.indexFile = new IndexFile();
            this.indexFile.addSegment(fileDescriptor2);
        } else {
            this.indexFile = null;
        }
        this.collate = block2;
        this.recordOverhead = s2;
        this.maxSegmentSize = l2;
        this.locks = new Lock[n4];
        this.rollbackable = bl;
        this.fileSystemCache = fileSystemCache;
        this.record = new Block(logicalAttributes.getMaxRecordSize() + s2);
        this.rewrittenRecord = new Block(logicalAttributes.getMaxRecordSize() + s2);
        this.compressedRecord = new Block(logicalAttributes.getMaxRecordSize() + s2 + 16);
        this.temporaryRecord = new byte[logicalAttributes.getMaxRecordSize()];
        this.loadedNode = new Block(this.blockSize);
    }

    public String toString() {
        return "name: '" + this.name + '\'' + ", version: " + this.version + ", record overhead: " + this.recordOverhead + ", max segment size: " + this.maxSegmentSize + ", total records: " + this.totalRecords + ", deleted records: " + this.deletedRecords + ", abandoned records: " + this.abandonedRecords + ", free failures: " + this.freeFailures + ", open counter: " + this.openCounter + ", internal version: " + this.treeVersion + ", keys root version: " + this.keyRootVersion + ", next unique id: " + this.nextUniqueId + ", size: " + this.getFileSize() + ", used nodes: " + this.usedNodes + ", free nodes: " + this.freeNodes + ", node usage: " + this.nodeUsage + " bytes";
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n2) {
        this.id = n2;
    }

    public String getName() {
        return this.name;
    }

    public int getOpenMode() {
        return this.openMode;
    }

    public boolean isPendingTransaction() {
        return this.pendingTransaction;
    }

    public void setPendingTransaction(boolean bl) {
        this.pendingTransaction = bl;
    }

    public FileSystemCache getFileSystemCache() {
        return this.fileSystemCache;
    }

    public int getVersion() {
        return this.version;
    }

    public PhysicalAttributes getPhysicalAttributes() {
        return this.physicalAttributes;
    }

    public LogicalAttributes getLogicalAttributes() {
        return this.logicalAttributes;
    }

    public short getRecordOverhead() {
        return this.recordOverhead;
    }

    public long getMaxSegmentSize() {
        return this.maxSegmentSize;
    }

    public boolean isRollbackable() {
        return this.rollbackable;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public boolean isHeaderLocked() {
        return this.headerLocked;
    }

    public void setHeaderLocked(boolean bl) {
        this.headerLocked = bl;
    }

    public boolean isUnlockedHeaderRead() {
        return this.unlockedHeaderRead;
    }

    public void setUnlockedHeaderRead(boolean bl) {
        this.unlockedHeaderRead = bl;
    }

    public Block getHeaderCache() {
        return this.headerCache;
    }

    public PointerState getPointerState() {
        return this.pointerState;
    }

    public void setPointerState(PointerState pointerState) {
        this.pointerState = pointerState;
    }

    public boolean isCurrentIsNext() {
        return this.currentIsNext;
    }

    public void setCurrentIsNext(boolean bl) {
        this.currentIsNext = bl;
    }

    public int getCurrentKeyNum() {
        return this.currentKeyNum;
    }

    public void setCurrentKeyNum(int n2) {
        this.currentKeyNum = n2;
    }

    public long getCurrentUniqueId() {
        return this.currentUniqueId;
    }

    public void setCurrentUniqueId(long l2) {
        this.currentUniqueId = l2;
    }

    public Block getCurrentKey() {
        return this.currentKey;
    }

    public Block getCurrentPrimaryKey() {
        return this.currentPrimaryKey;
    }

    public FileAddress getCurrentRecord() {
        return this.currentRecord;
    }

    public FileAddress getCurrentNode() {
        return this.currentNode;
    }

    public FileAddress getLastReadBlock() {
        return this.lastReadBlock;
    }

    public long getLastReadTreeVersion() {
        return this.lastReadTreeVersion;
    }

    public void setLastReadTreeVersion(long l2) {
        this.lastReadTreeVersion = l2;
    }

    public FileAddress[] getReadNextAddressesCache() {
        return this.readNextAddressesCache;
    }

    public byte[] getTemporaryRecord() {
        return this.temporaryRecord;
    }

    public Block getCompressedRecord() {
        return this.compressedRecord;
    }

    public Block getRewrittenRecord() {
        return this.rewrittenRecord;
    }

    public Block getRecord() {
        return this.record;
    }

    public Block getLoadedNode() {
        return this.loadedNode;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(long l2) {
        this.totalRecords = l2;
    }

    public long getDeletedRecords() {
        return this.deletedRecords;
    }

    public void setDeletedRecords(long l2) {
        this.deletedRecords = l2;
    }

    public long getAbandonedRecords() {
        return this.abandonedRecords;
    }

    public void setAbandonedRecords(long l2) {
        this.abandonedRecords = l2;
    }

    public int getFreeFailures() {
        return this.freeFailures;
    }

    public void setFreeFailures(int n2) {
        this.freeFailures = n2;
    }

    public int getOpenCounter() {
        return this.openCounter;
    }

    public void setOpenCounter(int n2) {
        this.openCounter = n2;
    }

    public long getTreeVersion() {
        return this.treeVersion;
    }

    public void setTreeVersion(long l2) {
        this.treeVersion = l2;
    }

    public long getKeyRootVersion() {
        return this.keyRootVersion;
    }

    public void setKeyRootVersion(long l2) {
        this.keyRootVersion = l2;
    }

    public long getNextUniqueId() {
        return this.nextUniqueId;
    }

    public void setNextUniqueId(long l2) {
        this.nextUniqueId = l2;
    }

    public int getFindKeyNum() {
        return this.findKeyNum;
    }

    public void setFindKeyNum(int n2) {
        this.findKeyNum = n2;
    }

    public Block getFoundKey() {
        return this.foundKey;
    }

    public boolean isFoundExactMatch() {
        return this.foundExactMatch;
    }

    public void setFoundExactMatch(boolean bl) {
        this.foundExactMatch = bl;
    }

    public int getKeyEntryOffset() {
        return this.keyEntryOffset;
    }

    public void setKeyEntryOffset(int n2) {
        this.keyEntryOffset = n2;
    }

    public int getKeyEntryOverhead() {
        return this.keyEntryOverhead;
    }

    public void setKeyEntryOverhead(int n2) {
        this.keyEntryOverhead = n2;
    }

    public FileAddress[] getNodeAddresses() {
        return this.nodeAddresses;
    }

    public FileAddress getNextRec() {
        return this.nextRec;
    }

    public FileAddress getFirstRec() {
        return this.firstRec;
    }

    public FileAddress getFreeRec() {
        return this.freeRec;
    }

    public FileAddress getAbandonedRec() {
        return this.abandonedRec;
    }

    public FileAddress getFirstNode() {
        return this.firstNode;
    }

    public FileAddress getFreeNode() {
        return this.freeNode;
    }

    public Lock[] getLocks() {
        return this.locks;
    }

    public IndexFile getIndexFile() {
        return this.indexFile;
    }

    public long getUsedNodes() {
        return this.usedNodes;
    }

    public void setUsedNodes(long l2) {
        this.usedNodes = l2;
    }

    public long getFreeNodes() {
        return this.freeNodes;
    }

    public void setFreeNodes(long l2) {
        this.freeNodes = l2;
    }

    public long getNodeUsage() {
        return this.nodeUsage;
    }

    public void setNodeUsage(long l2) {
        this.nodeUsage = l2;
    }
}

