/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.Config;
import com.veryant.vision4j.file.Constants;
import com.veryant.vision4j.file.Status;
import com.veryant.vision4j.file.internals.Block;
import com.veryant.vision4j.file.internals.BufferBlock;
import com.veryant.vision4j.file.internals.CacheDataType;
import com.veryant.vision4j.file.internals.CacheResult;
import com.veryant.vision4j.file.internals.FileDescriptor;
import com.veryant.vision4j.file.internals.ReadAheadBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FileSystemCache
implements Constants {
    private final Status status;
    private final int numBuffers;
    private final boolean buffersNodesOnly;
    private boolean readAhead;
    private final ReadAheadBuffer readAheadBuffer = new ReadAheadBuffer();
    private long buffersVersion;
    private final List<HashMap<Long, BufferBlock>> buffersMap = new ArrayList<HashMap<Long, BufferBlock>>();
    private final BufferBlock[] buffers;
    private int mruHead;
    private int lruHead;
    private int fileDescriptorCounter = 0;

    private void addIntoMap(BufferBlock bufferBlock) {
        this.buffersMap.get(bufferBlock.getFileDescriptorId() - 1).put(bufferBlock.getBlockNumber(), bufferBlock);
    }

    private void deleteFromMap(BufferBlock bufferBlock) {
        this.buffersMap.get(bufferBlock.getFileDescriptorId() - 1).remove(bufferBlock.getBlockNumber());
    }

    private BufferBlock getFromMap(int n2, long l2) {
        return this.buffersMap.get(n2 - 1).get(l2);
    }

    private boolean lookupMap(int n2, long l2) {
        return this.buffersMap.get(n2 - 1).containsKey(l2);
    }

    private static long sectorModule(long l2) {
        return l2 & 0x1FFL;
    }

    private static boolean notAlignedRegion(long l2, int n2) {
        return FileSystemCache.sectorModule(l2) != 0L || FileSystemCache.sectorModule(n2) != 0L;
    }

    private CacheResult isCachedRegion(FileDescriptor fileDescriptor, long l2, int n2) {
        int n3;
        long l3 = l2 >> 9;
        int n4 = (int)FileSystemCache.sectorModule(l2);
        int n5 = 0;
        int n6 = 0;
        for (int i2 = n2; i2 > 0; i2 -= n3) {
            n3 = 512 - n4;
            if (n3 > i2) {
                n3 = i2;
            }
            if (this.lookupMap(fileDescriptor.getId(), l3)) {
                ++n5;
            }
            ++n6;
            ++l3;
            n4 = 0;
        }
        if (n5 == 0) {
            return CacheResult.NONE;
        }
        if (n5 < n6) {
            return CacheResult.PARTIAL;
        }
        return CacheResult.FULL;
    }

    private int getCachedRegion(FileDescriptor fileDescriptor, long l2, int n2, Block block, int n3) {
        int n4;
        long l3 = l2 >> 9;
        int n5 = (int)FileSystemCache.sectorModule(l2);
        for (int i2 = n2; i2 > 0; i2 -= n4) {
            BufferBlock bufferBlock;
            n4 = 512 - n5;
            if (n4 > i2) {
                n4 = i2;
            }
            if ((bufferBlock = this.getFromMap(fileDescriptor.getId(), l3)) == null) {
                return -1;
            }
            this.bumpBuffer(bufferBlock.getIndex());
            block.copy(n3, bufferBlock.getBlock(), n5, n4);
            n3 += n4;
            ++l3;
            n5 = 0;
        }
        return n2;
    }

    private void bumpBuffer(int n2) {
        if (n2 == this.mruHead) {
            return;
        }
        if (n2 == this.lruHead) {
            this.lruHead = this.buffers[n2].getLruLink();
            this.buffers[this.lruHead].setMruLink(-1);
        } else {
            int n3 = this.buffers[n2].getLruLink();
            int n4 = this.buffers[n2].getMruLink();
            this.buffers[n3].setMruLink(n4);
            this.buffers[n4].setLruLink(n3);
        }
        this.buffers[n2].setMruLink(this.mruHead);
        this.buffers[n2].setLruLink(-1);
        this.buffers[this.mruHead].setLruLink(n2);
        this.mruHead = n2;
    }

    private void ignoreBuffer(int n2) {
        if (n2 == this.lruHead) {
            return;
        }
        if (n2 == this.mruHead) {
            this.mruHead = this.buffers[n2].getMruLink();
            this.buffers[this.mruHead].setLruLink(-1);
        } else {
            int n3 = this.buffers[n2].getLruLink();
            int n4 = this.buffers[n2].getMruLink();
            this.buffers[n3].setMruLink(n4);
            this.buffers[n4].setLruLink(n3);
        }
        this.buffers[n2].setLruLink(this.lruHead);
        this.buffers[n2].setMruLink(-1);
        this.buffers[this.lruHead].setMruLink(n2);
        this.lruHead = n2;
    }

    private int doCacheNotAlignedRegion(FileDescriptor fileDescriptor, long l2, int n2, Block block, int n3) {
        int n4;
        long l3 = l2 >> 9;
        int n5 = (int)FileSystemCache.sectorModule(l2);
        int n6 = 0;
        for (int i2 = n2; i2 > 0; i2 -= n4) {
            BufferBlock bufferBlock;
            n4 = 512 - n5;
            if (n4 > i2) {
                n4 = i2;
            }
            if ((bufferBlock = this.loadBufferBlock(fileDescriptor, l3)) == null) {
                int n7 = this.readRegion(fileDescriptor, l2 + (long)n6, n4, block, n3 + n6);
                if (n7 < n4) {
                    return -1;
                }
            } else {
                block.copy(n3 + n6, bufferBlock.getBlock(), n5, n4);
            }
            n6 += n4;
            ++l3;
            n5 = 0;
        }
        return n2;
    }

    private BufferBlock loadBufferBlock(FileDescriptor fileDescriptor, long l2) {
        int n2;
        BufferBlock bufferBlock = this.getFromMap(fileDescriptor.getId(), l2);
        if (bufferBlock != null) {
            this.bumpBuffer(bufferBlock.getIndex());
            return bufferBlock;
        }
        bufferBlock = this.buffers[this.lruHead];
        if (bufferBlock.getFileDescriptorId() > 0) {
            this.deleteFromMap(bufferBlock);
        }
        if ((n2 = this.readRegion(fileDescriptor, l2 << 9, 512, bufferBlock.getBlock(), 0)) < 0) {
            bufferBlock.setFileDescriptorId(0);
            bufferBlock.setBlockNumber(-1L);
            return null;
        }
        bufferBlock.setFileDescriptorId(fileDescriptor.getId());
        bufferBlock.setBlockNumber(l2);
        this.addIntoMap(bufferBlock);
        this.bumpBuffer(bufferBlock.getIndex());
        return bufferBlock;
    }

    private int doCacheRegion(FileDescriptor fileDescriptor, long l2, int n2, Block block, int n3) {
        if (this.readRegion(fileDescriptor, l2, n2, block, n3) < n2) {
            return -1;
        }
        long l3 = l2 >> 9;
        for (int i2 = n2; i2 > 0; i2 -= 512) {
            BufferBlock bufferBlock = this.getFromMap(fileDescriptor.getId(), l3);
            if (bufferBlock == null) {
                bufferBlock = this.buffers[this.lruHead];
                if (bufferBlock.getFileDescriptorId() > 0) {
                    this.deleteFromMap(bufferBlock);
                }
                bufferBlock.setFileDescriptorId(fileDescriptor.getId());
                bufferBlock.setBlockNumber(l3);
                bufferBlock.getBlock().copy(0, block, n3, 512);
                this.addIntoMap(bufferBlock);
            }
            this.bumpBuffer(bufferBlock.getIndex());
            n3 += 512;
            ++l3;
        }
        return n2;
    }

    private int readRegion(FileDescriptor fileDescriptor, long l2, int n2, Block block, int n3) {
        FileChannel fileChannel = fileDescriptor.getChannel();
        if (this.readAhead && n2 <= 4096) {
            long l3 = this.readAheadBuffer.getOffset();
            if (fileDescriptor.getId() != this.readAheadBuffer.getFileDescriptorId() || l2 < l3 || l2 + (long)n2 > l3 + 4096L) {
                try {
                    fileChannel.position(l2);
                    int n4 = fileChannel.read(ByteBuffer.wrap(this.readAheadBuffer.getBlock().getBytes(), 0, 4096));
                    if (n4 < n2) {
                        n2 = n4;
                    }
                    this.readAheadBuffer.setFileDescriptorId(n4 < 512 ? 0 : fileDescriptor.getId());
                    this.readAheadBuffer.setOffset(l2);
                }
                catch (IOException iOException) {
                    this.readAheadBuffer.setFileDescriptorId(0);
                    this.readAhead = false;
                }
            }
            if (this.readAhead) {
                block.copy(n3, this.readAheadBuffer.getBlock(), (int)(l2 - this.readAheadBuffer.getOffset()), n2);
                return n2;
            }
        }
        try {
            fileChannel.position(l2);
            return fileChannel.read(ByteBuffer.wrap(block.getBytes(), n3, n2));
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    private int readFromCache(FileDescriptor fileDescriptor, long l2, int n2, Block block, int n3) {
        if (FileSystemCache.notAlignedRegion(l2, n2)) {
            return this.doCacheNotAlignedRegion(fileDescriptor, l2, n2, block, n3);
        }
        if (this.isCachedRegion(fileDescriptor, l2, n2) == CacheResult.FULL) {
            return this.getCachedRegion(fileDescriptor, l2, n2, block, n3);
        }
        return this.doCacheRegion(fileDescriptor, l2, n2, block, n3);
    }

    private int writeRegion(FileDescriptor fileDescriptor, long l2, int n2, Block block, int n3) {
        try {
            FileChannel fileChannel = fileDescriptor.getChannel();
            fileChannel.position(l2);
            return fileChannel.write(ByteBuffer.wrap(block.getBytes(), n3, n2));
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    private int writeRegionAndUpdateCache(FileDescriptor fileDescriptor, long l2, int n2, Block block, int n3) {
        int n4;
        int n5 = this.writeRegion(fileDescriptor, l2, n2, block, n3);
        if (n5 < n2) {
            return n5;
        }
        long l3 = l2 >> 9;
        int n6 = (int)FileSystemCache.sectorModule(l2);
        for (int i2 = n2; i2 > 0; i2 -= n4) {
            BufferBlock bufferBlock;
            n4 = 512 - n6;
            if (n4 > i2) {
                n4 = i2;
            }
            if ((bufferBlock = this.getFromMap(fileDescriptor.getId(), l3)) != null) {
                this.bumpBuffer(bufferBlock.getIndex());
                bufferBlock.getBlock().copy(n6, block, n3, n4);
            }
            n3 += n4;
            ++l3;
            n6 = 0;
        }
        return n2;
    }

    private boolean useCache(CacheDataType cacheDataType) {
        if (this.numBuffers > 0) {
            return this.buffersNodesOnly ? cacheDataType == CacheDataType.INDEX : cacheDataType != CacheDataType.HEADER;
        }
        return false;
    }

    public FileSystemCache(Status status) {
        this.status = status;
        this.numBuffers = Config.V_BUFFERS_PER_FILE.getIntegerValue();
        this.readAhead = Config.V_READ_AHEAD.isOn();
        this.buffersNodesOnly = Config.V_BUFFERS_NODES_ONLY.isOn();
        this.buffers = new BufferBlock[this.numBuffers];
        for (int i2 = 0; i2 < this.numBuffers; ++i2) {
            this.buffers[i2] = new BufferBlock(i2);
            this.buffers[i2].setFileDescriptorId(0);
            this.buffers[i2].setBlockNumber(-1L);
            this.buffers[i2].setLruLink(i2 - 1);
            this.buffers[i2].setMruLink(i2 + 1);
        }
        if (this.numBuffers > 0) {
            this.buffers[this.numBuffers - 1].setMruLink(-1);
        }
        this.mruHead = 0;
        this.lruHead = this.numBuffers - 1;
    }

    public void syncCache() {
    }

    public void checkCacheVersion(long l2) {
        if (l2 != this.buffersVersion) {
            this.readAheadBuffer.setFileDescriptorId(0);
            for (int i2 = 0; i2 < this.numBuffers; ++i2) {
                this.buffers[i2].setFileDescriptorId(0);
                this.buffers[i2].setBlockNumber(-1L);
            }
            this.buffersVersion = 0L;
            for (HashMap<Long, BufferBlock> hashMap : this.buffersMap) {
                hashMap.clear();
            }
        }
    }

    public void setCacheVersion(long l2) {
        this.buffersVersion = l2;
    }

    public FileLock lock(FileDescriptor fileDescriptor) {
        while (true) {
            try {
                return fileDescriptor.getChannel().lock(0L, 1L, false);
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                continue;
            }
            catch (IOException | RuntimeException exception) {
                this.status.setErrno(1);
                return null;
            }
            break;
        }
    }

    public FileLock testLock(FileDescriptor fileDescriptor, long l2, int n2) {
        try {
            FileLock fileLock = fileDescriptor.getChannel().tryLock(l2, n2, false);
            if (fileLock == null) {
                this.status.setErrno(5);
            }
            return fileLock;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.status.setErrno(5);
        }
        catch (IOException | RuntimeException exception) {
            this.status.setErrno(1);
        }
        return null;
    }

    public void unlock(FileLock fileLock) {
        try {
            fileLock.release();
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
    }

    public FileDescriptor open(String string, int n2) {
        try {
            FileDescriptor fileDescriptor = new FileDescriptor(this.fileDescriptorCounter + 1, string, n2);
            ++this.fileDescriptorCounter;
            this.buffersMap.add(new HashMap());
            return fileDescriptor;
        }
        catch (NoSuchFileException noSuchFileException) {
            this.status.setErrno(15);
        }
        catch (SecurityException | AccessDeniedException exception) {
            this.status.setErrno(16);
        }
        catch (IOException | RuntimeException exception) {
            this.status.setErrno(1);
        }
        return null;
    }

    public boolean remove(String string) {
        Path path = Paths.get(string, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.status.setErrno(1);
            return false;
        }
        try {
            Files.delete(path);
            return true;
        }
        catch (NoSuchFileException noSuchFileException) {
            this.status.setErrno(15);
        }
        catch (SecurityException | AccessDeniedException exception) {
            this.status.setErrno(16);
        }
        catch (IOException | RuntimeException exception) {
            this.status.setErrno(1);
        }
        return false;
    }

    public boolean rename(String string, String string2) {
        Path path = Paths.get(string, new String[0]);
        Path path2 = Paths.get(string2, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
            this.status.setErrno(1);
            return false;
        }
        try {
            Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (NoSuchFileException noSuchFileException) {
            this.status.setErrno(15);
        }
        catch (SecurityException | AccessDeniedException exception) {
            this.status.setErrno(16);
        }
        catch (IOException | RuntimeException exception) {
            this.status.setErrno(1);
        }
        return false;
    }

    public boolean checkSize(FileDescriptor fileDescriptor, long l2) {
        try {
            return fileDescriptor.getChannel().size() == l2;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public long seek(FileDescriptor fileDescriptor, long l2) {
        fileDescriptor.setOffset(l2);
        return l2;
    }

    public int read(FileDescriptor fileDescriptor, Block block, CacheDataType cacheDataType) {
        return this.read(fileDescriptor, block, 0, block.size(), cacheDataType);
    }

    public int read(FileDescriptor fileDescriptor, Block block, int n2, int n3, CacheDataType cacheDataType) {
        int n4;
        int n5 = n4 = this.useCache(cacheDataType) ? this.readFromCache(fileDescriptor, fileDescriptor.getOffset(), n3, block, n2) : this.readRegion(fileDescriptor, fileDescriptor.getOffset(), n3, block, n2);
        if (n4 >= 0) {
            if (n4 != n3) {
                this.status.setErrno(6);
                this.status.setIntErrno(9);
            }
            fileDescriptor.incOffset(n4);
        } else {
            this.status.setErrno(1);
        }
        return n4;
    }

    public int write(FileDescriptor fileDescriptor, Block block, CacheDataType cacheDataType) {
        return this.write(fileDescriptor, block, 0, block.size(), cacheDataType);
    }

    public int write(FileDescriptor fileDescriptor, Block block, int n2, int n3, CacheDataType cacheDataType) {
        int n4;
        this.readAheadBuffer.setFileDescriptorId(0);
        int n5 = n4 = this.useCache(cacheDataType) ? this.writeRegionAndUpdateCache(fileDescriptor, fileDescriptor.getOffset(), n3, block, n2) : this.writeRegion(fileDescriptor, fileDescriptor.getOffset(), n3, block, n2);
        if (n4 >= 0) {
            if (n4 != n3) {
                this.status.setErrno(10);
            }
            fileDescriptor.incOffset(n4);
        } else {
            this.status.setErrno(1);
        }
        return n4;
    }

    public boolean close(FileDescriptor fileDescriptor) {
        try {
            if (this.readAheadBuffer.getFileDescriptorId() == fileDescriptor.getId()) {
                this.readAheadBuffer.setFileDescriptorId(0);
            }
            this.buffersVersion = 0L;
            fileDescriptor.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

