/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.File;
import java.io.IOException;
import java.nio.file.Files;

public class FileTable {
    private final File[] openedFiles;
    private final int[] freeId;
    private int next;

    private boolean locked(File file) {
        if (this.next > 0) {
            try {
                int n2 = 0;
                for (File file2 : this.openedFiles) {
                    if (file2 == null) continue;
                    if (Files.isSameFile(file2.getSegment(0).getPath(), file.getSegment(0).getPath())) {
                        int n3 = file2.getOpenMode();
                        int n4 = file.getOpenMode();
                        if ((n4 & 0x200) != 0 || (n3 & 0x200) != 0) {
                            return true;
                        }
                        if ((n4 & 0x100) != 0 && (n3 & 3) != 0) {
                            return true;
                        }
                        if ((n3 & 0x100) != 0 && (n4 & 3) != 0) {
                            return true;
                        }
                    }
                    if (++n2 < this.next) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public FileTable(int n2) {
        this.openedFiles = new File[n2];
        this.freeId = new int[n2];
        this.next = 0;
    }

    private int nextId() {
        if (this.next < this.freeId.length) {
            int n2;
            return (n2 = this.freeId[this.next++]) == 0 ? this.next : n2;
        }
        return 0;
    }

    private void freeId(int n2) {
        this.freeId[--this.next] = n2;
    }

    public synchronized boolean isFull() {
        return this.next >= this.freeId.length;
    }

    public synchronized File get(int n2) {
        return this.openedFiles[n2 - 1];
    }

    public synchronized int add(File file, boolean bl) {
        if (bl && this.locked(file)) {
            return -1;
        }
        int n2 = this.nextId();
        file.setId(n2);
        if (n2 > 0) {
            this.openedFiles[n2 - 1] = file;
            return n2;
        }
        return 0;
    }

    public synchronized void remove(File file) {
        int n2 = file.getId();
        this.openedFiles[n2 - 1] = null;
        this.freeId(n2);
        file.setId(0);
    }
}

