/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SegmentInfoHelper {
    private static final ByteOrder byteOrder = ByteOrder.nativeOrder();
    private final byte[] bytes;

    private int getNativeUnsignedShort(int n2) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return (this.bytes[n2 + 1] & 0xFF) << 8 | this.bytes[n2] & 0xFF;
        }
        return (this.bytes[n2] & 0xFF) << 8 | this.bytes[n2 + 1] & 0xFF;
    }

    private void setCString(String string, int n2, int n3) {
        Arrays.fill(this.bytes, n2, n3, (byte)0);
        byte[] byArray = string.getBytes(StandardCharsets.US_ASCII);
        System.arraycopy(byArray, 0, this.bytes, n2, Math.min(n3 - 1, byArray.length));
    }

    public SegmentInfoHelper(byte[] byArray) {
        this.bytes = byArray;
    }

    public boolean isDataSegment() {
        return this.getNativeUnsignedShort(272) == 255;
    }

    public boolean isIndexSegment() {
        return this.getNativeUnsignedShort(272) == 254;
    }

    public int getSegmentNumber() {
        return this.getNativeUnsignedShort(274);
    }

    public void setSegmentName(String string) {
        this.setCString(string, 0, 256);
    }

    public void setSegmentSize(long l2) {
        this.setCString(String.format("%015d", l2), 256, 16);
    }
}

