/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.internals.FileAddress;
import com.veryant.vision4j.file.internals.FileDescriptor;

abstract class SegmentedFile {
    private static final int INITIAL_SIZE = 10;
    private FileDescriptor[] fileDescriptors = new FileDescriptor[10];
    private long[] segmentSizes = new long[10];
    private int segmentCount;
    private final FileAddress fileSize = new FileAddress();
    private final FileAddress nextBlock = new FileAddress();

    SegmentedFile() {
    }

    void setSegmentSize(int n2, long l2) {
        if (n2 >= this.segmentCount) {
            throw new IndexOutOfBoundsException();
        }
        this.segmentSizes[n2] = l2;
    }

    long getSegmentSize(int n2) {
        if (n2 >= this.segmentCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.segmentSizes[n2];
    }

    void addSegment(FileDescriptor fileDescriptor) {
        if (this.segmentCount >= this.fileDescriptors.length) {
            FileDescriptor[] fileDescriptorArray = this.fileDescriptors;
            this.fileDescriptors = new FileDescriptor[fileDescriptorArray.length + fileDescriptorArray.length / 4];
            System.arraycopy(fileDescriptorArray, 0, this.fileDescriptors, 0, fileDescriptorArray.length);
            long[] lArray = this.segmentSizes;
            this.segmentSizes = new long[lArray.length + lArray.length / 4];
            System.arraycopy(lArray, 0, this.segmentSizes, 0, lArray.length);
        }
        this.fileDescriptors[this.segmentCount] = fileDescriptor;
        ++this.segmentCount;
    }

    FileDescriptor getSegment(int n2) {
        if (n2 < this.segmentCount) {
            return this.fileDescriptors[n2];
        }
        throw new IndexOutOfBoundsException();
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public FileAddress getFileSize() {
        return this.fileSize;
    }

    public FileAddress getNextBlock() {
        return this.nextBlock;
    }
}

