/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.Config;
import com.veryant.vision4j.file.File;
import com.veryant.vision4j.file.FileTable;
import com.veryant.vision4j.file.TransactionLog;
import com.veryant.vision4j.file.VisionBase;
import com.veryant.vision4j.file.internals.Block;
import com.veryant.vision4j.file.internals.FileAddress;
import com.veryant.vision4j.file.internals.FindKeyResult;
import com.veryant.vision4j.file.internals.KeyEntry;
import com.veryant.vision4j.file.internals.Lock;
import com.veryant.vision4j.file.internals.LockType;
import com.veryant.vision4j.file.internals.LogicalAttributes;
import com.veryant.vision4j.file.internals.PointerState;
import com.veryant.vision4j.file.internals.RecordHeader;

public abstract class Vision
extends VisionBase {
    public Vision(Config config, FileTable fileTable) {
        super(config, fileTable);
    }

    public boolean write(int n2, byte[] byArray, int n3, TransactionLog transactionLog) {
        File file = this.fileTable.get(n2);
        if (file == null) {
            this.status.setErrno(1);
            return false;
        }
        this.status.setErrno(0);
        this.invalidateReadNextAddressesCache(file);
        if (!this.lockHeader(file, true, true, false)) {
            return false;
        }
        this.unlockRecord(file);
        this.config.F_NO_LOCK = 0;
        if (n3 == 0) {
            n3 = file.getLogicalAttributes().getMaxRecordSize();
        } else if (n3 > file.getLogicalAttributes().getMaxRecordSize() || n3 < file.getLogicalAttributes().getMinRecordSize()) {
            this.unlockHeader(file, false);
            this.status.setErrno(2);
            return false;
        }
        FileAddress fileAddress = this.appendRecord(file, byArray, n3);
        if (fileAddress.isZero()) {
            this.unlockHeader(file, false);
            return false;
        }
        boolean bl = this.useTransactionLog(file, transactionLog);
        if (bl && this.getRecordWithLock(file, null, fileAddress, null, LockType.TRANSACTION) == 0) {
            this.deleteRecord(file, fileAddress);
            this.saveHeader(file, true);
            this.unlockHeader(file, false);
            return false;
        }
        Block block = new Block(252);
        LogicalAttributes logicalAttributes = file.getLogicalAttributes();
        int n4 = logicalAttributes.getNumKeys();
        for (int i2 = 0; i2 < n4; ++i2) {
            this.buildKey(file, i2, byArray, block);
            boolean bl2 = logicalAttributes.getKey(i2).isDuplicate();
            FileAddress fileAddress2 = fileAddress.copy();
            fileAddress2.flipOffset();
            file.setFoundExactMatch(false);
            if (!this.addKey(file, block, fileAddress2, bl2 ? file.getNextUniqueId() : 0L, bl2)) {
                if (this.status.getErrno() == 6) {
                    this.unlockHeader(file, false);
                    return false;
                }
                if (bl) {
                    this.unlockRecord(file, fileAddress);
                }
                while (--i2 >= 0) {
                    this.buildKey(file, i2, byArray, block);
                    bl2 = logicalAttributes.getKey(i2).isDuplicate();
                    this.deleteKey(file, block, bl2 ? file.getNextUniqueId() : 0L);
                }
                this.deleteRecord(file, fileAddress);
                this.saveHeader(file, true);
                this.unlockHeader(file, false);
                return false;
            }
            if (!file.isFoundExactMatch()) continue;
            this.status.setErrno(101);
        }
        file.incNextUniqueId();
        this.saveHeader(file, true);
        this.unlockHeader(file, false);
        if (bl) {
            file.setPendingTransaction(true);
            transactionLog.write(n2, byArray, n3);
        }
        return true;
    }

    public boolean start(int n2, byte[] byArray, int n3, int n4, int n5) {
        boolean bl;
        File file = this.fileTable.get(n2);
        if (file == null) {
            this.status.setErrno(1);
            return false;
        }
        LogicalAttributes logicalAttributes = file.getLogicalAttributes();
        if (n3 < 0 || n3 >= logicalAttributes.getNumKeys()) {
            this.status.setErrno(2);
            return false;
        }
        this.invalidateReadNextAddressesCache(file);
        if (!this.beginRead(file, false)) {
            return false;
        }
        int n6 = logicalAttributes.getKey(n3).getTotalSize();
        boolean bl2 = bl = n4 > 0 && n4 < logicalAttributes.getKey(n3).getTotalSize();
        if (!bl) {
            n4 = n6;
        }
        Block block = new Block(252);
        this.buildKey(file, n3, byArray, block);
        byte by = 0;
        long l2 = 0L;
        if (n5 == 2 || n5 == 4) {
            by = -1;
            l2 = 0xFFFFFFFFL;
        }
        block.fill(n4 + 2, n6 - n4, by);
        KeyEntry keyEntry = new KeyEntry();
        FindKeyResult findKeyResult = this.findKey(file, block, l2, keyEntry);
        if (findKeyResult == FindKeyResult.ERROR) {
            this.unlockHeader(file, true);
            return false;
        }
        if (bl && n5 == 0 && findKeyResult == FindKeyResult.MATCH_NEXT && file.getFoundKey().compare(2, block, 2, n4) == 0) {
            findKeyResult = FindKeyResult.KEY_MATCH;
        }
        if (findKeyResult.fastCompare(FindKeyResult.EMPTY) > 0 && (n5 == 3 || n5 == 4)) {
            if (!this.findPrevious(file, keyEntry)) {
                this.unlockHeader(file, true);
                return false;
            }
            findKeyResult = FindKeyResult.MATCH_NEXT;
        }
        if (findKeyResult.fastCompare(FindKeyResult.MATCH_NEXT) < 0 || file.getFoundKey().get8(1) != block.get8(1) || n5 == 0 && findKeyResult.fastCompare(FindKeyResult.KEY_MATCH) < 0) {
            this.status.setErrno(8);
            this.unlockHeader(file, true);
            return false;
        }
        this.finishRead(file, n3, file.getFoundKey(), this.getUniqueId(file, file.getLoadedNode(), keyEntry.getPhysicalKeyOffset()), keyEntry.getNodeAddress(), true);
        return true;
    }

    public int next(int n2, byte[] byArray) {
        int n3;
        File file = this.fileTable.get(n2);
        if (file == null) {
            this.status.setErrno(1);
            return 0;
        }
        while (true) {
            FindKeyResult findKeyResult;
            int n4 = file.getCurrentKeyNum();
            PointerState pointerState = file.getPointerState();
            FileAddress fileAddress = file.getLastReadBlock().copy();
            if (!this.beginRead(file, true)) {
                return 0;
            }
            LogicalAttributes logicalAttributes = file.getLogicalAttributes();
            if (pointerState == PointerState.AT_START) {
                int n5 = logicalAttributes.getKey(n4).getTotalSize();
                file.getCurrentKey().put8(0, (byte)(n5 + 1));
                file.getCurrentKey().put8(1, (byte)n4);
                file.getCurrentKey().fill(2, n5, (byte)0);
                file.setCurrentUniqueId(0L);
                file.setCurrentIsNext(true);
                pointerState = PointerState.HAS_CUR_REC;
            }
            if (pointerState != PointerState.HAS_CUR_REC) {
                file.setPointerState(pointerState);
                this.unlockHeader(file, true);
                this.status.setErrno(9);
                return 0;
            }
            if (!file.isCurrentIsNext()) {
                file.incCurrentUniqueId();
            }
            KeyEntry keyEntry = new KeyEntry();
            if (!fileAddress.isZero() && file.getLastReadTreeVersion() == file.getTreeVersion()) {
                FileAddress fileAddress2 = this.getReadNextCachedAddress(file);
                if (fileAddress2 != null) {
                    RecordHeader recordHeader = new RecordHeader();
                    FileAddress fileAddress3 = this.getReadNextCachedAddress(file).copy();
                    fileAddress3.flipOffset();
                    int n6 = this.getRecordWithLock(file, byArray, fileAddress3, recordHeader, LockType.PROGRAM);
                    if (n6 > 0 && this.locklessReadCheck(file)) {
                        this.buildKey(file, n4, byArray, file.getCurrentKey());
                        this.finishRead(file, n4, file.getCurrentKey(), logicalAttributes.getKey(n4).isDuplicate() ? recordHeader.getUniqueId() : 0L, fileAddress, false);
                        this.popReadNextCachedAddress(file);
                        return n6;
                    }
                }
                this.setKey(file, n4);
                findKeyResult = this.searchInNode(file, file.getCurrentKey(), file.getCurrentUniqueId(), fileAddress, keyEntry);
            } else {
                findKeyResult = FindKeyResult.NO_MATCH;
            }
            if (findKeyResult == FindKeyResult.NO_MATCH) {
                findKeyResult = this.findKey(file, file.getCurrentKey(), file.getCurrentUniqueId(), keyEntry);
            }
            this.invalidateReadNextAddressesCache(file);
            if (!(findKeyResult != FindKeyResult.MATCH_NEXT && file.getFoundKey().get8(1) == file.getCurrentKey().get8(1) || this.locklessReadCheck(file))) {
                file.setCurrentIsNext(true);
                file.setPointerState(PointerState.HAS_CUR_REC);
                continue;
            }
            if (findKeyResult == FindKeyResult.ERROR) {
                this.unlockHeader(file, true);
                return 0;
            }
            if (findKeyResult.fastCompare(FindKeyResult.MATCH_NEXT) < 0 || file.getFoundKey().get8(1) != file.getCurrentKey().get8(1)) {
                file.setPointerState(PointerState.AT_END);
                this.unlockHeader(file, true);
                this.status.setErrno(8);
                return 0;
            }
            n3 = this.read(file, file.getFoundKey(), keyEntry, byArray, n4, true, true);
            if (n3 >= 0) break;
            file.setCurrentIsNext(true);
            file.setPointerState(PointerState.HAS_CUR_REC);
        }
        return n3;
    }

    public int previous(int n2, byte[] byArray) {
        int n3;
        File file = this.fileTable.get(n2);
        if (file == null) {
            this.status.setErrno(1);
            return 0;
        }
        this.invalidateReadNextAddressesCache(file);
        int n4 = file.getCurrentKeyNum();
        PointerState pointerState = file.getPointerState();
        if (!this.beginRead(file, false)) {
            return 0;
        }
        LogicalAttributes logicalAttributes = file.getLogicalAttributes();
        if (pointerState == PointerState.AT_END) {
            int n5 = logicalAttributes.getKey(n4).getTotalSize();
            file.getCurrentKey().put8(0, (byte)(n5 + 1));
            file.getCurrentKey().put8(1, (byte)n4);
            file.getCurrentKey().fill(2, n5, (byte)-1);
            file.setCurrentUniqueId(0xFFFFFFFFL);
            file.setCurrentIsNext(false);
            pointerState = PointerState.HAS_CUR_REC;
        }
        if (pointerState != PointerState.HAS_CUR_REC) {
            file.setPointerState(pointerState);
            this.unlockHeader(file, true);
            this.status.setErrno(9);
            return 0;
        }
        KeyEntry keyEntry = new KeyEntry();
        FindKeyResult findKeyResult = this.findKey(file, file.getCurrentKey(), file.getCurrentUniqueId(), keyEntry);
        if (findKeyResult == FindKeyResult.ERROR) {
            this.unlockHeader(file, true);
            return 0;
        }
        if (findKeyResult.fastCompare(FindKeyResult.MATCH_NEXT) < 0) {
            file.setPointerState(PointerState.AT_START);
            this.unlockHeader(file, true);
            this.status.setErrno(8);
            return 0;
        }
        if (!file.isCurrentIsNext() || findKeyResult != FindKeyResult.FULL_MATCH) {
            if (!this.findPrevious(file, keyEntry)) {
                if (this.status.getErrno() == 8) {
                    file.setPointerState(PointerState.AT_START);
                }
                this.unlockHeader(file, true);
                return 0;
            }
            if (file.getFoundKey().get8(1) != file.getCurrentKey().get8(1)) {
                file.setPointerState(PointerState.AT_START);
                this.unlockHeader(file, true);
                this.status.setErrno(8);
                return 0;
            }
        }
        if ((n3 = this.read(file, file.getFoundKey(), keyEntry, byArray, n4, false, false)) <= 0) {
            return 0;
        }
        return n3;
    }

    public int read(int n2, byte[] byArray, int n3) {
        int n4;
        File file = this.fileTable.get(n2);
        if (file == null) {
            this.status.setErrno(1);
            return 0;
        }
        LogicalAttributes logicalAttributes = file.getLogicalAttributes();
        if (n3 < 0 || n3 >= logicalAttributes.getNumKeys()) {
            this.status.setErrno(2);
            return 0;
        }
        while (true) {
            this.invalidateReadNextAddressesCache(file);
            if (!this.beginRead(file, true)) {
                return 0;
            }
            KeyEntry keyEntry = new KeyEntry();
            Block block = new Block(252);
            this.buildKey(file, n3, byArray, block);
            FindKeyResult findKeyResult = this.findKey(file, block, 0L, keyEntry);
            if (findKeyResult.fastCompare(FindKeyResult.KEY_MATCH) < 0 && !this.locklessReadCheck(file)) continue;
            if (findKeyResult == FindKeyResult.ERROR) {
                this.unlockHeader(file, true);
                return 0;
            }
            if (findKeyResult.fastCompare(FindKeyResult.KEY_MATCH) < 0) {
                this.unlockHeader(file, true);
                this.status.setErrno(8);
                return 0;
            }
            n4 = this.read(file, file.getFoundKey(), keyEntry, byArray, n3, false, true);
            if (n4 >= 0) break;
        }
        return n4;
    }

    private int read(File file, Block block, KeyEntry keyEntry, byte[] byArray, int n2, boolean bl, boolean bl2) {
        int n3;
        Object object;
        int n4;
        int n5;
        int n6;
        Block block2;
        FileAddress fileAddress = new FileAddress();
        this.getLeftAddress(file, file.getLoadedNode(), keyEntry.getPhysicalKeyOffset(), fileAddress);
        fileAddress.flipOffset();
        RecordHeader recordHeader = new RecordHeader();
        int n7 = this.getRecordWithLock(file, byArray, fileAddress, recordHeader, LockType.PROGRAM);
        if (n7 == 0) {
            if (!this.locklessReadCheck(file)) {
                return -1;
            }
            if (this.status.getErrno() == 5) {
                this.finishRead(file, n2, block, this.getUniqueId(file, file.getLoadedNode(), keyEntry.getPhysicalKeyOffset()), keyEntry.getNodeAddress(), true);
                return 0;
            }
            this.unlockHeader(file, true);
            return 0;
        }
        LogicalAttributes logicalAttributes = file.getLogicalAttributes();
        if (bl2 && logicalAttributes.getKey(n2).isDuplicate()) {
            block2 = file.getLoadedNode();
            n6 = (block2.get16(1) & 0xFFFF) + 3;
            n5 = keyEntry.getPhysicalKeyOffset();
            if ((n5 += (n4 = file.getKeyEntryOverhead() + (block2.get8(n5 + file.getKeyEntryOffset()) & 0xFF))) >= n6) {
                long l2 = this.getUniqueId(file, block2, keyEntry.getPhysicalKeyOffset());
                object = new KeyEntry();
                FindKeyResult findKeyResult = this.findKey(file, block = block.copy(), l2 + 1L, (KeyEntry)object);
                if (findKeyResult.fastCompare(FindKeyResult.KEY_MATCH) >= 0) {
                    this.status.setErrno(101);
                }
                this.loadNode(file, keyEntry.getNodeAddress());
            } else {
                int n8;
                int n9 = n5 + file.getKeyEntryOffset();
                n3 = block2.get8(n9 + 1) & 0xFF;
                int n10 = n3 + 1;
                int n11 = 2;
                int n12 = (block2.get8(n9) & 0xFF) - 1;
                if (n12 == n8) {
                    for (n8 = (block.get8(0) & 0xFF) - n3; n8 > 0 && block.get8(n10) == block2.get8(n9 + n11); --n8) {
                        ++n10;
                        ++n11;
                    }
                    if (n8 == 0) {
                        this.status.setErrno(101);
                    }
                }
            }
            bl = false;
        }
        if (!this.locklessReadCheck(file)) {
            return -1;
        }
        if (bl) {
            int n13;
            block2 = file.getLoadedNode();
            n6 = (block2.get16(1) & 0xFFFF) + 3;
            n5 = keyEntry.getPhysicalKeyOffset();
            n4 = n5 + file.getKeyEntryOffset();
            for (n13 = 0; n13 < 10 && (n5 += file.getKeyEntryOverhead() + (block2.get8(n4) & 0xFF)) < n6 && (n3 = block2.get8((n4 = n5 + file.getKeyEntryOffset()) + 1) & 0xFF) != 0; ++n13) {
                object = new FileAddress();
                this.getLeftAddress(file, block2, n5, (FileAddress)object);
                this.storeReadNextCachedAddress(file, n13, (FileAddress)object);
            }
            this.purgeReadNextCachedAddress(file, n13);
        }
        this.finishRead(file, n2, block, this.getUniqueId(file, file.getLoadedNode(), keyEntry.getPhysicalKeyOffset()), keyEntry.getNodeAddress(), false);
        return n7;
    }

    public boolean delete(int n2, byte[] byArray, TransactionLog transactionLog) {
        Object object;
        File file = this.fileTable.get(n2);
        if (file == null) {
            this.status.setErrno(1);
            return false;
        }
        this.status.setErrno(0);
        this.invalidateReadNextAddressesCache(file);
        if (!this.lockHeader(file, true, true, false)) {
            return false;
        }
        FileAddress fileAddress = this.isCurrentLockedRecord(file, byArray);
        this.unlockRecord(file);
        this.config.F_NO_LOCK = 0;
        Block block = new Block(252);
        if (fileAddress == null) {
            this.buildKey(file, 0, byArray, block);
            object = new KeyEntry();
            FindKeyResult findKeyResult = this.findKey(file, block, 0L, (KeyEntry)object);
            if (findKeyResult == FindKeyResult.ERROR) {
                this.unlockHeader(file, false);
                return false;
            }
            if (findKeyResult != FindKeyResult.FULL_MATCH) {
                this.unlockHeader(file, false);
                this.status.setErrno(8);
                return false;
            }
            fileAddress = new FileAddress();
            this.getLeftAddress(file, file.getLoadedNode(), ((KeyEntry)object).getPhysicalKeyOffset(), fileAddress);
            fileAddress.flipOffset();
        }
        object = new RecordHeader();
        int n3 = this.getRecordWithLock(file, file.getTemporaryRecord(), fileAddress, (RecordHeader)object, LockType.PROGRAM);
        if (n3 == 0) {
            this.unlockHeader(file, false);
            return false;
        }
        this.unlockRecord(file, fileAddress);
        LogicalAttributes logicalAttributes = file.getLogicalAttributes();
        for (int i2 = 0; i2 < logicalAttributes.getNumKeys(); ++i2) {
            this.buildKey(file, i2, file.getTemporaryRecord(), block);
            if (this.deleteKey(file, block, logicalAttributes.getKey(i2).isDuplicate() ? ((RecordHeader)object).getUniqueId() : 0L)) continue;
            this.unlockHeader(file, false);
            return false;
        }
        if (!this.deleteRecord(file, fileAddress)) {
            this.unlockHeader(file, false);
            return false;
        }
        this.saveHeader(file, true);
        this.unlockHeader(file, false);
        if (this.useTransactionLog(file, transactionLog)) {
            file.setPendingTransaction(true);
            transactionLog.delete(n2, file.getTemporaryRecord(), n3);
        }
        return true;
    }

    public boolean rewrite(int n2, byte[] byArray, int n3, TransactionLog transactionLog) {
        boolean bl;
        boolean bl2;
        Object object;
        File file = this.fileTable.get(n2);
        if (file == null) {
            this.status.setErrno(1);
            return false;
        }
        this.status.setErrno(0);
        this.invalidateReadNextAddressesCache(file);
        if (!this.lockHeader(file, true, true, false)) {
            return false;
        }
        FileAddress fileAddress = this.isCurrentLockedRecord(file, byArray);
        this.unlockRecord(file);
        if (n3 == 0) {
            n3 = file.getLogicalAttributes().getMaxRecordSize();
        } else if (n3 > file.getLogicalAttributes().getMaxRecordSize() || n3 < file.getLogicalAttributes().getMinRecordSize()) {
            this.unlockHeader(file, false);
            this.status.setErrno(2);
            return false;
        }
        Block block = new Block(252);
        if (fileAddress == null) {
            this.buildKey(file, 0, byArray, block);
            KeyEntry keyEntry = new KeyEntry();
            object = this.findKey(file, block, 0L, keyEntry);
            if (object == FindKeyResult.ERROR) {
                this.unlockHeader(file, false);
                return false;
            }
            if (object != FindKeyResult.FULL_MATCH) {
                this.unlockHeader(file, false);
                this.status.setErrno(8);
                return false;
            }
            fileAddress = new FileAddress();
            this.getLeftAddress(file, file.getLoadedNode(), keyEntry.getPhysicalKeyOffset(), fileAddress);
            fileAddress.flipOffset();
        }
        this.config.F_NO_LOCK = (bl2 = this.useTransactionLog(file, transactionLog)) ? 0 : -1;
        object = new RecordHeader();
        int n4 = this.getRecordWithLock(file, file.getTemporaryRecord(), fileAddress, (RecordHeader)object, bl2 ? LockType.TRANSACTION : LockType.PROGRAM);
        if (n4 == 0) {
            this.unlockHeader(file, false);
            return false;
        }
        KeyEntry keyEntry = new KeyEntry();
        Block block2 = new Block(252);
        LogicalAttributes logicalAttributes = file.getLogicalAttributes();
        boolean[] blArray = new boolean[logicalAttributes.getNumKeys()];
        blArray[0] = true;
        for (int i2 = 1; i2 < blArray.length; ++i2) {
            blArray[i2] = true;
            this.buildKey(file, i2, byArray, block);
            this.buildKey(file, i2, file.getTemporaryRecord(), block2);
            if (block.compare(0, block2, 0, (block.get8(0) & 0xFF) + 1) != 0) {
                blArray[i2] = false;
            }
            if (blArray[i2] || logicalAttributes.getKey(i2).isDuplicate() || this.findKey(file, block, 0L, keyEntry).fastCompare(FindKeyResult.KEY_MATCH) < 0) continue;
            this.unlockHeader(file, false);
            this.status.setErrno(7);
            return false;
        }
        long l2 = ((RecordHeader)object).getUniqueId();
        FileAddress fileAddress2 = fileAddress.copy();
        this.rewriteRecord(file, byArray, n3, (RecordHeader)object, fileAddress);
        if (fileAddress.isZero()) {
            this.unlockHeader(file, false);
            return false;
        }
        boolean bl3 = bl = !fileAddress.eq(fileAddress2);
        if (bl) {
            this.moveLock(file, fileAddress2, fileAddress);
            file.getCurrentRecord().copyFrom(fileAddress);
        }
        for (int i3 = 0; i3 < blArray.length; ++i3) {
            if (!bl && blArray[i3]) continue;
            boolean bl4 = logicalAttributes.getKey(i3).isDuplicate();
            this.buildKey(file, i3, file.getTemporaryRecord(), block);
            if (!this.deleteKey(file, block, bl4 ? l2 : 0L)) {
                this.unlockHeader(file, false);
                return false;
            }
            this.buildKey(file, i3, byArray, block);
            FileAddress fileAddress3 = fileAddress.copy();
            fileAddress3.flipOffset();
            file.setFoundExactMatch(false);
            if (!this.addKey(file, block, fileAddress3, bl4 ? l2 : 0L, bl4)) {
                this.unlockHeader(file, false);
                return false;
            }
            if (!file.isFoundExactMatch()) continue;
            this.status.setErrno(101);
        }
        this.saveHeader(file, true);
        this.unlockHeader(file, false);
        if (bl2) {
            file.setPendingTransaction(true);
            transactionLog.rewrite(n2, file.getTemporaryRecord(), n4);
        }
        return true;
    }

    public boolean unlock(int n2) {
        File file = this.fileTable.get(n2);
        if (file == null) {
            this.status.setErrno(1);
            return false;
        }
        this.status.setErrno(0);
        return this.unlock(file);
    }

    protected boolean unlock(File file) {
        if (!this.lockHeader(file, false, false, true)) {
            return false;
        }
        Lock[] lockArray = file.getLocks();
        int n2 = lockArray.length;
        for (int i2 = 0; i2 < n2 && lockArray[i2] != null; ++i2) {
            lockArray[i2].release();
            lockArray[i2] = null;
        }
        file.getCurrentRecord().invalidate();
        this.unlockHeader(file, false);
        return true;
    }

    public void sync() {
    }
}

