/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.Config;
import com.veryant.vision4j.file.Constants;
import com.veryant.vision4j.file.File;
import com.veryant.vision4j.file.FileSystemCache;
import com.veryant.vision4j.file.FileTable;
import com.veryant.vision4j.file.IndexFile;
import com.veryant.vision4j.file.Offset;
import com.veryant.vision4j.file.SegmentedFile;
import com.veryant.vision4j.file.Status;
import com.veryant.vision4j.file.TransactionLog;
import com.veryant.vision4j.file.internals.Block;
import com.veryant.vision4j.file.internals.BlockType;
import com.veryant.vision4j.file.internals.CacheDataType;
import com.veryant.vision4j.file.internals.CombineMode;
import com.veryant.vision4j.file.internals.FileAddress;
import com.veryant.vision4j.file.internals.FileDescriptor;
import com.veryant.vision4j.file.internals.FindKeyResult;
import com.veryant.vision4j.file.internals.KeyEntry;
import com.veryant.vision4j.file.internals.KeyInfo;
import com.veryant.vision4j.file.internals.Lock;
import com.veryant.vision4j.file.internals.LockType;
import com.veryant.vision4j.file.internals.LogicalAttributes;
import com.veryant.vision4j.file.internals.PointerState;
import com.veryant.vision4j.file.internals.RecordHeader;
import com.veryant.vision4j.file.internals.RecordStatus;
import java.nio.channels.FileLock;

public abstract class VisionBase
implements Constants {
    private static final Block FULL_STOPPER_KEY = new Block(new byte[]{1, 127});
    private static final byte[] COMPRESSED_VALUES = new byte[]{0, 32, 48, 0};
    protected final Config config;
    protected final Status status = new Status();
    protected final FileTable fileTable;

    public VisionBase(Config config, FileTable fileTable) {
        this.config = config;
        this.fileTable = fileTable;
    }

    private String stripFileExtension(String string) {
        int n2;
        int n3 = string.lastIndexOf(46);
        if (n3 > (n2 = Math.max(string.lastIndexOf(92), string.lastIndexOf(47)) + 1)) {
            return string.substring(0, n3);
        }
        return string;
    }

    protected int standardizeOpenMode(int n2) {
        int n3 = n2 & 3;
        int n4 = n2 & 0x300;
        int n5 = n2 & 0x4010;
        return (n3 == 1 || n2 == 3 ? 2 : n3) | n4 | n5;
    }

    protected boolean isInputOnly(int n2) {
        return (n2 & 3) == 0;
    }

    protected boolean isOutputOnly(int n2) {
        return (n2 & 3) == 1;
    }

    protected boolean isExtendOnly(int n2) {
        return (n2 & 3) == 3;
    }

    protected boolean isMultiLockOnly(int n2) {
        return (n2 & 0x10) != 0;
    }

    protected boolean isMultiLock(int n2) {
        return (n2 & 0x10) != 0 || (n2 & 0x4000) != 0;
    }

    protected boolean canRollback(int n2) {
        return (n2 & 0x4000) != 0;
    }

    protected boolean useTransactionLog(File file, TransactionLog transactionLog) {
        return transactionLog != null && transactionLog.inTransaction() && file.isRollbackable() && !this.isInputOnly(file.getOpenMode());
    }

    protected String getDataSegmentName(String string, int n2) {
        if (n2 == 0) {
            return string;
        }
        if (this.config.V_STRIP_DOT_EXTENSION.isOn()) {
            string = this.stripFileExtension(string);
        }
        string = string + (n2 < 256 ? String.format(".d%02x", n2) : String.format(".d%04x", n2));
        return string;
    }

    protected String getIndexSegmentName(String string, int n2) {
        if (this.config.V_STRIP_DOT_EXTENSION.isOn()) {
            string = this.stripFileExtension(string);
        }
        string = n2 == 0 ? string + ".vix" : string + (n2 < 256 ? String.format(".v%02x", n2) : String.format(".v%04x", n2));
        return string;
    }

    protected String getSegmentName(String string, BlockType blockType, int n2) {
        return blockType == BlockType.NODE ? this.getIndexSegmentName(string, n2) : this.getDataSegmentName(string, n2);
    }

    private boolean hold(File file) {
        FileDescriptor fileDescriptor = file.getSegment(0);
        Lock lock = fileDescriptor.getExclusiveLock();
        if (lock == null) {
            int n2 = file.getOpenMode();
            if ((n2 & 0x200) != 0 || (n2 & 0x100) != 0) {
                return true;
            }
            FileLock fileLock = file.getFileSystemCache().lock(fileDescriptor);
            if (fileLock == null) {
                return false;
            }
            fileDescriptor.setExclusiveLock(new Lock(0, fileLock));
        }
        return true;
    }

    private void release(File file) {
        FileDescriptor fileDescriptor = file.getSegment(0);
        Lock lock = fileDescriptor.getExclusiveLock();
        if (lock != null) {
            lock.release();
            fileDescriptor.setExclusiveLock(null);
        }
    }

    protected boolean lockHeader(File file, boolean bl, boolean bl2, boolean bl3) {
        long l2;
        Object object;
        int n2;
        int n3;
        boolean bl4;
        if (file.isHeaderLocked() && !file.isUnlockedHeaderRead()) {
            return true;
        }
        if (bl3 && this.config.V_LOCK_METHOD.is(1) && !file.isUnlockedHeaderRead()) {
            file.setUnlockedHeaderRead(true);
        } else {
            if (file.isUnlockedHeaderRead()) {
                file.getCurrentNode().invalidate();
            }
            file.setUnlockedHeaderRead(false);
            if (!this.hold(file)) {
                return false;
            }
        }
        FileDescriptor fileDescriptor = file.getSegment(0);
        int n4 = file.getVersion();
        int n5 = Offset.PHDR_SIZE.get(n4) - 4;
        Block block = file.getHeaderCache();
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        do {
            bl4 = false;
            fileSystemCache.seek(fileDescriptor, 4L);
            if (fileSystemCache.read(fileDescriptor, block, 4, n5, CacheDataType.HEADER) != n5) {
                this.release(file);
                return false;
            }
            block.put32(0, n4 == 3 ? 269620246 : 269620249);
            if (!file.isUnlockedHeaderRead() || block.get16(Offset.UPDATING.get(n4)) == 0) continue;
            file.setUnlockedHeaderRead(false);
            if (!this.hold(file)) {
                return false;
            }
            bl4 = true;
        } while (bl4);
        file.setTreeVersion((long)block.get32(Offset.IVERSION.get(n4)) & 0xFFFFFFFFL);
        fileSystemCache.checkCacheVersion(file.getTreeVersion());
        if (n4 > 3) {
            Block block2;
            n3 = file.getSegmentCount() - 1;
            if (n3 == 0) {
                if (n4 < 6) {
                    file.setSegmentSize(0, (long)block.get32(Offset.FILESIZE.get(n4)) & 0xFFFFFFFFL);
                } else {
                    file.setSegmentSize(0, block.get48(Offset.FILESIZE.get(n4)));
                }
            } else {
                Block block3 = new Block(4);
                FileDescriptor fileDescriptor2 = file.getSegment(n3);
                fileSystemCache.seek(fileDescriptor2, Offset.D_FILESIZE.get(n4));
                fileSystemCache.read(fileDescriptor2, block3, CacheDataType.HEADER);
                file.setSegmentSize(n3, (long)block3.get32(0) & 0xFFFFFFFFL);
            }
            int n6 = 0;
            n2 = 0;
            if (n4 < 6) {
                n6 = block.get16(Offset.WHOLE_DATA_SEG.get(n4)) & 0xFFFF;
                n2 = block.get16(Offset.DATA_SEGS.get(n4)) & 0xFFFF;
            }
            while (file.getSegmentCount() <= n2) {
                if (this.loadAdditionalSegment(file, false, file.getSegmentCount())) continue;
                return false;
            }
            file.getFileSize().setSegment(n6);
            if (n4 < 6) {
                file.getFileSize().setOffset((long)block.get32(Offset.WHOLE_DATA_OFF.get(n4)) & 0xFFFFFFFFL);
            } else {
                file.getFileSize().setOffset(block.get48(Offset.WHOLE_DATA_OFF.get(n4)));
            }
            IndexFile indexFile = file.getIndexFile();
            int n7 = indexFile.getSegmentCount() - 1;
            object = indexFile.getSegment(n7);
            fileSystemCache.seek((FileDescriptor)object, Offset.I_FILESIZE.get(n4));
            if (n4 < 6) {
                block2 = new Block(4);
                fileSystemCache.read((FileDescriptor)object, block2, CacheDataType.HEADER);
                indexFile.setSegmentSize(n7, (long)block2.get32(0) & 0xFFFFFFFFL);
            } else {
                block2 = new Block(6);
                fileSystemCache.read((FileDescriptor)object, block2, CacheDataType.HEADER);
                indexFile.setSegmentSize(n7, block2.get48(0));
            }
            n6 = 0;
            n2 = 0;
            if (n4 < 6) {
                n6 = block.get16(Offset.WHOLE_INDEX_SEG.get(n4)) & 0xFFFF;
                n2 = block.get16(Offset.INDEX_SEGS.get(n4)) & 0xFFFF;
            }
            while (indexFile.getSegmentCount() <= n2) {
                if (this.loadAdditionalSegment(file, true, indexFile.getSegmentCount())) continue;
                return false;
            }
            indexFile.getFileSize().setSegment(n6);
            if (n4 < 6) {
                indexFile.getFileSize().setOffset((long)block.get32(Offset.WHOLE_INDEX_OFF.get(n4)) & 0xFFFFFFFFL);
            } else {
                indexFile.getFileSize().setOffset(block.get48(Offset.WHOLE_INDEX_OFF.get(n4)));
            }
        }
        if (bl) {
            if (n4 == 3) {
                file.getFileSize().setOffset((long)block.get32(Offset.FILESIZE.get(n4)) & 0xFFFFFFFFL);
                file.getFileSize().setSegment(0);
                file.getNextBlock().setSegment(0);
                file.getNextRec().setSegment(0);
                file.getFreeRec().setSegment(0);
                file.getAbandonedRec().setSegment(0);
                file.getFreeNode().setSegment(0);
            } else if (n4 < 6) {
                file.getNextBlock().setSegment(block.get16(Offset.NXTBLK_SEG.get(n4)) & 0xFFFF);
                file.getNextRec().setSegment(block.get16(Offset.NXTREC_SEG.get(n4)) & 0xFFFF);
                file.getFreeRec().setSegment(block.get16(Offset.FREEREC_SEG.get(n4)) & 0xFFFF);
                file.getFreeNode().setSegment(block.get16(Offset.FREENODE_SEG.get(n4)) & 0xFFFF);
                IndexFile indexFile = file.getIndexFile();
                indexFile.getNextBlock().setOffset((long)block.get32(Offset.I_NXTBLK_OFF.get(n4)) & 0xFFFFFFFFL);
                indexFile.getNextBlock().setSegment(block.get16(Offset.I_NXTBLK_SEG.get(n4)) & 0xFFFF);
            } else {
                file.getNextBlock().setSegment(0);
                file.getNextRec().setSegment(0);
                file.getFreeRec().setSegment(0);
                file.getFreeNode().setSegment(0);
                IndexFile indexFile = file.getIndexFile();
                indexFile.getNextBlock().setOffset(block.get48(Offset.I_NXTBLK_OFF.get(n4)));
                indexFile.getNextBlock().setSegment(0);
            }
            if (n4 < 6) {
                file.getNextBlock().setOffset((long)block.get32(Offset.NXTBLK_OFF.get(n4)) & 0xFFFFFFFFL);
                file.getNextRec().setOffset((long)block.get32(Offset.NXTREC_OFF.get(n4)) & 0xFFFFFFFFL);
                file.getFreeRec().setOffset((long)block.get32(Offset.FREEREC_OFF.get(n4)) & 0xFFFFFFFFL);
                file.getFreeNode().setOffset((long)block.get32(Offset.FREENODE_OFF.get(n4)) & 0xFFFFFFFFL);
            } else {
                file.getNextBlock().setOffset(block.get48(Offset.NXTBLK_OFF.get(n4)));
                file.getNextRec().setOffset(block.get48(Offset.NXTREC_OFF.get(n4)));
                file.getFreeRec().setOffset(block.get48(Offset.FREEREC_OFF.get(n4)));
                file.getFreeNode().setOffset(block.get48(Offset.FREENODE_OFF.get(n4)));
            }
            file.setTotalRecords((long)block.get32(Offset.RECCOUNT.get(n4)) & 0xFFFFFFFFL);
            file.setDeletedRecords((long)block.get32(Offset.DELCOUNT.get(n4)) & 0xFFFFFFFFL);
            file.setNextUniqueId((long)block.get32(Offset.NEXTUNIQ.get(n4)) & 0xFFFFFFFFL);
            file.setFreeFailures(block.get16(Offset.FREEFAILS.get(n4)) & 0xFFFF);
            file.setOpenCounter(block.get16(Offset.OPEN_CNT.get(n4)) & 0xFFFF);
            if (n4 < 5) {
                file.setUsedNodes(block.get16(Offset.NODES_USED.get(n4)) & 0xFFFF);
                file.setFreeNodes(block.get16(Offset.NODES_FREE.get(n4)) & 0xFFFF);
                file.setNodeUsage((long)block.get32(Offset.NODE_USAGE.get(n4)) & 0xFFFFFFFFL);
            } else {
                file.setNodeUsage(block.get48(Offset.NODE_USAGE.get(n4)));
                if (n4 < 6) {
                    file.setUsedNodes((long)block.get32(Offset.NODES_USED.get(n4)) & 0xFFFFFFFFL);
                    file.setFreeNodes((long)block.get32(Offset.NODES_FREE.get(n4)) & 0xFFFFFFFFL);
                    file.getAbandonedRec().setOffset((long)block.get32(Offset.ABREC_OFF.get(n4)) & 0xFFFFFFFFL);
                    file.getAbandonedRec().setSegment(block.get16(Offset.ABREC_SEG.get(n4)) & 0xFFFF);
                } else {
                    file.setUsedNodes(block.get48(Offset.NODES_USED.get(n4)));
                    file.setFreeNodes(block.get48(Offset.NODES_FREE.get(n4)));
                    file.getAbandonedRec().setOffset(block.get48(Offset.ABREC_OFF.get(n4)));
                    file.getAbandonedRec().setSegment(0);
                }
                file.setAbandonedRecords((long)block.get32(Offset.ABCOUNT.get(n4)) & 0xFFFFFFFFL);
            }
            n3 = block.get16(Offset.BROKEN.get(n4));
            if (n3 != 0) {
                if (this.config.V_FORCE_OPEN.isOff()) {
                    this.release(file);
                    this.status.setErrno(6);
                    this.status.setIntErrno(n3);
                    return false;
                }
            } else if (file.getNextUniqueId() == 0xFFFFFFFFL) {
                if (bl2) {
                    Block block4 = new Block(2);
                    block4.put16(0, (short)42);
                    fileSystemCache.seek(fileDescriptor, Offset.BROKEN.get(n4));
                    fileSystemCache.write(fileDescriptor, block4, CacheDataType.HEADER);
                }
                this.release(file);
                this.status.setErrno(6);
                this.status.setIntErrno(42);
                return false;
            }
            if (bl2 && this.config.V_LOCK_METHOD.is(1)) {
                block.put16(Offset.UPDATING.get(n4), (short)1);
                fileSystemCache.seek(fileDescriptor, 0L);
                fileSystemCache.write(fileDescriptor, block, 0, Offset.PHDR_SIZE.get(n4), CacheDataType.HEADER);
            }
        }
        if ((l2 = (long)block.get32(Offset.ROOT_VERS.get(n4)) & 0xFFFFFFFFL) != file.getKeyRootVersion()) {
            file.setKeyRootVersion(l2);
            n2 = Offset.KEYINFO.get(n4);
            int n8 = Offset.KEY_MULT.get(n4);
            Block block5 = new Block(n8);
            object = file.getLogicalAttributes();
            for (int i2 = 0; i2 < ((LogicalAttributes)object).getNumKeys(); ++i2) {
                int n9 = 512 - n2 % 512;
                if (n9 < n8) {
                    n2 += n9;
                }
                fileSystemCache.seek(fileDescriptor, n2);
                fileSystemCache.read(fileDescriptor, block5, CacheDataType.HEADER);
                n2 += n8;
                KeyInfo keyInfo = ((LogicalAttributes)object).getKey(i2);
                if (n4 < 6) {
                    keyInfo.getKeyRoot().setOffset((long)block5.get32(Offset.KEYROOT_OFF.get(n4)) & 0xFFFFFFFFL);
                } else {
                    keyInfo.getKeyRoot().setOffset(block5.get48(Offset.KEYROOT_OFF.get(n4)));
                }
                if (n4 == 4 || n4 == 5) {
                    keyInfo.getKeyRoot().setSegment(block5.get16(Offset.KEYROOT_SEG.get(n4)) & 0xFFFF);
                } else {
                    keyInfo.getKeyRoot().setSegment(0);
                }
                keyInfo.setHeight((short)(block5.get8(Offset.KEYHEIGHT.get(n4)) & 0xFF));
            }
        }
        file.setHeaderLocked(true);
        return true;
    }

    public boolean locklessReadCheck(File file) {
        if (file.isUnlockedHeaderRead()) {
            int n2 = file.getVersion();
            FileDescriptor fileDescriptor = this.retrieveSegment(file, BlockType.DATA, 0);
            Block block = file.getHeaderCache();
            FileSystemCache fileSystemCache = file.getFileSystemCache();
            fileSystemCache.seek(fileDescriptor, 4L);
            fileSystemCache.read(fileDescriptor, block, 4, Offset.PHDR_SIZE.get(n2) - 4, CacheDataType.HEADER);
            long l2 = (long)block.get32(Offset.IVERSION.get(n2)) & 0xFFFFFFFFL;
            if (block.get16(Offset.UPDATING.get(n2)) > 0 || l2 != file.getTreeVersion()) {
                return false;
            }
        }
        return true;
    }

    private boolean loadAdditionalSegment(File file, boolean bl, int n2) {
        boolean bl2;
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        FileDescriptor fileDescriptor = fileSystemCache.open(bl ? this.getIndexSegmentName(file.getName(), n2) : this.getDataSegmentName(file.getName(), n2), this.standardizeOpenMode(file.getOpenMode()));
        if (fileDescriptor == null) {
            if (this.status.getErrno() == 15) {
                this.status.setErrno(6);
                this.status.setIntErrno(bl ? 69 : 68);
            }
            return false;
        }
        FileLock fileLock = fileSystemCache.lock(fileDescriptor);
        if (fileLock == null) {
            fileSystemCache.close(fileDescriptor);
            return false;
        }
        Block block = new Block(512);
        if (fileSystemCache.read(fileDescriptor, block, CacheDataType.HEADER) != 512) {
            fileSystemCache.unlock(fileLock);
            fileSystemCache.close(fileDescriptor);
            return false;
        }
        int n3 = file.getVersion();
        int n4 = file.getHeaderCache().get16(Offset.OPEN_CNT.get(n3)) & 0xFFFF;
        boolean bl3 = bl2 = n4 == 0 && (this.config.V_OPEN_STRICT.isOn() || this.config.V_FORCE_OPEN.isOff());
        if (bl) {
            int n5 = block.get32(Offset.I_MAGIC.get(n3));
            short s2 = block.get16(Offset.I_VERSION.get(n3));
            short s3 = block.get16(Offset.I_SEGNUM.get(n3));
            if (n5 != 269620248 || s2 != n3 || s3 != n2) {
                fileSystemCache.unlock(fileLock);
                fileSystemCache.close(fileDescriptor);
                this.status.setErrno(13);
                return false;
            }
            if (bl2 && file.getTreeVersion() != ((long)block.get32(Offset.I_IVERSION.get(n3)) & 0xFFFFFFFFL)) {
                fileSystemCache.unlock(fileLock);
                fileSystemCache.close(fileDescriptor);
                this.status.setErrno(6);
                this.status.setIntErrno(90);
                return false;
            }
            IndexFile indexFile = file.getIndexFile();
            indexFile.addSegment(fileDescriptor);
            indexFile.setSegmentSize(n2, (long)block.get32(Offset.I_FILESIZE.get(n3)) & 0xFFFFFFFFL);
        } else {
            int n6 = block.get32(Offset.D_MAGIC.get(n3));
            short s4 = block.get16(Offset.D_VERSION.get(n3));
            short s5 = block.get16(Offset.D_SEGNUM.get(n3));
            if (n6 != 269620247 || s4 != n3 || s5 != n2) {
                fileSystemCache.unlock(fileLock);
                fileSystemCache.close(fileDescriptor);
                this.status.setErrno(13);
                return false;
            }
            if (bl2 && file.getTreeVersion() != ((long)block.get32(Offset.D_IVERSION.get(n3)) & 0xFFFFFFFFL)) {
                fileSystemCache.unlock(fileLock);
                fileSystemCache.close(fileDescriptor);
                this.status.setErrno(6);
                this.status.setIntErrno(89);
                return false;
            }
            file.addSegment(fileDescriptor);
            file.setSegmentSize(n2, (long)block.get32(Offset.D_FILESIZE.get(n3)) & 0xFFFFFFFFL);
        }
        fileSystemCache.unlock(fileLock);
        return true;
    }

    protected boolean unlockHeader(File file, boolean bl) {
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        file.getCurrentNode().invalidate();
        if (file.isHeaderLocked()) {
            FileDescriptor fileDescriptor = file.getSegment(0);
            if (this.status.getErrno() == 6 && this.isInputOnly(file.getOpenMode()) && (this.config.V_MARK_READ_CORRUPT.isOn() || !bl)) {
                Block block = new Block(2);
                block.put16(0, (short)this.status.getIntErrno());
                fileSystemCache.seek(fileDescriptor, Offset.BROKEN.get(file.getVersion()));
                fileSystemCache.write(fileDescriptor, block, CacheDataType.HEADER);
            }
            this.release(file);
            file.setHeaderLocked(false);
            file.setUnlockedHeaderRead(false);
        }
        return true;
    }

    protected void saveHeader(File file, boolean bl) {
        int n2 = file.getVersion();
        if (bl) {
            file.incTreeVersion();
        }
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        fileSystemCache.setCacheVersion(file.getTreeVersion());
        Block block = file.getHeaderCache();
        if (n2 < 6) {
            block.put32(Offset.NXTREC_OFF.get(n2), (int)file.getNextRec().getOffset());
        } else {
            block.put48(Offset.NXTREC_OFF.get(n2), file.getNextRec().getOffset());
        }
        if (n2 == 3) {
            block.put32(Offset.FILESIZE.get(n2), (int)file.getFileSize().getOffset());
        } else if (n2 < 6) {
            block.put16(Offset.NXTREC_SEG.get(n2), (short)file.getNextRec().getSegment());
            block.put32(Offset.WHOLE_DATA_OFF.get(n2), (int)file.getFileSize().getOffset());
            block.put16(Offset.WHOLE_DATA_SEG.get(n2), (short)file.getFileSize().getSegment());
            block.put32(Offset.WHOLE_INDEX_OFF.get(n2), (int)file.getIndexFile().getFileSize().getOffset());
            block.put16(Offset.WHOLE_INDEX_SEG.get(n2), (short)file.getIndexFile().getFileSize().getSegment());
            block.put16(Offset.DATA_SEGS.get(n2), (short)(file.getSegmentCount() - 1));
            block.put16(Offset.INDEX_SEGS.get(n2), (short)(file.getIndexFile().getSegmentCount() - 1));
        } else {
            block.put48(Offset.WHOLE_DATA_OFF.get(n2), file.getFileSize().getOffset());
            block.put48(Offset.WHOLE_INDEX_OFF.get(n2), file.getIndexFile().getFileSize().getOffset());
        }
        block.put32(Offset.RECCOUNT.get(n2), (int)file.getTotalRecords());
        block.put32(Offset.DELCOUNT.get(n2), (int)file.getDeletedRecords());
        block.put32(Offset.NEXTUNIQ.get(n2), (int)file.getNextUniqueId());
        block.put32(Offset.IVERSION.get(n2), (int)file.getTreeVersion());
        if (n2 < 5) {
            block.put32(Offset.NODE_USAGE.get(n2), (int)file.getNodeUsage());
        } else {
            block.put48(Offset.NODE_USAGE.get(n2), file.getNodeUsage());
            block.put32(Offset.ABCOUNT.get(n2), (int)file.getAbandonedRecords());
        }
        block.put16(Offset.FREEFAILS.get(n2), (short)file.getFreeFailures());
        block.put16(Offset.UPDATING.get(n2), (short)0);
        FileDescriptor fileDescriptor = this.retrieveSegment(file, BlockType.DATA, 0);
        fileSystemCache.seek(fileDescriptor, 0L);
        fileSystemCache.write(fileDescriptor, block, 0, Offset.PHDR_SIZE.get(n2), CacheDataType.HEADER);
    }

    protected FileDescriptor retrieveSegment(File file, BlockType blockType, int n2) {
        if (file.getVersion() > 3) {
            if (blockType == BlockType.NODE) {
                return file.getIndexFile().getSegment(n2);
            }
            return file.getSegment(n2);
        }
        return file.getSegment(0);
    }

    private boolean updateSegmentSize(File file, BlockType blockType, FileAddress fileAddress) {
        int n2;
        Block block;
        int n3 = file.getVersion();
        if (n3 < 6) {
            block = new Block(4);
            block.put32(0, (int)fileAddress.getOffset());
        } else {
            block = new Block(6);
            block.put48(0, fileAddress.getOffset());
        }
        if (blockType == BlockType.NODE) {
            file.getIndexFile().setSegmentSize(fileAddress.getSegment(), fileAddress.getOffset());
            n2 = Offset.I_FILESIZE.get(n3);
        } else {
            file.setSegmentSize(fileAddress.getSegment(), fileAddress.getOffset());
            if (fileAddress.getSegment() > 0) {
                n2 = Offset.D_FILESIZE.get(n3);
            } else {
                n2 = Offset.FILESIZE.get(n3);
                file.getHeaderCache().copy(n2, block, 0, block.size());
            }
        }
        FileDescriptor fileDescriptor = this.retrieveSegment(file, blockType, fileAddress.getSegment());
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        fileSystemCache.seek(fileDescriptor, n2);
        return fileSystemCache.write(fileDescriptor, block, CacheDataType.HEADER) == block.size();
    }

    private boolean createAdditionalSegment(File file, BlockType blockType) {
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        SegmentedFile segmentedFile = file;
        if (blockType == BlockType.NODE) {
            segmentedFile = file.getIndexFile();
        }
        if (segmentedFile.getSegmentCount() >= 65535) {
            this.status.setErrno(6);
            this.status.setIntErrno(99);
            return false;
        }
        int n2 = segmentedFile.getSegmentCount();
        String string = this.getSegmentName(file.getName(), blockType, n2);
        FileDescriptor fileDescriptor = fileSystemCache.open(string, 1);
        if (fileDescriptor == null) {
            this.status.setErrno(1);
            return false;
        }
        fileSystemCache.close(fileDescriptor);
        fileDescriptor = fileSystemCache.open(string, this.standardizeOpenMode(file.getOpenMode()));
        if (fileDescriptor == null) {
            this.status.setErrno(1);
            return false;
        }
        int n3 = file.getVersion();
        Block block = new Block(512);
        if (blockType == BlockType.NODE) {
            block.put32(Offset.I_MAGIC.get(n3), 269620248);
            block.put16(Offset.I_VERSION.get(n3), (short)n3);
            block.put16(Offset.I_SEGNUM.get(n3), (short)n2);
            block.put32(Offset.I_FILESIZE.get(n3), 512);
        } else {
            block.put32(Offset.D_MAGIC.get(n3), 269620247);
            block.put16(Offset.D_VERSION.get(n3), (short)n3);
            block.put16(Offset.D_SEGNUM.get(n3), (short)n2);
            block.put32(Offset.D_FILESIZE.get(n3), 512);
        }
        if (fileSystemCache.write(fileDescriptor, block, CacheDataType.HEADER) != 512) {
            return false;
        }
        segmentedFile.addSegment(fileDescriptor);
        segmentedFile.setSegmentSize(n2, 512L);
        return true;
    }

    private boolean newBlock(File file, BlockType blockType) {
        int n2;
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        int n3 = file.getVersion();
        SegmentedFile segmentedFile = file;
        if (n3 > 3 && blockType == BlockType.NODE) {
            segmentedFile = file.getIndexFile();
        }
        int n4 = file.getPhysicalAttributes().getExtensionFactor();
        if (blockType == BlockType.NODE && (n4 = (int)((double)n4 * ((double)this.config.V_INDEX_BLOCK_PERCENT.getIntegerValue() / 100.0) + 0.5)) < 1) {
            n4 = 1;
        }
        FileAddress fileAddress = segmentedFile.getNextBlock();
        FileAddress fileAddress2 = fileAddress.copy();
        FileDescriptor fileDescriptor = this.retrieveSegment(file, blockType, fileAddress.getSegment());
        fileSystemCache.seek(fileDescriptor, fileAddress.getOffset());
        CacheDataType cacheDataType = blockType == BlockType.NODE ? CacheDataType.INDEX : CacheDataType.RECORD;
        int n5 = file.getPhysicalAttributes().getBlockingFactor();
        FileAddress fileAddress3 = segmentedFile.getFileSize();
        Block block = new Block(512);
        if (fileAddress.ge(fileAddress3)) {
            for (int i2 = 0; i2 < n4; ++i2) {
                if (n3 == 3) {
                    block.put8(0, i2 == 0 ? blockType.getVal() : BlockType.EMPTY.getVal());
                }
                n2 = 0;
                boolean bl = false;
                for (int i3 = 0; i3 < n5; ++i3) {
                    if ((n3 == 4 || n3 == 5) && fileAddress2.getOffset() > file.getMaxSegmentSize() - 512L) {
                        if (!this.updateSegmentSize(file, blockType, fileAddress2)) {
                            this.status.setErrno(1);
                            return false;
                        }
                        if (!this.createAdditionalSegment(file, blockType)) {
                            return false;
                        }
                        fileAddress2.incSegment();
                        fileAddress2.setOffset(512L);
                        fileDescriptor = this.retrieveSegment(file, blockType, fileAddress2.getSegment());
                        fileSystemCache.seek(fileDescriptor, fileAddress2.getOffset());
                        i3 -= n2;
                        bl = true;
                    }
                    if (!bl) {
                        ++n2;
                    }
                    if (fileSystemCache.write(fileDescriptor, block, cacheDataType) != 512) {
                        return false;
                    }
                    fileAddress2.incOffset(512L);
                    block.put8(0, (byte)0);
                }
            }
            fileAddress3.copyFrom(fileAddress2);
            if (n3 > 3 && !this.updateSegmentSize(file, blockType, fileAddress3)) {
                this.status.setErrno(1);
                return false;
            }
        } else if (n3 == 3 && blockType != BlockType.NODE) {
            block.put8(0, blockType.getVal());
            fileSystemCache.write(fileDescriptor, block, 0, 1, cacheDataType);
        }
        Block block2 = file.getHeaderCache();
        n2 = n5 * 512;
        if (n3 == 3) {
            fileAddress.incOffset(n2);
            block2.put32(Offset.NXTBLK_OFF.get(n3), (int)fileAddress.getOffset());
        } else {
            if (n3 < 6 && fileAddress.getOffset() > file.getMaxSegmentSize() - (long)n2) {
                fileAddress.incSegment();
                fileAddress.setOffset(512 + n2);
            } else {
                fileAddress.incOffset(n2);
            }
            if (blockType == BlockType.NODE) {
                if (n3 < 6) {
                    block2.put32(Offset.I_NXTBLK_OFF.get(n3), (int)fileAddress.getOffset());
                    block2.put16(Offset.I_NXTBLK_SEG.get(n3), (short)fileAddress.getSegment());
                } else {
                    block2.put48(Offset.I_NXTBLK_OFF.get(n3), fileAddress.getOffset());
                }
            } else if (n3 < 6) {
                block2.put32(Offset.NXTBLK_OFF.get(n3), (int)fileAddress.getOffset());
                block2.put16(Offset.NXTBLK_SEG.get(n3), (short)fileAddress.getSegment());
            } else {
                block2.put48(Offset.NXTBLK_OFF.get(n3), fileAddress.getOffset());
            }
        }
        return true;
    }

    protected FileAddress getRecord(File file, Block block, int n2, FileAddress fileAddress, boolean bl) {
        FileAddress fileAddress2;
        block9: {
            FileSystemCache fileSystemCache = file.getFileSystemCache();
            fileAddress2 = fileAddress.copy();
            int n3 = 0;
            if (bl) {
                fileAddress2.incOffset(1L);
                --n2;
                n3 = 1;
            }
            if (fileAddress2.getOffset() < 0L) {
                this.status.setErrno(6);
                this.status.setIntErrno(83);
                fileAddress2.initialize();
                return fileAddress2;
            }
            if (fileAddress2.getSegment() >= file.getSegmentCount()) {
                this.status.setErrno(6);
                this.status.setIntErrno(83);
                fileAddress2.initialize();
                return fileAddress2;
            }
            FileDescriptor fileDescriptor = this.retrieveSegment(file, BlockType.DATA, fileAddress2.getSegment());
            if (file.getVersion() == 3) {
                Block block2 = new Block(4);
                int n4 = file.getBlockSize();
                do {
                    int n5 = Math.min(n2, n4 - (int)(fileAddress2.getOffset() % (long)n4) - 4);
                    fileSystemCache.seek(fileDescriptor, fileAddress2.getOffset());
                    if (n5 > 0 && fileSystemCache.read(fileDescriptor, block, n3, n5, CacheDataType.RECORD) != n5) {
                        this.status.setErrno(6);
                        this.status.setIntErrno(83);
                        fileAddress2.initialize();
                        return fileAddress2;
                    }
                    n3 += n5;
                    if ((n2 -= n5) == 0) {
                        fileAddress2.incOffset(n5);
                        break block9;
                    }
                    if (fileSystemCache.read(fileDescriptor, block2, CacheDataType.RECORD) != 4) {
                        this.status.setErrno(6);
                        this.status.setIntErrno(83);
                        fileAddress2.initialize();
                        return fileAddress2;
                    }
                    fileAddress2.setOffset(block2.get32(0) + 1);
                } while (fileAddress2.getOffset() > 1L);
                this.status.setErrno(6);
                this.status.setIntErrno(83);
                fileAddress2.initialize();
                return fileAddress2;
            }
            fileSystemCache.seek(fileDescriptor, fileAddress2.getOffset());
            if (fileSystemCache.read(fileDescriptor, block, n3, n2, CacheDataType.RECORD) != n2) {
                this.status.setErrno(6);
                this.status.setIntErrno(83);
                fileAddress2.initialize();
                return fileAddress2;
            }
            fileAddress2.incOffset(n2);
        }
        return fileAddress2;
    }

    protected int getRecordWithLock(File file, byte[] byArray, FileAddress fileAddress, RecordHeader recordHeader, LockType lockType) {
        FileAddress fileAddress2;
        int n2;
        int n3;
        this.unlockRecord(file);
        int n4 = file.getBlockSize();
        if (file.getVersion() == 3 && (n3 = n4 - (int)(fileAddress.getOffset() % (long)n4)) == 4) {
            this.status.setErrno(6);
            this.status.setIntErrno(31);
            return 0;
        }
        n3 = (file.getOpenMode() & 0x300) != 0 ? 1 : 0;
        boolean bl = this.isInputOnly(file.getOpenMode()) || n3 != 0 || this.config.F_NO_LOCK == 1;
        boolean bl2 = !bl && this.config.F_NO_LOCK == 0;
        boolean bl3 = false;
        Lock[] lockArray = file.getLocks();
        int n5 = lockArray.length;
        if (!bl && n5 > 1) {
            for (n2 = 0; n2 < n5 && lockArray[n2] != null; ++n2) {
                if (!lockArray[n2].getAddress().eq(fileAddress)) continue;
                bl2 = false;
                lockArray[n2].updateType(lockType);
                bl3 = true;
                break;
            }
            if (!bl3 && n2 >= n5) {
                this.status.setErrno(18);
                this.status.setIntErrno(3);
                return 0;
            }
        }
        if (!bl && !bl3) {
            Lock lock = this.createLock(file, fileAddress, lockType);
            if (lock == null) {
                return 0;
            }
            if (bl2) {
                lockArray[n2] = lock;
            } else {
                lock.release();
            }
        }
        if (byArray == null) {
            return n4;
        }
        boolean bl4 = this.isInputOnly(file.getOpenMode()) || this.config.F_NO_LOCK > 0;
        Block block = file.getRecord();
        LogicalAttributes logicalAttributes = file.getLogicalAttributes();
        if (logicalAttributes.getMinRecordSize() < logicalAttributes.getMaxRecordSize() || logicalAttributes.isCompressed()) {
            fileAddress2 = this.getRecord(file, block, file.getRecordOverhead(), fileAddress, bl4);
            if (fileAddress2.isZero()) {
                if (bl2) {
                    lockArray[n2].release();
                    lockArray[n2] = null;
                }
                return 0;
            }
            this.unpackRecordHeader(file, block, recordHeader);
            if (recordHeader.getStatus() != RecordStatus.NO_STATUS || recordHeader.getUsed() > logicalAttributes.getMaxRecordSize() || recordHeader.getUsed() <= 0) {
                this.status.setErrno(6);
                this.status.setIntErrno(81);
                if (bl2) {
                    lockArray[n2].release();
                    lockArray[n2] = null;
                }
                return 0;
            }
            boolean bl5 = logicalAttributes.isCompressed() && !recordHeader.isUncompressed();
            fileAddress2 = this.getRecord(file, bl5 ? file.getCompressedRecord() : block, file.getRecordOverhead() + recordHeader.getUsed(), fileAddress, bl4);
            if (fileAddress2.isZero()) {
                if (bl2) {
                    lockArray[n2].release();
                    lockArray[n2] = null;
                }
                return 0;
            }
            if (bl5) {
                n4 = this.inflate(file, block, file.getRecordOverhead(), recordHeader.getUsed());
                if (n4 == 0) {
                    this.status.setErrno(6);
                    this.status.setIntErrno(85);
                    if (bl2) {
                        lockArray[n2].release();
                        lockArray[n2] = null;
                    }
                    return 0;
                }
            } else {
                n4 = recordHeader.getUsed();
            }
        } else {
            fileAddress2 = this.getRecord(file, block, block.size(), fileAddress, bl4);
            if (fileAddress2.isZero()) {
                if (bl2) {
                    lockArray[n2].release();
                    lockArray[n2] = null;
                }
                return 0;
            }
            this.unpackRecordHeader(file, block, recordHeader);
            if (recordHeader.getStatus() != RecordStatus.NO_STATUS || recordHeader.getUsed() > logicalAttributes.getMaxRecordSize()) {
                this.status.setErrno(6);
                this.status.setIntErrno(82);
                if (bl2) {
                    lockArray[n2].release();
                    lockArray[n2] = null;
                }
                return 0;
            }
            n4 = recordHeader.getUsed();
        }
        System.arraycopy(block.getBytes(), file.getRecordOverhead(), byArray, 0, Math.min(byArray.length, n4));
        if (bl2 || n3 != 0) {
            file.getCurrentRecord().copyFrom(fileAddress);
            KeyInfo keyInfo = logicalAttributes.getKey(0);
            int n6 = 0;
            for (int i2 = 0; i2 < keyInfo.getSegments(); ++i2) {
                int n7 = keyInfo.getSize(i2);
                file.getCurrentPrimaryKey().copy(n6, byArray, keyInfo.getOffset(i2), n7);
                n6 += n7;
            }
            if (bl2 && this.config.V_INTERNAL_LOCKS.isOff()) {
                this.extendLock(file, lockArray[n2], fileAddress2);
            }
        }
        return n4;
    }

    protected FileAddress setRecord(File file, Block block, int n2, FileAddress fileAddress, boolean bl) {
        FileAddress fileAddress2;
        block16: {
            FileSystemCache fileSystemCache = file.getFileSystemCache();
            fileAddress2 = fileAddress.copy();
            FileDescriptor fileDescriptor = this.retrieveSegment(file, BlockType.DATA, fileAddress2.getSegment());
            int n3 = file.getVersion();
            if (n3 == 3) {
                int n4 = 0;
                Block block2 = new Block(4);
                int n5 = file.getBlockSize();
                while (true) {
                    fileSystemCache.seek(fileDescriptor, fileAddress2.getOffset());
                    int n6 = Math.min(n2, n5 - (int)(fileAddress2.getOffset() % (long)n5) - 4);
                    if (n6 > 0 && fileSystemCache.write(fileDescriptor, block, n4, n6, CacheDataType.RECORD) != n6) {
                        fileAddress2.initialize();
                        return fileAddress2;
                    }
                    if ((n2 -= n6) == 0) {
                        fileAddress2.incOffset(n6);
                        break block16;
                    }
                    n4 += n6;
                    if (bl) {
                        fileAddress2 = file.getNextBlock().copy();
                        block2.put32(0, (int)fileAddress2.getOffset());
                        fileAddress2.incOffset(1L);
                        fileSystemCache.write(fileDescriptor, block2, CacheDataType.RECORD);
                        if (!this.newBlock(file, BlockType.DATA)) {
                            fileAddress2.initialize();
                            return fileAddress2;
                        }
                    } else {
                        if (fileSystemCache.read(fileDescriptor, block2, CacheDataType.RECORD) != 4) {
                            this.status.setErrno(6);
                            this.status.setIntErrno(86);
                            fileAddress2.initialize();
                            return fileAddress2;
                        }
                        fileAddress2.setOffset(block2.get32(0) + 1);
                    }
                    if (n6 != 0) continue;
                    fileAddress.copyFrom(fileAddress2);
                }
            }
            if (bl) {
                int n7;
                int n8 = 0;
                long l2 = fileAddress2.getOffset();
                int n9 = file.getBlockSize();
                if (n3 < 6) {
                    long l3 = file.getMaxSegmentSize();
                    if (l2 > l3 - (long)n2) {
                        n8 = (int)((long)n8 + ((l3 - l2) / (long)n9 + 1L));
                        fileAddress2.incSegment();
                        fileAddress2.setOffset(512L);
                        fileAddress.copyFrom(fileAddress2);
                    }
                    if (fileAddress2.getSegment() > 0) {
                        l2 = fileAddress2.getOffset() - 512L;
                    }
                }
                if (n2 >= (n7 = n9 - (int)(l2 % (long)n9))) {
                    n8 += (n2 - n7) / n9 + 1;
                }
                while (n8-- > 0) {
                    if (this.newBlock(file, BlockType.DATA)) continue;
                    fileAddress2.initialize();
                    return fileAddress2;
                }
                if (n3 < 6) {
                    fileDescriptor = this.retrieveSegment(file, BlockType.DATA, fileAddress2.getSegment());
                }
            }
            fileSystemCache.seek(fileDescriptor, fileAddress2.getOffset());
            if (fileSystemCache.write(fileDescriptor, block, 0, n2, CacheDataType.RECORD) != n2) {
                fileAddress2.initialize();
                return fileAddress2;
            }
            fileAddress2.incOffset(n2);
        }
        return fileAddress2;
    }

    private void unpackRecordHeader(File file, Block block, RecordHeader recordHeader) {
        int n2 = file.getVersion();
        if (n2 < 5) {
            recordHeader.setSize(block.get16(0) & 0xFFFF);
            short s2 = block.get16(2);
            if ((s2 & 0x8000) != 0) {
                recordHeader.setUncompressed(true);
                s2 = (short)(s2 & Short.MAX_VALUE);
            }
            recordHeader.setUsed(s2);
            recordHeader.setUniqueId(file.getLogicalAttributes().getDuplicates() > 0 ? (long)block.get32(4) & 0xFFFFFFFFL : 0L);
            recordHeader.setStatus(recordHeader.getUsed() == 0 ? RecordStatus.DELETED : RecordStatus.NO_STATUS);
            recordHeader.getNextDeleted().initialize();
        } else {
            recordHeader.setSize(block.get32(0));
            recordHeader.setUsed(block.get32(4));
            byte by = block.get8(8);
            if ((by & 4) != 0) {
                recordHeader.setUncompressed(true);
            }
            recordHeader.setStatus(RecordStatus.from(by));
            if (recordHeader.getStatus() == RecordStatus.NO_STATUS) {
                recordHeader.setUniqueId(file.getLogicalAttributes().getDuplicates() > 0 ? (long)block.get32(9) & 0xFFFFFFFFL : 0L);
                recordHeader.getNextDeleted().initialize();
            } else {
                FileAddress fileAddress = new FileAddress();
                if (n2 < 6) {
                    fileAddress.setOffset((long)block.get32(9) & 0xFFFFFFFFL);
                    fileAddress.setSegment(block.get16(13) & 0xFFFF);
                } else {
                    fileAddress.setOffset(block.get48(9));
                }
                recordHeader.getNextDeleted().copyFrom(fileAddress);
                recordHeader.setUniqueId(0L);
            }
        }
    }

    private void packRecordHeader(File file, Block block, RecordHeader recordHeader) {
        int n2 = file.getVersion();
        if (n2 < 5) {
            block.put16(0, (short)recordHeader.getSize());
            if (recordHeader.getStatus() == RecordStatus.NO_STATUS) {
                short s2 = (short)recordHeader.getUsed();
                if (recordHeader.isUncompressed()) {
                    s2 = (short)(s2 | 0x8000);
                }
                block.put16(2, s2);
                if (file.getLogicalAttributes().getDuplicates() > 0) {
                    block.put32(4, (int)recordHeader.getUniqueId());
                }
            } else {
                block.put16(2, (short)0);
                if (file.getLogicalAttributes().getDuplicates() > 0) {
                    block.put32(4, 0);
                }
            }
        } else {
            block.put32(0, recordHeader.getSize());
            block.put32(4, recordHeader.getUsed());
            byte by = recordHeader.getStatus().getVal();
            if (recordHeader.isUncompressed()) {
                by = (byte)(by | 4);
            }
            block.put8(8, by);
            if (recordHeader.getStatus() == RecordStatus.NO_STATUS) {
                if (file.getLogicalAttributes().getDuplicates() > 0) {
                    block.put32(9, (int)recordHeader.getUniqueId());
                }
            } else if (n2 < 6) {
                block.put32(9, (int)recordHeader.getNextDeleted().getOffset());
                block.put16(13, (short)recordHeader.getNextDeleted().getSegment());
            } else {
                block.put48(9, recordHeader.getNextDeleted().getOffset());
            }
        }
    }

    private int fileAddressSize(int n2) {
        switch (n2) {
            case 3: {
                return 4;
            }
            case 4: 
            case 5: {
                return 6;
            }
        }
        return 6;
    }

    private int checkMinRecordSize(int n2, int n3) {
        switch (n2) {
            case 3: {
                return Math.max(n3, 4);
            }
            case 4: {
                return Math.max(n3, 6);
            }
            case 5: 
            case 6: {
                return Math.max(n3, 1);
            }
        }
        return n3;
    }

    protected boolean loadNode(File file, FileAddress fileAddress) {
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        FileAddress fileAddress2 = file.getCurrentNode();
        if (!fileAddress.eq(fileAddress2)) {
            FileDescriptor fileDescriptor = this.retrieveSegment(file, BlockType.NODE, fileAddress.getSegment());
            fileSystemCache.seek(fileDescriptor, fileAddress.getOffset());
            if (fileSystemCache.read(fileDescriptor, file.getLoadedNode(), CacheDataType.INDEX) != file.getBlockSize()) {
                fileAddress2.invalidate();
                return false;
            }
            fileAddress2.copyFrom(fileAddress);
        }
        return true;
    }

    protected void buildKey(File file, int n2, byte[] byArray, Block block) {
        KeyInfo keyInfo = file.getLogicalAttributes().getKey(n2);
        block.put8(0, (byte)(keyInfo.getTotalSize() + 1));
        block.put8(1, (byte)n2);
        int n3 = 2;
        for (int i2 = 0; i2 < keyInfo.getSegments(); ++i2) {
            int n4;
            int n5 = keyInfo.getOffset(i2);
            if (file.hasCollate()) {
                for (n4 = keyInfo.getSize(i2); n4 > 0; --n4) {
                    block.put8(n3++, file.collate(byArray[n5++] & 0xFF));
                }
                continue;
            }
            block.copy(n3, byArray, n5, n4);
            n3 += n4;
        }
    }

    private long getKeyInfoOffset(File file, int n2) {
        int n3 = file.getVersion();
        int n4 = Offset.KEY_MULT.get(n3);
        int n5 = Offset.BLK_1_KEYS.get(n3);
        int n6 = Offset.BLK_N_KEYS.get(n3);
        if (n3 == 3 || n2 < n5) {
            return (long)Offset.KEYINFO.get(n3) + (long)n2 * (long)n4;
        }
        long l2 = 512L;
        return (l2 += (long)((n2 -= n5) / n6) * 512L) + (long)(n2 %= n6) * (long)n4;
    }

    private boolean saveNode(File file, Block block, FileAddress fileAddress) {
        block.put8(0, BlockType.NODE.getVal());
        FileDescriptor fileDescriptor = this.retrieveSegment(file, BlockType.NODE, fileAddress.getSegment());
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        fileSystemCache.seek(fileDescriptor, fileAddress.getOffset());
        return fileSystemCache.write(fileDescriptor, block, CacheDataType.INDEX) == file.getBlockSize();
    }

    protected boolean addKey(File file, Block block, FileAddress fileAddress, long l2, boolean bl) {
        FindKeyResult findKeyResult;
        KeyEntry keyEntry = new KeyEntry();
        do {
            if ((findKeyResult = this.findKey(file, block, l2, keyEntry)) != FindKeyResult.EMPTY) continue;
            FileAddress fileAddress2 = new FileAddress();
            FileAddress fileAddress3 = new FileAddress();
            Block block2 = new Block(file.getBlockSize());
            this.makeRoot(file, block2, fileAddress2, fileAddress3);
            if (!fileAddress3.isZero() && this.saveNode(file, block2, fileAddress3)) continue;
            return false;
        } while (findKeyResult == FindKeyResult.EMPTY);
        if (findKeyResult == FindKeyResult.ERROR) {
            return false;
        }
        if (!bl && findKeyResult.fastCompare(FindKeyResult.KEY_MATCH) >= 0) {
            this.status.setErrno(7);
            return false;
        }
        if (findKeyResult == FindKeyResult.FULL_MATCH) {
            this.status.setErrno(6);
            this.status.setIntErrno(3);
            return false;
        }
        return this.insertKey(file, block, l2, fileAddress, keyEntry);
    }

    protected boolean deleteKey(File file, Block block, long l2) {
        KeyEntry keyEntry = new KeyEntry();
        FindKeyResult findKeyResult = this.findKey(file, block, l2, keyEntry);
        if (findKeyResult == FindKeyResult.ERROR) {
            return false;
        }
        if (findKeyResult != FindKeyResult.FULL_MATCH) {
            this.status.setErrno(6);
            this.status.setIntErrno(6);
            return false;
        }
        return this.deleteKeyEntry(file, keyEntry);
    }

    private boolean deleteKeyEntry(File file, KeyEntry keyEntry) {
        CombineMode combineMode = CombineMode.NONE;
        boolean bl = this.deleteKeyEntryFromLoadedNode(file, keyEntry.getPhysicalKeyOffset());
        int n2 = file.getLoadedNode().get16(1) & 0xFFFF;
        if (n2 < (file.getBlockSize() - 3) / 3) {
            combineMode = this.combineNodes(file, keyEntry);
            if (combineMode == CombineMode.ERROR) {
                return false;
            }
            n2 = file.getLoadedNode().get16(1) & 0xFFFF;
        }
        if (n2 == 0) {
            return true;
        }
        if (file.getCurrentNode().gtZero()) {
            this.saveNode(file, file.getLoadedNode(), file.getCurrentNode());
        }
        if (bl && combineMode != CombineMode.RIGHT && keyEntry.getKeyDepth() > 0) {
            int n3 = keyEntry.getKeyDepth() - 1;
            FileAddress fileAddress = file.getNodeAddresses()[n3];
            if (fileAddress.isValid()) {
                return this.refreshLastKey(file, fileAddress, keyEntry.getNodeAddress(), n3);
            }
        }
        return true;
    }

    private boolean refreshLastKey(File file, FileAddress fileAddress, FileAddress fileAddress2, int n2) {
        if (!this.loadNode(file, fileAddress2)) {
            return false;
        }
        Block block = new Block(252);
        Block block2 = file.getLoadedNode();
        int n3 = block2.get16(1) & 0xFFFF;
        long l2 = this.getFullKey(file, n3 - 1, block2, block);
        KeyEntry keyEntry = new KeyEntry();
        if (!this.findMe(file, fileAddress, fileAddress2, keyEntry)) {
            return false;
        }
        boolean bl = this.deleteKeyEntryFromLoadedNode(file, keyEntry.getPhysicalKeyOffset());
        KeyEntry keyEntry2 = new KeyEntry();
        keyEntry2.setKeyOffset(keyEntry.getKeyOffset());
        keyEntry2.getNodeAddress().copyFrom(fileAddress);
        keyEntry2.setKeyDepth(n2);
        if (!this.insertKey(file, block, l2, fileAddress2, keyEntry2)) {
            return false;
        }
        if (bl && n2 > 0) {
            return this.refreshLastKey(file, file.getNodeAddresses()[n2 - 1], keyEntry2.getNodeAddress(), n2 - 1);
        }
        return true;
    }

    private CombineMode combineNodes(File file, KeyEntry keyEntry) {
        int n2;
        CombineMode combineMode = CombineMode.LEFT;
        Block block = file.getLoadedNode();
        if (keyEntry.getKeyDepth() <= 0) {
            if ((block.get8(3 + file.getKeyEntryOffset() + 2) & 0xFF) == 127) {
                FileAddress fileAddress = new FileAddress();
                this.getLeftAddress(file, block, 3, fileAddress);
                int n3 = file.getVersion();
                Block block2 = new Block(this.fileAddressSize(n3) + 1);
                file.getHeaderCache().put32(Offset.ROOT_VERS.get(n3), (int)file.incKeyRootVersion());
                int n4 = file.getFindKeyNum();
                KeyInfo keyInfo = file.getLogicalAttributes().getKey(n4);
                keyInfo.getKeyRoot().copyFrom(fileAddress);
                if (n3 < 6) {
                    block2.put32(0, (int)fileAddress.getOffset());
                    if (n3 == 4 || n3 == 5) {
                        block2.put16(4, (short)fileAddress.getSegment());
                    }
                } else {
                    block2.put48(0, fileAddress.getOffset());
                }
                block2.put8(Offset.KEYHEIGHT.get(n3), (byte)keyInfo.decHeight());
                FileDescriptor fileDescriptor = this.retrieveSegment(file, BlockType.DATA, 0);
                FileSystemCache fileSystemCache = file.getFileSystemCache();
                fileSystemCache.seek(fileDescriptor, this.getKeyInfoOffset(file, n4));
                fileSystemCache.write(fileDescriptor, block2, CacheDataType.HEADER);
                int n5 = block.get16(1) & 0xFFFF;
                file.decNodeUsage(n5);
                this.freeCurrentNode(file);
                file.getNodeAddresses()[0].invalidate();
            }
            return CombineMode.NONE;
        }
        Block block3 = new Block(block.size());
        block3.copy(0, block, 0, block.size());
        KeyEntry keyEntry2 = new KeyEntry();
        FileAddress fileAddress = file.getNodeAddresses()[keyEntry.getKeyDepth() - 1];
        if (!this.findMe(file, fileAddress, keyEntry.getNodeAddress(), keyEntry2)) {
            return CombineMode.ERROR;
        }
        block = file.getLoadedNode();
        int n6 = keyEntry2.getPhysicalKeyOffset() + file.getKeyEntryOverhead() + (block.get8(keyEntry2.getPhysicalKeyOffset() + file.getKeyEntryOffset()) & 0xFF);
        if (n6 >= (n2 = (block.get16(1) & 0xFFFF) + 3)) {
            n6 = -1;
        }
        boolean bl = false;
        if (block3.get16(1) == 0) {
            combineMode = CombineMode.RIGHT;
            bl = true;
        }
        FileAddress fileAddress2 = new FileAddress();
        FileAddress fileAddress3 = new FileAddress();
        FileAddress fileAddress4 = new FileAddress();
        Block block4 = new Block(file.getBlockSize());
        if (!bl) {
            boolean bl2 = false;
            if (keyEntry2.getPreviousKeyOffset() >= 0) {
                this.getLeftAddress(file, block, keyEntry2.getPreviousPhysicalKeyOffset(), fileAddress3);
            }
            if (n6 >= 0) {
                this.getLeftAddress(file, block, n6, fileAddress2);
            }
            int n7 = block3.get16(1) & 0xFFFF;
            int n8 = 0;
            if (n6 >= 0) {
                if (!this.loadNode(file, fileAddress2)) {
                    return CombineMode.ERROR;
                }
                block = file.getLoadedNode();
                n8 = block.get16(1) & 0xFFFF;
                if (n8 + n7 <= file.getBlockSize() - 3) {
                    combineMode = CombineMode.RIGHT;
                    bl2 = true;
                }
            }
            if (!bl2 && keyEntry2.getPreviousKeyOffset() >= 0) {
                if (!this.loadNode(file, fileAddress3)) {
                    return CombineMode.ERROR;
                }
                block = file.getLoadedNode();
                n8 = block.get16(1) & 0xFFFF;
                if (n8 + n7 <= file.getBlockSize() - 3) {
                    bl2 = true;
                }
            }
            if (!bl2) {
                file.getLoadedNode().copy(0, block3, 0, block3.size());
                file.getCurrentNode().copyFrom(keyEntry.getNodeAddress());
                return CombineMode.NONE;
            }
            this.makeNewNode(file, fileAddress4);
            if (fileAddress4.isZero()) {
                return CombineMode.ERROR;
            }
            if (combineMode == CombineMode.RIGHT) {
                block4.copy(3, block3, 3, n7);
                block4.copy(3 + n7, block, 3, n8);
            } else {
                block4.copy(3, block, 3, n8);
                block4.copy(3 + n8, block3, 3, n7);
            }
            block4.put16(1, (short)(n7 + n8));
            this.saveNode(file, block4, fileAddress4);
            this.loadNode(file, fileAddress);
            block = file.getLoadedNode();
            this.setLeftBranch(file, block, combineMode == CombineMode.RIGHT ? n6 : keyEntry2.getPhysicalKeyOffset(), fileAddress4);
            this.saveNode(file, block, fileAddress);
        }
        KeyEntry keyEntry3 = new KeyEntry();
        keyEntry3.getNodeAddress().copyFrom(fileAddress);
        keyEntry3.setPhysicalKeyOffset(combineMode == CombineMode.RIGHT ? keyEntry2.getPhysicalKeyOffset() : keyEntry2.getPreviousPhysicalKeyOffset());
        keyEntry3.setKeyDepth(keyEntry.getKeyDepth() - 1);
        this.loadNode(file, fileAddress);
        if (!this.deleteKeyEntry(file, keyEntry3)) {
            return CombineMode.ERROR;
        }
        file.getCurrentNode().copyFrom(keyEntry.getNodeAddress());
        this.freeCurrentNode(file);
        if (!bl) {
            file.getCurrentNode().copyFrom(combineMode == CombineMode.RIGHT ? fileAddress2 : fileAddress3);
            this.freeCurrentNode(file);
            file.getLoadedNode().copy(0, block4, 0, block4.size());
            file.getCurrentNode().copyFrom(fileAddress4);
        }
        keyEntry.getNodeAddress().copyFrom(file.getCurrentNode());
        file.getNodeAddresses()[keyEntry.getKeyDepth()].copyFrom(file.getCurrentNode());
        return combineMode;
    }

    private boolean deleteKeyEntryFromLoadedNode(File file, int n2) {
        int n3;
        int n4;
        boolean bl;
        Block block = new Block(253);
        Block block2 = file.getLoadedNode();
        int n5 = block2.get16(1) & 0xFFFF;
        int n6 = n5 + 3;
        int n7 = n2 + file.getKeyEntryOffset();
        int n8 = n2 + file.getKeyEntryOverhead() + (block2.get8(n7) & 0xFF);
        if (n8 >= n6) {
            bl = true;
            n4 = 0;
        } else {
            int n9;
            bl = false;
            n3 = n8 + file.getKeyEntryOffset();
            int n10 = block2.get8(n7 + 1) & 0xFF;
            if (n10 >= (n9 = block2.get8(n3 + 1) & 0xFF)) {
                n4 = 0;
            } else {
                n4 = n9 - n10;
                block.copy(0, block2, n7 + 2, n4);
            }
        }
        block2.shift(n8, n2 + n4 - n8, n6 - n8);
        if (n4 > 0) {
            block2.shift(n2 + n4, -n4, file.getKeyEntryOverhead() + 1);
            block2.copy(n7 + 2, block, 0, n4);
            block2.put8(n7, (byte)(block2.get8(n7) + n4));
            block2.put8(n7 + 1, (byte)(block2.get8(n7 + 1) - n4));
        }
        n3 = n8 - n2 - n4;
        block2.fill(n6 - n3, n3, (byte)0);
        block2.put16(1, (short)(n5 - n3));
        file.decNodeUsage(n3);
        return bl;
    }

    private void makeRoot(File file, Block block, FileAddress fileAddress, FileAddress fileAddress2) {
        this.makeNewNode(file, fileAddress2);
        if (fileAddress2.isZero()) {
            return;
        }
        int n2 = file.getVersion();
        file.getHeaderCache().put32(Offset.ROOT_VERS.get(n2), (int)file.incKeyRootVersion());
        KeyInfo keyInfo = file.getLogicalAttributes().getKey(file.getFindKeyNum());
        keyInfo.getKeyRoot().copyFrom(fileAddress2);
        Block block2 = new Block(this.fileAddressSize(n2) + 1);
        if (n2 < 6) {
            block2.put32(Offset.KEYROOT_OFF.get(n2), (int)fileAddress2.getOffset());
            if (n2 == 4 || n2 == 5) {
                block2.put16(Offset.KEYROOT_SEG.get(n2), (short)fileAddress2.getSegment());
            }
        } else {
            block2.put48(Offset.KEYROOT_OFF.get(n2), fileAddress2.getOffset());
        }
        block2.put8(Offset.KEYHEIGHT.get(n2), (byte)keyInfo.incHeight());
        FileDescriptor fileDescriptor = this.retrieveSegment(file, BlockType.DATA, 0);
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        fileSystemCache.seek(fileDescriptor, this.getKeyInfoOffset(file, file.getFindKeyNum()));
        fileSystemCache.write(fileDescriptor, block2, CacheDataType.HEADER);
        int n3 = file.getKeyEntryOverhead() + 2;
        block.fill(0, file.getBlockSize(), (byte)0);
        block.put8(0, BlockType.NODE.getVal());
        block.put16(1, (short)n3);
        int n4 = 3;
        if (n2 < 6) {
            block.put32(n4 + Offset.LEFT_OFF.get(n2), (int)fileAddress.getOffset());
            if (n2 == 4 || n2 == 5) {
                block.put16(n4 + Offset.LEFT_SEG.get(n2), (short)fileAddress.getSegment());
            }
        } else {
            block.put48(n4 + Offset.LEFT_OFF.get(n2), fileAddress.getOffset());
        }
        if (this.selectedKeyHasDuplicates(file)) {
            block.put32(n4 + Offset.UNIQ.get(n2), 0);
        }
        block.put8(n4 += file.getKeyEntryOffset(), (byte)2);
        block.put8(n4 + 1, (byte)0);
        block.put8(n4 + 2, (byte)127);
        file.incNodeUsage(n3);
    }

    private void makeNewNode(File file, FileAddress fileAddress) {
        int n2 = file.getVersion();
        FileAddress fileAddress2 = file.getFreeNode();
        if (!fileAddress2.isZero()) {
            int n3 = this.fileAddressSize(n2);
            Block block = new Block(1 + n3);
            FileDescriptor fileDescriptor = this.retrieveSegment(file, BlockType.NODE, fileAddress2.getSegment());
            FileSystemCache fileSystemCache = file.getFileSystemCache();
            fileSystemCache.seek(fileDescriptor, fileAddress2.getOffset());
            if (fileSystemCache.read(fileDescriptor, block, CacheDataType.INDEX) != 1 + n3) {
                return;
            }
            FileAddress fileAddress3 = new FileAddress();
            byte by = block.get8(0);
            if (n2 < 6) {
                fileAddress3.setOffset((long)block.get32(1) & 0xFFFFFFFFL);
            } else {
                fileAddress3.setOffset(block.get48(1));
            }
            if (n2 == 4 || n2 == 5) {
                fileAddress3.setSegment(block.get16(5) & 0xFFFF);
            } else {
                fileAddress3.setSegment(0);
            }
            if (by != BlockType.FREENODE.getVal()) {
                this.status.setErrno(6);
                this.status.setIntErrno(12);
                return;
            }
            fileAddress.copyFrom(fileAddress2);
            fileAddress2.copyFrom(fileAddress3);
            file.decFreeNodes();
            Block block2 = file.getHeaderCache();
            if (n2 < 6) {
                block2.put32(Offset.FREENODE_OFF.get(n2), (int)fileAddress2.getOffset());
            } else {
                block2.put48(Offset.FREENODE_OFF.get(n2), fileAddress2.getOffset());
            }
            if (n2 == 4 || n2 == 5) {
                block2.put16(Offset.FREENODE_SEG.get(n2), (short)fileAddress2.getSegment());
            }
            if (n2 < 5) {
                block2.put16(Offset.NODES_FREE.get(n2), (short)file.getFreeNodes());
            } else if (n2 == 5) {
                block2.put32(Offset.NODES_FREE.get(n2), (int)file.getFreeNodes());
            } else {
                block2.put48(Offset.NODES_FREE.get(n2), file.getFreeNodes());
            }
        } else {
            if (n2 == 3) {
                fileAddress.copyFrom(file.getNextBlock());
            } else {
                fileAddress.copyFrom(file.getIndexFile().getNextBlock());
                if (n2 < 6 && fileAddress.getOffset() > file.getMaxSegmentSize() - (long)file.getBlockSize()) {
                    fileAddress.setOffset(512L);
                    fileAddress.incSegment();
                }
            }
            if (!this.newBlock(file, BlockType.NODE)) {
                fileAddress.initialize();
                return;
            }
        }
        file.incUsedNodes();
        Block block = file.getHeaderCache();
        if (n2 < 5) {
            block.put16(Offset.NODES_USED.get(n2), (short)file.getUsedNodes());
        } else if (n2 == 5) {
            block.put32(Offset.NODES_USED.get(n2), (int)file.getUsedNodes());
        } else {
            block.put48(Offset.NODES_USED.get(n2), file.getUsedNodes());
        }
    }

    private boolean insertKey(File file, Block block, long l2, FileAddress fileAddress, KeyEntry keyEntry) {
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl;
        Block block2 = file.getLoadedNode();
        Block block3 = new Block(252);
        int n6 = (block2.get16(1) & 0xFFFF) + 3;
        do {
            n5 = keyEntry.getPhysicalKeyOffset();
            this.getFullKey(file, n5 - 1, block2, block3);
            n4 = this.getPrefix(block3, block);
            n3 = file.getKeyEntryOverhead() + (block.get8(0) & 0xFF) - n4 + 1;
            if (n3 > file.getBlockSize() - n6) {
                if (!this.splitNode(file, keyEntry, block, l2)) {
                    return false;
                }
                block2 = file.getLoadedNode();
                n6 = (block2.get16(1) & 0xFFFF) + 3;
                bl = true;
                continue;
            }
            bl = false;
        } while (bl);
        int n7 = 0;
        int n8 = 0;
        if (n5 < n6) {
            n2 = this.getPartialKey(file, n5, block2, block3);
            n8 = this.getPrefix(block, block3);
            n7 = n8 - n2;
        }
        n2 = n5 + file.getKeyEntryOffset();
        if (n7 > 0) {
            block2.put8(n2, (byte)((block2.get8(n2) & 0xFF) - n7));
            block2.put8(n2 + 1, (byte)n8);
            block2.shift(n5, n7, file.getKeyEntryOverhead() + 1);
        }
        block2.shift(n5 + n7, n3 - n7, n6 - n5 - n7);
        block2.put8(n2, (byte)(n3 - file.getKeyEntryOverhead()));
        block2.put8(n2 + 1, (byte)n4);
        block2.copy(n2 + 2, block, 1 + n4, (block.get8(0) & 0xFF) - n4);
        int n9 = file.getVersion();
        if (n9 < 6) {
            block2.put32(n5 + Offset.LEFT_OFF.get(n9), (int)fileAddress.getOffset());
            if (n9 == 4 || n9 == 5) {
                block2.put16(n5 + Offset.LEFT_SEG.get(n9), (short)fileAddress.getSegment());
            }
        } else {
            block2.put48(n5 + Offset.LEFT_OFF.get(n9), fileAddress.getOffset());
        }
        if (this.selectedKeyHasDuplicates(file)) {
            block2.put32(n5 + Offset.UNIQ.get(n9), (int)l2);
        }
        int n10 = n3 - n7;
        block2.put16(1, (short)(n6 - 3 + n10));
        if (!this.saveNode(file, block2, file.getCurrentNode())) {
            return false;
        }
        file.incNodeUsage(n10);
        return true;
    }

    private boolean splitNode(File file, KeyEntry keyEntry, Block block, long l2) {
        KeyEntry keyEntry2;
        int n2;
        int n3;
        int n4;
        FileAddress fileAddress = new FileAddress();
        FileAddress fileAddress2 = new FileAddress();
        this.makeNewNode(file, fileAddress2);
        this.makeNewNode(file, fileAddress);
        if (fileAddress2.isZero() || fileAddress.isZero()) {
            return false;
        }
        this.saveNode(file, file.getLoadedNode(), fileAddress);
        this.loadNode(file, fileAddress);
        Block block2 = file.getLoadedNode();
        int n5 = block2.get16(1) & 0xFFFF;
        int n6 = keyEntry.getKeyOffset();
        int n7 = 0;
        int n8 = 0;
        int n9 = 3 + n6 + file.getKeyEntryOffset();
        if (block2.get8(n9 + 1) == 0 && block2.get8(n9 + 2) != block.get8(1)) {
            if (n6 < n5 / 2) {
                n6 += file.getKeyEntryOverhead() + (block2.get8(n9) & 0xFF);
            }
            if (n6 >= n5) {
                n6 = 0;
            }
            n7 = n6;
        } else {
            n6 = 0;
        }
        if (n6 == 0) {
            while (n6 < n5 / 2) {
                n9 = 3 + n6 + file.getKeyEntryOffset();
                n8 = n6;
                n6 += file.getKeyEntryOverhead() + (block2.get8(n9) & 0xFF);
            }
            n7 = n6;
            if (keyEntry.getKeyOffset() < n6) {
                n6 = n8;
            }
        }
        int n10 = file.getBlockSize();
        Block block3 = new Block(n10);
        block3.put8(0, BlockType.NODE.getVal());
        block3.put16(1, (short)n6);
        block3.copy(3, block2, 3, n6);
        Block block4 = new Block(253);
        this.getFullKey(file, 3 + n6, block2, block4);
        int n11 = block2.get8(3 + n6 + file.getKeyEntryOffset() + 1) & 0xFF;
        block2.put16(1, (short)(n5 - (n6 - n11)));
        block2.shift(3 + n6, n11 - n6, n5 - n6);
        block2.fill(3 + n5 - n6 + n11, n6 - n11, (byte)0);
        if (n11 > 0) {
            block2.shift(3 + n11, -n11, file.getKeyEntryOverhead());
            int n12 = 3 + file.getKeyEntryOffset();
            n4 = block4.get8(0) & 0xFF;
            block2.put8(n12, (byte)(n4 + 1));
            block2.put8(n12 + 1, (byte)0);
            block2.copy(n12 + 2, block4, 1, n4);
            file.incNodeUsage(n11);
        }
        Block block5 = new Block(n10);
        block5.copy(0, block2, 0, n10);
        n4 = 0;
        long l3 = 0L;
        for (n2 = 0; n2 < n6; n2 += n3) {
            n3 = file.getKeyEntryOverhead() + (block3.get8(3 + n2 + file.getKeyEntryOffset()) & 0xFF);
            n4 = n2;
        }
        if (keyEntry.getKeyOffset() < n7 && keyEntry.getKeyOffset() > n4) {
            block4.copy(0, block, 0, (block.get8(0) & 0xFF) + 1);
            l3 = l2;
        } else {
            l3 = this.getFullKey(file, 3 + n4, block3, block4);
        }
        n2 = 0;
        FileAddress fileAddress3 = new FileAddress();
        if (keyEntry.getKeyDepth() == 0 || !file.getNodeAddresses()[keyEntry.getKeyDepth() - 1].isValid()) {
            this.makeRoot(file, file.getLoadedNode(), fileAddress, fileAddress3);
            if (fileAddress3.isZero()) {
                return false;
            }
            file.getCurrentNode().copyFrom(fileAddress3);
            n2 = 1;
        } else {
            fileAddress3.copyFrom(file.getNodeAddresses()[keyEntry.getKeyDepth() - 1]);
        }
        this.saveNode(file, block5, fileAddress);
        this.saveNode(file, block3, fileAddress2);
        if (n2 == 0) {
            keyEntry2 = new KeyEntry();
            if (!this.findMe(file, fileAddress3, keyEntry.getNodeAddress(), keyEntry2)) {
                return false;
            }
            this.setLeftBranch(file, file.getLoadedNode(), keyEntry2.getPhysicalKeyOffset(), fileAddress);
            this.saveNode(file, file.getLoadedNode(), fileAddress3);
        }
        if (this.searchInNode(file, block4, l3, fileAddress3, keyEntry2 = new KeyEntry()) == FindKeyResult.ERROR) {
            return false;
        }
        keyEntry2.setKeyDepth(keyEntry.getKeyDepth() - 1);
        if (!this.insertKey(file, block4, l3, fileAddress2, keyEntry2)) {
            return false;
        }
        file.getCurrentNode().copyFrom(keyEntry.getNodeAddress());
        this.freeCurrentNode(file);
        if (keyEntry.getKeyOffset() < n7) {
            keyEntry.getNodeAddress().copyFrom(fileAddress2);
        } else {
            keyEntry.getNodeAddress().copyFrom(fileAddress);
            if (keyEntry.getKeyOffset() == n6) {
                keyEntry.setKeyOffset(0);
            } else {
                keyEntry.setKeyOffset(keyEntry.getKeyOffset() - (n6 - n11));
            }
        }
        this.loadNode(file, keyEntry.getNodeAddress());
        file.getNodeAddresses()[keyEntry.getKeyDepth()].copyFrom(keyEntry.getNodeAddress());
        return true;
    }

    private void freeCurrentNode(File file) {
        FileAddress fileAddress = file.getCurrentNode();
        int n2 = file.getVersion();
        Block block = new Block(1 + this.fileAddressSize(n2));
        block.put8(0, BlockType.FREENODE.getVal());
        FileAddress fileAddress2 = file.getFreeNode();
        if (n2 < 6) {
            block.put32(1, (int)fileAddress2.getOffset());
            if (n2 == 4 || n2 == 5) {
                block.put16(5, (short)fileAddress2.getSegment());
            }
        } else {
            block.put48(1, fileAddress2.getOffset());
        }
        FileDescriptor fileDescriptor = this.retrieveSegment(file, BlockType.NODE, fileAddress.getSegment());
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        fileSystemCache.seek(fileDescriptor, fileAddress.getOffset());
        fileSystemCache.write(fileDescriptor, block, CacheDataType.INDEX);
        fileAddress2.copyFrom(fileAddress);
        file.decUsedNodes();
        file.incFreeNodes();
        Block block2 = file.getHeaderCache();
        if (n2 < 6) {
            block2.put32(Offset.FREENODE_OFF.get(n2), (int)fileAddress.getOffset());
            if (n2 == 4 || n2 == 5) {
                block2.put16(Offset.FREENODE_SEG.get(n2), (short)fileAddress.getSegment());
            }
        } else {
            block2.put48(Offset.FREENODE_OFF.get(n2), fileAddress.getOffset());
        }
        if (n2 < 5) {
            block2.put16(Offset.NODES_USED.get(n2), (short)file.getUsedNodes());
            block2.put16(Offset.NODES_FREE.get(n2), (short)file.getFreeNodes());
        } else if (n2 == 5) {
            block2.put32(Offset.NODES_USED.get(n2), (int)file.getUsedNodes());
            block2.put32(Offset.NODES_FREE.get(n2), (int)file.getFreeNodes());
        } else {
            block2.put48(Offset.NODES_USED.get(n2), file.getUsedNodes());
            block2.put48(Offset.NODES_FREE.get(n2), file.getFreeNodes());
        }
        fileAddress.invalidate();
    }

    private boolean findMe(File file, FileAddress fileAddress, FileAddress fileAddress2, KeyEntry keyEntry) {
        int n2;
        int n3;
        if (!this.loadNode(file, fileAddress)) {
            return false;
        }
        Block block = file.getLoadedNode();
        FileAddress fileAddress3 = new FileAddress();
        int n4 = (block.get16(1) & 0xFFFF) + 3;
        keyEntry.setPreviousPhysicalKeyOffset(-1);
        for (n2 = 3; n2 < n4; n2 += file.getKeyEntryOverhead() + n3) {
            n3 = block.get8(n2 + file.getKeyEntryOffset()) & 0xFF;
            this.getLeftAddress(file, block, n2, fileAddress3);
            if (fileAddress3.eq(fileAddress2)) break;
            keyEntry.setPreviousPhysicalKeyOffset(n2);
        }
        if (n2 >= n4) {
            this.status.setErrno(6);
            this.status.setIntErrno(7);
            return false;
        }
        keyEntry.setPhysicalKeyOffset(n2);
        return true;
    }

    private int getPrefix(Block block, Block block2) {
        int n2 = Math.min(block.get8(0) & 0xFF, block2.get8(0) & 0xFF);
        int n3 = 0;
        int n4 = 1;
        while (n3 < n2 && block.get8(n4) == block2.get8(n4)) {
            ++n3;
            ++n4;
        }
        return n3;
    }

    private long getFullKey(File file, int n2, Block block, Block block2) {
        int n3 = (block.get16(1) & 0xFFFF) + 3;
        if (n2 >= n3 || n2 < 0) {
            block2.put8(0, (byte)0);
            return 0L;
        }
        int n4 = 0;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        for (int i2 = 3; i2 <= n2; i2 += file.getKeyEntryOverhead() + n4) {
            n6 = i2 + file.getKeyEntryOffset();
            n4 = block.get8(n6) & 0xFF;
            n5 = block.get8(n6 + 1) & 0xFF;
            block2.copy(n5 + 1, block, n6 + 2, n4 - 1);
            n7 = i2;
        }
        block2.put8(0, (byte)(n4 + n5 - 1));
        return this.getUniqueId(file, block, n7);
    }

    private int getPartialKey(File file, int n2, Block block, Block block2) {
        int n3 = n2 + file.getKeyEntryOffset();
        int n4 = (block.get8(n3) & 0xFF) - 1;
        int n5 = block.get8(n3 + 1) & 0xFF;
        block2.copy(n5 + 1, block, n3 + 2, n4);
        block2.put8(0, (byte)(n4 + n5));
        return n5;
    }

    protected FindKeyResult findKey(File file, Block block, long l2, KeyEntry keyEntry) {
        FindKeyResult findKeyResult = FindKeyResult.ERROR;
        this.setKey(file, block.get8(1) & 0xFF);
        KeyInfo keyInfo = file.getLogicalAttributes().getKey(file.getFindKeyNum());
        FileAddress fileAddress = keyInfo.getKeyRoot().copy();
        if (fileAddress.isZero()) {
            return FindKeyResult.EMPTY;
        }
        int n2 = 0;
        FileAddress[] fileAddressArray = file.getNodeAddresses();
        while (fileAddress.gtZero()) {
            fileAddressArray[n2] = fileAddress.copy();
            findKeyResult = this.searchInNode(file, block, l2, fileAddress, keyEntry);
            if (findKeyResult == FindKeyResult.ERROR) {
                return findKeyResult;
            }
            if (findKeyResult == FindKeyResult.NO_MATCH) {
                this.status.setErrno(6);
                this.status.setIntErrno(4);
                return FindKeyResult.ERROR;
            }
            ++n2;
            this.getLeftAddress(file, file.getLoadedNode(), keyEntry.getPhysicalKeyOffset(), fileAddress);
        }
        keyEntry.setKeyDepth(n2 - 1);
        return findKeyResult;
    }

    protected boolean findPrevious(File file, KeyEntry keyEntry) {
        block4: {
            if (keyEntry.getPreviousPhysicalKeyOffset() < 0) {
                for (int i2 = keyEntry.getKeyDepth(); keyEntry.getPreviousPhysicalKeyOffset() < 0 && i2 > 0; --i2) {
                    if (this.findMe(file, file.getNodeAddresses()[i2 - 1], file.getNodeAddresses()[i2], keyEntry)) continue;
                    return false;
                }
                if (keyEntry.getPreviousPhysicalKeyOffset() < 0) {
                    this.status.setErrno(8);
                    return false;
                }
                FileAddress fileAddress = new FileAddress();
                do {
                    this.getLeftAddress(file, file.getLoadedNode(), keyEntry.getPreviousPhysicalKeyOffset(), fileAddress);
                    if (fileAddress.ltZero()) break block4;
                    file.getNodeAddresses()[++i2] = fileAddress.copy();
                } while (this.searchInNode(file, FULL_STOPPER_KEY, 0L, fileAddress, keyEntry) != FindKeyResult.ERROR);
                return false;
            }
        }
        keyEntry.setPhysicalKeyOffset(keyEntry.getPreviousPhysicalKeyOffset());
        this.getFullKey(file, keyEntry.getPhysicalKeyOffset(), file.getLoadedNode(), file.getFoundKey());
        return true;
    }

    protected void getLeftAddress(File file, Block block, int n2, FileAddress fileAddress) {
        int n3 = file.getVersion();
        if (n3 < 6) {
            fileAddress.setOffset(block.get32(n2 + Offset.LEFT_OFF.get(n3)));
        } else {
            fileAddress.setOffset(block.get48s(n2 + Offset.LEFT_OFF.get(n3)));
        }
        if (n3 == 4 || n3 == 5) {
            fileAddress.setSegment(block.get16(n2 + Offset.LEFT_SEG.get(n3)) & 0xFFFF);
        } else {
            fileAddress.setSegment(0);
        }
    }

    private void setLeftBranch(File file, Block block, int n2, FileAddress fileAddress) {
        int n3 = file.getVersion();
        if (n3 < 6) {
            block.put32(n2 + Offset.LEFT_OFF.get(n3), (int)fileAddress.getOffset());
            if (n3 == 4 || n3 == 5) {
                block.put16(n2 + Offset.LEFT_SEG.get(n3), (short)fileAddress.getSegment());
            }
        } else {
            block.put48(n2 + Offset.LEFT_OFF.get(n3), fileAddress.getOffset());
        }
    }

    protected void setKey(File file, int n2) {
        int n3 = file.getVersion();
        file.setFindKeyNum(n2);
        if (file.getLogicalAttributes().getKey(n2).isDuplicate()) {
            file.setKeyEntryOffset(Offset.KEY.get(n3));
            file.setKeyEntryOverhead(Offset.ENTRY_OVERHEAD.get(n3));
        } else {
            file.setKeyEntryOffset(Offset.KEY.get(n3) - 4);
            file.setKeyEntryOverhead(Offset.ENTRY_OVERHEAD.get(n3) - 4);
        }
    }

    private boolean selectedKeyHasDuplicates(File file) {
        return file.getKeyEntryOverhead() == Offset.ENTRY_OVERHEAD.get(file.getVersion());
    }

    protected FindKeyResult searchInNode(File file, Block block, long l2, FileAddress fileAddress, KeyEntry keyEntry) {
        int n2;
        if (!this.loadNode(file, fileAddress)) {
            return FindKeyResult.ERROR;
        }
        Block block2 = file.getLoadedNode();
        int n3 = (block2.get16(1) & 0xFFFF) + 3;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        long l3 = 0L;
        int n10 = 0;
        int n11 = 0;
        for (n2 = 3; n2 < n3; n2 += file.getKeyEntryOverhead() + (block2.get8(n7) & 0xFF)) {
            n7 = n2 + file.getKeyEntryOffset();
            n5 = block2.get8(n7 + 1) & 0xFF;
            if (n5 > n6) {
                if (n8 == 0) {
                    this.status.setErrno(6);
                    this.status.setIntErrno(20);
                    return FindKeyResult.ERROR;
                }
                if (n5 > 251) {
                    this.status.setErrno(6);
                    this.status.setIntErrno(22);
                    return FindKeyResult.ERROR;
                }
                file.getFoundKey().copy(n6 + 1, block2, n8 + 2, n5 - n6);
            }
            n6 = n5;
            n8 = n7;
            if (n11 == 0 || n10 >= n5) {
                int n12;
                int n13;
                n9 = (block2.get8(n7) & 0xFF) - 1;
                if (n9 < 0 || n9 + n5 > 251) {
                    this.status.setErrno(6);
                    this.status.setIntErrno(21);
                    return FindKeyResult.ERROR;
                }
                int n14 = (block.get8(0) & 0xFF) - n5;
                int n15 = n5;
                int n16 = n7 + 1;
                n11 = 0;
                for (int i2 = Math.min(n14, n9); i2 > 0; --i2) {
                    if ((n13 = block.get8(++n15) & 0xFF) == (n12 = block2.get8(++n16) & 0xFF)) continue;
                    n11 = n13 < n12 ? -1 : 1;
                    break;
                }
                n10 = n5 + (n16 - (n7 + 2));
                if (n11 == 0 && n14 != n9) {
                    ++n10;
                    if (n14 < n9) {
                        n13 = n7 + 2 + n14;
                        n12 = n9 - n14;
                    } else {
                        n13 = n5 + 1 + n9;
                        n12 = n14 - n9;
                    }
                    while (n12-- > 0) {
                        if ((block2.get8(n13) & 0xFF) < 32) {
                            n11 = n14 < n9 ? 1 : -1;
                            break;
                        }
                        if ((block2.get8(n13) & 0xFF) > 32) {
                            n11 = n14 < n9 ? -1 : 1;
                            break;
                        }
                        ++n13;
                        ++n10;
                    }
                }
                if (n11 < 0) break;
                if (n11 == 0) {
                    file.setFoundExactMatch(true);
                    l3 = this.getUniqueId(file, block2, n2);
                    if (l2 <= l3) break;
                }
            }
            n4 = n2;
        }
        keyEntry.getNodeAddress().copyFrom(fileAddress);
        keyEntry.setPhysicalKeyOffset(n2);
        keyEntry.setPreviousPhysicalKeyOffset(n4);
        if (n2 >= n3) {
            return FindKeyResult.NO_MATCH;
        }
        file.getFoundKey().copy(n5 + 1, block2, n7 + 2, n9);
        file.getFoundKey().put8(0, (byte)(n5 + n9));
        return n11 < 0 ? FindKeyResult.MATCH_NEXT : (l2 == l3 ? FindKeyResult.FULL_MATCH : FindKeyResult.KEY_MATCH);
    }

    protected long getUniqueId(File file, Block block, int n2) {
        if (this.selectedKeyHasDuplicates(file)) {
            return (long)block.get32(n2 + Offset.UNIQ.get(file.getVersion())) & 0xFFFFFFFFL;
        }
        return 0L;
    }

    protected FileAddress appendRecord(File file, byte[] byArray, int n2) {
        Block block;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        FileAddress fileAddress;
        int n3 = file.getVersion();
        LogicalAttributes logicalAttributes = file.getLogicalAttributes();
        Block block2 = file.getRecord();
        FileAddress fileAddress2 = file.getFreeRec();
        RecordHeader recordHeader = new RecordHeader();
        int n4 = n2;
        boolean bl = logicalAttributes.isCompressed();
        if (bl) {
            n4 = this.deflate(file, byArray, n2);
            byArray = file.getCompressedRecord().getBytes();
        }
        FileAddress fileAddress3 = new FileAddress();
        boolean bl2 = fileAddress2.isZero();
        if (!bl2) {
            fileAddress = this.getRecord(file, block2, file.getRecordOverhead(), fileAddress2, false);
            if (fileAddress.isZero()) {
                fileAddress3.initialize();
                return fileAddress3;
            }
            this.unpackRecordHeader(file, block2, recordHeader);
            if (recordHeader.getStatus() != RecordStatus.DELETED) {
                this.status.setErrno(6);
                this.status.setIntErrno(13);
                fileAddress3.initialize();
                return fileAddress3;
            }
            if (n3 < 5) {
                int n5 = n3 == 3 ? 4 : 6;
                object4 = new Block(n5);
                object3 = this.getRecord(file, (Block)object4, n5, fileAddress, false);
                if (((FileAddress)object3).isZero()) {
                    fileAddress3.initialize();
                    return fileAddress3;
                }
                recordHeader.getNextDeleted().setOffset((long)((Block)object4).get32(0) & 0xFFFFFFFFL);
                recordHeader.getNextDeleted().setSegment(n3 == 3 ? 0 : ((Block)object4).get16(4) & 0xFFFF);
            }
            if (n4 > recordHeader.getSize()) {
                bl2 = true;
                if (file.incFreeFailures() > 30) {
                    if (n3 > 4) {
                        Block block3 = new Block(file.getRecordOverhead());
                        object4 = new RecordHeader();
                        ((RecordHeader)object4).setStatus(RecordStatus.ABANDONED);
                        ((RecordHeader)object4).setSize(recordHeader.getSize());
                        ((RecordHeader)object4).setUsed(recordHeader.getUsed());
                        ((RecordHeader)object4).getNextDeleted().copyFrom(file.getAbandonedRec());
                        this.packRecordHeader(file, block3, (RecordHeader)object4);
                        object3 = this.retrieveSegment(file, BlockType.DATA, fileAddress2.getSegment());
                        object2 = file.getFileSystemCache();
                        ((FileSystemCache)object2).seek((FileDescriptor)object3, fileAddress2.getOffset());
                        ((FileSystemCache)object2).write((FileDescriptor)object3, block3, CacheDataType.RECORD);
                        file.getAbandonedRec().copyFrom(fileAddress2);
                        object = file.getHeaderCache();
                        if (n3 < 6) {
                            ((Block)object).put32(Offset.ABREC_OFF.get(n3), (int)fileAddress2.getOffset());
                            ((Block)object).put16(Offset.ABREC_SEG.get(n3), (short)fileAddress2.getSegment());
                        } else {
                            ((Block)object).put48(Offset.ABREC_OFF.get(n3), fileAddress2.getOffset());
                        }
                        file.incAbandonedRecords();
                        file.decDeletedRecords();
                    }
                    file.setFreeFailures(0);
                    fileAddress2.copyFrom(recordHeader.getNextDeleted());
                }
            } else {
                fileAddress3.copyFrom(fileAddress2);
                file.setFreeFailures(0);
                fileAddress2.copyFrom(recordHeader.getNextDeleted());
            }
            block = file.getHeaderCache();
            if (n3 < 6) {
                block.put32(Offset.FREEREC_OFF.get(n3), (int)fileAddress2.getOffset());
                if (n3 > 3) {
                    block.put16(Offset.FREEREC_SEG.get(n3), (short)fileAddress2.getSegment());
                }
            } else {
                block.put48(Offset.FREEREC_OFF.get(n3), fileAddress2.getOffset());
            }
        }
        if (bl2) {
            if (file.getNextRec().isZero()) {
                fileAddress = file.getNextBlock().copy();
                if (n3 == 3) {
                    fileAddress.incOffset(1L);
                }
                file.getFirstRec().copyFrom(fileAddress);
                file.getNextRec().copyFrom(fileAddress);
                block = file.getHeaderCache();
                if (n3 < 6) {
                    block.put32(Offset.FIRST_REC_OFF.get(n3), (int)fileAddress.getOffset());
                    if (n3 > 3) {
                        block.put16(Offset.FIRST_REC_SEG.get(n3), (short)fileAddress.getSegment());
                    }
                } else {
                    block.put48(Offset.FIRST_REC_OFF.get(n3), fileAddress.getOffset());
                }
                if (!this.newBlock(file, BlockType.DATA)) {
                    fileAddress3.initialize();
                    return fileAddress3;
                }
            }
            fileAddress3.copyFrom(file.getNextRec());
            int n6 = n2 - (n2 - n4) * logicalAttributes.getCompressFactor() / 100;
            recordHeader.setSize(this.checkMinRecordSize(n3, n6));
        }
        recordHeader.setStatus(RecordStatus.NO_STATUS);
        recordHeader.setUncompressed(bl && n2 == n4);
        recordHeader.setUsed(n4);
        recordHeader.setUniqueId(logicalAttributes.getDuplicates() > 0 ? file.getNextUniqueId() : 0L);
        this.packRecordHeader(file, block2, recordHeader);
        block2.copy((int)file.getRecordOverhead(), byArray, 0, n4);
        if (recordHeader.getUsed() < recordHeader.getSize()) {
            block2.fill(file.getRecordOverhead() + recordHeader.getUsed(), recordHeader.getSize() - recordHeader.getUsed(), (byte)0);
        }
        if (n3 > 3) {
            long l2 = fileAddress3.getOffset() + (long)file.getRecordOverhead();
            object4 = file.getFileSize();
            object3 = fileAddress3.copy();
            if (((FileAddress)object3).getSegment() == ((FileAddress)object4).getSegment() && l2 > ((FileAddress)object4).getOffset()) {
                ((FileAddress)object3).invalidate();
            } else if (n3 < 6 && l2 > file.getMaxSegmentSize()) {
                if (((FileAddress)object3).getSegment() < ((FileAddress)object4).getSegment() && ((FileAddress)object4).getOffset() > 512L) {
                    ((FileAddress)object3).incSegment();
                    ((FileAddress)object3).setOffset(512L);
                } else {
                    ((FileAddress)object3).invalidate();
                }
            }
            if (((FileAddress)object3).isValid()) {
                object2 = this.retrieveSegment(file, BlockType.DATA, ((FileAddress)object3).getSegment());
                object = file.getFileSystemCache();
                ((FileSystemCache)object).seek((FileDescriptor)object2, ((FileAddress)object3).getOffset());
                Block block4 = new Block(file.getRecordOverhead());
                if (((FileSystemCache)object).read((FileDescriptor)object2, block4, CacheDataType.RECORD) == block4.size()) {
                    RecordHeader recordHeader2 = new RecordHeader();
                    this.unpackRecordHeader(file, block4, recordHeader2);
                    if (recordHeader2.getStatus() != RecordStatus.DELETED && recordHeader2.getUsed() != 0) {
                        this.status.setErrno(6);
                        this.status.setIntErrno(87);
                        fileAddress3.initialize();
                        return fileAddress3;
                    }
                }
            }
        }
        if ((fileAddress = this.setRecord(file, block2, file.getRecordOverhead() + recordHeader.getSize(), fileAddress3, bl2)).isZero()) {
            fileAddress3.initialize();
            return fileAddress3;
        }
        if (bl2) {
            file.getNextRec().copyFrom(fileAddress);
        }
        file.incTotalRecords();
        if (!bl2) {
            file.decDeletedRecords();
        }
        return fileAddress3;
    }

    protected boolean deleteRecord(File file, FileAddress fileAddress) {
        Block block;
        FileAddress fileAddress2;
        FileAddress fileAddress3 = fileAddress.copy();
        int n2 = file.getVersion();
        int n3 = 0;
        if (n2 == 3 || n2 == 4) {
            n3 = this.checkMinRecordSize(n2, 0);
        }
        if ((fileAddress2 = this.getRecord(file, block = new Block(file.getRecordOverhead() + n3), file.getRecordOverhead(), fileAddress3, false)).isZero()) {
            return false;
        }
        RecordHeader recordHeader = new RecordHeader();
        this.unpackRecordHeader(file, block, recordHeader);
        recordHeader.setStatus(RecordStatus.DELETED);
        if (n2 < 5) {
            recordHeader.setUsed(0);
        }
        recordHeader.getNextDeleted().copyFrom(file.getFreeRec());
        this.packRecordHeader(file, block, recordHeader);
        if (n2 == 3 || n2 == 4) {
            block.put32(file.getRecordOverhead(), (int)recordHeader.getNextDeleted().getOffset());
            if (n2 == 4) {
                block.put16(file.getRecordOverhead() + 4, (short)recordHeader.getNextDeleted().getSegment());
            }
        }
        if ((fileAddress2 = this.setRecord(file, block, block.size(), fileAddress3, false)).isZero()) {
            return false;
        }
        file.getFreeRec().copyFrom(fileAddress3);
        Block block2 = file.getHeaderCache();
        if (n2 < 6) {
            block2.put32(Offset.FREEREC_OFF.get(n2), (int)fileAddress3.getOffset());
            if (n2 == 4 || n2 == 5) {
                block2.put16(Offset.FREEREC_SEG.get(n2), (short)fileAddress3.getSegment());
            }
        } else {
            block2.put48(Offset.FREEREC_OFF.get(n2), fileAddress3.getOffset());
        }
        file.setFreeFailures(0);
        file.decTotalRecords();
        file.incDeletedRecords();
        return true;
    }

    protected void rewriteRecord(File file, byte[] byArray, int n2, RecordHeader recordHeader, FileAddress fileAddress) {
        FileAddress fileAddress2;
        int n3;
        boolean bl;
        LogicalAttributes logicalAttributes = file.getLogicalAttributes();
        FileAddress fileAddress3 = fileAddress.copy();
        int n4 = n2;
        boolean bl2 = logicalAttributes.isCompressed();
        if (bl2) {
            n4 = this.deflate(file, byArray, n2);
            byArray = file.getCompressedRecord().getBytes();
        }
        boolean bl3 = bl = n4 > recordHeader.getSize();
        if (bl) {
            fileAddress.copyFrom(file.getNextRec());
            n3 = n2 - (n2 - n4) * logicalAttributes.getCompressFactor() / 100;
            recordHeader.setSize(this.checkMinRecordSize(file.getVersion(), n3));
        }
        recordHeader.setUsed(n4);
        recordHeader.setStatus(RecordStatus.NO_STATUS);
        recordHeader.setUncompressed(bl2 && n2 == n4);
        n3 = file.getRecordOverhead();
        Block block = file.getRewrittenRecord();
        this.packRecordHeader(file, block, recordHeader);
        block.copy(n3, byArray, 0, n4);
        if (n4 < recordHeader.getSize()) {
            block.fill(n3 + n4, recordHeader.getSize() - n4, (byte)0);
        }
        if ((fileAddress2 = this.setRecord(file, block, n3 + recordHeader.getSize(), fileAddress, bl)).isZero()) {
            fileAddress.initialize();
            return;
        }
        if (bl) {
            file.getNextRec().copyFrom(fileAddress2);
            if (!this.deleteRecord(file, fileAddress3)) {
                fileAddress.initialize();
                return;
            }
            file.incTotalRecords();
        }
    }

    protected void unlockRecord(File file) {
        this.unlockRecord(file, null);
    }

    protected void unlockRecord(File file, FileAddress fileAddress) {
        if (fileAddress == null) {
            if (!this.isMultiLockOnly(file.getOpenMode())) {
                Lock[] lockArray = file.getLocks();
                int n2 = lockArray.length;
                for (int i2 = 0; i2 < n2 && lockArray[i2] != null; ++i2) {
                    if (!lockArray[i2].isProgramLock()) continue;
                    lockArray[i2].release();
                    lockArray[i2] = null;
                    int n3 = i2 + 1;
                    if (n3 >= n2 || lockArray[n3] == null) break;
                    System.arraycopy(lockArray, n3, lockArray, i2, n2 - n3);
                    lockArray[n2 - 1] = null;
                    break;
                }
            }
        } else {
            Lock[] lockArray = file.getLocks();
            int n4 = lockArray.length;
            for (int i3 = 0; i3 < n4 && lockArray[i3] != null; ++i3) {
                if (!lockArray[i3].getAddress().eq(fileAddress)) continue;
                lockArray[i3].release();
                lockArray[i3] = null;
                int n5 = i3 + 1;
                if (n5 >= n4 || lockArray[n5] == null) break;
                System.arraycopy(lockArray, n5, lockArray, i3, n4 - n5);
                lockArray[n4 - 1] = null;
                break;
            }
        }
        file.getCurrentPrimaryKey().put8(0, (byte)0);
        file.getCurrentRecord().invalidate();
    }

    private Lock createLock(File file, FileAddress fileAddress, LockType lockType) {
        FileDescriptor fileDescriptor = this.retrieveSegment(file, BlockType.DATA, fileAddress.getSegment());
        FileLock fileLock = file.getFileSystemCache().testLock(fileDescriptor, fileAddress.getOffset(), 1);
        if (fileLock != null) {
            return new Lock(fileAddress.getSegment(), fileLock, lockType);
        }
        return null;
    }

    protected void moveLock(File file, FileAddress fileAddress, FileAddress fileAddress2) {
        Lock[] lockArray = file.getLocks();
        int n2 = lockArray.length;
        for (int i2 = 0; i2 < n2 && lockArray[i2] != null; ++i2) {
            int n3;
            if (!lockArray[i2].getAddress().eq(fileAddress)) continue;
            lockArray[i2].release();
            lockArray[i2] = this.createLock(file, fileAddress2, lockArray[i2].getType());
            if (lockArray[i2] != null || (n3 = i2 + 1) >= n2 || lockArray[n3] == null) break;
            System.arraycopy(lockArray, n3, lockArray, i2, n2 - n3);
            lockArray[n2 - 1] = null;
            break;
        }
    }

    private void extendLock(File file, Lock lock, FileAddress fileAddress) {
        FileAddress fileAddress2 = lock.getAddress();
        FileDescriptor fileDescriptor = this.retrieveSegment(file, BlockType.DATA, fileAddress2.getSegment());
        long l2 = fileAddress2.getOffset() + 1L;
        FileLock fileLock = file.getFileSystemCache().testLock(fileDescriptor, l2, (int)(fileAddress.getOffset() - l2));
        if (fileLock != null) {
            lock.extend(fileLock);
        }
    }

    protected void finishRead(File file, int n2, Block block, long l2, FileAddress fileAddress, boolean bl) {
        this.unlockHeader(file, true);
        file.setCurrentKeyNum(n2);
        if (file.getCurrentKey() != block) {
            file.getCurrentKey().copy(0, block, 0, (block.get8(0) & 0xFF) + 1);
        }
        file.setCurrentUniqueId(l2);
        file.setCurrentIsNext(bl);
        file.setPointerState(PointerState.HAS_CUR_REC);
        file.getLastReadBlock().copyFrom(fileAddress);
        file.setLastReadTreeVersion(file.getTreeVersion());
    }

    protected boolean beginRead(File file, boolean bl) {
        this.status.setErrno(0);
        file.setPointerState(PointerState.NO_CUR_REC);
        file.getLastReadBlock().initialize();
        if (!this.lockHeader(file, false, false, bl)) {
            return false;
        }
        this.unlockRecord(file);
        if (this.isOutputOnly(file.getOpenMode()) || this.isExtendOnly(file.getOpenMode())) {
            this.unlockHeader(file, true);
            this.status.setErrno(4);
            return false;
        }
        return true;
    }

    protected void invalidateReadNextAddressesCache(File file) {
        file.getReadNextAddressesCache()[0] = null;
    }

    protected FileAddress getReadNextCachedAddress(File file) {
        return file.getReadNextAddressesCache()[0];
    }

    protected void storeReadNextCachedAddress(File file, int n2, FileAddress fileAddress) {
        file.getReadNextAddressesCache()[n2] = fileAddress;
    }

    protected void popReadNextCachedAddress(File file) {
        FileAddress[] fileAddressArray = file.getReadNextAddressesCache();
        for (int i2 = 1; i2 < 10; ++i2) {
            fileAddressArray[i2 - 1] = fileAddressArray[i2];
        }
        fileAddressArray[9] = null;
    }

    protected void purgeReadNextCachedAddress(File file, int n2) {
        FileAddress[] fileAddressArray = file.getReadNextAddressesCache();
        while (n2 < 10) {
            fileAddressArray[n2] = null;
            ++n2;
        }
    }

    protected FileAddress isCurrentLockedRecord(File file, byte[] byArray) {
        if (file.getCurrentRecord().gtZero()) {
            Block block = file.getCurrentPrimaryKey();
            KeyInfo keyInfo = file.getLogicalAttributes().getKey(0);
            int n2 = 0;
            for (int i2 = 0; i2 < keyInfo.getSegments(); ++i2) {
                int n3 = keyInfo.getSize(i2);
                if (block.compare(n2, byArray, keyInfo.getOffset(i2), n3) != 0) {
                    return null;
                }
                n2 += n3;
            }
            return file.getCurrentRecord().copy();
        }
        return null;
    }

    private int deflate(File file, byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = byArray[n4] & 0xFF;
        int n6 = 0;
        int n7 = n2;
        Block block = file.getCompressedRecord();
        while ((n2 > 0 || n6 > 0) && n3 <= n7) {
            if (n2 > 0 && n5 == (byArray[n4] & 0xFF)) {
                ++n6;
            } else {
                int n8;
                int n9;
                switch (n5) {
                    case 32: {
                        n9 = 253;
                        break;
                    }
                    case 48: {
                        n9 = 252;
                        break;
                    }
                    case 0: {
                        n9 = 251;
                        break;
                    }
                    default: {
                        n9 = 0;
                    }
                }
                while (n9 != 0 && n6 > 2) {
                    block.put8(n3++, (byte)n9);
                    n8 = Math.min(n6, 127);
                    block.put8(n3++, (byte)n8);
                    n6 -= n8;
                }
                while (n6 > 3) {
                    block.put8(n3++, (byte)-2);
                    block.put8(n3++, (byte)n5);
                    n8 = Math.min(n6, 127);
                    block.put8(n3++, (byte)n8);
                    n6 -= n8;
                }
                while (n6 > 0) {
                    if (n5 >= 250 && n5 <= 254) {
                        block.put8(n3++, (byte)-6);
                    }
                    block.put8(n3++, (byte)n5);
                    --n6;
                }
                if (n2 > 0) {
                    n5 = byArray[n4] & 0xFF;
                    n6 = 1;
                }
            }
            if (n2 <= 0) continue;
            ++n4;
            --n2;
        }
        if (n3 >= n7) {
            block.copy(0, byArray, 0, n7);
            return n7;
        }
        return n3;
    }

    private int inflate(File file, Block block, int n2, int n3) {
        int n4 = n3;
        int n5 = n2;
        int n6 = n2 + file.getLogicalAttributes().getMaxRecordSize();
        int n7 = n2;
        Block block2 = file.getCompressedRecord();
        while (n3 > 0) {
            int n8 = block2.get8(n7) & 0xFF;
            if (n8 >= 251 && n8 <= 254) {
                byte by;
                if (n8 == 254) {
                    by = block2.get8(++n7);
                    --n4;
                    --n3;
                } else {
                    by = COMPRESSED_VALUES[254 - n8];
                }
                int n9 = block2.get8(++n7) & 0xFF;
                n4 += n9 - 2;
                if (n5 + n9 > n6) {
                    return 0;
                }
                while (n9-- > 0) {
                    block.put8(n5++, by);
                }
                n3 -= 2;
                ++n7;
                continue;
            }
            if (n8 == 250) {
                --n4;
                --n3;
                n8 = block2.get8(++n7) & 0xFF;
            }
            if (n5 >= n6) {
                return 0;
            }
            block.put8(n5++, (byte)n8);
            ++n7;
            --n3;
        }
        return n4;
    }
}

