/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.Config;
import com.veryant.vision4j.file.File;
import com.veryant.vision4j.file.FileInfoHelper;
import com.veryant.vision4j.file.FileSystemCache;
import com.veryant.vision4j.file.FileTable;
import com.veryant.vision4j.file.Offset;
import com.veryant.vision4j.file.SegmentInfoHelper;
import com.veryant.vision4j.file.TransactionLog;
import com.veryant.vision4j.file.Vision;
import com.veryant.vision4j.file.internals.Block;
import com.veryant.vision4j.file.internals.BlockType;
import com.veryant.vision4j.file.internals.CacheDataType;
import com.veryant.vision4j.file.internals.FileAddress;
import com.veryant.vision4j.file.internals.FileDescriptor;
import com.veryant.vision4j.file.internals.KeyInfo;
import com.veryant.vision4j.file.internals.Lock;
import com.veryant.vision4j.file.internals.LogicalAttributes;
import com.veryant.vision4j.file.internals.PhysicalAttributes;
import com.veryant.vision4j.file.internals.PointerState;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class VisionFactory
extends Vision {
    private static final int INVALID_FILE_ID = 0;

    public VisionFactory(Config config, FileTable fileTable) {
        super(config, fileTable);
    }

    public int getErrno() {
        return this.status.getErrno();
    }

    public int getIntErrno() {
        return this.status.getIntErrno();
    }

    public int open(String string, int n2) {
        int n3;
        this.status.setErrno(0);
        File file = this.openFile(string, n2, false);
        if (file == null) {
            return 0;
        }
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        file.setPointerState(PointerState.AT_START);
        file.setCurrentKeyNum(0);
        file.getCurrentRecord().invalidate();
        int n4 = file.getVersion();
        boolean bl = this.isInputOnly(file.getOpenMode());
        if (!bl || this.config.V_OPEN_STRICT.isOn()) {
            int n5;
            int n6;
            n3 = 0;
            if (n4 == 3) {
                n3 = !fileSystemCache.checkSize(this.retrieveSegment(file, BlockType.DATA, 0), file.getFileSize().getOffset()) ? 1 : 0;
            } else {
                n6 = file.getSegmentCount();
                for (n5 = 0; n3 == 0 && n5 < n6; ++n5) {
                    n3 = !fileSystemCache.checkSize(this.retrieveSegment(file, BlockType.DATA, n5), file.getSegmentSize(n5)) ? 1 : 0;
                }
                n6 = file.getIndexFile().getSegmentCount();
                for (n5 = 0; n3 == 0 && n5 < n6; ++n5) {
                    n3 = !fileSystemCache.checkSize(this.retrieveSegment(file, BlockType.NODE, n5), file.getIndexFile().getSegmentSize(n5)) ? 1 : 0;
                }
            }
            if (n3 != 0) {
                this.closeAdditionalSegments(file);
                this.unlockHeader(file, false);
                this.closeFile(file);
                this.status.setErrno(6);
                this.status.setIntErrno(1);
                return 0;
            }
            n6 = 0;
            if (file.getNextRec().gt(file.getFileSize())) {
                n6 = 1;
            } else if (file.getNextRec().gtZero()) {
                n5 = n4 > 4 ? 4 : 2;
                Block block = new Block(n5);
                FileAddress fileAddress = file.getNextRec().copy();
                fileAddress.incOffset(n5);
                if ((n4 == 4 || n4 == 5) && fileAddress.getOffset() > file.getMaxSegmentSize()) {
                    fileAddress.incSegment();
                    fileAddress.setOffset(512 + n5);
                }
                if (fileAddress.lt(file.getFileSize())) {
                    FileDescriptor fileDescriptor = this.retrieveSegment(file, BlockType.DATA, fileAddress.getSegment());
                    fileSystemCache.seek(fileDescriptor, fileAddress.getOffset() - (long)(--n5));
                    if (fileSystemCache.read(fileDescriptor, block, 1, n5, CacheDataType.RECORD) == n5) {
                        for (int i2 = 1; i2 <= n5; ++i2) {
                            if (block.get8(i2) == 0) continue;
                            n6 = 1;
                            break;
                        }
                    } else {
                        n6 = 1;
                    }
                }
            }
            if (n6 != 0 && this.config.V_FORCE_OPEN.isOff()) {
                this.closeAdditionalSegments(file);
                this.unlockHeader(file, false);
                this.closeFile(file);
                this.status.setErrno(6);
                this.status.setIntErrno(2);
                return 0;
            }
        }
        if (!bl) {
            file.getHeaderCache().put16(Offset.OPEN_CNT.get(file.getVersion()), (short)file.incOpenCounter());
            this.saveHeader(file, true);
        }
        if ((n3 = this.fileTable.add(file, this.config.V_INTERNAL_LOCKS.isOn())) > 0) {
            this.unlockHeader(file, false);
            return file.getId();
        }
        this.closeAdditionalSegments(file);
        this.unlockHeader(file, false);
        this.closeFile(file);
        this.status.setErrno(n3 == 0 ? 3 : 11);
        return 0;
    }

    public boolean close(int n2, TransactionLog transactionLog) {
        File file = this.fileTable.get(n2);
        if (file == null) {
            this.status.setErrno(1);
            return false;
        }
        this.status.setErrno(0);
        boolean bl = this.isInputOnly(file.getOpenMode());
        if (this.useTransactionLog(file, transactionLog) && file.isPendingTransaction()) {
            transactionLog.postponedClose(n2);
            return true;
        }
        if (!this.unlock(file)) {
            return false;
        }
        boolean bl2 = this.config.V_FORCE_OPEN.isOn();
        if (!bl2) {
            this.config.V_FORCE_OPEN.set(true);
        }
        boolean bl3 = this.lockHeader(file, true, !bl, false);
        this.config.V_FORCE_OPEN.set(bl2);
        if (!bl3) {
            return false;
        }
        if (!this.closeAdditionalSegments(file)) {
            bl3 = false;
        }
        if (!bl) {
            file.getHeaderCache().put16(Offset.OPEN_CNT.get(file.getVersion()), (short)file.decOpenCounter());
            this.saveHeader(file, false);
        }
        this.unlockHeader(file, false);
        if (!this.closeFile(file)) {
            bl3 = false;
        }
        this.fileTable.remove(file);
        return bl3;
    }

    public boolean remove(String string) {
        int n2 = this.open(string, 0);
        if (n2 == 0) {
            return false;
        }
        File file = this.fileTable.get(n2);
        int n3 = file.getVersion();
        int n4 = file.getSegmentCount();
        int n5 = 0;
        if (n3 > 3) {
            n5 = file.getIndexFile().getSegmentCount();
        }
        this.close(n2, null);
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        boolean bl = fileSystemCache.remove(this.getDataSegmentName(string, 0));
        if (n3 > 3) {
            int n6;
            for (n6 = 1; bl && n6 < n4; ++n6) {
                bl = fileSystemCache.remove(this.getDataSegmentName(string, n6));
            }
            for (n6 = 0; bl && n6 < n5; ++n6) {
                bl = fileSystemCache.remove(this.getIndexSegmentName(string, n6));
            }
        }
        return bl;
    }

    public byte[] info(int n2, int n3, byte[] byArray) {
        File file = this.fileTable.get(n2);
        if (file == null) {
            this.status.setErrno(1);
            return null;
        }
        this.status.setErrno(0);
        LogicalAttributes logicalAttributes = file.getLogicalAttributes();
        PhysicalAttributes physicalAttributes = file.getPhysicalAttributes();
        switch (n3) {
            case -1: {
                return String.format("%010d,%010d,%03d", logicalAttributes.getMaxRecordSize(), logicalAttributes.getMinRecordSize(), logicalAttributes.getNumKeys()).getBytes(StandardCharsets.US_ASCII);
            }
            case -2: {
                return String.format("%02d,%05d,%02d,%03d,%1d", physicalAttributes.getBlockingFactor(), 0, physicalAttributes.getExtensionFactor(), logicalAttributes.getCompressFactor(), 0).getBytes(StandardCharsets.US_ASCII);
            }
            case -3: {
                return Arrays.copyOfRange(file.getHeaderCache().getBytes(), Offset.COMMENT.get(file.getVersion()), 30);
            }
            case -4: {
                return String.format("%010d", file.getTotalRecords()).getBytes(StandardCharsets.US_ASCII);
            }
            case -5: {
                if (file.hasCollate()) {
                    return file.copyOfCollate();
                }
                return null;
            }
            case -6: {
                int n4;
                Lock[] lockArray = file.getLocks();
                for (n4 = 0; n4 < lockArray.length && lockArray[n4] != null; ++n4) {
                }
                return String.format("%04d", n4).getBytes(StandardCharsets.US_ASCII);
            }
            case -7: {
                if (file.getVersion() > 3) {
                    return String.format("%05d,%05d", file.getSegmentCount(), file.getIndexFile().getSegmentCount()).getBytes(StandardCharsets.US_ASCII);
                }
                return "00000,00000".getBytes(StandardCharsets.US_ASCII);
            }
            case -8: {
                SegmentInfoHelper segmentInfoHelper = new SegmentInfoHelper(byArray);
                if (file.getVersion() == 3) {
                    segmentInfoHelper.setSegmentName(file.getName());
                    segmentInfoHelper.setSegmentSize(file.getFileSize().getOffset());
                } else {
                    int n5 = segmentInfoHelper.getSegmentNumber();
                    boolean bl = segmentInfoHelper.isDataSegment();
                    if (!bl && !segmentInfoHelper.isIndexSegment()) {
                        return null;
                    }
                    if (n5 < 1 || bl ? n5 > file.getSegmentCount() : n5 > file.getIndexFile().getSegmentCount()) {
                        return null;
                    }
                    segmentInfoHelper.setSegmentName(bl ? this.getDataSegmentName(file.getName(), n5 - 1) : this.getIndexSegmentName(file.getName(), n5 - 1));
                    segmentInfoHelper.setSegmentSize(bl ? file.getSegmentSize(n5 - 1) : file.getIndexFile().getSegmentSize(n5 - 1));
                }
                return byArray;
            }
            case -9: {
                if (file.getVersion() > 3) {
                    int n6;
                    long l2 = 0L;
                    for (n6 = 0; n6 < file.getSegmentCount(); ++n6) {
                        l2 += file.getSegmentSize(n6);
                    }
                    for (n6 = 0; n6 < file.getIndexFile().getSegmentCount(); ++n6) {
                        l2 += file.getIndexFile().getSegmentSize(n6);
                    }
                    return String.format("%015d", l2).getBytes(StandardCharsets.US_ASCII);
                }
                return String.format("%015d", file.getFileSize().getOffset()).getBytes(StandardCharsets.US_ASCII);
            }
            case -10: {
                return String.format("%03d", file.getVersion()).getBytes(StandardCharsets.US_ASCII);
            }
            case -11: {
                if (file.getVersion() < 5) {
                    return String.format("%010d", file.getDeletedRecords()).getBytes(StandardCharsets.US_ASCII);
                }
                return String.format("%010d", file.getDeletedRecords() + file.getAbandonedRecords()).getBytes(StandardCharsets.US_ASCII);
            }
        }
        if (n3 >= file.getLogicalAttributes().getNumKeys() || n3 < 0) {
            this.status.setErrno(2);
            return null;
        }
        KeyInfo keyInfo = file.getLogicalAttributes().getKey(n3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%02d,%1d", keyInfo.getSegments(), keyInfo.isDuplicate() ? 1 : 0));
        for (int i2 = 0; i2 < keyInfo.getSegments(); ++i2) {
            stringBuilder.append(String.format(",%03d,%010d", keyInfo.getSize(i2), keyInfo.getOffset(i2)));
        }
        return stringBuilder.toString().getBytes(StandardCharsets.US_ASCII);
    }

    private void storeKeyInfo(int n2, Block block, int n3, KeyInfo keyInfo) {
        int n4 = Offset.KOFF.get(n2);
        int n5 = Offset.KSIZE.get(n2);
        int n6 = Offset.SEG_MULT.get(n2);
        int n7 = keyInfo.getSegments();
        block.put8(n3 + Offset.NPARTS.get(n2), (byte)n7);
        block.put8(n3 + Offset.KDUP.get(n2), (byte)(keyInfo.isDuplicate() ? 1 : 0));
        block.put8(n3 + Offset.TOTALSIZE.get(n2), (byte)keyInfo.getTotalSize());
        for (int i2 = 0; i2 < n7; ++i2) {
            int n8 = n3 + i2 * n6;
            block.put8(n8 + n5, (byte)keyInfo.getSize(i2));
            if (n2 < 5) {
                block.put16(n8 + n4, (short)keyInfo.getOffset(i2));
                continue;
            }
            block.put32(n8 + n4, keyInfo.getOffset(i2));
        }
    }

    private KeyInfo retrieveKeyInfo(int n2, Block block) {
        int n3 = block.get8(Offset.NPARTS.get(n2)) & 0xFF;
        if (n3 < 1 || n2 == 3 && n3 > 6 || n3 > 16) {
            return null;
        }
        int n4 = Offset.SEG_MULT.get(n2);
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = i2 * n4;
            nArray2[i2] = block.get8(n5 + Offset.KSIZE.get(n2)) & 0xFF;
            nArray[i2] = n2 < 5 ? block.get16(n5 + Offset.KOFF.get(n2)) & 0xFFFF : block.get32(n5 + Offset.KOFF.get(n2));
        }
        KeyInfo keyInfo = new KeyInfo(block.get8(Offset.KDUP.get(n2)) != 0, nArray, nArray2);
        if (keyInfo.getTotalSize() != (block.get8(Offset.TOTALSIZE.get(n2)) & 0xFF)) {
            return null;
        }
        keyInfo.setHeight((short)(block.get8(Offset.KEYHEIGHT.get(n2)) & 0xFF));
        keyInfo.getKeyRoot().setOffset(n2 < 6 ? (long)block.get32(Offset.KEYROOT_OFF.get(n2)) & 0xFFFFFFFFL : block.get48(Offset.KEYROOT_OFF.get(n2)));
        keyInfo.getKeyRoot().setSegment(n2 == 4 || n2 == 5 ? block.get16(Offset.KEYROOT_SEG.get(n2)) & 0xFFFF : 0);
        return keyInfo;
    }

    public boolean make(String string, PhysicalAttributes physicalAttributes, LogicalAttributes logicalAttributes, byte[] byArray) {
        this.status.setErrno(2);
        if (physicalAttributes == null) {
            physicalAttributes = new PhysicalAttributes();
        }
        if (logicalAttributes == null) {
            return false;
        }
        if (logicalAttributes.getMinRecordSize() > logicalAttributes.getMaxRecordSize()) {
            return false;
        }
        if (byArray != null && byArray.length != 256) {
            return false;
        }
        int n2 = this.config.V_VERSION.getIntegerValue();
        if (n2 < 5 ? logicalAttributes.getMaxRecordSize() > Short.MAX_VALUE || physicalAttributes.getBlockingFactor() > 2 || physicalAttributes.getPreallocAmount() > 65535 || physicalAttributes.getExtensionFactor() > 99 : logicalAttributes.getMaxRecordSize() > 0x4000000 || physicalAttributes.getBlockingFactor() > 16 || physicalAttributes.getPreallocAmount() > 0x200000 || physicalAttributes.getExtensionFactor() > 0x200000) {
            return false;
        }
        int n3 = logicalAttributes.getNumKeys();
        if (n3 > 120 || n3 < 1) {
            return false;
        }
        int n4 = n2 == 3 ? 6 : 16;
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            KeyInfo keyInfo = logicalAttributes.getKey(i2);
            int n6 = keyInfo.getSegments();
            int n7 = keyInfo.getTotalSize();
            if (n6 > n4 || n7 > 250) {
                return false;
            }
            for (int i3 = 0; i3 < n6; ++i3) {
                int n8 = keyInfo.getOffset(i3) + keyInfo.getSize(i3);
                if (n8 <= n5) continue;
                n5 = n8;
            }
        }
        if (n5 > logicalAttributes.getMinRecordSize()) {
            return false;
        }
        if (logicalAttributes.getMaxKeySize() > 125 && physicalAttributes.getBlockingFactor() < 2) {
            physicalAttributes = new PhysicalAttributes(2, physicalAttributes.getPreallocAmount(), physicalAttributes.getExtensionFactor());
        }
        this.status.setErrno(0);
        return this.createEmptyFile(string, n2, physicalAttributes, logicalAttributes, byArray);
    }

    private boolean createEmptyFile(String string, int n2, PhysicalAttributes physicalAttributes, LogicalAttributes logicalAttributes, byte[] byArray) {
        Block block;
        int n3;
        int n4;
        int n5;
        int n6;
        long l2;
        int n7 = physicalAttributes.getBlockingFactor();
        int n8 = physicalAttributes.getPreallocAmount();
        int n9 = n7 * 512;
        int n10 = 1;
        int n11 = logicalAttributes.getNumKeys();
        int n12 = Offset.BLK_1_KEYS.get(n2);
        int n13 = Offset.BLK_N_KEYS.get(n2);
        if (n11 > n12) {
            n10 += (n11 - n12 + n13 - 1) / n13;
        }
        if (byArray != null) {
            ++n10;
        }
        long l3 = (long)((n10 + n7 - 1) / n7) * (long)n7;
        long l4 = (long)((1 + n7 - 1) / n7) * (long)n7;
        long l5 = (long)n8 * (long)n7;
        if (l5 < (long)n10) {
            l5 = l3;
        }
        if ((l2 = (long)((double)l5 * ((double)(n6 = this.config.V_INDEX_BLOCK_PERCENT.getIntegerValue()) / 100.0) + 0.5)) < 1L) {
            l2 = 1L;
        }
        int n14 = this.config.V_SEG_SIZE.getIntegerValue();
        int n15 = n14 / n9 * n9;
        if (n2 == 4 || n2 == 5) {
            int n16;
            int n17 = 2147482112 / n9 * n9;
            if (n15 > n17 || n14 == 0) {
                n15 = n17;
            }
            if ((n16 = 81920 / n9 * n9) < 81920) {
                n16 += n9;
            }
            if (n15 < n16) {
                n15 = n16;
            }
            if (l5 > (long)(n15 / 512)) {
                l5 = n15 / 512;
            }
            if (l2 > (long)(n15 / 512)) {
                l2 = n15 / 512;
            }
            if ((long)(logicalAttributes.getMaxRecordSize() + 15) > (long)n15 - l3 * 512L) {
                this.status.setErrno(17);
                return false;
            }
        }
        this.remove(string);
        FileSystemCache fileSystemCache = new FileSystemCache(this.status);
        FileDescriptor fileDescriptor = fileSystemCache.open(this.getDataSegmentName(string, 0), 513);
        if (fileDescriptor == null) {
            return false;
        }
        FileLock fileLock = fileSystemCache.lock(fileDescriptor);
        if (fileLock == null) {
            return false;
        }
        Block block2 = new Block(512);
        int n18 = 0;
        while ((long)n18 < l5) {
            if (n2 == 3 && n18 % n7 == 0) {
                block2.put8(0, BlockType.EMPTY.getVal());
            }
            if (fileSystemCache.write(fileDescriptor, block2, CacheDataType.RECORD) != 512) {
                fileSystemCache.unlock(fileLock);
                fileSystemCache.close(fileDescriptor);
                return false;
            }
            ++n18;
        }
        FileDescriptor fileDescriptor2 = null;
        FileLock fileLock2 = null;
        if (n2 > 3) {
            fileDescriptor2 = fileSystemCache.open(this.getIndexSegmentName(string, 0), 513);
            if (fileDescriptor2 == null) {
                fileSystemCache.unlock(fileLock);
                fileSystemCache.close(fileDescriptor);
                return false;
            }
            fileLock2 = fileSystemCache.lock(fileDescriptor2);
            if (fileLock2 == null) {
                fileSystemCache.unlock(fileLock);
                fileSystemCache.close(fileDescriptor);
                return false;
            }
            fileSystemCache.seek(fileDescriptor2, 0L);
            n5 = 0;
            while ((long)n5 < l2) {
                if (fileSystemCache.write(fileDescriptor2, block2, CacheDataType.INDEX) != 512) {
                    fileSystemCache.unlock(fileLock);
                    fileSystemCache.close(fileDescriptor);
                    fileSystemCache.unlock(fileLock2);
                    fileSystemCache.close(fileDescriptor2);
                    return false;
                }
                ++n5;
            }
        }
        l5 *= 512L;
        l2 *= 512L;
        l3 *= 512L;
        l4 *= 512L;
        if (n2 == 3) {
            block2.put32(Offset.MAGIC.get(n2), 269620246);
        } else {
            block2.put32(Offset.MAGIC.get(n2), 269620249);
            if (n2 < 6) {
                block2.put32(Offset.WHOLE_DATA_OFF.get(n2), (int)l5);
                block2.put16(Offset.WHOLE_DATA_SEG.get(n2), (short)0);
                block2.put32(Offset.WHOLE_INDEX_OFF.get(n2), (int)l2);
                block2.put16(Offset.WHOLE_INDEX_SEG.get(n2), (short)0);
                block2.put16(Offset.NXTBLK_SEG.get(n2), (short)0);
            } else {
                block2.put48(Offset.WHOLE_DATA_OFF.get(n2), l5);
                block2.put48(Offset.WHOLE_INDEX_OFF.get(n2), l2);
            }
            if (n2 == 4) {
                block2.put32(Offset.I_NXTBLK_OFF.get(n2), (int)l3);
            } else if (n2 == 5) {
                block2.put32(Offset.I_NXTBLK_OFF.get(n2), (int)l4);
            } else {
                block2.put48(Offset.I_NXTBLK_OFF.get(n2), l4);
            }
            if (n2 < 6) {
                block2.put16(Offset.I_NXTBLK_SEG.get(n2), (short)0);
                block2.put16(Offset.DATA_SEGS.get(n2), (short)0);
                block2.put16(Offset.INDEX_SEGS.get(n2), (short)0);
                block2.put32(Offset.MAX_SEG_SIZE.get(n2), n15);
            }
        }
        block2.put16(Offset.VERSION.get(n2), (short)n2);
        block2.put16(Offset.BLKMULT.get(n2), (short)n7);
        if (n2 < 5) {
            block2.put16(Offset.PREALLOC.get(n2), (short)n8);
            block2.put16(Offset.EXTENSION.get(n2), (short)physicalAttributes.getExtensionFactor());
        } else {
            block2.put32(Offset.PREALLOC.get(n2), n8);
            block2.put32(Offset.EXTENSION.get(n2), physicalAttributes.getExtensionFactor());
        }
        if (n2 < 6) {
            block2.put32(Offset.FILESIZE.get(n2), (int)l5);
            block2.put32(Offset.NXTBLK_OFF.get(n2), (int)l3);
        } else {
            block2.put48(Offset.FILESIZE.get(n2), l5);
            block2.put48(Offset.NXTBLK_OFF.get(n2), l3);
        }
        if (byArray != null) {
            block2.put32(Offset.COLLATE.get(n2), (n10 - 1) * 512);
        }
        n5 = 0;
        for (n4 = 0; n4 < n11; ++n4) {
            if (!logicalAttributes.getKey(n4).isDuplicate()) continue;
            ++n5;
        }
        block2.put16(Offset.DUPKEYS.get(n2), (short)n5);
        if (n2 < 5) {
            if (n5 == 0) {
                block2.put16(Offset.REC_OVERHEAD.get(n2), (short)4);
            } else {
                block2.put16(Offset.REC_OVERHEAD.get(n2), (short)8);
            }
        } else {
            block2.put16(Offset.REC_OVERHEAD.get(n2), (short)15);
        }
        if (n2 < 5) {
            block2.put16(Offset.MAXREC.get(n2), (short)logicalAttributes.getMaxRecordSize());
            block2.put16(Offset.MINREC.get(n2), (short)logicalAttributes.getMinRecordSize());
        } else {
            block2.put32(Offset.MAXREC.get(n2), logicalAttributes.getMaxRecordSize());
            block2.put32(Offset.MINREC.get(n2), logicalAttributes.getMinRecordSize());
        }
        block2.put8(Offset.NKEYS.get(n2), (byte)n11);
        block2.put8(Offset.MAXKSIZE.get(n2), (byte)logicalAttributes.getMaxKeySize());
        n4 = logicalAttributes.getCompressFactor();
        if (n4 == 0 && this.config.V_COMPRESS_FILES.isOn()) {
            n4 = 1;
        }
        block2.put8(Offset.COMPRESS.get(n2), (byte)n4);
        block2.put8(Offset.ENCRYPT.get(n2), (byte)0);
        if (this.config.V_APPLY_SIGNATURE.isOn()) {
            block2.copy(Offset.COMMENT.get(n2), DEFAULT_COMMENT, 0, 30);
        }
        int n19 = Offset.KEYINFO.get(n2);
        int n20 = Offset.BLK_1_KEYS.get(n2);
        int n21 = Offset.KEY_MULT.get(n2);
        for (n3 = 0; n3 < n11 && n3 < n20; ++n3) {
            this.storeKeyInfo(n2, block2, n19, logicalAttributes.getKey(n3));
            n19 += n21;
        }
        fileSystemCache.seek(fileDescriptor, 0L);
        fileSystemCache.write(fileDescriptor, block2, CacheDataType.HEADER);
        int n22 = 0;
        int n23 = Offset.BLK_N_KEYS.get(n2);
        while (n3 < n11) {
            n19 = 0;
            block = new Block(512);
            for (int i2 = 0; n3 < n11 && i2 < n23; ++i2, ++n3) {
                this.storeKeyInfo(n2, block, n19, logicalAttributes.getKey(n3));
                n19 += n21;
            }
            fileSystemCache.seek(fileDescriptor, (long)(++n22) * 512L);
            fileSystemCache.write(fileDescriptor, block, CacheDataType.HEADER);
        }
        if (byArray != null) {
            block = new Block(512);
            if (n2 != 4) {
                block.put8(0, BlockType.COLLATE.getVal());
            }
            block.copy(16, byArray, 0, 256);
            fileSystemCache.seek(fileDescriptor, (long)(++n22) * 512L);
            fileSystemCache.write(fileDescriptor, block, CacheDataType.HEADER);
        }
        if (n2 > 3) {
            block = new Block(512);
            block.put32(Offset.I_MAGIC.get(n2), 269620248);
            block.put16(Offset.I_VERSION.get(n2), (short)n2);
            if (n2 < 6) {
                block.put32(Offset.I_FILESIZE.get(n2), (int)l2);
            } else {
                block.put48(Offset.I_FILESIZE.get(n2), l2);
            }
            fileSystemCache.seek(fileDescriptor2, 0L);
            fileSystemCache.write(fileDescriptor2, block, CacheDataType.HEADER);
        }
        fileSystemCache.unlock(fileLock);
        if (n2 > 3) {
            fileSystemCache.unlock(fileLock2);
        }
        if (!fileSystemCache.close(fileDescriptor) || n2 > 3 && !fileSystemCache.close(fileDescriptor2)) {
            this.status.setErrno(10);
            return false;
        }
        return true;
    }

    private File openFile(String string, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        FileSystemCache fileSystemCache = new FileSystemCache(this.status);
        FileDescriptor fileDescriptor = fileSystemCache.open(this.getDataSegmentName(string, 0), this.standardizeOpenMode(n2));
        if (fileDescriptor == null) {
            return null;
        }
        FileLock fileLock = fileSystemCache.lock(fileDescriptor);
        if (fileLock == null) {
            fileSystemCache.close(fileDescriptor);
            return null;
        }
        Block block = new Block(512);
        fileSystemCache.seek(fileDescriptor, 0L);
        if (fileSystemCache.read(fileDescriptor, block, CacheDataType.HEADER) < 512) {
            fileSystemCache.unlock(fileLock);
            fileSystemCache.close(fileDescriptor);
            this.status.setErrno(13);
            return null;
        }
        short s2 = 0;
        int n7 = block.get32(0);
        if (n7 == 269620246 || n7 == 269620249) {
            s2 = block.get16(4);
        }
        if (s2 < 3 || s2 > 6) {
            fileSystemCache.unlock(fileLock);
            fileSystemCache.close(fileDescriptor);
            this.status.setErrno(13);
            return null;
        }
        if (block.get8(Offset.ENCRYPT.get(s2)) != 0) {
            fileSystemCache.unlock(fileLock);
            fileSystemCache.close(fileDescriptor);
            this.status.setErrno(17);
            return null;
        }
        PhysicalAttributes physicalAttributes = new PhysicalAttributes(block.get16(Offset.BLKMULT.get(s2)), s2 < 5 ? block.get16(Offset.PREALLOC.get(s2)) : block.get32(Offset.PREALLOC.get(s2)), s2 < 5 ? block.get16(Offset.EXTENSION.get(s2)) : block.get32(Offset.EXTENSION.get(s2)));
        if (s2 < 5) {
            n6 = block.get16(Offset.MAXREC.get(s2));
            n5 = block.get16(Offset.MINREC.get(s2));
        } else {
            n6 = block.get32(Offset.MAXREC.get(s2));
            n5 = block.get32(Offset.MINREC.get(s2));
        }
        int n8 = block.get8(Offset.COMPRESS.get(s2)) & 0xFF;
        if (n8 == 1) {
            n8 = this.config.V_COMPRESS_FACTOR.getIntegerValue();
        }
        int n9 = block.get8(Offset.NKEYS.get(s2)) & 0xFF;
        KeyInfo[] keyInfoArray = new KeyInfo[n9];
        int n10 = Offset.KEYINFO.get(s2);
        int n11 = Offset.KEY_MULT.get(s2);
        Block block2 = new Block(n11);
        for (int i2 = 0; i2 < n9; ++i2) {
            int n12 = 512 - n10 % 512;
            if (n12 < n11) {
                n10 += n12;
            }
            fileSystemCache.seek(fileDescriptor, n10);
            if (fileSystemCache.read(fileDescriptor, block2, CacheDataType.HEADER) != n11) {
                fileSystemCache.unlock(fileLock);
                fileSystemCache.close(fileDescriptor);
                this.status.setErrno(6);
                this.status.setIntErrno(8);
                return null;
            }
            n10 += n11;
            keyInfoArray[i2] = this.retrieveKeyInfo(s2, block2);
            if (keyInfoArray[i2] != null) continue;
            fileSystemCache.unlock(fileLock);
            fileSystemCache.close(fileDescriptor);
            this.status.setErrno(6);
            this.status.setIntErrno(23);
            return null;
        }
        LogicalAttributes logicalAttributes = new LogicalAttributes(n5, n6, keyInfoArray, n8);
        if (logicalAttributes.getMaxKeySize() != (block.get8(Offset.MAXKSIZE.get(s2)) & 0xFF) || logicalAttributes.getDuplicates() != block.get16(Offset.DUPKEYS.get(s2))) {
            fileSystemCache.unlock(fileLock);
            fileSystemCache.close(fileDescriptor);
            this.status.setErrno(6);
            this.status.setIntErrno(23);
            return null;
        }
        Block block3 = null;
        long l2 = (long)block.get32(Offset.COLLATE.get(s2)) & 0xFFFFFFFFL;
        if (l2 != 0L) {
            block3 = new Block(256);
            fileSystemCache.seek(fileDescriptor, l2 + 16L);
            if (fileSystemCache.read(fileDescriptor, block3, CacheDataType.HEADER) != 256) {
                fileSystemCache.unlock(fileLock);
                fileSystemCache.close(fileDescriptor);
                return null;
            }
        }
        FileDescriptor fileDescriptor2 = null;
        if (s2 > 3 && !bl) {
            fileDescriptor2 = fileSystemCache.open(this.getIndexSegmentName(string, 0), this.standardizeOpenMode(n2));
            if (fileDescriptor2 == null) {
                if (this.status.getErrno() == 15) {
                    fileSystemCache.unlock(fileLock);
                    fileSystemCache.close(fileDescriptor);
                    this.status.setErrno(6);
                    this.status.setIntErrno(69);
                }
                return null;
            }
            FileLock fileLock2 = fileSystemCache.lock(fileDescriptor2);
            if (fileLock2 == null) {
                fileSystemCache.unlock(fileLock);
                fileSystemCache.close(fileDescriptor);
                fileSystemCache.close(fileDescriptor2);
                return null;
            }
            Block block4 = new Block(512);
            if (fileSystemCache.read(fileDescriptor2, block4, CacheDataType.HEADER) != 512) {
                fileSystemCache.unlock(fileLock);
                fileSystemCache.close(fileDescriptor);
                fileSystemCache.unlock(fileLock2);
                fileSystemCache.close(fileDescriptor2);
                return null;
            }
            int n13 = block4.get32(Offset.I_MAGIC.get(s2));
            short s3 = block4.get16(Offset.I_VERSION.get(s2));
            n4 = 0;
            if (s2 < 6) {
                n4 = block4.get16(Offset.I_SEGNUM.get(s2)) & 0xFFFF;
            }
            if (n13 != 269620248 || s3 != s2 || n4 != 0) {
                fileSystemCache.unlock(fileLock);
                fileSystemCache.close(fileDescriptor);
                fileSystemCache.unlock(fileLock2);
                fileSystemCache.close(fileDescriptor2);
                this.status.setErrno(13);
                return null;
            }
            n3 = block.get16(Offset.OPEN_CNT.get(s2)) & 0xFFFF;
            if (!n3 && (this.config.V_OPEN_STRICT.isOn() || this.config.V_FORCE_OPEN.isOff()) && ((long)block.get32(Offset.IVERSION.get(s2)) & 0xFFFFFFFFL) != ((long)block4.get32(Offset.I_IVERSION.get(s2)) & 0xFFFFFFFFL)) {
                fileSystemCache.unlock(fileLock);
                fileSystemCache.close(fileDescriptor);
                fileSystemCache.unlock(fileLock2);
                fileSystemCache.close(fileDescriptor2);
                this.status.setErrno(6);
                this.status.setIntErrno(89);
                return null;
            }
            fileSystemCache.unlock(fileLock2);
        }
        short s4 = block.get16(Offset.REC_OVERHEAD.get(s2));
        long l3 = 0L;
        if (s2 == 4 || s2 == 5) {
            l3 = (long)block.get32(Offset.MAX_SEG_SIZE.get(s2)) & 0xFFFFFFFFL;
        }
        File file = new File(string, n2, s2, block, physicalAttributes, logicalAttributes, fileDescriptor, fileDescriptor2, block3, s4, l3, this.isMultiLock(n2) ? this.config.V_LOCKS_PER_FILE.getIntegerValue() : 1, this.canRollback(n2), fileSystemCache);
        n4 = this.isInputOnly(n2);
        n3 = this.config.V_FORCE_OPEN.isOn();
        if (!n3 && n4 != 0 && this.config.V_OPEN_STRICT.isOff()) {
            this.config.V_FORCE_OPEN.set(true);
        }
        fileSystemCache.unlock(fileLock);
        boolean bl2 = this.lockHeader(file, true, n4 == 0, false);
        this.config.V_FORCE_OPEN.set(n3 != 0);
        if (!bl2) {
            this.unlockHeader(file, false);
            fileSystemCache.close(fileDescriptor);
            if (fileDescriptor2 != null) {
                fileSystemCache.close(fileDescriptor2);
            }
            return null;
        }
        return file;
    }

    private boolean closeAdditionalSegments(File file) {
        int n2;
        if (file.getVersion() == 3) {
            return true;
        }
        boolean bl = true;
        for (n2 = file.getIndexFile().getSegmentCount() - 1; n2 >= 0; --n2) {
            if (this.closeSegment(file, BlockType.NODE, n2)) continue;
            bl = false;
        }
        for (n2 = file.getSegmentCount() - 1; n2 >= 1; --n2) {
            if (this.closeSegment(file, BlockType.DATA, n2)) continue;
            bl = false;
        }
        return bl;
    }

    private boolean closeFile(File file) {
        boolean bl = file.getFileSystemCache().close(this.retrieveSegment(file, BlockType.DATA, 0));
        return bl;
    }

    private boolean closeSegment(File file, BlockType blockType, int n2) {
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        FileDescriptor fileDescriptor = this.retrieveSegment(file, blockType, n2);
        boolean bl = true;
        if (!this.isInputOnly(file.getOpenMode())) {
            int n3 = blockType == BlockType.DATA ? Offset.D_IVERSION.get(file.getVersion()) : Offset.I_IVERSION.get(file.getVersion());
            Block block = new Block(4);
            block.put32(0, (int)file.getTreeVersion());
            fileSystemCache.seek(fileDescriptor, n3);
            boolean bl2 = bl = fileSystemCache.write(fileDescriptor, block, CacheDataType.HEADER) == 4;
        }
        if (!fileSystemCache.close(fileDescriptor)) {
            bl = false;
        }
        return bl;
    }

    public FileInfoHelper getFileInfo(int n2) {
        File file = this.fileTable.get(n2);
        if (file == null) {
            this.status.setErrno(1);
            return null;
        }
        return new FileInfoHelper(file.getLogicalAttributes(), file.getTotalRecords());
    }

    public boolean rename(String string, String string2) {
        this.status.setErrno(0);
        int n2 = this.open(string, 0);
        if (n2 == 0) {
            return false;
        }
        File file = this.fileTable.get(n2);
        int n3 = file.getVersion();
        int n4 = file.getSegmentCount();
        int n5 = 0;
        if (n3 > 3) {
            n5 = file.getIndexFile().getSegmentCount();
        }
        this.close(n2, null);
        FileSystemCache fileSystemCache = file.getFileSystemCache();
        boolean bl = fileSystemCache.rename(this.getDataSegmentName(string, 0), this.getDataSegmentName(string2, 0));
        if (n3 > 3) {
            int n6;
            for (n6 = 1; bl && n6 < n4; ++n6) {
                bl = fileSystemCache.rename(this.getDataSegmentName(string, n6), this.getDataSegmentName(string2, n6));
            }
            for (n6 = 0; bl && n6 < n5; ++n6) {
                bl = fileSystemCache.rename(this.getIndexSegmentName(string, n6), this.getIndexSegmentName(string2, n6));
            }
        }
        return bl;
    }
}

