/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file.internals;

public class Block {
    private final byte[] bytes;
    private final int size;

    public int size() {
        return this.size;
    }

    public Block(byte[] byArray) {
        this.bytes = byArray;
        this.size = byArray.length;
    }

    public Block(int n2) {
        this(new byte[n2]);
    }

    public int compare(int n2, byte[] byArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = this.bytes[n2 + i2] & 0xFF;
            int n6 = byArray[n3 + i2] & 0xFF;
            if (n5 == n6) continue;
            return n5 < n6 ? -1 : 1;
        }
        return 0;
    }

    public int compare(int n2, Block block, int n3, int n4) {
        return this.compare(n2, block.bytes, n3, n4);
    }

    public void fill(int n2, int n3, byte by) {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.bytes[i2] = by;
        }
    }

    public Block copy() {
        byte[] byArray = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
        return new Block(byArray);
    }

    public void copy(int n2, byte[] byArray, int n3, int n4) {
        System.arraycopy(byArray, n3, this.bytes, n2, n4);
    }

    public void copy(int n2, Block block, int n3, int n4) {
        System.arraycopy(block.bytes, n3, this.bytes, n2, n4);
    }

    public void shift(int n2, int n3, int n4) {
        block3: {
            block2: {
                if (n3 <= 0) break block2;
                int n5 = n2 + n4 - 1;
                int n6 = n2 + n4 - 1 + n3;
                while (n4 > 0) {
                    this.bytes[n6] = this.bytes[n5];
                    --n4;
                    --n5;
                    --n6;
                }
                break block3;
            }
            if (n3 >= 0) break block3;
            int n7 = n2;
            int n8 = n2 + n3;
            while (n4 > 0) {
                this.bytes[n8] = this.bytes[n7];
                --n4;
                ++n7;
                ++n8;
            }
        }
    }

    public void put8(int n2, byte by) {
        this.bytes[n2] = by;
    }

    public byte get8(int n2) {
        return this.bytes[n2];
    }

    public void put16(int n2, short s2) {
        this.bytes[n2] = (byte)(s2 >>> 8);
        this.bytes[++n2] = (byte)s2;
    }

    public short get16(int n2) {
        return (short)((this.bytes[n2] & 0xFF) << 8 | this.bytes[++n2] & 0xFF);
    }

    public void put32(int n2, int n3) {
        this.bytes[n2] = (byte)(n3 >>> 24);
        this.bytes[++n2] = (byte)(n3 >>> 16);
        this.bytes[++n2] = (byte)(n3 >>> 8);
        this.bytes[++n2] = (byte)n3;
    }

    public int get32(int n2) {
        return (this.bytes[n2] & 0xFF) << 24 | (this.bytes[++n2] & 0xFF) << 16 | (this.bytes[++n2] & 0xFF) << 8 | this.bytes[++n2] & 0xFF;
    }

    public void put48(int n2, long l2) {
        this.bytes[n2] = (byte)(l2 >>> 40);
        this.bytes[++n2] = (byte)(l2 >>> 32);
        this.bytes[++n2] = (byte)(l2 >>> 24);
        this.bytes[++n2] = (byte)(l2 >>> 16);
        this.bytes[++n2] = (byte)(l2 >>> 8);
        this.bytes[++n2] = (byte)l2;
    }

    public long get48(int n2) {
        return ((long)this.bytes[n2] & 0xFFL) << 40 | ((long)this.bytes[++n2] & 0xFFL) << 32 | ((long)this.bytes[++n2] & 0xFFL) << 24 | ((long)this.bytes[++n2] & 0xFFL) << 16 | ((long)this.bytes[++n2] & 0xFFL) << 8 | (long)this.bytes[++n2] & 0xFFL;
    }

    public long get48s(int n2) {
        return (long)this.bytes[n2] << 40 | ((long)this.bytes[++n2] & 0xFFL) << 32 | ((long)this.bytes[++n2] & 0xFFL) << 24 | ((long)this.bytes[++n2] & 0xFFL) << 16 | ((long)this.bytes[++n2] & 0xFFL) << 8 | (long)this.bytes[++n2] & 0xFFL;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

