/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file.internals;

public class FileAddress {
    private int segment;
    private long offset;

    public boolean isZero() {
        return this.offset == 0L && this.segment == 0;
    }

    public boolean isValid() {
        return this.offset != -1L && this.segment != 65535;
    }

    public boolean eq(FileAddress fileAddress) {
        return this.offset == fileAddress.getOffset() && this.segment == fileAddress.getSegment();
    }

    public boolean gt(FileAddress fileAddress) {
        return this.segment > fileAddress.getSegment() || this.segment == fileAddress.getSegment() && this.offset > fileAddress.getOffset();
    }

    public boolean gtZero() {
        return this.offset > 0L || this.offset == 0L && this.segment > 0;
    }

    public boolean lt(FileAddress fileAddress) {
        return this.segment < fileAddress.getSegment() || this.segment == fileAddress.getSegment() && this.offset < fileAddress.getOffset();
    }

    public boolean ltZero() {
        return this.offset < 0L;
    }

    public boolean ge(FileAddress fileAddress) {
        return !this.lt(fileAddress);
    }

    public boolean le(FileAddress fileAddress) {
        return !this.gt(fileAddress);
    }

    public void invalidate() {
        this.offset = -1L;
        this.segment = 65535;
    }

    public void initialize() {
        this.offset = 0L;
        this.segment = 0;
    }

    public void incSegment() {
        ++this.segment;
    }

    public void incOffset(long l2) {
        this.offset += l2;
    }

    public void flipOffset() {
        this.offset = -this.offset;
    }

    public FileAddress copy() {
        return new FileAddress(this.segment, this.offset);
    }

    public void copyFrom(FileAddress fileAddress) {
        this.segment = fileAddress.getSegment();
        this.offset = fileAddress.getOffset();
    }

    public FileAddress() {
        this(0, 0L);
    }

    public FileAddress(int n2, long l2) {
        this.segment = n2;
        this.offset = l2;
    }

    public String toString() {
        return "offset: " + this.offset + ", segment: " + this.segment;
    }

    public int getSegment() {
        return this.segment;
    }

    public void setSegment(int n2) {
        this.segment = n2;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long l2) {
        this.offset = l2;
    }
}

