/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file.internals;

import com.veryant.vision4j.file.internals.Lock;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class FileDescriptor
implements Closeable {
    private static final StandardOpenOption[][] OPTIONS = new StandardOpenOption[][]{{StandardOpenOption.READ, StandardOpenOption.WRITE}, {StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.READ, StandardOpenOption.WRITE}, {StandardOpenOption.READ, StandardOpenOption.WRITE}, {StandardOpenOption.READ, StandardOpenOption.WRITE}};
    private final int id;
    private final String name;
    private final Path path;
    private final FileChannel channel;
    private Lock exclusiveLock;
    private long offset;

    public void incOffset(long l2) {
        this.offset += l2;
    }

    public FileDescriptor(int n2, String string, int n3) throws IOException {
        this.id = n2;
        this.name = string;
        this.path = Paths.get(this.name, new String[0]);
        this.channel = FileChannel.open(this.path, OPTIONS[n3 & 3]);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public String toString() {
        return this.name + (this.exclusiveLock != null ? " (locked)" : "");
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Path getPath() {
        return this.path;
    }

    public FileChannel getChannel() {
        return this.channel;
    }

    public Lock getExclusiveLock() {
        return this.exclusiveLock;
    }

    public void setExclusiveLock(Lock lock) {
        this.exclusiveLock = lock;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long l2) {
        this.offset = l2;
    }
}

