/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file.internals;

import com.veryant.vision4j.file.internals.FileAddress;
import com.veryant.vision4j.file.internals.LockType;
import java.io.IOException;
import java.nio.channels.FileLock;

public class Lock {
    private final FileLock instance;
    private FileLock extenderInstance;
    private final FileAddress address;
    private long size;
    private LockType type;

    public boolean isProgramLock() {
        return this.type == LockType.PROGRAM || this.type == LockType.PROGRAM_AND_TRANSACTION;
    }

    public boolean isTransactionLock() {
        return this.type == LockType.TRANSACTION || this.type == LockType.PROGRAM_AND_TRANSACTION;
    }

    public void updateType(LockType lockType) {
        if (lockType != null) {
            if (lockType != this.type) {
                this.type = LockType.PROGRAM_AND_TRANSACTION;
            }
        } else {
            this.type = null;
        }
    }

    public void extend(FileLock fileLock) {
        this.extenderInstance = fileLock;
        this.size = this.instance.size() + fileLock.size();
    }

    public boolean release() {
        try {
            this.instance.release();
            if (this.extenderInstance != null) {
                this.instance.release();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public Lock(int n2, FileLock fileLock, LockType lockType) {
        this.instance = fileLock;
        this.address = new FileAddress(n2, fileLock.position());
        this.size = fileLock.size();
        this.type = lockType;
    }

    public Lock(int n2, FileLock fileLock) {
        this(n2, fileLock, LockType.PROGRAM);
    }

    public String toString() {
        return "address: (" + this.address + "), size: " + this.size;
    }

    public FileAddress getAddress() {
        return this.address;
    }

    public long getSize() {
        return this.size;
    }

    public LockType getType() {
        return this.type;
    }
}

