/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file.internals;

import com.veryant.vision4j.file.internals.KeyInfo;

public class LogicalAttributes {
    private final int minRecordSize;
    private final int maxRecordSize;
    private final int compressFactor;
    private final int numKeys;
    private int maxKeySize;
    private int duplicates;
    private final KeyInfo[] keys;

    public KeyInfo getKey(int n2) {
        return this.keys[n2];
    }

    public boolean isCompressed() {
        return this.compressFactor > 0;
    }

    public LogicalAttributes(int n2, int n3, KeyInfo[] keyInfoArray, int n4) {
        this.maxRecordSize = Math.max(1, n3);
        this.minRecordSize = n2 < 1 ? this.maxRecordSize : n2;
        this.numKeys = keyInfoArray.length;
        this.keys = keyInfoArray;
        for (KeyInfo keyInfo : keyInfoArray) {
            this.maxKeySize = Math.max(this.maxKeySize, keyInfo.getTotalSize());
            if (!keyInfo.isDuplicate()) continue;
            ++this.duplicates;
        }
        this.compressFactor = n4 < 0 ? 0 : Math.min(n4, 100);
    }

    public String toString() {
        return "min record size: " + this.minRecordSize + ", max record size: " + this.maxRecordSize + ", compress factor: " + this.compressFactor + ", keys: " + this.numKeys + ", max key size: " + this.maxKeySize + ", duplicates: " + this.duplicates;
    }

    public int getMinRecordSize() {
        return this.minRecordSize;
    }

    public int getMaxRecordSize() {
        return this.maxRecordSize;
    }

    public int getCompressFactor() {
        return this.compressFactor;
    }

    public int getNumKeys() {
        return this.numKeys;
    }

    public int getMaxKeySize() {
        return this.maxKeySize;
    }

    public int getDuplicates() {
        return this.duplicates;
    }
}

