package com.veryant.javabeans.jasperreport;

import java.awt.BorderLayout;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JPanel;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRCsvDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.swing.JRViewer;

public class ReportViewer extends JPanel {

   private static final long serialVersionUID = 1L;

   private JRViewer jrViewer;
   private JasperPrint jPrint;
   private byte[] report;
   private byte[] dataSource;
   private String[] dataSourceColumnNames;
   private boolean dataSourceUseFirstRowAsHeader;
   private char dataSourceFieldDelimiter;
   private Map reportParameters;
   
   public ReportViewer() {
      setLayout(new BorderLayout());
   }

   public byte[] getReport() {
      return report;
   }

   public void setReport(byte[] report) {
      this.report = report;
   }
   
   public void setReport(File file) {
      setReport(readFile(file));
   }
   
   private byte[] readFile(File file) {
      try {
         FileInputStream in = new FileInputStream(file);
         byte[] b = new byte[in.available()];
         in.read(b);
         in.close();
         return b;
      } catch(IOException ex) {
         return null;
      }
   }

   public byte[] getDataSource() {
      return dataSource;
   }

   public void setDataSource(byte[] dataSource) {
      this.dataSource = dataSource;
   }
   
   public void setDataSource(File file) {
      setDataSource(readFile(file));
   }

   public String[] getDataSourceColumnNames() {
      return dataSourceColumnNames;
   }

   public void setDataSourceColumnNames(String[] dataSourceColumnNames) {
      this.dataSourceColumnNames = dataSourceColumnNames;
   }

   public boolean isDataSourceUseFirstRowAsHeader() {
      return dataSourceUseFirstRowAsHeader;
   }

   public void setDataSourceUseFirstRowAsHeader(
         boolean dataSourceUseFirstRowAsHeader) {
      this.dataSourceUseFirstRowAsHeader = dataSourceUseFirstRowAsHeader;
   }

   public char getDataSourceFieldDelimiter() {
      return dataSourceFieldDelimiter;
   }

   public void setDataSourceFieldDelimiter(char dataSourceFieldDelimiter) {
      this.dataSourceFieldDelimiter = dataSourceFieldDelimiter;
   }

   public Map getReportParameters() {
      return reportParameters;
   }

   public void setReportParameters(Map reportParameters) {
      this.reportParameters = reportParameters;
   }
   
   private JasperPrint getJasperPrint() throws JRException {
	   if(jPrint == null) {
	      if(report == null) {
	         throw new IllegalStateException("report contents is null");
	      }
	      if(dataSource == null) {
	         throw new IllegalStateException("dataSource contents is null");
	      }
	      ByteArrayInputStream reportContents = new ByteArrayInputStream(report);
	      JasperDesign jrdesign = JRXmlLoader.load(reportContents);
	      JasperReport rpt = JasperCompileManager.compileReport(jrdesign);
	      ByteArrayInputStream dataSourceContents = new ByteArrayInputStream(dataSource);
	      JRCsvDataSource ds = new JRCsvDataSource(dataSourceContents);
	      if(dataSourceColumnNames != null) {
	         ds.setColumnNames(dataSourceColumnNames);
	      }
	      ds.setUseFirstRowAsHeader(dataSourceUseFirstRowAsHeader);
	      ds.setFieldDelimiter(dataSourceFieldDelimiter);
	      Map params = reportParameters;
	      if(params == null) {
	         params = new HashMap();
	      }
	      jPrint = JasperFillManager.fillReport(rpt, params, ds);
	   }
	   return jPrint;
   }
   
   public void printReport() throws JRException {
      JasperPrintManager.printReport(getJasperPrint(), true);
   }
   
   public void showReport() throws JRException {
      if(jrViewer != null) {
         remove(jrViewer);
      }
      jrViewer = new JRViewer(getJasperPrint());
      add(jrViewer, BorderLayout.CENTER);
      revalidate();
   }

}
