      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       identification division.
       program-id. indexed.

       environment division.
       input-output section.
       file-control.
      *    Local file
           select file1 assign to "LocalIndexed"
                 organization is indexed
                 access is dynamic
                 record key is key-file1
                 lock mode is manual
                 file status is file-status.

      *    Remote file using the ISF notation into the File Name
           select file2 assign to file2-remote-path 
                 organization is indexed
                 access is dynamic
                 record key is key-file2
                 lock mode is manual
                 file status is file-status.

      *    Remote file using the configuration file
           select file3 assign to "RemoteIndexed"
                 organization is indexed
                 access is dynamic
                 record key is key-file3
                 lock mode is manual
                 file status is file-status.

       data division.
       file section.
       fd  file1.
       01  rec-file1.
           03 key-file1   pic 99.
           03 data-file1  pic x(20).

       fd  file2.
       01  rec-file2.
           03 key-file2   pic 99.
           03 data-file2  pic x(20).

       fd  file3.
       01  rec-file3.
           03 key-file3   pic 99.
           03 data-file3  pic x(20).

       working-storage section.
       77  wrk-hostname            pic x any length.
       77  wrk-port-number         pic x any length.
       77  file2-remote-path       pic x any length.
       77  file-status             pic x(2).
       01  crerr-status.
           03 crerr-file-status    pic xx.
           03 crerr-ext-status     pic xxx.

       77  rerrname                pic x(50).
       77  fileop                  pic x(50).

       procedure division.
       declaratives.
       FILE1-ERROR section.
           use after error procedure on file1 file2 file3.
           call "C$RERR"          using crerr-status
           call "C$RERRNAME"      using rerrname
           call "C$GETLASTFILEOP" using fileOp
           display " "  
           display "Error " crerr-status " on " rerrname  
           display "on statement " fileOp.
       end declaratives.

       MAIN.
      *    Create the "assign to" variable for the file2 
           perform BUILD-REMOTE-PATH.

      *    creates the file
           display "Creating files..."
           open output file1
           close file1
           open output file2
           close file2
           open output file3
           close file3

      *    opening 
           display " "
           display "Opening files..."
           open i-o file1
           open i-o file2
           open i-o file3

      *    record writing
           display " "
           display "Writing into filed..."
           move 01     to key-file1
           move "aaa"  to data-file1
           write rec-file1
           move 01     to key-file2
           move "aaa"  to data-file2
           write rec-file2
           move 01     to key-file3
           move "aaa"  to data-file3
           write rec-file3

      *    start
           display " "
           display "Getting the first records..."
           move low-values    to key-file1
           start file1 key not < key-file1
           move low-values    to key-file2
           start file2 key not < key-file2
           move low-values    to key-file3
           start file3 key not < key-file3

      *    read next
           display " "
           display "Reading next records..."
           read file1 next
           read file2 next
           read file3 next

      *    record rewriting
           display " "
           display "Rewriting into files..."
           move 01     to key-file1
           move "bbb"  to data-file1
           rewrite rec-file1
           move 01     to key-file2
           move "bbb"  to data-file2
           rewrite rec-file2
           move 01     to key-file3
           move "bbb"  to data-file3
           rewrite rec-file3

      *    record delete
           display " "
           display "Deleting the records into files..."
           move 01  to key-file1
           delete file1 record
           move 01  to key-file2
           delete file2 record
           move 01  to key-file3
           delete file3 record

      *    close
           display " "
           display "Closing files..."
           close file1
           close file2
           close file3

           goback.

       BUILD-REMOTE-PATH.
           accept wrk-hostname from environment "file.remote.host"
           if wrk-hostname = space
              move "127.0.0.1"   to wrk-hostname
           end-if
             
           accept wrk-port-number from environment "file.remote.port"
           if wrk-port-number = space
              move "10997"       to wrk-port-number
           end-if

           initialize file2-remote-path      
           string "isf://"               delimited by size
                  wrk-hostname           delimited by trailing space
                  ":"                    delimited by size
                  wrk-port-number        delimited by trailing space
                  ":./RemoteISFIndexed"  delimited by size
                  into file2-remote-path
           .
           