      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       program-id. prog-file1.

       input-output section.
       file-control.
           select file1 assign to "file1" 
           organization is indexed
           access mode is dynamic
           record key is f-cod
           file status is f-status.

       data division.
       file section.
       fd  file1.
       01  f-rec.
           03 f-cod              pic 9(3).
           03 f-firstname        pic x(20).
           03 f-secname          pic x(20).
           03 f-address          pic x(20).
      $EFD DATE=YYYYMMDD
           03 f-birthday         pic 9(8).
       
       working-storage section.
       77  f-status              pic x(2).
       77  cont                  pic 9(3).

       01  crerr-status.
           03 crerr-file-status  pic xx.
           03 crerr-ext-status   pic x(128).
       77  crerr-mesage          pic x any length.

       77  rerrname              pic x(50).
       77  fileop                pic x(50).

       procedure division.
       declaratives.
       FILE1-ERROR section.
           use after error procedure on file1.
           call "C$RERR"          using crerr-status
                                        crerr-mesage
           call "C$RERRNAME"      using rerrname
           call "C$GETLASTFILEOP" using fileOp
           display " "  
           display "Error " crerr-file-status " " 
                   function trim(crerr-ext-status)
                   " on " rerrname
           display crerr-mesage
           display "on statement " fileOp.
       end declaratives.

       MAIN.
           perform CREATE-FILE 
           perform REWRITE-FILE
           perform READ-FILE   

           display " "
           display "end."

           stop run
           .

       CREATE-FILE.
           open output file1
           if f-status not = "00"
              goback
           end-if.

           display " "
           display "'file1' table created."

           move 1                       to f-cod
           move "Smith"                 to f-firstname
           move "Albert"                to f-secname
           move "3400 Paradise Rd."     to f-address
           move 19711011                to f-birthday
           write f-rec

           move 2                       to f-cod
           move "Johnson"               to f-firstname
           move "Alan"                  to f-secname
           move "2248 Palm Spring Rd."  to f-address
           move 19680114                to f-birthday
           write f-rec

           move "AA"                    to f-firstname
           move "BB"                    to f-secname
           move "CC"                    to f-address
           move 19540103                to f-birthday
           perform 50 times
              add 1 to f-cod
              write f-rec
           end-perform

           close file1

           display "52 records inserted."
           .

       REWRITE-FILE.
           open i-o file1

           move 1                  to f-cod
           read file1 key is f-cod
           move "49 West 44th St." to f-address
           rewrite f-rec

           close file1

           display "first record rewritten."
           .

       READ-FILE.
           display "reading records."

           open input file1

           move low-values to f-cod
           start file1 key not less f-cod
              invalid
                 display "Start failed."
              not invalid
                 initialize cont
                 perform until 1 = 2
                    read file1 next
                       at end
                          exit perform
                       not at end
                          add 1 to cont
                    end-read
                 end-perform
                 display "cont= " cont
           end-start


           close file1
           .