      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       program-id. GOOGLECONNECT.
       configuration section.
       repository.
           class web-area as "com.iscobol.rts.HTTPHandler"
           class http-client as "com.iscobol.rts.HTTPClient"
           class http-params as "com.iscobol.rts.HTTPData.Params"
           class j-bigint as "java.math.BigInteger"
           class j-securernd as "java.security.SecureRandom"
           .
       working-storage section.
       77  client-id pic x any length.
       77  clsc  pic x any length.
       77  redir pic x any length.
       77  realm pic x any length.

       01  params object reference http-params.
       01  http object reference http-client.
       01  state pic x any length.
       01  data-dir  pic x any length.
       77  response-code pic S9(3).

       01  http-response identified by "_".
           03 identified by "state".
              05 http-state  pic x any length.
           03 identified by "code".
              05 http-code  pic x any length.
       01  google-auth identified by "_".
           03 identified by "access_token".
              05 access-token  pic x any length.
           03 identified by "token_type".
              05 token-type  pic x any length.
           03 identified by "expires_in".
              05 expires-in  pic 9(9).
           03 identified by "id_token".
              05 id-token  pic x any length.
       01  user-info identified by "_".
           03 identified by "id".
              05 user-id  pic x any length.
           03 identified by "email".
              05 user-email  pic x any length.
           03 identified by "verified_email".
              05 user-verified-email  pic x any length.
           03 identified by "name".
              05 user-name  pic x any length.
           03 identified by "given_name".
              05 user-given-name  pic x any length.
           03 identified by "family_name".
              05 user-family-name  pic x any length.
           03 identified by "link".
              05 user-link  pic x any length.
           03 identified by "picture".
              05 user-picture  pic x any length.
           03 identified by "gender".
              05 user-gender  pic x any length.

       77  authorization pic x any length.

       linkage section.
       01  comm-area object reference web-area.
       procedure division using comm-area.
       main.

           accept client-id from environment "client_id_by_google"
           accept clsc  from environment "client_secret_by_google".

           accept redir from environment "realdir".
           accept realm from environment "realm".


           if user-email = space 
              perform do-auth
           else
              perform run-first-program
           end-if.
           goback.
              
       do-auth.
           initialize http-response.
           comm-area:>accept(http-response).
           if http-state = space
              perform phase-1-redirection
           else
              if http-state = state
                 perform phase-2-get-auth-token
                 perform phase-3-get-info
                 perform set-first-program
                 perform run-first-program
              else
                 comm-area:>displayError(403 "Forged state!")
              end-if
           end-if.

       phase-1-redirection..
           set state to 
                    j-bigint:>new(130 j-securernd:>new):>toString(32).
           set params = http-params:>new
                      :>add ("client_id" client-id)
                      :>add ("response_type" "code")
                      :>add ("scope" "openid email")
                      :>add ("redirect_uri" redir)
                      :>add ("state" state)
                      :>add ("openid.realm" realm)
           ;;
           comm-area:>redirect (
                 "https://accounts.google.com/o/oauth2/auth" params).

       phase-2-get-auth-token.
           set http = http-client:>new
           set params = http-params:>new
                :>add ("code" http-code)
                :>add ("client_id" client-id)
                :>add ("client_secret" clsc)
                :>add ("redirect_uri" redir)
                :>add ("grant_type" "authorization_code")
           try
              http:>doPost (
                      "https://accounts.google.com/o/oauth2/token"
                      params)
              http:>getResponseCode (response-code)
              if response-code = 200
                 http:>getResponseJSON (google-auth)
              else
                 comm-area:>displayError(response-code "")
                 goback
              end-if
           catch exception
              comm-area:>displayError(500 exception-object:>toString)
              goback
           end-try.

       phase-3-get-info.
           string token-type " " access-token into authorization
           try 
              http:>setHeaderProperty ("Authorization" authorization)
              http:>doGet (
                     "https://www.googleapis.com/oauth2/v2/userinfo")
              http:>getResponseCode (response-code)
              if response-code = 200
                 http:>getResponseJSON (user-info)
              else
                 comm-area:>displayError(response-code "")
                 goback
              end-if
           catch exception
              comm-area:>displayError(500 exception-object:>toString)
              goback
           end-try.

       set-first-program.
           set environment "openid.email" to user-email.
           accept data-dir from environment "myprefix"
           string data-dir "/" user-email into data-dir
      
           call "c$makedir" using data-dir
           set environment "file.prefix" to data-dir.

       run-first-program.
           comm-area:>redirect ("mainapp.html").
           