      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
      $set "servicebridge" "1"
      $set "servicebridge.type" "REST"
       PROGRAM-ID. LISTSONGS.
       CONFIGURATION SECTION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "songs.sl".

       DATA DIVISION.
       FILE SECTION.
           copy "songs.fd".

       WORKING-STORAGE SECTION.
       77  file-status                pic xx value "00".

       77                             pic 9.
           88 rec-ok                  value 1 false 0.

       77  cont                       pic 9(3).
       77  cont-songs                 pic 9(3).

      $elk decoration=default
       LINKAGE SECTION.
      $elk input
      $elk name=filter
       01  lnk-song-filter            pic x(256).

      $elk output
      $elk name=ListSongs
       01  lnk-list.
      $elk output
      $elk name=SongData
           05  lnk-song-data          occurs dynamic capacity num-songs.
      $elk output
      $elk name=Id
              10 lnk-sd-id            pic 9(5).
      $elk output
      $elk name=Title
              10 lnk-sd-title         pic x(30).
      $elk output
      $elk name=Length
              10 lnk-sd-length        pic x(5).
      $elk output
      $elk name=Artist
              10 lnk-sd-artist        pic x(20).
      $elk output
      $elk name=Album
              10 lnk-sd-album         pic x(30).
      $elk output
      $elk name=Genre
              10 lnk-sd-genre         pic x(15).
      $elk output
      $elk name=Label
              10 lnk-sd-label         pic x(30).
      $elk output
      $elk name=Year
              10 lnk-sd-year          pic 9(4).

      $elk output
      $elk name=Status
       01  lnk-return-status.
      $elk output
      $elk name=ReturnStatus
           05 lnk-status              pic x(2).
              88 lnk-ok               value "OK".
              88 lnk-ko               value "KO".
      $elk output
      $elk name=FileStatus
           05 lnk-file-status         pic x(2).
      $elk output
      $elk name=ReturnMessage
           05 lnk-status-message      pic x(50).

       PROCEDURE DIVISION USING lnk-song-filter, 
                                lnk-list
                                lnk-return-status.
       DECLARATIVES.
       decl section.
           use after standard error on songs.
           set lnk-ko  to true
           move file-status to lnk-file-status.
           initialize lnk-status-message
           string "Error "            delimited by size
                  file-status         delimited by size
                  " on file 'songs'"  delimited by size
                  into lnk-status-message.

           if file-status not = "00"
              goback
           end-if.

       end declaratives.

       INIT.
           set lnk-ok  to true
           initialize lnk-file-status
           move "Operation successful"   to lnk-status-message.

           set rec-ok        to true.
           move 0            to cont-songs.
           open input songs
           start songs first
           perform until exit
              read songs next no lock
                 at end
                    exit perform
              end-read
              if lnk-song-filter not = space
                 perform VALIDATE-RECORD
              end-if
              if rec-ok
                 perform EXPORT-RECORD
              end-if
           end-perform
           close songs.

           goback.

       EXPORT-RECORD.
           add 1 to cont-songs.

           move sr-id     to lnk-sd-id(cont-songs).
           move sr-title  to lnk-sd-title(cont-songs).
           move sr-length to lnk-sd-length(cont-songs).
           move sr-artist to lnk-sd-artist(cont-songs).
           move sr-album  to lnk-sd-album(cont-songs).
           move sr-genre  to lnk-sd-genre(cont-songs).
           move sr-label  to lnk-sd-label(cont-songs).
           move sr-year   to lnk-sd-year(cont-songs).

       VALIDATE-RECORD.
           set rec-ok  to false.

           initialize cont
           inspect function upper-case (function trim (sr-artist))
                    tallying cont for all
                 function upper-case (function trim (lnk-song-filter))
           if cont > zero
              set rec-ok  to true
           end-if

           if not rec-ok
              initialize cont
              inspect function upper-case (function trim (sr-title))
                    tallying cont for all
                 function upper-case (function trim (lnk-song-filter))
              if cont > zero
                 set rec-ok  to true
              end-if
           end-if
           .

           if not rec-ok
              initialize cont
              inspect function upper-case (function trim (sr-album))
                    tallying cont for all
                 function upper-case (function trim (lnk-song-filter))
              if cont > zero
                 set rec-ok  to true
              end-if
           end-if
           .

