      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

      *    SusiFilter - Switching URL Server Interface Filter
       class-id. SusiFilter as "SusiFilter" implements c-filter.

       configuration section.
       repository.
           class j-ioexception as "java.io.IOException"
           class c-filter as "javax.servlet.Filter"
           class c-filter-chain as "javax.servlet.FilterChain"
           class c-filter-config as "javax.servlet.FilterConfig"
           class c-ServletException as "javax.servlet.ServletException"
           class c-ServletRequest as "javax.servlet.ServletRequest"
           class c-ServletResponse as "javax.servlet.ServletResponse"
           class c-HttpServletResponse as
                             "javax.servlet.http.HttpServletResponse"
           class c-HttpServletRequest as
                             "javax.servlet.http.HttpServletRequest"
           class j-String as "java.lang.String"
           class j-parts as "java.lang.String[]"
           class j-StringBuilder as "java.lang.StringBuilder"
           class j-int as "java.lang.Integer"
           .
       id division.
       object.
       data division.
       working-storage section.

       procedure division.

       id division.
       method-id. init as "init".
       linkage section.
       77  cfg object reference c-filter-config.
       procedure division using cfg raising c-ServletException.
       main.
       end method.

       id division.
       method-id. c-destroy as "destroy".
       procedure division.
       main.
       end method.

       id division.
       method-id. doFilter as "doFilter".
       working-storage section.
       77  http-response     object reference c-HttpServletResponse.
       77  http-request      object reference c-HttpServletRequest.
       77  uri               object reference j-String.
       77  mth               object reference j-String.
       77  strBuilder        object reference j-StringBuilder.
       77  str               object reference j-String.
       77  w-parts           object reference j-parts. 
       77  res               object reference j-String.
       77  sParamIdx         object reference j-String.

       77  idx               int.
       77  paramIdx          int.
       77  w-flag            pic 9 value 0.

       01  tableReq          occurs dynamic capacity idx-tableReq 
                             pic x any length.
       01  tableReqIsc       occurs dynamic capacity idx-tableReqIsc 
                             pic x any length.

       01  behavior-on-error pic x value "B".
           88 bad-request    value "B".
           88 forward        value "F".

       77  res-cob           pic x any length.

       linkage section.
       77  request           object reference c-ServletRequest.
       77  response          object reference c-ServletResponse.
       77  f-chain           object reference c-filter-chain.

       procedure division using request response f-chain
                        raising c-ServletException j-IOException.
       MAIN.
           set http-request to request as c-HttpServletRequest
           
      *    Load the mapping from the "REST URL" convention using paths 
      *    to the isCOBOL notation that uses URL parameters. 
      *    The mapping is the only source where modifications are needed
           perform LOADREQTABLES

           perform GETREQUEST

      *    Check if the received request matches a mapped one
           perform CHECK-VALID-REQUEST.
       
      *    If a match is not found, we don't modify the request
           if w-flag = 0
              f-chain:>doFilter(request, response)
           else
              request:>getRequestDispatcher(res):>forward
                                   (request, response)
           end-if

           goback.

       LOADREQTABLES.
      *    In this paragraph the mapping of the URLs is loaded.
      *    Once the REST API has been planned, it needs to be described 
      *    and mapped so that the isCOBOL runtime can understand it
      *
      *    To do so, 2 string arrays are used
      *    tableReq: contains the patterns that define the application's
      *              REST API
      *    tableReqIsc: contain the translation from the REST API to the 
      *                 standard isCOBOL notation using URL parameters

      *    Below are 3 samples
      
      *     move "GET/.+/songs/last"                  to tableReq(6)
      *     move "/servlet/SONGS?Operation=L"         to tableReqIsc(6)
      *
      *     move "GET/.+/songs/print"                 to tableReq(7)
      *     move "/servlet/SONGS?Operation=p"         to tableReqIsc(7)
      *
      *     move "GET/.+/songs/next/[0-9]+"           to tableReq(4)
      *     move "/servlet/SONGS?Operation=N&id={4}"  to tableReqIsc(4)

      *    The matching process is based on regular expression checking.
      *    The tableReq array holds a list of regular expression strings
      *    that describe REST URLs and parameters.
      *
      *    The string is composed by three logical parts:
      *    1. The HTTP method (GET / PUT / POST / DELETE)
      *    2. The Webapp name
      *    3. The resource name and parameters needed for the REST call
      *
      *    In this sample the webapp name is matched using the regular 
      *    expression ".+/" which accepts any string, as the only 
      *    resource used is SONGS

      *    The parameters are expressed using a combination of fixed 
      *    strings and the following regular expression patterns:
      *    1. [0-9] used to accept numeric parameter, of any length
      *    2. [a-zA-Z] used to accpet to accept alphabetic parameter, of 
      *             any length
      *    3. .+ used to accept any kind of charactrs, of any length

      *    The tableReqIsc array holds the URL needed by the isCOBOL 
      *    runtime to perform the REST request. This string may contain 
      *    placeholders, identified by a integer number enclosed in 
      *    brackets, which represent the original request ordinal 
      *    parameter, and will be explained below
      *
      *    REST parameters are usually embedded in the URL (such as /songs/next/3)
      *    to request the song following the one with id 3.
      *    In this case, the 3 is a variable parameter, while "songs" 
      *    and "next" are fixed parameters
      *    The tableReq entry to match this URL is: 
      *    "GET/.+/songs/next/[0-9]+"

      *    The matching process performs the following steps:
      *    1. It determines the tableReq entry that matches the request 
      *       URL
      *    2. If none is found, a HTTP error 400 BAD REQUEST is returned
      *    3. If one is found, the incoming URL request is split in 
      *       segments on the "/" character.
      *    4. The tableReqIsc arrays is used to rearrange the URL 
      *       parameters in the resulting isCOBOL URL.
      *    5. The request if forwarded to the resulting isCOBOL URL
      *
      *    For example, if the URL /songs/next/10 is requested, it 
      *    matches the "GET/.+/songs/next/[0-9]+" tableReq entry, and 
      *    the corresponding tableReqIsc entry is 
      *    "/servlet/SONGS?Operation=N&id={4}"
      *    The REST url is split into the following 0-based array of 
      *    parts:
      *    [0] - the request method, in this case "GET"
      *    [1] - the wepapp name, which we will not need
      *    [2] - the resource name, "songs"
      *    [3] - the parameter "next"
      *    [4] - the parameter "10"
      *
      *    The tableReqIsc entry only indicates to extract parameter 
      *    number 4, in this case "10" and the corresponding isCOBOL URL 
      *    is then composed, yelding the final URL 
      *    "/servlet/SONGS?Operation=N&id=10"
      *    The request is redirected to this URL, and the isCOBOL 
      *    program is invoked

      *    This copy contains the list of the mappings used in the SONGS 
      *    sample

           copy "request-match.cpy".

       CHECK-VALID-REQUEST.
           perform varying idx from 1 by 1 until idx > idx-tableReq
              if str:>matches(tableReq(idx))
                 move 1 to w-flag 
                 exit perform
              end-if
           end-perform
           if w-flag = 1
              set res to tableReqIsc(idx)
              set w-parts to uri:>split("/")
              set idx to null
              set idx to res:>indexOf("{")
              if idx not < 0
                 add 1 to idx
                 set sParamIdx 
                             to res:>substring (idx, res:>indexOf("}"))
                 set paramIdx to j-Int:>parseInt(sParamIdx)
                 set str to "{"
                 set str to str:>concat(sParamIdx):>concat("}")
                 set res to res:>replace (str, w-parts(paramIdx))
              end-if
           end-if
           .
       
       GETREQUEST.
           set uri to http-request:>getRequestURI
           set mth to http-request:>getMethod
           set strBuilder to j-StringBuilder:>new
           strBuilder:>append(mth):>append(uri)
           set str to strBuilder:>toString
           .

       end method.

       end object.