      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       program-id. isfunctions.
       configuration section.
       repository.
           class web-area as "com.iscobol.rts.HTTPHandler"
           .
       data division.
       working-storage section.
       
       01 ok-page identified by "_comm_buffer".
           03 filler identified by "_status".
              05 ok-status pic x any length value "OK".
           03 filler identified by "_message".
              05 ok-message pic x any length.
       
       01  isfunction-getZipCode identified by "".
           03 identified by "get_Zip_Code".
              05 city-zipCode  pic x any length.

       01  isfunction-returnZipCode identified by "".
           03 identified by "Zip_Code".
              05 returnZipCode  pic x any length.

       01  isfunction-getcity identified by "".
           03 identified by "get_City".
              05 zipCode-city  pic x any length.

       01  isfunction-recivedCity identified by "".
           03 identified by "City".
              05 returnCity  pic x any length.

       01  array-data   occurs 4 indexed by idx.
           03 a-zipcode pic x(5).
           03 a-city    pic x any length.
           03 a-county  pic x any length.
           03 a-state   pic x any length.

       linkage section.
       01  comm-area object reference web-area.
       
       procedure division using comm-area.
       MAIN.

           move "94101"         to  a-zipcode(1).
           move "San Francisco" to  a-city(1).
           move "San Francisco" to  a-county(1).
           move "California"    to  a-state(1).

           move "92123"         to  a-zipcode(2).
           move "San Diego"     to  a-city(2).
           move "San Diego"     to  a-county(2).
           move "California"    to  a-state(2).

           move "10001"         to  a-zipcode(3).
           move "New York"      to  a-city(3).
           move "New York"      to  a-county(3).
           move "New York"      to  a-state(3).

           move "89044"         to  a-zipcode(4).
           move "Las Vegas"     to  a-city(4).
           move "Clark"         to  a-county(4).
           move "Nevada"        to  a-state(4).

           move "Program Loaded" to ok-message;;
           comm-area:>displayJSON (ok-page).
           goback.
            
       GETZIPCODE.
              entry "ISFUNCTION_GETZIP" using comm-area.

           comm-area:>accept (isfunction-getZipCode).

           move 1 to idx.
           search array-data varying idx
              at end 
                 move "Zip code not Found"  to returnZipCode
              when city-zipCode = a-city(idx)
                 move a-zipcode(idx)  to returnZipCode
           end-search.

           comm-area:>displayJSON (isfunction-returnZipCode).

           goback.

       GETCITY.
              entry "ISFUNCTION_GETCITY" using comm-area.

           comm-area:>accept (isfunction-getcity).

           move 1 to idx.
           search array-data varying idx
              at end 
                 move "City not Found"  to returnCity
              when zipCode-city(1:5) = a-zipcode(idx)
                 move a-city(idx)  to returnCity
           end-search.

           comm-area:>displayJSON (isfunction-recivedCity).

           goback.


