      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       IDENTIFICATION DIVISION.
       CLASS-ID. CHDATE as "CHDATE" INHERITS CURRENT-DATE.
       environment division.
       configuration section.
       repository.
             class CURRENT-DATE as "com.iscobol.rts.CurrentDate"
             class JAVA-CALENDAR as "java.util.GregorianCalendar"
             class JAVA-STRING as "java.lang.String"
             class JAVA-STRING-ARRAY as "java.lang.String[]"
             class JAVA-SYSTEM as "java.lang.System"
             .
      *
       IDENTIFICATION DIVISION.
       FACTORY.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       PROCEDURE DIVISION.
      *
       IDENTIFICATION DIVISION.
       METHOD-ID. main as "main".
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       77  THIS-OBJECT OBJECT REFERENCE CHDATE.
       77  PRG-TO-CALL PIC X ANY LENGTH.
       LINKAGE SECTION.
       77 ARGV OBJECT REFERENCE JAVA-STRING-ARRAY.
       PROCEDURE DIVISION USING ARGV.
       START-METHOD.
           IF ARGV:>length < 2
              DISPLAY "Usage java CHDATE YYYYMMDD[hhmmss] PROG"
           ELSE
              SET THIS-OBJECT = CHDATE:>new()
              IF THIS-OBJECT:>init(ARGV(0)) = 1
                 CURRENT-DATE:>set(THIS-OBJECT)
                 SET PRG-TO-CALL = ARGV(1)
                 CALL PRG-TO-CALL
              ELSE
                 DISPLAY "Invalid date " ARGV(0)
              END-IF
           END-IF
       END METHOD.
      *
       END FACTORY.
      *
       IDENTIFICATION DIVISION.
       OBJECT.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       77  MY-CALENDAR OBJECT REFERENCE JAVA-CALENDAR.
       77  MY-TIME PIC 9(18).
       77  CURR-TIME PIC 9(18).
       PROCEDURE DIVISION.
      *
       IDENTIFICATION DIVISION.
       METHOD-ID. INIT AS "init".
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       01 NOW OBJECT REFERENCE JAVA-CALENDAR.
       01 MY-DATE.
           02  YEAR PIC 9(4).
           02  MONTH PIC 9(2).
           02  DDAY PIC 9(2).
           02  HOUR PIC 9(2).
           02  MIN PIC 9(2).
           02  SEC PIC 9(2).
       01  RETURN-VALUE PIC 9.
       LINKAGE SECTION.
       77  SET-DATE OBJECT REFERENCE JAVA-STRING.
       PROCEDURE DIVISION USING SET-DATE RETURNING RETURN-VALUE.
       START-METHOD.
            SET MY-DATE TO SET-DATE.
            IF SET-DATE:>length < 8
               MOVE 0 TO RETURN-VALUE
            ELSE
               SUBTRACT 1 FROM MONTH
               IF SET-DATE:>length < 14
                  SET NOW = JAVA-CALENDAR:>new()
                     SET HOUR = NOW:>get(JAVA-CALENDAR:>HOUR_OF_DAY)
                     SET MIN = NOW:>get(JAVA-CALENDAR:>MINUTE)
                     SET SEC = NOW:>get(JAVA-CALENDAR:>SECOND)
               END-IF
               SET MY-CALENDAR = JAVA-CALENDAR:>new (
                                      YEAR, MONTH, DDAY, HOUR, MIN, SEC)
               SET CURR-TIME TO JAVA-SYSTEM:>currentTimeMillis();;
               SET MY-TIME TO MY-CALENDAR:>getTimeInMillis();;
               MOVE 1 TO RETURN-VALUE
            END-IF.
       END METHOD.
      *
       IDENTIFICATION DIVISION.
       METHOD-ID. now as "now" OVERRIDE.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       77 NEW-TIME PIC 9(18).
       77 CURR-TIME2 PIC 9(18).
       PROCEDURE DIVISION RETURNING MY-CALENDAR.
       START-METHOD.
           SET CURR-TIME2 TO JAVA-SYSTEM:>currentTimeMillis().
           COMPUTE NEW-TIME = MY-TIME + CURR-TIME2 - CURR-TIME.
           MY-CALENDAR:>setTimeInMillis(NEW-TIME AS LONG).
       END METHOD.
      *
      *
       END OBJECT.