      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       program-id. jprogress.

       configuration section.
       repository.
           class event-object       as "java.util.EventObject"
           class j-progress-bar     as "javax.swing.JProgressBar"
           class iscobol-java-bean  
                           as "com.iscobol.gui.server.CobolGUIJavaBean".
       special-names.
           crt status is key-status
           event object is event-obj
           event source is event-source
           .

       working-storage section.
           copy "isgui.def".
           copy "iscrt.def".
           copy "jprogressbar.def".
      *>-
       77  event-obj              object reference event-object.
       77  event-source           object reference iscobol-java-bean.
       77  v-pr-bar               object reference iscobol-java-bean.
       77  h-pr-bar               object reference iscobol-java-bean.
      *>-
       77  hWin                   handle of window.
       77  close-win              pic 9 value 0. 
       77  small-font             handle of font small-font.
       77  key-status             pic 99.
       77  i                      pic 999.
       77  k                      pic 999.
       77  pb-value               pic zzz.
       77  pb-string              pic x(15).
       77  ef-val                 pic x(100).
 
       screen section.
       01  mask.
           03 java-bean 
              clsid                "javax.swing.JProgressBar"
              event-list           "change"
              line                 2 
              col                  2 
              size                 4 
              lines                20
              background-color     7
              object               v-pr-bar
              foreground-color     1
              event                pb-event
              .
           03 java-bean 
              clsid                "javax.swing.JProgressBar"
              event-list           "change"
              line                 2 
              col                  8 
              size                 50 
              lines                1.5
              object               h-pr-bar
              background-color rgb x#00ff11
              foreground-color rgb x#00aa00
              event                pb-event
              .
           03 pb-horizontal
              push-button 
              title                "Start horizontal progress" 
              line                 7 
              col                  16
              size                 30
              exception-value      2
              . 
           03 label  
              title                "Horizontal Progress Bar value: " 
              line                 9 
              col                  16
              .
           03 lbl-horizontal
              label 
              col                  + 1.5 
              size                 5
              .
           03 pb-vertical
              push-button
              line                 15
              col                  16
              title                "Start vertical progress" 
              size                 30
              exception-value      1
              .
           03 label  
              title                "Vertical Progress Bar value: " 
              line                 17
              col                  16
              .
           03 lbl-vertical
              label 
              col                  + 1.5 
              size                 5
              .
           03 push-button
              line                 21 
              col                  48 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       procedure division.
       main.
           display standard graphical window
                   background-low
                   with   system menu
                   title  "Progress Bar Bean Demo"
                   control font small-font
                   lines 23
                   size  59
                   handle hWin
                   event  WIN-EVT

           control font small-font.

           display mask.
   
           v-pr-bar:>setProperty("orientation" 1).
           v-pr-bar:>setProperty("borderpainted" 1).
           v-pr-bar:>setProperty("maximum" 100).
           v-pr-bar:>setProperty("minimum" 0).
           v-pr-bar:>setProperty("stringpainted" 1).

           h-pr-bar:>setProperty("orientation" 0).
           h-pr-bar:>setProperty("borderpainted" 1).
           h-pr-bar:>setProperty("maximum" 100).
           h-pr-bar:>setProperty("minimum" 0).
           h-pr-bar:>setProperty("stringpainted" 1).
               
           perform until key-status = 27 or close-win = 1
              accept mask
                 on exception 
              continue
              evaluate key-status
              when 1
                   perform thread test-v-pb
              when 2
                   perform thread test-h-pb
              end-evaluate
           end-perform.
    
           destroy Mask
           destroy hWin
           goback
           .
   
       TEST-V-PB.
           modify pb-vertical enabled 0
           perform varying i from 10 by 10 until i > 100
              call "c$sleep" using 0.5 end-call
              v-pr-bar:>setProperty("value" i)
           end-perform
           modify pb-vertical enabled 1
           .

       TEST-H-PB.
           modify pb-horizontal enabled 0
           perform varying k from 10 by 10 until k > 100
              call "c$sleep" using 0.5 end-call
              h-pr-bar:>setProperty("value" k)
           end-perform
           modify pb-horizontal enabled 1
           .

       PB-EVENT.
           if event-type = msg-jb-event
              if event-data-2 = JProgressBar-stateChanged
                 set pb-value to event-source:>getProperty("value") 
                 string pb-value "%" delimited size into pb-string
                 event-source:>setProperty ("string" pb-string)
                 perform update-lbl
              end-if
           end-if
           .

       UPDATE-LBL.
           set pb-value to v-pr-bar:>getProperty("value")
           modify lbl-vertical title pb-value
           set pb-value to  h-pr-bar:>getProperty("value")
           modify lbl-horizontal title pb-value
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .
