      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. ISINVOICE.
       configuration section.
       special-names.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "invoice.sl".
           copy "invoicedetail.sl".
           copy "customer.sl".
           copy "product.sl".
       DATA DIVISION.
       FILE SECTION.
           copy "invoice.fd".
           copy "invoicedetail.fd".
           copy "customer.fd".
           copy "product.fd".

       WORKING-STORAGE SECTION.

           copy "common.wrk".
           copy "color.wrk".
           copy "isprintinvoice-link.lks".

       77  status-invoice             pic xx.
       77  status-invoicedetail       pic xx.
       77  status-customer            pic xx.
       77  status-product             pic xx.
      
       01  screen-value.
           05 scr-year                pic  9(4).
           05 scr-number              pic  9(10).
           05 scr-customer            pic  x(10).
           05 scr-lbl-customer        pic  x(71).
           05 scr-date                pic  9(8).
           05 scr-vat                 pic  9(2).
           05 scr-product             pic  x(10).
           05 scr-lbl-product         pic  x(20).
           05 scr-qta                 pic  9(3)v99.

       78  id-ef-year                 value 100.
       78  id-ef-number               value 101.
       78  id-ef-customer             value 102.
       78  id-ef-date                 value 103.
       78  id-ef-vat                  value 104.
       78  id-ef-product              value 105.
       78  id-ef-qta                  value 106.
       
       77  wrk-customer               pic  x(10).
       77  wrk-product                pic  x(10).
       
       01                             pic 9.
           88 all-ok                  value 1 false zero.
       
       01                             pic 9.
           88 ask-confirm-exit        value 1 false zero.
       
       77  choice                     pic x.
       77  wrk-Invoice                pic x(10).
       77  cont                       pic 9(3).
       
       01  wrk-date.
           05 wrk-year                pic 9(4).
           05 wrk-month               pic 9(2).
           05 wrk-day                 pic 9(2).
       
       77  e-customer                 pic 9.
       77  e-product                  pic 9.
 
       01  rec-grid.
           05 rg-filler               pic x.
           05 rg-product              pic x(10).
           05 rg-prod-name            pic x(20).
           05 rg-unit-price           pic zzz,zz9.99.
           05 rg-qta                  pic zz9.99.
           05 rg-row-price            pic zzz,zz9.99.
       
       77  row-price                  pic 9(06)v99.
       77  wrk-price                  pic 9(06)v99.
       77  row                        pic 9(4).
       
       01  OCCURS-deleted-row.
           03 deleted-row             occurs dynamic 
                                      capacity num-delete-row.
              05 dr-invde-inv-key.
                 10 dr-invde-year     pic  9(4).
                 10 dr-invde-number   pic  9(10).
              05   dr-invde-row       pic 9(3).

       77  last-invde-row             pic 9(4).
       77  last-row-h-grid            pic 9(4).

       01  wrk-inv-key.
           05 wrk-inv-year            pic  9(4).
           05 wrk-inv-number          pic  9(10).
       
       77  paramCount                 pic s99 comp-1.
       
       linkage section.
       01  link-inv-key.
           10 link-inv-year           pic  9(4).
           10 link-inv-number         pic  9(10).

       screen section.

       01 mask-main.
           05  label
               foreground-color RGB 78-lbl-menu-foreground-color
               background-color RGB 78-lbl-menu-background-color
               right
               col 31 
               line 1
               lines 2 
               size 100
               height-in-cells
               width-in-cells
               . 
           05  frame 
               raised
               line 3 
               col 31
               lines 35 cells
               size 100 cells
               .
           05  Label, 
               COL 32
               LINE 4
               TITLE R"Invoice_N�"
               transparent
               .
           05  ef-year Entry-Field
               COL 45 
               LINE 04
               SIZE 6
               VALUE scr-year
               id id-ef-year
               read-only
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               .

           05  ef-number Entry-Field
               COL 52 
               LINE 04
               SIZE 11
               VALUE scr-number
               read-only
               id id-ef-number
               right
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               .
      
           05  Label, 
               COL 32
               LINE 6
               TITLE R"Customer_id"
               transparent
               .
      
           05  ef-customer Entry-Field
               COL 45 
               LINE 6
               SIZE 10
               max-text 10
               id id-ef-customer
               VALUE scr-customer
               enabled e-customer
               after AFT-EF-CUSTOMER
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               .
      
           05  lbl-customer label
               COL 58 
               LINE 6
               SIZE 40
               title scr-lbl-customer
               transparent
               .
      
           05  Label
               COL 32
               LINE 8
               TITLE R"Order_date"
               transparent
               .

           05  ef-date date-Entry, 
               COL 45
               LINE 8
               SIZE 10
               VALUE scr-date
               id id-ef-date
               .
           
           05  Label
               COL 65
               LINE 8
               TITLE R"VAT_%"
               transparent
               .
           
           05  ef-vat Entry-Field, 
               COL 72
               LINE 8
               SIZE 4
               max-text 2
               VALUE scr-vat
               right
               id id-ef-vat
               numeric
               picture z9
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               .
           
           05  bar
               line 10 col 31 size 100.

           05  Label
               COL 32
               LINE 11
               TITLE R"Product"
               transparent
               .

           05  ef-product Entry-Field, 
               COL 45
               LINE 11
               SIZE 10
               max-text 10
               VALUE scr-product
               id id-ef-product
               enabled e-product
               after AFT-EF-PRODUCT
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               .

           05  lbl-product label, 
               COL 60
               LINE 11
               SIZE 40
               title scr-lbl-product
               transparent
               .

           05  Label
               COL 32
               LINE 13
               TITLE R"Qta"
               transparent
               .

           05  ef-qta Entry-Field, 
               COL 45
               LINE 13
               SIZE 10
               max-text 6
               VALUE scr-qta
               picture zz9.99
               numeric
               right
               id id-ef-qta
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               .
           
           05  Push-Button
               col 102 
               line 12.7
               lines 2.2 
               cells
               size 14 cells
               bitmap-handle h-tools
               bitmap-width 16
               bitmap-number 78-n-pb-save
               bitmap-rollover 78-n-pb-save-rollover
               exception-value 2003
               title R"Save_Row"
               title-position 2
               self-act
               flat
               background-color     78-pb-background-color
               foreground-color     78-pb-foreground-color
               disabled-background-color 
                                    rgb 78-pb-disabled-background-color
               disabled-foreground-color 
                                    rgb 78-pb-disabled-foreground-color
               rollover-foreground-color 
                                    rgb 78-pb-rollover-foreground-color
               .
           
           05  Push-Button
               col + 1.2
               line 12.7
               lines 2.2 cells
               size 14 cells
               bitmap-width 16
               bitmap-handle h-tools
               bitmap-number 78-n-pb-delete
               bitmap-rollover 78-n-pb-delete-rollover
               exception-value 2004
               title-position 2
               title R"Delete_Row"
               self-act
               flat
               background-color     78-pb-background-color
               foreground-color     78-pb-foreground-color
               disabled-background-color 
                                    rgb 78-pb-disabled-background-color
               disabled-foreground-color 
                                    rgb 78-pb-disabled-foreground-color
               rollover-foreground-color 
                                    rgb 78-pb-rollover-foreground-color
               .
           
           05  h-grid, grid
               reordering-columns
               sortable-columns
               adjustable-rows
               line 15 col 32
               lines 22 size 98
               width-in-cells
               height-in-cells
               data-columns (1,   2,   12,   32, 43, 49)
               alignment   ( "C", "L", "L", "R", "R", "R" )
               data-types ( "I", "X(-1)", "X(-1)", "9", "9", "9")
               display-columns (3, 15, 50, 63, 80)  
               color 513  
               vscroll
               tiled-headings
               centered-headings 
               column-headings
               row-headings
               heading-color 257
               adjustable-columns
               use-tab
               num-rows -1
               cursor-frame-width 1
               Row-Cursor-Background-Color rgb 
                                           78-lbl-menu-background-color
               Row-Cursor-foreground-Color rgb 
                                           78-lbl-menu-foreground-color
               Cursor-Foreground-Color rgb 78-cursor-foreground-color 
               Cursor-Background-Color rgb 78-cursor-background-color
               event H-GRID-EVENT
               protection 1
               .

       01  mask-tool.
           05  Push-Button
               col 2 
               line 3
               lines 2.2 
               cells
               size 10 cells
               bitmap-handle h-tools
               bitmap-width 16
               bitmap-number 78-n-new
               bitmap-rollover 78-n-new-rollover
               exception-value 78-exe-new
               title R"&New"
               hint R"(F2)"
               title-position 2
               self-act
               rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
               .
           05  Push-Button
               col + 1.2 
               line 3
               lines 2.2 
               cells
               bitmap-handle h-tools
               size 13 cells
               bitmap-width 16
               bitmap-number 78-n-save
               bitmap-rollover 78-n-save-rollover
               exception-value 78-exe-save
               title R"&Save"
               hint R"(F3)"
               title-position 2
               self-act
               rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
               .
           05  Push-Button
               col + 1.2
               lines 2.2 cells
               size 11 cells
               bitmap-handle h-tools
               bitmap-width 16
               bitmap-number 78-n-delete
               bitmap-rollover 78-n-delete-rollover
               exception-value 78-exe-delete
               title-position 2
               title R"&Delete"
               hint R"(F4)"
               self-act
               rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
               .
           05  Push-Button
               col + 1.2
               lines 2.2 cells
               size 13 cells
               bitmap-handle h-tools
               bitmap-width 16
               bitmap-number 78-n-print
               bitmap-rollover 78-n-print-rollover
               exception-value 78-exe-print
               title-position 2
               title R"&Print"
               hint R"(F6)"
               self-act
               rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
               .
           05  bar
               col + 1.2
               lines 2 width 2
               color 16
               shading (-1, 1)
               .
           05  Push-Button
               col + 1.2
               lines 2.2 cells
               size 11 cells
               bitmap-handle h-tools
               bitmap-width 16
               bitmap-number 78-n-search
               bitmap-rollover 78-n-search-rollover
               exception-value 78-exe-zoom
               title R"Search"
               hint R"(F8)"
               title-position 2
               self-act
               rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
               .
           05  Push-Button
               col + 1.2
               lines 2.2 cells
               size 10 cells
               bitmap-handle h-tools
               bitmap-width 16
               bitmap-number 78-n-first
               bitmap-rollover 78-n-first-rollover
               exception-value 78-exe-first
               title R"&First"
               title-position 2
               self-act
               rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
               .
           05  Push-Button
               col + 1.2
               lines 2.2 cells
               size 13 cells
               bitmap-handle h-tools
               bitmap-width 16
               bitmap-number 78-n-previous
               bitmap-rollover 78-n-previous-rollover
               exception-value 78-exe-prev
               title R"&Previous"
               hint R"(PgUp)"
               title-position 2
               self-act
               rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
               .
           05  Push-Button
               col + 1.2
               lines 2.2 cells
               size 13 cells
               bitmap-handle h-tools
               bitmap-width 16
               bitmap-number 78-n-next
               bitmap-rollover 78-n-next-rollover
               exception-value 78-exe-next
               title R"Ne&xt_"
               hint R"(PgDn)"
               title-position 2
               self-act
               rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
               .
           05  Push-Button
               col + 1.2
               lines 2.2 cells
               size 10 cells
               bitmap-handle h-tools
               bitmap-width 16
               bitmap-number 78-n-last
               bitmap-rollover 78-n-last-rollover
               exception-value 78-exe-last
               title R"&Last"
               title-position 2
               self-act
               rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
               .
           05  bar
               col + 1.2
               lines 2 width 2
               color 16
               shading (-1, 1)
               .
           05  push-button 
               title R"&Exit"
               hint R"(Esc)"
               bitmap-handle h-tools
               bitmap-number 78-n-exit
               bitmap-rollover 78-n-exit-rollover
               title-position 2
               lines 2.2 cells
               size 12 cells
               bitmap-width 16
               col + 1.2
               exception-value 27
               self-act
               rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
               .

       PROCEDURE DIVISION USING link-inv-key.
       DECLARATIVES.
       INVOICE-ERR section.
           use after standard error procedure on invoice.
           perform ERROR-FILE
           .
       INVOICEDETAIL-ERR section.
           use after standard error procedure on invoicedetail.
           perform ERROR-FILE
           .
       CUSTOMER-ERR section.
           use after standard error procedure on customer.
           perform ERROR-FILE
           .
       PRODUCT-ERR section.
           use after standard error procedure on product.
           perform ERROR-FILE
           .
       END DECLARATIVES.
      
       MAIN.

           perform OPEN-FILES.
           
           initialize screen-value.
           set ask-confirm-exit     to false.
           
           display independent graphical window
                   title R"isCOBOL_Application_Invoice"
                   lines 37
                   size 131
                   control font h-font
                   background-low
                   handle h-sta
                   visible 0
                   system menu
                   link to thread
                   gradient-color-1 rgb 78-gradient-color-1
                   gradient-color-2 rgb 78-gradient-color-2 
                   .
           call "ISTOOLTIP"
           cancel "ISTOOLTIP"
           
           display tool-bar 
                   lines 2.5 
                   control font h-font 
                   handle h-tool 
                   upon h-sta
           
           display mask-main upon h-sta
           display mask-tool upon h-tool
           
           call "C$NARG" using paramCount
           if paramCount = zero
              perform NEW-RECORD
           else
              move link-inv-year   to scr-year
              move link-inv-number to scr-number
              modify ef-year value scr-year
              modify ef-number value scr-number
              perform LOAD-RECORD
           end-if
           
           modify h-sta visible 1
           
           perform until key-status = 27
              accept mask-main
                 on exception continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform
           
           perform EXIT-PRG.
           
           goback
           .

       AFTER-ACCEPT.
           evaluate key-status
           when 78-exe-exit
                perform ASK-CONFIRM
                if not all-ok
                   move zero to key-status
                end-if
           when 78-exe-new
                perform ASK-CONFIRM
                if all-ok
                  perform NEW-RECORD
                end-if
           when 78-exe-save
                perform SAVE-RECORD
           when 78-exe-delete
                perform DELETE-RECORD
                initialize inv-record
                perform DISPLAY-SCREEN
           when 78-exe-first
                perform ASK-CONFIRM
                if all-ok
                   perform READ-FIRST
                   perform DISPLAY-SCREEN
                end-if
           when 78-exe-prev
                perform ASK-CONFIRM
                if all-ok
                   perform READ-PREV
                   perform DISPLAY-SCREEN
                end-if
           when 78-exe-next
                perform ASK-CONFIRM
                if all-ok
                   perform READ-NEXT
                   perform DISPLAY-SCREEN
                end-if
           when 78-exe-last
                perform ASK-CONFIRM
                if all-ok
                   perform READ-LAST
                   perform DISPLAY-SCREEN
                end-if
           when 78-exe-zoom
                PERFORM ZOOM-PARAGRAPH
           when 78-exe-print
                perform SAVE-RECORD
                if all-ok
                   perform PRINT-PARAGRAPH
                end-if
           when w-event
                evaluate event-type
                when cmd-close
                     perform ASK-CONFIRM
                     if all-ok
                        move 27 to key-status
                     end-if
                end-evaluate
           when 2003
                perform SAVE-ROW
           when 2004
                perform DELETE-ROW
           end-evaluate.

       PRINT-PARAGRAPH.
           move scr-year     to wrk-inv-year
                                ips-inv-year
           move scr-number   to wrk-inv-number
                                ips-inv-number
           set ips-print  to true
           
           call "ISPRINTINVOICE" using ips-linkage
           cancel "ISPRINTINVOICE".

       NEW-RECORD.

           move 1   to e-customer
           accept wrk-date from century-date
                
           initialize inv-record
           move high-value to inv-key
           start Invoice key not > inv-key
              invalid
                 move zero       to inv-number
                 move wrk-year   to inv-year
              not invalid
                 read Invoice previous no lock
                    at end
                      move zero       to inv-number
                      move wrk-year   to inv-year
                    not at end
                      if wrk-year not = inv-year
                         move zero       to inv-number
                         move wrk-year   to inv-year
                      end-if
                 end-read
           end-start
           
           add 1  to inv-number
           initialize inv-data
           move wrk-date   to scr-date
           perform DISPLAY-SCREEN.

       DELETE-RECORD.
           display message box 
                          R"Are_you_sure_to_delete_the_selected_record?"
                   type mb-yes-no
                   default mb-no
                   giving choice
           if choice = mb-yes
             delete Invoice record
                invalid
                   continue
             end-delete
             perform DELETE-DETAIL
           end-if.

       DELETE-DETAIL.
           move inv-key   to invde-inv-key
           move low-value to invde-row
           start invoicedetail  key not < invde-key
              invalid
                 continue
              not invalid
                 perform until 1 = 2
                    read invoicedetail next no lock
                       at end
                          exit perform
                    end-read
                    if inv-key not = invde-inv-key
                       exit perform
                    end-if
                    delete invoicedetail record
                 end-perform
           end-start.

       SAVE-RECORD.
           set all-ok  to true
           perform CONTROL-ALL
           
           if all-ok
             if e-customer = 1
                move zero          to e-customer
                modify ef-customer enabled e-customer
             end-if
             move scr-year      to inv-year
             move scr-number    to inv-number
             move scr-customer  to inv-customer
             move scr-date      to inv-date
             move scr-vat       to inv-vat
           
             rewrite inv-record
               invalid
                 write inv-record
             end-rewrite
           
             perform SAVE-DETAIL
             
             set ask-confirm-exit to false
           
           end-if.
 
       SAVE-DETAIL.
           move zero   to last-invde-row
         
      *    delete from the file the deleted row
           perform varying idx from 1 by 1 until idx > num-delete-row
              move deleted-row(idx)  to invde-key
              delete invoicedetail record
                 invalid
                    continue
              end-delete
           end-perform
              
      *>   save the row into the file
            inquire h-grid last-row = last-row-h-grid
            perform varying idx from 2 by 1 until idx > last-row-h-grid
              inquire h-grid(idx) record-data = rec-grid
              
              if rg-product not = space
                 perform WRITE-DETAIL
              end-if
            end-perform.
            .

       WRITE-DETAIL.
           inquire h-grid(idx, 1) hidden-data = invde-key
           if invde-year(1:) = space
              move 0   to invde-year
           end-if
           if invde-year = zero
              if last-invde-row = zero
                 move inv-key   to invde-inv-key
                 move high-value   to invde-row
                 start invoicedetail key not > invde-key
                    invalid
                       move zero   to invde-row
                    not invalid
                       read invoicedetail previous no lock
                          at end
                             move zero   to invde-row
                       end-read
                       if inv-key not = invde-inv-key
                          move zero   to invde-row
                       end-if
                 end-start
                 move invde-row    to last-invde-row
              end-if
              add 1                to last-invde-row
              move last-invde-row  to invde-row 
              move inv-key         to invde-inv-key
           end-if
           
           move rg-product    to invde-product
           move rg-unit-price to invde-price
           move rg-qta        to invde-qta
           
           move scr-customer to invde-customer
           rewrite invde-record
              invalid
                 write invde-record
           end-rewrite.
           
           modify h-grid(idx, 1) hidden-data = invde-key.

       CONTROL-ALL.
           inquire ef-customer  value scr-customer
           inquire ef-date      value scr-date
           inquire ef-vat       value scr-vat.
           
           move id-ef-customer to control-id
           perform CONTROL-CUSTOMER.
            
           inquire h-grid last-row = last-row-h-grid
           
           if last-row-h-grid < 2
              display message box R"Detail_is_mandatory!"
              set all-ok  to false
           end-if.

       ASK-CONFIRM.
           set all-ok       to true
           if ask-confirm-exit
              display message box R"Do_you_want_to_save_changes?"
                      type mb-yes-no-cancel
                      giving choice
           
              evaluate choice
              when mb-yes
                   perform SAVE-RECORD
              when mb-cancel
                   set all-ok to false
              when mb-no
                  continue
              end-evaluate
           end-if.

       READ-FIRST.
           move low-value  to inv-key
           start Invoice key not < inv-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize inv-record
              not invalid
                read Invoice next no lock
                   at end
                      perform RECORD-NOT-FOUND
                      initialize inv-record
                 not at end
                    move zero   to e-customer
                end-read
           end-start.
 
       READ-LAST.
           move high-value  to inv-key
           start Invoice key not > inv-key
              invalid
                 perform RECORD-NOT-FOUND
                 perform NEW-RECORD
              not invalid
                read Invoice previous no lock
                   at end
                      perform RECORD-NOT-FOUND
                     perform NEW-RECORD
                 not at end
                    move zero   to e-customer
                end-read
           end-start.
 
       READ-PREV.
           if scr-number = zero
              perform READ-LAST
           else
              move scr-year    to inv-year
              move scr-number  to inv-number
              read Invoice no lock
                invalid
                   start Invoice key not < inv-key
                      invalid
                        perform READ-LAST
                   end-start
              end-read
              read Invoice previous no lock
                at end
                   perform READ-LAST
                not at end
                   move zero   to e-customer
              end-read
           end-if.

       READ-NEXT.
           if scr-number = zero
              perform READ-FIRST
           else
              move scr-year    to inv-year
              move scr-number  to inv-number
              read Invoice no lock
                invalid
                   start Invoice key not > inv-key
                      invalid
                         perform READ-FIRST
                   end-start
              end-read
              read Invoice next no lock
                at end
                   perform READ-FIRST
                not at end
                   move zero   to e-customer
              end-read
           end-if.
 
       RECORD-NOT-FOUND.
           display message box R"Record_not_found".
 
       DISPLAY-SCREEN.
           move inv-year          to scr-year
           move inv-number        to scr-number
           move inv-date          to scr-date
           move inv-customer      to scr-customer
                                     cust-id
           read customer no lock
              invalid
                 move space   to cust-fname
                                 cust-lname
           end-read
           initialize scr-lbl-customer
           string cust-fname  delimited by trailing space
                  " "         delimited by size
                  cust-lname  delimited by trailing space
                  into scr-lbl-customer
                                      
           move inv-vat           to scr-vat
           
           display mask-main.
           perform DISPLAY-DETAIL.

       DISPLAY-DETAIL.
           initialize OCCURS-deleted-row.

           modify h-grid mass-update 1
                         reset-grid 1
           
           move 1   to row
           modify h-grid(1, 2) cell-data R"Product_Id"
           modify h-grid(1, 3) cell-data R"Name"
           modify h-grid(1, 4) cell-data R"Unit_price"
           modify h-grid(1, 5) cell-data R"Quantity"
           modify h-grid(1, 6) cell-data R"Row_Price"
           
           move inv-key   to invde-inv-key
           move low-value to invde-row
           start invoicedetail  key not < invde-key
              invalid
                 continue
              not invalid
                 perform until 1 = 2
                    read invoicedetail next no lock
                       at end
                          exit perform
                    end-read
                    if inv-key not = invde-inv-key
                       exit perform
                    end-if
                    perform ADD-ROW-GRID
                 end-perform
           end-start.
           
           modify h-grid mass-update zero.
           move 2  to row.
           perform LOAD-ROW.

       ADD-ROW-GRID.
           add 1 to row
           initialize rec-grid
           
           move invde-product   to rg-product
                                   prod-id
           read product no lock
              invalid
                 move space   to prod-name
           end-read
           move prod-name    to rg-prod-name
           move invde-price  to rg-unit-price
           move invde-qta    to rg-qta
           compute row-price = invde-qta * invde-price
           move row-price    to rg-row-price
           
           modify h-grid record-to-add rec-grid
           modify h-grid(row, 1) hidden-data invde-key.

       OPEN-FILES.
           open I-O invoice.
           if status-invoice = 35
              open output invoice
              close invoice
              open i-o invoice
           end-if.
           open I-O invoicedetail.
           if status-invoicedetail = 35
              open output invoicedetail
              close invoicedetail
              open i-o invoicedetail
           end-if.
           open input Customer.
           if status-Customer = 35
              open output Customer
              close Customer
              open input Customer
           end-if.
           open input product.
           if status-product = 35
              open output product
              close product
              open input product
           end-if.

       EXIT-PRG.
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           close invoice.
           close invoicedetail.
           close customer.
           close product.

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy mask-main mask-tool h-tool 
                   h-sta 
           .

       AFT-EF-CUSTOMER.
           perform CONTROL-CUSTOMER.

       AFT-EF-PRODUCT.
           move scr-product  to prod-id
           read product no lock
              invalid
                 move space   to prod-name
                 move zero    to prod-price
           end-read
           move prod-price to wrk-price
           move prod-name  to scr-lbl-product
           modify lbl-product title scr-lbl-product.

       CONTROL-CUSTOMER.
           set all-ok          to true

           move scr-customer  to cust-id
           read customer no lock
              invalid
                 move space   to cust-fname
                                 cust-lname
                 display message box R"Wrong_Customer_id!"
                 move id-ef-customer   to control-id
                 set all-ok            to false
           end-read
           
           initialize scr-lbl-customer
           string cust-fname  delimited by trailing space
                  " "         delimited by size
                  cust-lname  delimited by trailing space
                  into scr-lbl-customer
           modify lbl-customer   title scr-lbl-customer
           
           if not all-ok
              move 4  to accept-control
           end-if.
 
       ZOOM-PARAGRAPH.
           evaluate control-id
           when id-ef-year
           when id-ef-number
                call "ZINVOICE" using wrk-inv-key
                cancel "ZINVOICE"
                if wrk-inv-key not = zero
                   move wrk-inv-year   to scr-year
                   move wrk-inv-number to scr-number
                   modify ef-year value scr-year
                   modify ef-number value scr-number
                   perform LOAD-RECORD
                end-if
           when id-ef-customer
                call "ZCUSTOMER" using wrk-customer
                cancel "ZCUSTOMER"
                if wrk-customer not = space
                   move wrk-customer   to scr-customer
                   modify ef-customer value scr-customer
                   perform CONTROL-CUSTOMER
                end-if
           when id-ef-product
                call "ZPRODUCT" using wrk-Product
                cancel "ZPRODUCT"
                if wrk-Product not = space
                   move wrk-Product   to scr-product
                   modify ef-product value scr-product
                   perform AFT-EF-PRODUCT
                end-if
           end-evaluate.

       LOAD-RECORD.
           move scr-year     to inv-year
           move scr-number   to inv-number
           read invoice no lock
              invalid
                 perform RECORD-NOT-FOUND
              not invalid
                 perform DISPLAY-SCREEN
           end-read.

       H-GRID-EVENT.
           evaluate event-type
           when MSG-GOTO-CELL
           when MSG-GOTO-CELL-MOUSE
                if event-data-2 not = row
                   move event-data-2  to row
                   perform LOAD-ROW
                end-if 
           end-evaluate.

       LOAD-ROW.
           inquire h-grid(row)    record-data = rec-grid
           inquire h-grid(row, 1) hidden-data = invde-key
           if row = 1
              initialize rec-grid
                         invde-key
           end-if
           if rg-product = space
             move 1 to e-product
           else
             move zero  to e-product
           end-if
           
           move rg-product    to scr-product
           move rg-prod-name  to scr-lbl-product
           move rg-qta        to scr-qta
           move rg-unit-price  to wrk-price
           
           display ef-product
                   lbl-product
                   ef-qta.

       SAVE-ROW.
           set all-ok  to true
           move scr-product  to prod-id
           read product no lock
              invalid
                 move space   to prod-name
                 move zero    to prod-price
                 display message box R"Wrong_Product_code!"
                 move id-ef-product    to control-id
                 set all-ok            to false
           end-read
           move prod-price to wrk-price
           move prod-name  to scr-lbl-product
           modify lbl-product title scr-lbl-product
           
           if all-ok
              if scr-qta = zero
                 display message box R"Quantity_is_mandatory!"
                 move id-ef-qta   to control-id
                 set all-ok            to false
              end-if
           end-if.
           
           if all-ok
              move scr-product     to rg-product
              move scr-lbl-product to rg-prod-name
              move scr-qta         to rg-qta
              move wrk-price       to rg-unit-price
              compute row-price = scr-qta * wrk-price
              move row-price       to rg-row-price
              modify h-grid(row) record-data = rec-grid
           end-if.

           if all-ok and e-product = 1
               add 1  to row
               perform LOAD-ROW
               modify h-grid cursor-x = 1, cursor-y = row
               move id-ef-product   to control-id
           end-if.

           set ask-confirm-exit     to true.


       DELETE-ROW.

           if rg-product not = space and row > 1
              display message box 
                             R"Are_you_sure_to_delete_the_selected_row?"
                      type mb-yes-no
                      default mb-no
                      giving choice
              if choice = mb-yes
                 if invde-key not = space
                    add 1   to num-delete-row giving idx 
                    move invde-key to deleted-row(idx)
                 end-if
                 modify h-grid record-to-delete row
                 inquire h-grid last-row = last-row-h-grid
                 if row > last-row-h-grid
                    move last-row-h-grid to row
                 end-if
                 perform LOAD-ROW
                 set ask-confirm-exit     to true
              end-if
           end-if.

           copy "dec-file.prd". 
