      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
      
       PROGRAM-ID. ISPRINTPROD.
       configuration section.
       special-names.   
      
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
        copy "print-f.sl".
        copy "product.sl".
       DATA DIVISION.
       FILE SECTION.
        copy "print-f.fd".
        copy "product.fd".
      
       WORKING-STORAGE SECTION.

           copy "common.wrk".
           copy "color.wrk".
           copy "isopensave.def".
           copy "isprint.def".

       77  status-product             pic xx.
       77  status-print-f             pic xx.
       
       77  print-env                  pic x(256).
       77  opensave-status            pic s9.
       
       01  screen-value.
           05 scr-print-mode          pic 9 value 1.
              88 scr-preview          value 1.
              88 scr-pdf              value 2.
              88 scr-print            value 3.
           05 scr-pdf-name            pic x(256).
           
       01                             pic 9.
           88 first-record            value 1 false zero.
           
       01  header-row.
           05 filler                  pic x(1) value space.
           05 hr-title                pic x(72).
           05 filler                  pic x(5) value R"Page_".
           05 hr-page                 pic z9.
           
       01  detail-row.
           05 filler                  pic x(1) value space.
           05 dr-prod-id              pic  x(10).
           05 filler                  pic  x(1) value space.
           05 dr-prod-name            pic  x(20).
           05 filler                  pic  x(1) value space.
           05 dr-prod-description     pic  x(36).
           05 filler                  pic  x(1) value space.
           05 dr-prod-price           pic  x(10).
       
       77  prz-ed                     pic zzz,zz9.99.
       77  call-result                signed-int.
       77  num-row                    pic 9(3).
       78  78-page-rows               value 50.
       77  num-pag                    pic 99 value zero.
       77  cont                       pic 9(3).
 
       77  h-font-print               usage handle of font.
       77  env-code                   pic 9.
 
       screen section.
       01  mask-main.
           05 label
              foreground-color RGB 78-lbl-menu-foreground-color
              background-color RGB 78-lbl-menu-background-color
              right
              col 31 
              line 1
              lines 2 
              size 52
              height-in-cells
              width-in-cells
              . 
           05 frame 
              raised
              line                 3 
              col                  31
              lines                14 cells
              size                 52 cells
              .
           05 Radio-Button 
              col 33 
              line 5 
              lines 2
              size 14  
              group 1
              group-value 1
              value scr-print-mode
              height-in-cells
              width-in-cells
              bitmap-width 16
              bitmap-handle h-tools
              bitmap-number 78-n-preview
              bitmap-rollover 78-n-preview-rollover
              bitmap-rollover-selected 78-n-preview-rollover
              title-position 2
              title R"Preview"
              event DISABLE-PDF
              transparent
              rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
              .
           05 Radio-Button 
              col 33
              line 8 
              lines 2
              size 14   
              group 1
              group-value 2
              value scr-print-mode
              height-in-cells
              width-in-cells
              bitmap-width 16
              bitmap-handle h-tools
              bitmap-number 78-n-pdf
              bitmap-rollover 78-n-pdf-rollover
              bitmap-rollover-selected 78-n-pdf-rollover
              title-position 2
              title R"Pdf"
              event ENABLE-PDF
              transparent
              rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
              .
           05 ef-scr-pdf-name
              entry-field
              col + 2
              line 8 
              size 30 
              lines 2 
              height-in-cells
              width-in-cells
              max-text 256
              enabled 0
              value scr-pdf-name
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              after AFT-PDF-NAME
              .
           05 pb-sel-pdf 
              push-button
              title "..."
              line 8, 
              col + 1.5
              size 3
              lines 2
              height-in-cells
              width-in-cells
              enabled 0
              exception-value 2001
              rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
              .
           05 Radio-Button 
              col 33
              line 11
              lines 2
              size 14
              group 1
              group-value 3
              value scr-print-mode
              height-in-cells
              width-in-cells
              bitmap-width 16
              bitmap-handle h-tools
              bitmap-number 78-n-print
              bitmap-rollover 78-n-print-rollover
              bitmap-rollover-selected 78-n-print-rollover
              title-position 2
              title R"Printer"
              event DISABLE-PDF
              transparent
              rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
              .
           05 push-button
              title R"&Print"
              line 14 col 72
              size 8
              exception-value 2002
              flat
              background-color     78-pb-background-color
              foreground-color     78-pb-foreground-color
              disabled-background-color 
                                   rgb 78-pb-disabled-background-color
              disabled-foreground-color 
                                   rgb 78-pb-disabled-foreground-color
              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
              .

       01  mask-tool.
           05 push-button 
              title R"&Exit"
              hint R"(Esc)"
              bitmap-handle h-tools
              bitmap-number 78-n-exit
              bitmap-rollover 78-n-exit-rollover
              title-position 2
              lines 2.2 cells
              size 12 cells
              bitmap-width 16
              col + 1.2
              exception-value 27
              self-act
              rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
               .

       PROCEDURE DIVISION.
       DECLARATIVES.
       PRODUCT-ERR section.
           use after standard error procedure on product.
           perform ERROR-FILE
           .
       END DECLARATIVES.

       MAIN.

           perform OPEN-FILES.
           
           initialize screen-value.
           move 1   to scr-print-mode.
           
           display independent graphical window
                   title R"isCOBOL_Application_Print_Product_List"
                   lines 16
                   size 84
                   control font h-font
                   background-low
                   handle h-sta
                   visible 0
                   system menu
                   link to thread
                   gradient-color-1 rgb 78-gradient-color-1
                   gradient-color-2 rgb 78-gradient-color-2 
                   .

           call "ISTOOLTIP"
           cancel "ISTOOLTIP".

           display tool-bar 
                   lines 2.5 
                   control font h-font 
                   handle h-tool 
                   upon h-sta
           
           display mask-main upon h-sta
           display mask-tool upon h-tool
           
           modify h-sta visible 1
           
           perform until key-status = 27
              accept mask-main
                 on exception 
                    continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform
           
           perform EXIT-PRG.
           
           goback.

       AFTER-ACCEPT.
           evaluate key-status
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           when 2001
                perform SELECT-PDF-NAME
           when 2002
                perform PRINT-LIST
           end-evaluate.

       SELECT-PDF-NAME.
           initialize opensave-data
           move "pdf"            to opnsav-default-ext
           move R"Save_PDF_file" to opnsav-title
           
           move "Pdf files (*.pdf)|*.pdf|All files (*.*)|*.*"  
                                                  to opnsav-filters
           move 1 to opnsav-default-filter
           call "C$OPENSAVEBOX" using opensave-save-box-checked
                                      opensave-data
                               giving opensave-status
           if opensave-status > 0
              move opnsav-filename  to scr-pdf-name
              modify EF-SCR-PDF-NAME value scr-pdf-name
           end-if.

       PRINT-LIST.
           set first-record  to true
           move 200 to num-row
           move zero   to num-pag
           move low-value to prod-key
           start product key not < prod-key
              invalid
                 continue
              not invalid
                 perform until 1 = 2
                    read product next no lock
                       at end
                          exit perform
                    end-read
                    perform PRINT-RECORD
                    if call-result not = zero |first-record
                       exit perform
                    end-if
                 end-perform
           end-start.
           if first-record
              display message box R"No_data_to_print"
           else
              if call-result = zero
                 close print-f
                 if scr-pdf
                    call client "C$EASYOPEN" using scr-pdf-name
                 end-if
              end-if
           end-if.

       PRINT-RECORD.
           if first-record
              perform OPEN-PRINT
              if call-result < zero
                 set first-record  to false
              end-if
           end-if
           
           if call-result = zero
              if num-row > 78-page-rows
                 perform PRINT-HEADER
              end-if
           
              set first-record        to false
              move prod-id            to dr-prod-id
              move prod-name          to dr-prod-name
              move prod-description   to dr-prod-description
              move prod-price         to prz-ed
              move prz-ed             to dr-prod-price
              
              write p-row from detail-row
              add 1 to num-row
           end-if.

       OPEN-PRINT.
           initialize print-env
           move zero   to call-result
           evaluate true
           when scr-preview
                move "-P PREVIEW" to print-env
           when scr-pdf
                string "-P PDF "     delimited by size
                       scr-pdf-name  delimited by trailing space
                       into print-env
           when scr-print
                call "C$GETRUNENV" GIVING env-code
                if env-code not = runenv-web-client
                   initialize winprint-selection
                   call "WIN$PRINTER" using winprint-get-current-info
                                            winprint-selection
                   if winprint-name = spaces
                      display message box R"No_printer_on_this_machine"
                      move -1   to call-result
                   end-if
                   call "WIN$PRINTER" using winprint-setup 
                                     giving call-result 
                end-if
                move "-P SPOOLER" to print-env
           end-evaluate.
           
           if call-result not < 0
              open output print-f
      *>      set the fixed font for the print
              move WPRTFONT-COURIER-10 to wprtdata-std-font
              call "WIN$PRINTER" using winprint-set-std-font 
                                       WINPRINT-DATA 
                                giving call-result
              move zero   to call-result
           end-if
           .

       PRINT-HEADER.
           if num-pag not = zero
              write p-row from space after page
           end-if
           
           set first-record to false
           add 1 to num-pag
           move zero   to num-row
           
           move R"isCOBOL_Application_Print_Product_List"   to hr-title
           move num-pag   to hr-page
           write p-row from header-row
           add 1 to num-row.
           
           initialize p-row
           move all "="   to p-row(2:79).
           write p-row 
           add 1 to num-row.
           
           move R"Product_Id"   to dr-prod-id
           move R"Product_Name" to dr-prod-name
           move R"Description"  to dr-prod-description
           move R"Price"        to dr-prod-price
           call "C$JUSTIFY" using dr-prod-price, "R"
           
           write p-row from detail-row
           add 1 to num-row.
           
           initialize p-row
           move all "="   to p-row(2:79).
           write p-row 
           add 1 to num-row.
  
 
       OPEN-FILES.
           open input product.

       EXIT-PRG.
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           close product.

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy mask-main mask-tool h-tool 
                   h-sta 
           .

       ENABLE-PDF.
           evaluate event-type
           when cmd-clicked
                modify ef-scr-pdf-name enabled 1
                modify pb-sel-pdf enabled 1
           end-evaluate
           .

       DISABLE-PDF.
           evaluate event-type
           when cmd-clicked
                modify ef-scr-pdf-name  enabled 0
                modify pb-sel-pdf enabled 0
           end-evaluate
           .

       AFT-PDF-NAME.
           inquire EF-SCR-PDF-NAME value scr-pdf-name
           initialize cont
           inspect scr-pdf-name tallying cont for characters 
                                               before trailing space
           if cont < 4
              string scr-pdf-name  delimited by trailing space
                     ".pdf"        delimited by size
                     into scr-pdf-name
              modify EF-SCR-PDF-NAME value scr-pdf-name
           else
              subtract 3 from cont
              call "C$TOLOWER" using scr-pdf-name(cont:4)
              if scr-pdf-name(cont:4) not = ".pdf"
                 string scr-pdf-name  delimited by trailing space
                     ".pdf"        delimited by size
                     into scr-pdf-name
                     modify EF-SCR-PDF-NAME value scr-pdf-name
              end-if
           end-if
           .

           copy "dec-file.prd".

