      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       PROGRAM-ID. AUDITLOG.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "auditlog.sl".
       DATA DIVISION.
       FILE SECTION.
           copy "auditlog.fd".

       working-storage section.
           copy "audit.wrk".
       77  stato          is special-names crt status pic 9(5).
       77  v9             pic 9 value 0.
       77  wrk            pic x any length.
       77  msg            pic x(280).
       77  msg-sz         pic 9(5).
       77  user-logged    pic x(20).
       01  crerr-status.
           03 file-status pic xx.
           03 ext-status  pic xxx.
       77  rerrname       pic x(50).
      
       77  thread-status  pic 99.
      
       procedure division.

       DECLARATIVES.
       AUDITLOG-ERR section.
           use after standard error procedure on auditlog.
           evaluate status-auditlog
           when 35
                continue
           when other
                perform ERROR-FILE
           end-evaluate.

       END DECLARATIVES.

       MAIN.
           open i-o auditlog.
           if status-auditlog = 35
              open output auditlog
              close auditlog
              open i-o auditlog
           end-if.

           perform until 1 = 2
              receive msg from any thread 
                          before time 0
                          size in msg-sz
                          status in thread-status 
              end-receive
              if thread-status = 99
                 call "C$SLEEP" using 0.5
              else
                 evaluate true
                 when msg(1:msg-sz) = "AUDIT-END"
                      exit perform
                 when msg(1:5) = "AUDIT"
                      move msg(1:msg-sz) to wrk
                      perform WRITE-AUDIT
                 when other
                      call "C$WRITELOG" using "Wrong thread message: "
                                              "size " msg-sz
                                              "Message " msg(1:msg-sz)
                    continue
                 end-evaluate

              end-if
              initialize msg
           end-perform

           close AUDITLOG.
           goback
           .

       WRITE-AUDIT.
      * 01  audit-operation pic xx.
      *     88 ao-login value "pi".
      *     88 ao-logout value "po".
      *     88 ao-start-program value "ps".
      *     88 ao-stop-program value "pe".
      *     88 ao-open value "fo".
      *     88 ao-close value "fc".
      *     88 ao-delete-record value "fd".
      *     88 ao-delete-file value "ff".
      *     88 ao-read value "fr".
      *     88 ao-write value "fw".
      *     88 ao-rewrite value "fx".

           accept user-logged from environment "userid"
           move user-logged  to AL-USERS-ID
           accept AL-DATE from century-date
           accept AL-TIME from time 

           move wrk(6:2) to AL-OPERATION
           move wrk(8:20) to AL-FILE-PROGRAM-NAME
           move wrk(28:)  to AL-FILE-KEY.
           
           perform until 1 = 2
              write AUDITLOG-R
                 invalid
                    accept AL-TIME from time 
                 not invalid
                    exit perform
              end-write
           end-perform
           .

       ERROR-FILE.
           call "C$RERR"     using crerr-status
           call "C$RERRNAME" using rerrname
           display message "Error " file-status "-" 
                           ext-status " on " rerrname  
               title "Audit Log"
               icon 2.
           stop run.