      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       IDENTIFICATION DIVISION.
       PROGRAM-ID. AUDITSETTINGS.

       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.

       SPECIAL-NAMES.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "auditfilesettings.sl".
           copy "auditlogsettings.sl".
           copy "users.sl".

       DATA DIVISION.
       FILE SECTION.
           copy "auditfilesettings.fd".
           copy "auditlogsettings.fd".
           copy "users.fd".

       working-storage section.
           copy "isgui.def".
           copy "iscobol.def".
           copy "iscrt.def".
           copy "isfilesys.def".
           copy "isfonts.def".
           copy "color.wrk".

       77  key-status is special-names crt status pic 9(4) value 0.
       77  w-activity-handle          handle of window.
       77  tb-activity-handle         handle of window.
       77  w-segment-handle           handle of window. 
       77  tb-segment-handle          handle of window. 
       77  control-font               handle of font.
       77  tools-png                  pic s9(9) comp-4.

       78  78-exe-delete              value 4.
       78  78-exe-exit                value 27.

       77  idx                        pic 9(3).

       77  status-auditfilesettings   pic x(2).
       77  status-auditlogsettings    pic x(2).
       77  status-users               pic x(2).

       77  choice pic x.

       01  rec-grid-activity.
           05 rga-users-id            pic x(20).
           05 rga-all                 pic 9.
           05 rga-login               pic 9.
           05 rga-logout              pic 9.
           05 rga-pgm-start           pic 9.
           05 rga-pgm-end             pic 9.
       01  activity-row               pic 9(4).
       01  activity-col               pic 9(4).

       01  rec-grid-file.
           05 rgf-users-id            pic x(20).
           05 rgf-file                pic x(20).
           05 rgf-all                 pic 9.
           05 rgf-open                pic 9.
           05 rgf-close               pic 9.
           05 rgf-delete-record       pic 9.
           05 rgf-delete-file         pic 9.
           05 rgf-read                pic 9.
           05 rgf-write               pic 9.
           05 rgf-rewrite             pic 9.

       01  filler pic 9.
           88 no-record               value 1 false 0.

       01  rec-grid-segment.
           05 rgs-segment             pic z(2).
           05 rgs-offset              pic z(10).
           05 rgs-size                pic z(3).

       77  file-row                   pic 9(4).
       77  file-col                   pic 9(4).
       77  tab-page                   pic s9(6) value 1.

       01  filler                     pic 9.
           88 New-file-rec            value 1 false 0.

       77  check-exception            pic 9(5).

       01  crerr-status.
           03 file-status             pic xx.
           03 ext-status              pic xxx.
       77  rerrname                   pic x(50).
       
       77  fullname                   pic x any length.
       77  file-handle                handle.

       01  wrk-afs-seg-info.
           05 wrk-afs-seg-info-occurs occurs 16 times.
              10 wrk-afs-key-size     pic 9(3).
              10 wrk-afs-key-offset   pic 9(10).

       77  wrk-color                  pic s9(8).
       77  wrk-font-name              pic x any length.
       77  h-font-awsome              handle of font.
       77  toolbar-characters         pic n any length.

       SCREEN SECTION.
       01  screen-activity.
           03 tab-activity Tab-Control
              line 2.0
              column 2.0
              size 118.0 cells 
              lines 35.0 cells 
              allow-container
              tab-flat
              active-tab-border-width       (0 0 3 0)
              tab-border-width              (0 0 2 0)
              tab-foreground-color          rgb x#ACACAC
              tab-border-color              rgb x#ACACAC
              active-tab-border-color       rgb x#395a9d
              active-tab-background-color   rgb x#dae1e5 
              active-tab-foreground-color   rgb x#354c5c
              value tab-page
              .
           03 tab-activity-1 tab-group tab-activity tab-group-value 1.
              05 gd-file
                 grid
                 line 5
                 column 3
                 size 115 
                 lines 31 
                 width-in-cells
                 height-in-cells
                 color 513
                 event procedure GD-FILE-EVT-PROC
                 boxed
                 centered-headings
                 column-headings
                 use-tab
                 vscroll
                 adjustable-rows
                 adjustable-columns
                 reordering-columns
                 row-dividers 1
                 cursor-background-color rgb x#ffff8e
                 cursor-foreground-color rgb x#100000
                 row-cursor-background-color rgb x#395a9d
                 row-cursor-foreground-color rgb x#cee3f6
                 end-color 16
                 heading-color 513
                 cursor-frame-width 1
                 num-rows -1
                 border-color rgb x#acacac
                 .
           03 tab-activity-2 tab-group tab-activity tab-group-value 2.
              05 gd-activity 
                 Grid
                 line 5
                 column 3
                 size 115 
                 lines 31 
                 width-in-cells
                 height-in-cells
                 color 513
                 event procedure GD-ACTIVITY-EVT-PROC
                 boxed
                 centered-headings
                 column-headings
                 use-tab
                 vscroll
                 adjustable-rows
                 adjustable-columns
                 reordering-columns
                 row-dividers 1
                 cursor-background-color rgb x#ffff8e
                 cursor-foreground-color rgb x#100000
                 row-cursor-background-color rgb x#395a9d
                 row-cursor-foreground-color rgb x#cee3f6
                 end-color 16
                 heading-color 513
                 cursor-frame-width 1
                 num-rows -1
                 border-color rgb x#acacac
                 .

       01  screen-tb-activity.
           03 Push-Button
              exception-value 4
              line 1.3
              column 2
              size 12 cells 
              lines 2 cells 
              hint "(F4)"
              flat
              self-act
              title "&Delete"
              bitmap-handle tools-png
              bitmap-rollover 3
              bitmap-number 1
              bitmap-width 16
              title-position 2
              rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
              .
           03 Push-Button
              exception-value 78-exe-exit
              line 1.3
              column 108
              size 12 cells 
              lines 2 cells 
              flat
              self-act
              title "Exit"
              bitmap-handle tools-png
              square
              bitmap-number 2
              bitmap-rollover 4
              bitmap-width 16
              title-position 2
              rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
              .

       01  screen-key-segment.
           02 gd-segment
              grid
              line 2
              column 3
              size 50 
              lines 17 
              width-in-cells
              color 513
              boxed
              centered-headings
              column-headings
              use-tab
              row-dividers 1
              cursor-background-color rgb x#ffff8e
              cursor-foreground-color rgb x#100000
              row-cursor-background-color rgb x#395a9d
              row-cursor-foreground-color rgb x#cee3f6
              end-color 16
              heading-color 513
              cursor-frame-width 1
              num-rows 17
              border-color rgb x#acacac
              .

       01  screen-tb-key-segment.
           03 Push-Button
              exception-value 78-exe-exit
              line 1.3
              column 43
              size 12 cells 
              lines 2 cells 
              flat
              self-act
              title "Exit"
              bitmap-handle tools-png
              square
              bitmap-number 2
              bitmap-rollover 4
              bitmap-width 16
              title-position 2
              rollover-foreground-color 
                                   rgb 78-pb-toolbar-rollover-color
              .

       PROCEDURE DIVISION.
       DECLARATIVES.
       AUDITFILESETTINGS-ERR section.
           use after standard error procedure on auditfilesettings.
           evaluate status-auditfilesettings
           when 35
                continue
           when other
                perform ERROR-FILE
           end-evaluate.

       AUDITLOGSETTINGS-ERR section.
           use after standard error procedure on auditlogsettings.
           evaluate status-auditlogsettings
           when 35
                continue
           when other
                perform ERROR-FILE
           end-evaluate.

       USERS-ERR section.
           use after standard error procedure on users.
           perform ERROR-FILE.

       END DECLARATIVES.

       MAIN-LOGIC.
           call "J$GETFROMLAF" using jget-laf-font
                                     "Label.font" 
                                     control-font

           perform OPEN-FILES.

           perform LOAD-BITMAPS.

           display independent graphical window 
                   background-low
                   size 120
                   lines 37
                   cell size is label font control-font
                   label-offset 20
                   control font control-font
                   color 513
                   visible 0
                   modeless
                   system menu
                   title-bar
                   no wrap
                   title "Audit Settings"
                   handle w-activity-handle
                   .

           display tool-bar
                   control font control-font
                   color 513
                   handle tb-activity-handle
                   .

           display screen-tb-activity upon tb-activity-handle.
           display screen-activity.

           perform SCREEN-ACTIVITY-SCREEN-SETTINGS.

           perform LOAD-GRIDS.

           modify w-activity-handle visible 1

           perform until key-status = 78-exe-exit
              accept screen-activity
                 on exception 
                    continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform

           perform EXIT-PRG.
           goback
           .

       LOAD-BITMAPS.
           copy resource "../fonts/Font Awesome 5 Free-Solid-900.otf".
           call "w$createfont" 
                       using "Font Awesome 5 Free-Solid-900.otf" 
                             wrk-font-name

           initialize wfont-data
           set wfdevice-console to true
           move wrk-font-name   to wfont-name
           move 10              to wfont-size
           call "W$FONT" using wfont-get-font
                               h-font-awsome
                               wfont-data

           string nx"f2ed" |delete 
                  nx"f2f5" |exit 
                  into toolbar-characters.

           move h-font-awsome               to wbitmap-lsf-font(1)
                                               wbitmap-lsf-font(2)
           move toolbar-characters          to wbitmap-lsf-characters(1)
                                               wbitmap-lsf-characters(2)
           move 78-toolbar-color            to wbitmap-lsf-color(1)
           move 78-toolbar-rollover-color   to wbitmap-lsf-color(2)
           call "W$BITMAP" using wbitmap-load-symbol-font-ex
                                 16
                                 wbitmap-lsf-data
                          giving tools-png
           .

       EXIT-PRG.
           destroy w-activity-handle.
           destroy tb-activity-handle.
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       DESTROY-RESOURCE.
           destroy control-font.
           call "w$bitmap" using wbitmap-destroy tools-png.

       CLOSE-FILE.
           close auditfilesettings.
           close auditlogsettings.
           close users.

       SCREEN-ACTIVITY-SCREEN-SETTINGS.
           modify tab-activity tab-to-add ( "I-O Activity" 
                                            "User Activity").
           perform GD-FILE-CONTENT.
           perform GD-ACTIVITY-CONTENT.

       GD-FILE-CONTENT.
           modify GD-FILE
                  column-dividers ( 1 1 1 1 1 1 1 1 1 1 )
                  data-columns ( 1 21 41 42 43 44 45 46 47 48 )
                  display-columns ( 1 16 31 41 51 61 73 83 93 103 )
                  separation ( 5 5 5 5 5 5 5 5 5 5 )
                  alignment ( "C" "C" "C" "C" "C" "C" "C" "C" "C" "C" )
                  data-types ( "x(-1)" "x(-1)" "9" "9" "9" "9" "9" "9" 
                              "9" "9" ).

           modify gd-file x = 1, y = 1  cell-data "User id".
           modify gd-file x = 2, y = 1  cell-data "Table".
           modify gd-file x = 3, y = 1  cell-data "ALL".
           modify gd-file x = 4, y = 1  cell-data "Open".
           modify gd-file x = 5, y = 1  cell-data "Close".
           modify gd-file x = 6, y = 1  cell-data "Delete Record".
           modify gd-file x = 7, y = 1  cell-data "Delete file".
           modify gd-file x = 8, y = 1  cell-data "Read".
           modify gd-file x = 9, y = 1  cell-data "Insert".
           modify gd-file x = 10, y = 1 cell-data "Update".

           perform varying idx from 3 by 1 until idx > 10
              add 200  to idx giving check-exception
              display Check-Box
                      self-act
                      exception-value check-exception
                      upon GD-FILE (-1 idx)
           end-perform.

       GD-ACTIVITY-CONTENT.
           modify GD-ACTIVITY
                  column-dividers ( 1 1 1 1 1 1 )
                  data-columns ( 1 21 22 23 24 25 )
                  display-columns ( 1 21 39 57 75 93 )
                  separation ( 5 5 5 5 5 5 )
                  alignment ( "C" "C" "C" "C" "C" "C" )
                  data-types ( "x(-1)" "9" "9" "9" "9" "9" )
                  .
           modify gd-activity x = 1, y = 1 cell-data "User id".
           modify gd-activity x = 2, y = 1 cell-data "ALL".
           modify gd-activity x = 3, y = 1 cell-data "Login".
           modify gd-activity x = 4, y = 1 cell-data "Logout".
           modify gd-activity x = 5, y = 1 cell-data "PGM Start".
           modify gd-activity x = 6, y = 1 cell-data "PGM End".

           perform varying idx from 2 by 1 until idx > 6
              add 300  to idx giving check-exception
              display Check-Box  
                      exception-value check-exception
                      self-act
                      upon GD-ACTIVITY (-1 idx)
           end-perform.

       GD-SEGMENT-CONTENT.
           modify gd-segment
                  column-dividers ( 1 1 1)
                  data-columns ( 1 3 13)
                  display-columns ( 15 30)
                  separation ( 5 5 5)
                  alignment ( "C" "R" "R" )
                  data-types ( "Z" "Z(10)" "Z(3)" )
                  .

           modify gd-segment x = 1, y = 1 cell-data "Segment #".
           modify gd-segment x = 2, y = 1 cell-data "Offset".
           modify gd-segment x = 3, y = 1 cell-data "Size".
           modify gd-segment x = 1, column-protection 1.

       GD-ACTIVITY-EVT-PROC.
           evaluate event-type
           when msg-begin-entry
                perform GD-ACTIVITY-EVT-MSG-BEGIN-ENTRY
           when msg-finish-entry
                perform GD-ACTIVITY-EVT-MSG-FINISH-ENTRY
           when msg-goto-cell
           when msg-goto-cell-mouse
           when msg-goto-cell-drag
                perform GD-ACTIVITY-EVT-MSG-GOTO-CELL
           end-evaluate
           .
       GD-FILE-evt-proc.
           evaluate event-type
           when msg-begin-entry
                perform GD-FILE-EVT-MSG-BEGIN-ENTRY
           when msg-finish-entry
                perform GD-FILE-EVT-MSG-FINISH-ENTRY
           when msg-goto-cell
           when msg-goto-cell-mouse
           when msg-goto-cell-drag
                perform GD-FILE-EVT-MSG-GOTO-CELL
           end-evaluate
           .

       AFTER-ACCEPT.
           evaluate key-status
           when 1
                if tab-page = 1
                   inquire gd-file cursor-y file-row 
                   inquire gd-file(file-row) record-data rec-grid-file 
                   perform INPUT-SEGMENT
                   modify gd-file(file-row, 1) 
                                         hidden-data wrk-afs-seg-info  
                   perform SAVE-RECORD-FILE
                end-if
           when 78-exe-delete
                perform DELETE-RECORD
           when 203
                inquire gd-file cursor-y file-row 
                inquire gd-file(file-row) record-data rec-grid-file 
                if rgf-all = 1
                   move 1               to rgf-open
                                           rgf-close
                                           rgf-delete-record 
                                           rgf-delete-file 
                                           rgf-read 
                                           rgf-write 
                                           rgf-rewrite
                    modify gd-file(file-row) 
                                   record-data rec-grid-file
                end-if
                perform SAVE-RECORD-FILE
           when 204
           when 205
           when 206
           when 207
           when 208
           when 209
           when 210
                inquire gd-file cursor-y file-row 
                inquire gd-file(file-row) record-data rec-grid-file
                if (rgf-open          = 0 or  
                    rgf-close         = 0 or
                    rgf-delete-record = 0 or
                    rgf-delete-file   = 0 or
                    rgf-read          = 0 or
                    rgf-write         = 0 or
                    rgf-rewrite       = 0) and
                    rgf-all           = 1
                   modify gd-file(file-row, 3) cell-data = 0
                end-if

                if rgf-open           = 1 and  
                   rgf-close          = 1 and
                   rgf-delete-record  = 1 and
                   rgf-delete-file    = 1 and
                   rgf-read           = 1 and
                   rgf-write          = 1 and
                   rgf-rewrite        = 1 and
                   rgf-all            = 0
                   modify gd-file(file-row, 3) cell-data = 1
                end-if
                perform SAVE-RECORD-FILE

           when 302
                inquire gd-activity cursor-y activity-row 
                inquire gd-activity (activity-row) 
                          record-data rec-grid-activity 
                if rga-all = 1
                   move 1    to rga-login
                                rga-logout
                                rga-pgm-start
                                rga-pgm-end 
                    modify gd-activity(activity-row) 
                          record-data rec-grid-activity
                end-if
                perform SAVE-RECORD-ACTVITY
           when 303
           when 304
           when 305
           when 306
                inquire gd-activity cursor-y activity-row 
                inquire gd-activity (activity-row) 
                          record-data rec-grid-activity 
                if (rga-login      = 0 or  
                    rga-logout     = 0 or
                    rga-pgm-start  = 0 or
                    rga-pgm-end    = 0 ) and
                    rga-all        = 1
                   modify gd-activity(activity-row, 2) cell-data = 0
                end-if

                if rga-login       = 1 and 
                   rga-logout      = 1 and
                   rga-pgm-start   = 1 and
                   rga-pgm-end     = 1 and
                   rga-all         = 1
                   modify gd-activity(activity-row, 2) cell-data = 1
                end-if

                perform SAVE-RECORD-ACTVITY
           end-evaluate.

       SAVE-RECORD-FILE.
           move rgf-users-id          to afs-users-id
           move rgf-file              to afs-file
           if wrk-afs-seg-info = space
              perform LOAD-KEY-INFO
           else
              move wrk-afs-seg-info   to afs-seg-info
           end-if
           move rgf-users-id          to afs-users-id
           move rgf-file              to afs-file
           move rgf-open              to afs-open
           move rgf-close             to afs-close
           move rgf-delete-record     to afs-delete-record
           move rgf-delete-file       to afs-delete-file
           move rgf-read              to afs-read
           move rgf-write             to afs-write
           move rgf-rewrite           to afs-rewrite
           write auditfilesettings-r
              invalid
                 rewrite auditfilesettings-r
           end-write.

       SAVE-RECORD-ACTVITY.
           move rga-users-id       to als-users-id
           move rga-login          to als-login
           move rga-logout         to als-logout
           move rga-pgm-start      to als-pgm-start
           move rga-pgm-end        to als-pgm-end
           write auditlogsettings-r
              invalid
                 rewrite auditlogsettings-r
           end-write
           .

       LOAD-KEY-INFO.
           if rgf-file = "ALL"
              initialize afs-seg-info
              move 100 to afs-key-size(1)
              move 1   to afs-key-offset(1)
              exit paragraph
           end-if
           call "C$FSFULLNAME" using rgf-file, 
                                     fullname
                              giving return-Code.
           if return-code not = zero
              perform MANAGE-FILE-NOT-FOUND
           else
              set open-function to true
              move finput to open-mode    
              call "i$io" using io-function, 
                                fullname, 
                                open-mode, 
                                logical-info
              if return-code = 0
                 perform MANAGE-FILE-NOT-FOUND
              else
                 move return-code to file-handle

                 set info-function to true
                 call "i$io" using io-function
                                   file-handle
                                   0
                                   KEY-INFO
                            giving return-code
                 initialize afs-seg-info
                 perform varying idx from 1 by 1 until idx > NUM-SEGS
                    move KEY-SIZE(idx)   to afs-key-size(idx)
                    add   1  to key-offset(idx) 
                                   giving afs-key-offset(idx)
                 end-perform
              end-if
           end-if.

       MANAGE-FILE-NOT-FOUND.
           read auditfilesettings
              invalid
                 initialize afs-seg-info
           end-read
           if afs-seg-info = all "0"
              display message R"File_not_found"
                             x"0D0A"
                            R"Do_you_want_insert_manually_the_key_info?"
                      type mb-yes-no 
                      giving choice
              if choice = mb-yes 
                 perform INPUT-SEGMENT
                 move wrk-afs-seg-info to afs-seg-info
              end-if
           end-if.

       INPUT-SEGMENT.
           display floating graphical window 
                   background-low
                   size 54
                   lines 29
                   cell size is label font control-font
                   label-offset 20
                   control font control-font
                   color 513
                   visible 0
                   modeless
                   system menu
                   title-bar
                   no wrap
                   title "Audit Settings - Key segment"
                   handle w-segment-handle
                   .

           display tool-bar
                   control font control-font
                   color 513
                   handle tb-segment-handle 
                   .

           display screen-tb-key-segment upon tb-segment-handle.
           display screen-key-segment.

           perform GD-SEGMENT-CONTENT.
           perform LOAD-GRID-KEY-SEGMENTS.

           modify w-segment-handle visible 1

           perform until key-status = 78-exe-exit
              accept screen-key-segment
                 on exception 
                    continue
              end-accept
              move 4 to accept-control
           end-perform

           initialize wrk-afs-seg-info
           perform varying idx from 1 by 1 until idx > 16
              inquire gd-segment(idx + 1) record-data rec-grid-segment
              move rgs-offset   to wrk-afs-key-offset(idx)
              move rgs-size     to wrk-afs-key-size(idx)  
           end-perform.

           destroy w-segment-handle

           initialize key-status.

       LOAD-GRID-KEY-SEGMENTS.
           perform varying idx from 1 by 1 until idx > 16
              move idx                      to rgs-segment
              move wrk-afs-key-offset(idx)  to rgs-offset
              move wrk-afs-key-size(idx)    to rgs-size 
              modify gd-segment record-to-add rec-grid-segment
           end-perform.

       LOAD-GRIDS.
           set no-record  to true.
           move 1   to idx

           move low-value to afs-key
           start auditfilesettings key not < afs-key
              invalid
                 continue
              not invalid
                 perform until 1 = 2
                    read auditfilesettings next no lock
                       at end
                          exit perform
                       not at end
                          add 1 to idx
                          move afs-users-id       to rgf-users-id
                          move afs-file           to rgf-file
                          move afs-open           to rgf-open
                          move afs-close          to rgf-close
                          move afs-delete-record  to rgf-delete-record
                          move afs-delete-file    to rgf-delete-file
                          move afs-read           to rgf-read
                          move afs-write          to rgf-write
                          move afs-rewrite        to rgf-rewrite

                          if afs-open-yes            and
                             afs-close-yes           and
                             afs-delete-record-yes   and
                             afs-delete-file-yes     and
                             afs-read-yes            and
                             afs-write-yes           and
                             afs-rewrite-yes
                             move 1   to rgf-all
                          else
                             move 0   to rgf-all
                          end-if
                          modify gd-file record-to-add rec-grid-file

                          modify gd-file(idx, 1) 
                                            hidden-data  afs-seg-info
                    end-read
                 end-perform
           end-start.
           inquire gd-file(2, 1) hidden-data wrk-afs-seg-info 

           move low-value  to als-key
           start auditlogsettings key not < als-key
              invalid
                 continue
              not invalid
                 perform until 1 = 2
                    read auditlogsettings next no lock
                       at end
                          exit perform
                       not at end 
                          move als-users-id       to rga-users-id
                          move als-login          to rga-login
                          move als-logout         to rga-logout
                          move als-pgm-start      to rga-pgm-start
                          move als-pgm-end        to rga-pgm-end
                          if als-data = "1111"
                             move 1   to rga-all
                          else
                             move 0   to rga-all
                          end-if
                          modify gd-activity 
                                 record-to-add rec-grid-activity
                    end-read
                 end-perform
           end-start.



       GD-FILE-EVT-MSG-BEGIN-ENTRY.
           evaluate event-data-1
           when 1
                if not new-file-rec
                   set event-action   to event-action-fail
                end-if
           when 2
                if not new-file-rec
                   set event-action   to event-action-fail
                end-if
           when other
                if new-file-rec
                   set event-action   to event-action-fail
                end-if
           end-evaluate
           .
           
       GD-ACTIVITY-EVT-MSG-BEGIN-ENTRY.
           evaluate event-data-1
           when 1
                if rga-users-id not = space
                   set event-action   to event-action-fail
                end-if
           when other
                if rga-users-id = space
                  set event-action   to event-action-fail
                end-if
           end-evaluate
           .

       GD-FILE-EVT-MSG-GOTO-CELL.
           perform LOAD-FILE-RECORD
           .

       LOAD-FILE-RECORD.
           move event-data-1 to file-col
           move event-data-2 to file-row
           inquire gd-file(event-data-2) 
                          record-data rec-grid-file.
           if rgf-users-id = space or
              rgf-file = space
              set new-file-rec  to true
           else
              set new-file-rec  to false
           end-if.

           inquire gd-file(file-row, 1) 
                          hidden-data wrk-afs-seg-info.

       DELETE-RECORD.
           display message box 
                          R"Are_you_sure_to_delete_the_selected_record?"
                   type mb-yes-no
                   default mb-no
                   giving choice
           if choice = mb-yes
              if tab-page = 1
                 move rgf-users-id to afs-users-id
                 move rgf-file     to afs-file

                 modify gd-file record-to-delete file-row

                 delete auditfilesettings record
                    invalid
                       continue
                 end-delete
              else
                 move rga-users-id to als-users-id

                 modify gd-activity record-to-delete activity-row

                 delete auditlogsettings record
                    invalid
                       continue
                 end-delete
              end-if
           end-if.
           
       GD-FILE-EVT-MSG-FINISH-ENTRY.
      *    Put here the validation of the column
           evaluate event-data-1
           when 1
                inquire gd-file(event-data-2, event-data-1) 
                       cell-data users-id 
                if users-id not = space
                   read Users no lock
                      invalid
                         display message R"Wrong_User_id"
                         set event-action   to event-action-fail
                   end-read
                end-if
           end-evaluate

           .
       GD-ACTIVITY-EVT-MSG-FINISH-ENTRY.
      *    Put here the validation of the column
           if event-data-1 = 1
              inquire gd-activity (event-data-2, event-data-1) 
                       cell-data users-id 
              if users-id not = space
                 read Users no lock
                    invalid
                       display message R"Wrong_User_id"
                       set event-action   to event-action-fail
                 end-read
              end-if
           end-if
           .

       GD-ACTIVITY-evt-msg-goto-cell.
           perform LOAD-ACTIVITY-RECORD
           .

       LOAD-ACTIVITY-RECORD.
           move event-data-1 to activity-col
           move event-data-2 to activity-row
           inquire gd-activity(event-data-2) 
                                         record-data rec-grid-activity.
           
       OPEN-FILES.
           open i-o auditfilesettings.
           if status-auditfilesettings = 35
              open output auditfilesettings
              perform INITIAL-AUDITFILESETTINGS
              close auditfilesettings
              open i-o auditfilesettings
           end-if.

           open i-o auditlogsettings.
           if status-auditlogsettings = 35
              open output auditlogsettings
              perform INITIAL-AUDITLOGSETTINGS
              close auditlogsettings
              open i-o auditlogsettings
           end-if.

           open input users.

       INITIAL-AUDITFILESETTINGS.
           initialize auditfilesettings-r.
           move R"default_std_user"   to afs-users-id
           move "ALL"                 to afs-file
           set afs-open-yes           to true
           set afs-close-yes          to true
           set afs-delete-record-yes  to true
           set afs-delete-file-yes    to true
           set afs-read-yes           to true
           set afs-write-yes          to true
           set afs-rewrite-yes        to true
           move 100                   to afs-key-size(1)
           move 1                     to afs-key-offset(1)
           write auditfilesettings-r.

       INITIAL-AUDITLOGSETTINGS.
           initialize auditlogsettings-r.
           move R"default_user"       to als-users-id
           set als-login-yes          to true
           set als-logout-yes         to true
           set als-pgm-start-yes      to true
           set als-pgm-end-yes        to true
           write auditlogsettings-r.

           move R"default_std_user"   to als-users-id
           write auditlogsettings-r.

       ERROR-FILE.
           call "C$RERR"     using crerr-status
           call "C$RERRNAME" using rerrname
           display message "Error " file-status "-" 
                           ext-status " on " rerrname  
                   title "Audit Settings"
                   icon 2.
           goback.
           
