      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. textviewer is initial.

       configuration section.
       repository.
           class ijb as "com.iscobol.gui.server.CobolGUIJavaBean"
           class jbool as "java.lang.Boolean"
           .

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select the-file assign to filename
           organization binary sequential.

       FILE SECTION.
       FD  the-file.
       01  file-row pic x(32000).

       WORKING-STORAGE SECTION.
       copy "iscobol.def".
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "isresize.def".
       77  crt-status    special-names crt status pic 9(5).
       77  hWin          handle of window.
       77  close-win     pic 9 value 0. 
       77  filename      pic x(256).
       77  param-info    pic 9(5). 
       77  read-size     pic 9(9). 
       77  ef-content    pic x any length.
       77  mem-area      handle.
       77  curr-offset   pic 9(9) value 1.
       01  file-info.   
        02  file-size    pic x(8) comp-x.   
        02  file-date    pic 9(8) comp-x.   
        02  file-time    pic 9(8) comp-x.   
       01  number-of-record  pic  9(18).
       01  lenght-of-last   pic  9(5).
 
       77  cobolw-obj     object reference ijb.

       01                pic 9.
           88  use-javabean  value 1 false zero.

       77  cont        pic 9(2).
       77  classpath   pic x any length.

       77  como-color  pic x(20).
       77  win-line    pic 9(3)v99.
       77  win-col     pic 9(3)v99.
       
       77  title-window   pic x any length.

       LINKAGE SECTION.
       77  lk-filename       pic x(256).
       77  offset-line-txtv  pic s9(3)v9(10).
       77  offset-col-txtv   pic s9(3)v9(10).

       SCREEN SECTION.
       01  cobol-viewer
              java-bean
              clsid  "com.iscobol.misc.javabeans.CobolSourceViewer"
              enabled 1
              boxed
              color  513
              line   1
              col    1 
              size   80 cells
              lines  30 cells
              object cobolw-obj
              event viewer-evt
              .

       01  ef entry-field read-only
              no-autosel, no-box color 513
              multiline
              line 1, col 1
              lines 30 cells, size 80 cells
              vscroll-bar
              value ef-content.

       PROCEDURE DIVISION using lk-filename 
                                offset-line-txtv
                                offset-col-txtv.
       MAIN.
           set environment "gui.curr_ef_bcolor"   to "-16777215"

           call "C$NARG" using param-info
           if param-info < 1
              goback
           end-if

           if param-info > 2
              compute win-line = 28 + offset-line-txtv
           else
              move 27  to win-line
           end-if
           if param-info = 3
              compute win-col = 5 + offset-col-txtv
           else
              move 5 to win-col
           end-if

           call "C$PARAMSIZE" using 1, giving param-info
           move lk-filename(1:param-info) to filename
                                             title-window

           call "C$FILEINFO" using filename, file-info
           call "M$ALLOC"    using file-size, mem-area

           set use-javabean to true
           move zero   to cont
           inspect filename tallying cont for all ".html"
           if cont > zero
              set use-javabean  to false
           end-if

           display standard graphical window
                   background-low
                   col win-col
                   line win-line 
                   lines  30 
                   size 80
                   min-lines  30 
                   min-size 80
                   with system menu
                   title  title-window 
                   control font fixed-font
                   resizable layout-manager lm-zoom
                   handle hWin
                   event  WIN-EVT

           set read-size  to size of file-row.
           divide read-size into file-size
                  giving number-of-record
                  remainder lenght-of-last.

           open input the-file

           perform number-of-record times
              read the-file  
              perform PUT-IN-MEMORY
           end-perform

           if lenght-of-last > zero
              move lenght-of-last to read-size
              read the-file
              perform PUT-IN-MEMORY
           end-if

   
           call "M$GET" using mem-area, ef-content
           call "M$FREE" using mem-area

           close the-file

           if use-javabean
              perform SHOW-JAVABEAN
           else
              perform SHOW-ENTRYFIELD
           end-if

           destroy hWin
           goback
           .

       PUT-IN-MEMORY.
           call "M$PUT" using mem-area, file-row(1:read-size)
                              read-size, curr-offset
           add read-size to curr-offset
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win  
           end-evaluate
           .

       VIEWER-EVT.
           if event-type = msg-validate
              set event-action to event-action-continue
           end-if.

       SHOW-JAVABEAN.
           display cobol-viewer
           cobolw-obj:>setProperty ( "showAreaDividers" jbool:>TRUE)
           cobolw-obj:>callMethod("setStringContents" ef-content)

           accept cobol-viewer until crt-status = 27 or close-win = 1
                  on exception
                     continue
           end-accept.
           destroy cobol-viewer.

       SHOW-ENTRYFIELD.
           display ef
           accept ef until crt-status = 27 or close-win = 1
                  on exception
                     continue
           end-accept
           destroy ef.
