      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. dispersion.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  var1                    pic s9(9).    
       77  var2                    pic s9(9).

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              size                 20 cells
              title                "Input two values:" 
              .
           03 Ef-Val1
              entry-field
              numeric
              line                 2
              col                  + 2 
              size                 18 
              value                var1
              .                        
           03 Ef-Val1
              entry-field
              numeric
              line                 2
              col                  + 2 
              size                 18 
              value                var2
              .
           03 push-button
              line                 4
              col                  2
              size                 25
              title                "Show standard deviation"
              exception-value      11
              self-act
              .
           03 push-button
              line                 6
              col                  2
              size                 18
              title                "Show variance"
              exception-value      12
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "STD.DEV and VARIANCE Functions"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    evaluate crt-status
                    when 11
                         perform STD
                    when 12
                         perform VARIANCE
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       STD.
           display message box function standard-deviation (var1, var2)
                   title "Standard Deviation"
           .
       VARIANCE.
           display message box function variance (var1, var2)
                   title "Variance"
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move EVENT-ACTION-FAIL-TERMINATE  to EVENT-ACTION 
                move 1 to close-win
           end-evaluate
           .
