      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. oct2dec.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  control-font            handle of font. 
       77  close-win               pic 9 value 0.

       77  oct-val                 pic x(5) value "777". 
       77  dec-val                 pic 9(5). 

       77  c                       pic 9.
       77  w-digit                 pic x.
           88 is-oct-digit         values "0", "1", "2", "3", 
                                          "4", "5", "6", "7".

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              size                 20 cells
              title                "Input an octal value:" 
              .
           03 ef-oct-val
              entry-field
              numeric
              line                 4
              col                  2
              size                 18 
              max-text             5
              value                oct-val
              notify-change
              event                EV-EF-OCT-VAL
              .
           03 push-button
              line                 6
              col                  2
              size                 30
              title                "Show &decimal value"
              exception-value      11
              self-act
              .
           03  Pb-exit  
               push-button
               line                20 
               col                 62 
               size                8 cells
               self-act
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "OCT2DEC Function"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask
             
           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception
                    if crt-status = 11
                       perform CALCULATION
                    end-if
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       CALCULATION.
           move function oct2dec (oct-val)  to dec-val
           display message box dec-val
                   title "Decimal value"
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move EVENT-ACTION-FAIL-TERMINATE  to EVENT-ACTION 
                move 1 to close-win
           end-evaluate
           .

       EV-EF-OCT-VAL.
           if event-type = ntf-changed
              inquire ef-oct-val value oct-val
              initialize c
              inspect oct-val tallying c 
                           for characters before initial trailing space
              move oct-val(c:1) to w-digit
              if not is-oct-digit
                 move spaces to oct-val(c:1)
                 modify ef-oct-val value oct-val
                                   cursor c
              end-if
              set event-action to event-action-continue
           end-if
           .
           