      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. chips-box.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isfonts.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  h-notif                 handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       77  chip-number             pic 9(3).
       77  chip-type               pic 9 value 1.
       77  chip-text               pic x any length.
       
       77  wrk-color               pic s9(9).
       77  item-id                 pic 999.

       78  78-bmp-width            value 20.

       77  choice                  pic 9.

       77  wrk-message             pic x any length.

       77  wrk-list                pic x any length.
       77  idx                     pic 9(3).

       01  image-color.
           05 filler               pic s9(10) value -5988295.
           05 filler               pic s9(10) value -12962810.
      *
           05 filler               pic s9(10) value -9853793.
           05 filler               pic s9(10) value -16046295.
      *
           05 filler               pic s9(10) value -5662784.
           05 filler               pic s9(10) value -15134173.
      *
           05 filler               pic s9(10) value -1458729.
           05 filler               pic s9(10) value -13623510.
      *
           05 filler               pic s9(10) value -1257785.
           05 filler               pic s9(10) value -13621984.

       01  image-color-occurs      redefines image-color.
           05 filler               occurs 5.
              10 image-fg-color    pic s9(10).
              10 image-bg-color    pic s9(10).

       01  image-handle-occurs.
           05 image-handle         pic s9(9) comp-4 occurs dynamic
                                             capacity num-image.
           05 image-2-handle       pic s9(9) comp-4 occurs dynamic
                                             capacity num-image-2.

       77  color-idx               pic 9 value 0.

       77  icon-text               pic x(2).

       77  radius-factor           pic 9(3) value 100.

       78  78-chip-color-1         value -946895.
       78  78-chip-color-2         value -16777215.

       77  notif-text              pic x any length.
       
       01  hidden-chip.
           05 hidden-image-idx     pic 9(3).
           05 hidden-selected      pic 9.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              title                "Chip number:"
              .
           03 ef-chip-number
              entry-field
              line                 2
              col                  14
              numeric
              size                 4 cells
              value                chip-number
              .
           03 label
              line                 2
              col                  22
              title                "Chip radius:"
              .
           03 sli-radius
              slider 
              show-ticks 
              horizontal
              col                  33
              line                 2
              size                 37
              height-in-cells
              width-in-cells
              max-val              100
              min-val              0
              minor-tick-spacing   5
              major-tick-spacing   100
              value                radius-factor
              event                EV-SLI-RADIUS
              .
           03 label
              line                 4
              col                  2
              title                "Chip text:"
              .
           03 entry-field
              line                 4
              col                  14
              size                 55 cells
              value                chip-text
              .
           03 push-button
              line                 6 
              col                  14 
              size                 8 cells
              title                "Add"
              exception-value      101
              .
           03 push-button
              line                 6 
              col                  25
              size                 8 cells
              title                "Modify"
              exception-value      102
              .
           03 push-button
              line                 6 
              col                  37
              size                 8 cells
              title                "Delete"
              exception-value      103
              .
           03 push-button
              line                 6 
              col                  49 
              size                 8 cells
              title                "Reset"
              exception-value      104
              .
           03 push-button
              line                 6 
              col                  61
              size                 8 cells
              title                "List"
              exception-value      105
              .
           03 chips
              chips-box
              line                 8
              column               2
              size                 68
              lines                10
              chips-type           2
              event CHIP-EVT
              .
           03 Pb-exit
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       01  mask-notification.
           03 Label
              line              2
              column            5
              size              35 
              foreground-color  rgb x#CFCFCF
              title             "<HTML><b>Removed Chip</b></HTML>"
              transparent
              .

           03 Label
              line              3
              column            5
              lines             2
              size              20
              title             notif-text
              foreground-color  rgb x#939392
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CHIPS-BOX Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask.

           initialize image-handle-occurs.

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4 to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           perform DESTROY-IMAGES
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101
                perform ADD-CHIP
           when 102
                perform MODIFY-CHIP
           when 103
                perform DELETE-CHIP
           when 104
                perform RESET-CHIPS
           when 105
                perform CHIPS-LIST
           end-evaluate
           .

       ADD-CHIP.
           perform CREATE-IMAGE-CHIP

           move idx to hidden-image-idx
           move 0 to hidden-selected

           modify chips item-to-add chip-text 
                        bitmap image-handle(idx)
                        bitmap-number 1
                        bitmap-width 78-bmp-width
                        item-foreground-color 78-chip-color-1
                        item-background-color 78-chip-color-2
                        item-border-color -946895
                        item-rollover-background-color -14019325
                        item-rollover-foreground-color -678063
                        item-rollover-border-Color -678063
                        hidden-data hidden-chip
                        giving item-id
           .

       MODIFY-CHIP.
           if chip-number = 0
              display message "Invalid chip number"
           else
              modify chips(chip-number) item-text chip-text 
           end-if
           .

       DELETE-CHIP.
           if chip-number = 0
              display message "Invalid chip number"
           else
              inquire chips(chip-number) item-text chip-text
              display message "Are you sure to delete the Chip " x"0D0A"
                              "'" chip-text "'?"
                              type mb-yes-no 
                              giving choice 
              if choice = mb-yes 
                 modify chips item-to-delete chip-number 
              end-if
           end-if
           .

       RESET-CHIPS.
           display message "Are you sure to rest the Chip List?"
                           type mb-yes-no 
                           giving choice 
           if choice = mb-yes 
              modify chips reset-list 1
              perform DESTROY-IMAGES
              initialize image-handle-occurs
           end-if
           .
       
       CHIPS-LIST.
           inquire chips last-item chip-number 
           initialize wrk-list
           move "List of Chips:"   to wrk-list
           perform varying idx from 1 by 1 until idx > chip-number 
              inquire chips(idx) item-text chip-text
                                 hidden-data hidden-chip 
              if hidden-selected = 1
                 string wrk-list   delimited by size
                        x"0D0A"    delimited by size
                        "*"        delimited by size
                        chip-text  delimited by trailing space
                        into wrk-list 
              else
                 string wrk-list   delimited by size
                        x"0D0A"    delimited by size
                        chip-text  delimited by trailing space
                        into wrk-list 
              end-if
           end-perform.
           
           display message wrk-list 
           .

       CHIP-EVT.
           evaluate event-type
           when cmd-clicked
                move event-data-1  to chip-number
                inquire chips(chip-number) hidden-data hidden-chip 
                evaluate hidden-selected
                when 0
                     move 1  to hidden-selected
                     modify chips 
                                bitmap image-2-handle(hidden-image-idx)
                                hidden-data  hidden-chip
                when 1
                     move 0  to hidden-selected
                     modify chips 
                                bitmap image-handle(hidden-image-idx)
                                hidden-data  hidden-chip
                end-evaluate
                modify ef-chip-number value chip-number 
           when msg-close
                move event-data-1 to chip-number
                inquire chips(chip-number) item-text notif-text 
                perform SHOW-CLOSE-MESSAGE
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       SHOW-CLOSE-MESSAGE.
           display notification window
                   bottom right
                   before time 500
                   lines 4
                   size  30
                   visible 0
                   background-color rgb x#343332
                   handle h-notif
           display mask-notification upon h-notif 
           modify h-notif visible 1
           .

       CREATE-IMAGE-CHIP.
           initialize icon-text.
           unstring function trim(chip-text) delimited by space
                    into icon-text(1:1)
                         icon-text(2:1)
           if icon-text(2:1) = space
              move function trim(chip-text)(2:1)  to icon-text(2:1)
           end-if

           add 1 to color-idx.
           if color-idx > 5
              move 1   to color-idx
           end-if

           initialize wbitmap-tb-data

           set wbitmap-tb-circle   to true

           move control-font       to wbitmap-tb-font
           move 78-bmp-width       to wbitmap-tb-width
           
           move image-fg-color(color-idx)   to wbitmap-tb-text-color
           move image-bg-color(color-idx)   to wbitmap-tb-bg-color
           move -1                          to wbitmap-tb-grd-or

           add 1 to num-image giving idx

           call "w$bitmap" using wbitmap-text-box 
                                 function upper-case (icon-text) 
                                 wbitmap-tb-data
                          giving image-handle(idx)

           move image-bg-color(color-idx)   to wbitmap-tb-text-color
           move image-fg-color(color-idx)   to wbitmap-tb-bg-color
           call "w$bitmap" using wbitmap-text-box 
                                 function upper-case (icon-text) 
                                 wbitmap-tb-data
                          giving image-2-handle(idx)
           .

       DESTROY-IMAGES.
           perform varying idx from 1 by 1 until idx > num-image
              call "W$BITMAP" using wbitmap-destroy, image-handle(idx)
              call "W$BITMAP" using wbitmap-destroy, image-2-handle(idx)
           end-perform
           .

       EV-SLI-RADIUS.
           evaluate event-type
           when msg-sl-thumb
                inquire sli-radius value radius-factor
                modify chips chips-radius radius-factor
           end-evaluate
           .
