      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. entry-field.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status                 special-names crt status pic 9(5).
       77  hWin                          handle of window.
       77  close-win                     pic 9 value 0.
       77  control-font                  handle of font.
       77  h-ef-icon                     pic s9(9) comp-4.
       01  ef-bmp-status                 pic 9.
           88 ef-bmp-no-action           value zero.
           88 ef-bmp-left-bmp-click      value 1.
           88 ef-bmp-right-bmp-click     value 2.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                       2
              col                        2
              size                       12 cells
              title                      "Normal:"
              .
           03 entry-field
              line                       2
              col                        16
              size                       19 cells
              .
           03 label
              line                       2
              col                        38
              size                       12 cells
              title                      "Spinner:"
              .
           03 entry-field
              auto-spin
              right
              min-val                    1 
              max-val                    100
              line                       2
              col                        50
              size                       19 cells
              value                      1
              .
           03 label
              line                       4
              col                        2
              size                       12 cells
              title                      "Numeric:"
              .
           03 entry-field
              numeric
              line                       4
              col                        16
              size                       19 cells
              .
           03 label
              line                       4
              col                        38
              size                       12 cells
              title                      "Secure:"
              .
           03 entry-field
              secure
              line                       4
              col                        50
              size                       19 cells
              .
           03 label
              line                       6
              col                        2
              size                       12 cells
              title                      "Read Only:"
              .
           03 entry-field
              read-only
              line                       6
              col                        16
              size                       19 cells
              value                      "read only text"
              .
           03 label
              line                       6
              col                        38
              size                       12 cells
              title                      "Placeholder"
              .
           03 entry-field
              line                       6
              col                        50
              size                       19 cells
              placeholder                "Type the value"
              .
           03 label
              line                       8
              col                        2
              size                       12 cells
              title                      "Border-color:"
              .
           03 entry-field 
              line                       8
              col                        16
              size                       19 cells
              border-color               -16711731
              .
           03 label
              line                       8
              col                        38
              size                       10 cells    
              title                      "Bitmap:"
              .
           03 ef-bmp 
              entry-field
              line                       8
              col                        50
              size                       19 cells
              bitmap-handle              h-ef-icon
              bitmap-width               16
              bitmap-number              1
              bitmap-trailing-number     3
              bitmap-trailing-rollover   2
              bitmap-hint                "Click here to fire ef-bmp-left
      -                                  "-bmp-click event"
              bitmap-trailing-hint       "Click here to fire ef-bmp-righ
      -                                  "t-bmp-click event"
              event                      EF-BMP-EV
              .
           03 label
              line                       10
              col                        2
              size                       12 cells    
              title                      "Border-width:"
              .
           03 entry-field 
              line                       10
              col                        16
              size                       19 cells
              border-color               -10079487
              border-width               (0 1 2 1)
              .
           03 label
              line                       10
              col                        38
              size                       12 cells
              title                      "Margin-width:"
              .
           03 entry-field 
              line                       10
              col                        50
              size                       19 cells
              margin-width               (1, 10, 1, 10)
              value                      "Margin of 10 px"
              placeholder                "Entry-field with margin"
              .
           03 label
              line                       12
              lines                      2
              col                        2
              size                       12 cells
              title                      "Proposal: (USA states)"
              .
           03 ef-p
              entry-field
              line                       12
              col                        16
              size                       19 cells
              .
           03 label
              line                       12
              lines                      2
              col                        38
              size                       12 cells
              title                      "Format String: (Date)"
              .
           03 entry-field
              line                       12
              col                        50
              size                       19 cells
              format-string              "##/##/####"
              .
           03 label
              line                       15
              col                        2
              size                       12 cells
              title                      "Multiline:"
              .
           03 entry-field
              multiline 
              vscroll-bar 
              use-return
              line                       15 
              col                        16
              lines                      4 cells 
              size                       19 cells
              value                      "This is a long text that will 
      -                                  "wrap automatically"
              .  
           03 label
              line                       15
              lines                      2
              col                        38
              size                       12 cells
              title                      "Multiline no-wrap:"
              .
           03 entry-field
              multiline 
              vscroll-bar 
              use-return
              line                       15
              col                        50
              lines                      4 cells 
              size                       19 cells
              no-wrap
              value                      "This is a long text that will 
      -                                  "not wrap automatically"
              .  
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           set ef-bmp-no-action to true.
           call "W$BITMAP" using wbitmap-load, "files/ef-icon.png"
                          giving h-ef-icon.

           set environment "gui.curr_ef_bcolor" to "-14675438"
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "ENTRY-FIELD Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           modify ef-p reset-proposals 1
           modify ef-p proposal
                       ( "Alabama",
                         "Alaska",
                         "Arizona",
                         "Arkansas",
                         "California",
                         "Colorado",
                         "Connecticut",
                         "Delaware",
                         "Florida",
                         "Georgia",
                         "Hawaii",
                         "Idaho",
                         "Illinois",
                         "Indiana",
                         "Iowa",
                         "Kansas",
                         "Kentucky",
                         "Louisiana",
                         "Maine",
                         "Maryland",
                         "Massachusetts",
                         "Michigan",
                         "Minnesota",
                         "Mississippi",
                         "Missouri",
                         "Montana",
                         "Nebraska",
                         "Nevada",
                         "New Hampshire",
                         "New Jersey",
                         "New Mexico",
                         "New York",
                         "North Carolina",
                         "North Dakota",
                         "Ohio",
                         "Oklahoma",
                         "Oregon",
                         "Pennsylvania",
                         "Rhode Island",
                         "South Carolina",
                         "South Dakota",
                         "Tennessee",
                         "Texas",
                         "Utah",
                         "Vermont",
                         "Virginia",
                         "Washington", 
                         "West Virginia",
                         "Wisconsin",
                         "Wyoming"
                         )

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception 
                    continue
              end-accept
              evaluate true
              when ef-bmp-left-bmp-click
                   set ef-bmp-no-action  to true
                   display message "Clicked on left bitmap"
              when ef-bmp-right-bmp-click
                   set ef-bmp-no-action  to true
                   display message "Clicked on right bitmap"
              end-evaluate
              move 4   to accept-control
           end-perform  
           
           destroy Mask
           destroy hWin    
           destroy control-font
           call "W$BITMAP" using wbitmap-destroy, h-ef-icon
           goback
           .

       EF-BMP-EV.
           evaluate event-type
           when msg-bitmap-clicked
                evaluate EVENT-DATA-1
                when 1
                     set event-action to event-action-terminate
                     set ef-bmp-left-bmp-click to true
                     
                when 2
                     set event-action to event-action-terminate
                     set ef-bmp-right-bmp-click   to true
                end-evaluate
           end-evaluate.

       win-evt.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
