      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. grid-on-demand.

       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
     
       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".

       77  crt-status              special-names crt status pic 9(5).
       77  hMain                   handle of window.
       77  hWin                    handle of window.
       77  close-win               pic 9    value 0.

       01  gd-rec.
           03 gd-cod               pic z(4)9.
           03 gd-name              pic x(40).
           03 gd-zip               pic x(5).
           03 gd-date              pic 99/99/9999.
           03 gd-amount            pic zzz,zzz,zz9.99.

       01  dateGMA                 pic 9(8).

       77  an-cod-bk               pic 9(9).

       77  control-font            handle of font.

       77  idx                     pic 9(3).

       77  wrk-cod                 pic 9(5).

       77  fetch-size              pic 9(3) value 100.
       77  num-row                 pic 9(5).
       77  num-row-ed              pic z(4)9.

       77  font-name               pic x any length.
       77  icon-characters         pic n any length.
       
       77  h-font                  handle of font.
       77  icon-color              pic s9(9) value -4804695.
       77  h-font-icon             pic s9(9) comp-4.
       
       77  wrk-cursor-y            pic 9(5).
       
       78  78-pb-add-page-ex       value 101.
       78  78-pb-load-all-ex       value 102.
       78  78-pb-first-ex          value 103.
       78  78-pb-previous-ex       value 104.
       78  78-pb-next-ex           value 105.
       78  78-pb-last-ex           value 106.
       
       78  78-max-loaded-rows      value 10000.

       77                          pic 9 value 0.
           88 data-at-end          value 1 false 0.

       77  choice                  pic 9.
       77  wrk-title-num-row       pic x any length.

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       SCREEN SECTION.
       01  Mask.
           03 gd 
              grid 
              lod-threshold        80
              line                 2
              col                  2
              lines                9
              size                 68 cells
              heading-color        257
              border-color         rgb x#ACACAC
              boxed
              column-headings 
              row-headings 
              centered-headings
              tiled-headings
              Adjustable-Columns
              vscroll
              display-columns      (1, 11, 31, 37, 50)
              data-columns         (record-position of gd-cod
                                    record-position of gd-name
                                    record-position of gd-zip
                                    record-position of gd-date
                                    record-position of gd-amount)
              alignment            ("C", "L", "L", "C", "C" )
              separation           (0, 0, 0, 0)
              protection            1
              row-background-color-pattern = (-16777215, -14675438)
              event                GD-EVT
              .
           03 label
              line                 18
              col                  2
              title                "Fetch size"
              .
           03 ef-fetch
              entry-field
              line                 18
              col                  11
              numeric
              value                fetch-size
              .
           03 bar
              line                 17.6
              col                  + 2
              lines                2
              width                2
              color                16
              shading              (-1, 1)
              .
           03 pb-add-page
              push-button
              line                 17.6
              col                  + 2
              lines                2 cells
              size                 14 cells
              bitmap               h-font-icon
              bitmap-width         16
              bitmap-number        5
              title                "Fetch more"
              title-position       2
              exception-value      78-pb-add-page-ex
              self-act
              .
           03 pb-load-all
              push-button
              line                 17.6
              col                  + 2
              lines                2 cells
              size                 14 cells
              bitmap               h-font-icon
              bitmap-width         16
              bitmap-number        6
              title                "Fetch all"
              title-position       2
              exception-value      78-pb-load-all-ex
              self-act
              .
           03 bar
              col                  + 2
              lines                2
              width                2
              color                16
              shading              (-1, 1)
              .
           03 pb-first
              push-button
              line                 17.6
              col                  + 2
              lines                2 cells
              size                 16
              bitmap               h-font-icon
              bitmap-width         16
              bitmap-number        1
              title                "First"
              exception-value      78-pb-first-ex
              self-act
              .
           03 pb-previous
              push-button
              line                 17.6
              col                  + 2
              lines                2 cells
              size                 16
              bitmap               h-font-icon
              bitmap-width         16
              bitmap-number        2
              title                "Previous"
              exception-value      78-pb-previous-ex
              self-act
              .
           03 pb-next
              push-button
              line                 17.6
              col                  + 2
              lines                2 cells
              size                 16
              bitmap               h-font-icon
              bitmap-width         16
              bitmap-number        3
              title                "Next"
              exception-value      78-pb-next-ex
              self-act
              .
           03 pb-last
              push-button
              line                 17.6
              col                  + 2
              lines                2 cells
              size                 16
              bitmap               h-font-icon
              bitmap-width         16
              bitmap-number        4
              title                "Last"
              exception-value      78-pb-last-ex
              self-act
              .
           03 label
              line                 20
              col                  2
              title                "Loaded rows:"
              .
           03 lbl-tot-row
              label
              line                 20
              col                  15
              title                num-row
              .
           03 push-button
              line                 20 
              col                  39
              size                 20 cells
              title                "View &Source [F2]"
              exception-value      2
              .
           03 push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.

           accept base-sorg-path from environment "home_source".
           call "w$createfont" 
                       using "files/Font Awesome 6 Free-Solid-900.otf" 
                             font-name
           initialize wfont-data
           set wfdevice-console to true
           move font-name       to wfont-name
           move 10              to wfont-size
           CALL "W$FONT" using wfont-get-font
                               h-font
                               wfont-data
                               
           set data-at-end   to false

           string nx"f100"   delimited by size
                  nx"f104"   delimited by size
                  nx"f105"   delimited by size
                  nx"f101"   delimited by size
                  nx"2b"     delimited by size
                  nx"f1da"   delimited by size
                  into icon-characters.
           CALL "W$BITMAP" using wbitmap-load-symbol-font, 
                                      h-font
                                      icon-characters
                                      16
                                      icon-color
                               giving h-font-icon


           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "GRID Load on demand feature"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT
                   control font control-font

           display mask

           modify gd(1,1) cell-data "Code"
           modify gd(1,2) cell-data "Name"
           modify gd(1,3) cell-data "Zip"
           modify gd(1,4) cell-data "Date"
           modify gd(1,5) cell-data "Price"

           move 0   to wrk-cod
           perform LOAD-RECORD

           perform until crt-status = 27 or close-win = 1
              accept  mask
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform 

           destroy mask
           destroy hMain
           destroy control-font
           call "W$BITMAP" using wbitmap-destroy, h-font-icon 
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 2
                perform VIEW-SORG
           when 78-pb-add-page-ex 
                perform LOAD-RECORD 
           when 78-pb-load-all-ex
                display message "Would you like to fetch all records?"
                                x"0D0A"
                                "This could take a while..."
                                type mb-yes-no
                                giving choice
                if choice = mb-yes
                   perform LOAD-ALL-RECORDS
                end-if 
           when 78-pb-first-ex
                modify gd cursor-x 1
           when 78-pb-previous-ex
                inquire gd cursor-y wrk-cursor-y
                subtract 1  from wrk-cursor-y
                if wrk-cursor-y < 2
                   move 2 to wrk-cursor-y
                end-if
                modify gd cursor-y wrk-cursor-y 
           when 78-pb-next-ex
                inquire gd cursor-y wrk-cursor-y
                add 1  to wrk-cursor-y
                modify gd cursor-y wrk-cursor-y 
           when 78-pb-last-ex
                inquire gd last-row wrk-cursor-y
                modify gd cursor-y wrk-cursor-y 
           end-evaluate
           .

       GD-EVT.
           evaluate event-type
           when MSG-LOAD-ON-DEMAND
                perform LOAD-RECORD
           end-evaluate.

       LOAD-RECORD.
           modify gd mass-update 1
           perform fetch-size times
              add 1 to wrk-cod
              if wrk-cod > 78-max-loaded-rows
                 set data-at-end   to true
                 exit perform
              end-if
              perform ADD-RECORD
           end-perform
           perform UPDATE-NUM-ROWS
           
           modify gd MASS-UPDATE 0
           .

       LOAD-ALL-RECORDS.
           modify gd mass-update 1
           modify gd reset-grid 3
           set data-at-end   to false
           move 0   to wrk-cod
           perform until data-at-end
              add 1 to wrk-cod
              if wrk-cod > 78-max-loaded-rows
                 set data-at-end   to true
                 exit perform
              end-if
              perform ADD-RECORD
           end-perform
           perform UPDATE-NUM-ROWS
           modify gd MASS-UPDATE 0
           .

       ADD-RECORD.
           move wrk-cod   to gd-cod
           move "name"    to gd-name
           move gd-cod    to gd-name(6:)
           move 01012014  to gd-date
           move 2500      to gd-amount 
           modify gd record-to-add gd-rec
           .

       UPDATE-NUM-ROWS.
           inquire gd last-row num-row
           subtract 1 from num-row
           
           move num-row   to num-row-ed
           if data-at-end 
              initialize wrk-title-num-row
              string function triml(num-row-ed) 
                     " AT END"   delimited by size
                     into wrk-title-num-row
           else
              move function triml(num-row-ed) to wrk-title-num-row
           end-if
           
           modify lbl-tot-row   title wrk-title-num-row
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path         delimited by trailing space
                  "s-gui"                delimited by space
                  "/GRID-ON-DEMAND.cbl"  delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.
