      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. label.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  title-html              pic x any length.
       77  path-gif                pic x any length.
       77  path-user-home          pic x any length.
       77  path-client-image       pic x any length.
       77  path-copy-client-image  pic x any length.
       77  wstatus                 pic s9.
       77  sel-bg-color            pic s9(9).
       77  sel-fg-color            pic s9(9).

       01  file-info.
           02  file-size           pic x(8) comp-x.
           02  file-date           pic 9(8) comp-x.
           02  file-time           pic 9(8) comp-x.

       77  Intro-Text              pic x any length.

       77  Lb-event-title          pic x any length.

       78  78-lb-event-mouse-enter 
           value '<html><font face="Arial" size="4" color="#1A0DAB"><b><
      -          'u>hyperlink label</u></b></font></html>'.

       78  78-lb-event-mouse-exit
           value '<html><font face="Arial" size="4" color="#1A0DAB">hype
      -          'rlink label</font></html>'.

       SCREEN SECTION.
       01  Mask. 
           03 Lb1 
              label
              line                 2 
              col                  2 
              size                 20 cells
              transparent
              background-color     RGB x#CEDBE1
              title                "common label"
              .
           03 Lb2 
              label
              line                 4 
              col                  2 
              lines                2 cells 
              size                 20 cells
              transparent
              title                '<html><font face="Arial" size="4" co
      -                            'lor="#0000FF"><b><i>html label</i></
      -                            'b></font></html>'
              .
           03 Lb-event 
              label
              line                 6.2
              lines                1.5
              col                  2
              size                 30 cells
              transparent
              title                Lb-event-title
              event                LBL-EVT
              hint                 "www.veryant.com"
              notify-mouse
              .
           03 LbB3 
              label
              line                 2 
              col                  25
              lines                5 cells
              size                 9 cells
              title                title-html 
              .
           03 Label 
              col                  4
              line                 10 
              lines                5 
              size                 15 
              foreground-color     sel-fg-color 
              background-color     sel-bg-color 
              TITLE                Intro-Text.
           03 Label 
              col                  20
              line                 10
              lines                5 
              size                 15 
              left
              foreground-color     sel-fg-color 
              background-color     sel-bg-color 
              title                intro-text.
           03 Label 
              COL                  36
              line                 10
              lines                5 
              size                 15
              center 
              foreground-color     sel-fg-color 
              background-color     sel-bg-color 
              title                intro-text.
           03 Label, 
              COL                  52
              line                 10
              lines                5
              size                 15
              right 
              foreground-color     sel-fg-color 
              background-color     sel-bg-color 
              title                intro-text.
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           move 78-lb-event-mouse-exit to Lb-event-title

           accept terminal-abilities from terminal-info.
           perform LOAD-HTML.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           call "J$GETFROMLAF" using jget-laf-color
                                     "List.selectionBackground"
                                     sel-bg-color
           call "J$GETFROMLAF" using jget-laf-color
                                     "List.selectionForeground"
                                     sel-fg-color.
           move "This is a multiline label and shows the various alignme
      -         "nt styles" to Intro-Text

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "LABEL Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept mask
                 on exception 
                    continue
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin 
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       LBL-EVT.
           evaluate event-type
           when msg-mouse-enter
                move 78-lb-event-mouse-enter to Lb-event-title
                modify Lb-event title lb-event-title
                call "W$MOUSE" using set-mouse-shape, 
                                     help-pointer 
           when msg-mouse-exit
                move 78-lb-event-mouse-exit to Lb-event-title
                modify Lb-event title lb-event-title 
                call "W$MOUSE" using set-mouse-shape, 
                                     arrow-pointer
           when msg-mouse-clicked
           when msg-mouse-dblclick
                call "C$DESKTOP" using cdesktop-browse 
                                        "https://www.veryant.com"
                                        1
           end-evaluate
           .

       LOAD-HTML.
           initialize title-html.

           if is-remote
              call client "C$GETENV" USING "user.home"
                                           path-user-home
              initialize path-client-image
              string path-user-home   delimited by trailing space
                     "/lb.gif"        delimited by size
                    into path-client-image

              call client "C$FILEINFO" using path-client-image, 
                                             file-info
                                      giving wstatus

              evaluate wstatus
                       when 0
                            continue
                       when 1
                            initialize path-copy-client-image
                            string "@[DISPLAY]:"      delimited by size
                                   path-client-image  delimited by size
                            into path-copy-client-image
                            CALL "C$COPY" USING "files/lb.gif" 
                                                path-copy-client-image
              end-evaluate
              move path-client-image  to path-gif
           else
              move "files/lb.gif" to path-gif
           end-if
           
           string '<html><img src="file:'   delimited by size
                  path-gif                  delimited by trailing space
                  '"></img></html>'         delimited by size
                  into title-html.