      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. list-box.

       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".

       77  crt-status              special-names crt status pic 9(5).
       77  hMain                   handle of window.
       77  hWin                    handle of window.
       77  close-win               pic 9    value 0.

       77  cont                    pic 9(2) value 0.

       77  item-name               pic x(50).

       01  dateGMA                 pic 9(8).

       77  an-cod-bk               pic 9(9).

       77  title-list              pic x(170).
       77  title-paged-list        pic x(170).
       77  control-font            handle of font.
      *selection colors
       77  sel-bg-color            pic s9(9).
       77  sel-fg-color            pic s9(9).
       
       77  idx                     pic 9(3).

       01  tab-album.
      ***
           03 filler pic x(30) value "Let It Be".
      ***
           03 filler pic x(30) value "Yellow Submarine".
      ***
           03 filler pic x(30) value "Help!".
      ***
           03 filler pic x(30) value "Yesterday".
      ***
           03 filler pic x(30) value "Angie".
      ***
           03 filler pic x(30) value "Start Me Up".
      ***
           03 filler pic x(30) value "Satisfaction".
      ***
           03 filler pic x(30) value "Rain Fall Down".
      ***
           03 filler pic x(30) value "Maria Maria".
      ***
           03 filler pic x(30) value "Oye como va".
      ***
           03 filler pic x(30) value "Lightning in the sky".
      ***
           03 filler pic x(30) value "Foo Foo".
      ***
           03 filler pic x(30) value "Money for Nothing".
      ***
           03 filler pic x(30) value "After Midnight".
      ***
           03 filler pic x(30) value "Bad Love".
      ***
           03 filler pic x(30) value "Next Time You See Her".
      ***
           03 filler pic x(30) value "Albachiara".
      ***
           03 filler pic x(30) value "Tango".
      ***
           03 filler pic x(30) value "C'e' chi dice no". 
      ***
           03 filler pic x(30) value "Bollicine".

       01  tab-album-red     redefines tab-album.
           03 ta-item        occurs 20.
              05 ta-title    pic x(30).

       SCREEN SECTION.
       01  Mask.
           03 frame
              engraved
              line                 2
              col                  3
              size                 32
              lines                11
              title                "Standard List-box"
              .
           03 push-button 
              line                 4 
              col                  4 
              size                 15 
              title                "List-box" 
              exception-value      1
              .
           03 label
              line                 6
              lines                6
              col                  4
              size                 30
              title                title-list
              .
           03 frame
              engraved
              line                 2
              col                  38
              size                 32
              lines                11
              title                "Paged List-box"
              .
           03 push-button 
              line                 4 
              col                  39 
              size                 15 
              title                "Paged List-box"
              exception-value      2
              .
           03 label
              line                 6
              lines                6
              col                  39
              size                 30
              title                title-paged-list 
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           initialize title-list
           string "This is the standard list-box used to show a list of"
                  " possible choices. The user can pick one of them."
                  x"0A"
                  "It shows scroll-bars to show more data if required."
                  delimited by size
                  into title-list

           initialize title-paged-list
           string "This paged list-box is suggested when handling a "
                "large amount of data, to save memory and loading time." 
                  x"0A"
                  "It only loads one screen of data at a time."
                  delimited by size
                  into title-paged-list

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "LIST-BOX and PAGED LIST-BOX Controls"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT
                   control font control-font

           display mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status
              when 1 
                   call run "LIST-STD"
              when 2 
                   call run "LIST-PAGED"
              end-evaluate
              move  4  to accept-control
           end-perform 

           destroy Mask
           destroy hMain
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
