      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. "MESSAGE-BOX-CUSTOM" initial.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       copy "isfonts.def".
       copy "iscobol.def".

       77  crt-status                 special-names crt status pic 9(5).
       77  close-win                  pic 9 value 0.
       77  hWin                       handle of window.
       77  rc                         pic s9 value -1.
       77  pb-1-col                   pic 99 value 0.
       77  pb-2-col                   pic 99 value 0.
       77  pb-3-col                   pic 99 value 0.
       77  pb-1-vis                   pic 9 value 0.
       77  pb-2-vis                   pic 9 value 0.
       77  pb-3-vis                   pic 9 value 0.
       77  pb-1-title                 pic x any length.
       77  pb-2-title                 pic x any length.
       77  pb-3-title                 pic x any length.
       77  pb-1-exec                  pic 9.
       77  pb-2-exec                  pic 9.
       77  pb-3-exec                  pic 9.
       77  id-ok                      pic 9 value 0.
       77  id-yes                     pic 9 value 0.
       77  id-no                      pic 9 value 0.
       77  id-cancel                  pic 9 value 0.
       77  id-abort                   pic 9 value 0.
       77  id-ignore                  pic 9 value 0.
       77  id-retry                   pic 9 value 0.
       77  id-continue                pic 9 value 0.
       
       78  78-id-pb-1                 value 1.
       78  78-id-pb-2                 value 2.
       78  78-id-pb-3                 value 3.

       77  control-font               handle of font.
       
       77  wrk-gradient-color-1       pic s9(8).
       77  wrk-gradient-color-2       pic s9(8).

       77  time-out-rc                pic s9 value -1.

       LINKAGE SECTION. 
       77  msgbox-text                pic x any length.
       77  msgbox-title               pic x any length.
       77  msgbox-type                pic 9. 
       77  msgbox-icon                pic 9(5). 
       77  msgbox-btn-default         pic 9. 
       77  msgbox-timeout             pic 9(5).
       77  msgbox-centered            pic 9.

       SCREEN SECTION.
       01  Mask.   
           03 frame 
              line                    1 
              col                     2 
              size                    38 
              lines                   9.5
              full-height
              transparent
              .
           03 label
              title                   msgbox-text
              line                    3
              lines                   6
              col                     3
              size                    35
              centered
              transparent
              .
           03 push-button
              title                   pb-1-title
              line                    11
              col                     pb-1-col
              id                      78-id-pb-1
              visible                 pb-1-vis
              exception-value         pb-1-exec
              .
           03 push-button
              title                   pb-2-title
              line                    11
              col                     pb-2-col
              id                      78-id-pb-2
              visible                 pb-2-vis
              exception-value         pb-2-exec
              .
           03 btn3 
              push-button
              title                   pb-3-title
              line                    11
              col                     pb-3-col
              id                      78-id-pb-3
              visible                 pb-3-vis
              exception-value         pb-3-exec
              .

       procedure division using msgbox-text
                                msgbox-title
                                msgbox-type 
                                msgbox-icon
                                msgbox-btn-default
                                msgbox-timeout
                                msgbox-centered
                                .
       MAIN.
           perform LOAD-FONT.

           evaluate msgbox-type
           when MB-OK
                move 1             to pb-3-vis
                move "Ok"          to pb-3-title
                move 30            to pb-3-col
                move MB-YES        to pb-3-exec
                move 78-id-pb-3    to id-ok
                move mb-ok         to time-out-rc
           when MB-YES-NO
                move 1             to pb-2-vis
                move "Yes"         to pb-2-title
                move 20            to pb-2-col
                move MB-YES        to pb-2-exec
                move 78-id-pb-2    to id-yes
                move 1             to pb-3-vis
                move "No"          to pb-3-title
                move 30            to pb-3-col
                move MB-NO         to pb-3-exec
                move 78-id-pb-3    to id-no
                move mb-yes        to time-out-rc
           when MB-OK-CANCEL
                move 1             to pb-2-vis
                move "Ok"          to pb-2-title
                move 20            to pb-2-col
                move 78-id-pb-2    to id-ok
                move MB-YES        to pb-2-exec
                move 1             to pb-3-vis
                move "Cancel"      to pb-3-title
                move 30            to pb-3-col
                move MB-CANCEL     to pb-3-exec
                move 78-id-pb-3    to id-cancel
                move mb-ok         to time-out-rc
           when MB-YES-NO-CANCEL
                move 1             to pb-1-vis
                move "Yes"         to pb-1-title
                move 10            to pb-1-col
                move MB-YES        to pb-1-exec
                move 78-id-pb-1    to id-yes
                move 1             to pb-2-vis
                move "No"          to pb-2-title
                move 20            to pb-2-col
                move MB-NO         to pb-2-exec
                move 2             to id-no
                move 1             to pb-3-vis
                move "Cancel"      to pb-3-title
                move 30            to pb-3-col
                move MB-CANCEL     to pb-3-exec
                move 78-id-pb-3    to id-cancel
                move mb-yes        to time-out-rc
           when MB-RETRY-CANCEL
                move 1             to pb-2-vis
                move "Retry"       to pb-2-title
                move 20            to pb-2-col
                move MB-RETRY      to pb-2-exec
                move 78-id-pb-2    to id-retry
                move 1             to pb-3-vis
                move "Cancel"      to pb-3-title
                move 30            to pb-3-col
                move MB-CANCEL     to pb-3-exec
                move 78-id-pb-3    to id-cancel
                move mb-retry      to time-out-rc
           when MB-ABORT-RETRY-IGNORE
                move 1             to pb-1-vis
                move "Abort"       to pb-1-title
                move 10            to pb-1-col
                move MB-ABORT      to pb-1-exec
                move 78-id-pb-1    to id-abort
                move 1             to pb-2-vis
                move "Retry"       to pb-2-title
                move 20            to pb-2-col
                move MB-RETRY      to pb-2-exec
                move 2             to id-retry
                move 1             to pb-3-vis
                move "Ignore"      to pb-3-title
                move 30            to pb-3-col
                move MB-IGNORE     to pb-3-exec
                move 78-id-pb-3    to id-ignore
                move mb-abort      to time-out-rc
           when MB-CANCEL-RETRY-CONTINUE
                move 1             to pb-1-vis
                move "Cancel"      to pb-1-title
                move 10            to pb-1-col
                move MB-CANCEL     to pb-1-exec
                move 78-id-pb-1    to id-cancel
                move 1             to pb-2-vis
                move "Retry"       to pb-2-title
                move 20            to pb-2-col
                move MB-RETRY      to pb-2-exec
                move 2             to id-retry
                move 1             to pb-3-vis
                move "Continue"    to pb-3-title
                move 30            to pb-3-col
                move MB-CONTINUE   to pb-3-exec
                move 78-id-pb-3    to id-continue
                move mb-cancel     to time-out-rc
           end-evaluate

           move -16777215 to wrk-gradient-color-1
           move -7178966  to wrk-gradient-color-2

           if msgbox-icon > 0
              evaluate msgbox-icon
              when MB-DEFAULT-ICON
                   move -7178966  to wrk-gradient-color-2
              when MB-WARNING-ICON
                   move -16776960 to wrk-gradient-color-2
              when MB-ERROR-ICON
                   move -16724736 to wrk-gradient-color-2
              end-evaluate
           end-if

           display floating graphical window
                   lines  12
                   size   40
                   gradient-color-1 wrk-gradient-color-1
                   gradient-color-2 wrk-gradient-color-2 
                   title msgbox-title
                   control font control-font
                   handle hWin
                   visible 0
                   event  WIN-EVT

           if msgbox-centered = 1
              call "W$CENTER_WINDOW" using hWin
           end-if

           display Mask

           modify hWin visible 1

           move 0 to rc
           move 0 to crt-status
           move 0 to close-win

           if msgbox-btn-default > 0
              evaluate msgbox-btn-default
              when MB-OK
                   move id-ok         to control-id
              when MB-YES
                   move id-yes        to control-id
              when MB-NO
                   move id-no         to control-id
              when MB-CANCEL
                   move id-cancel     to control-id
              when MB-ABORT
                   move id-abort      to control-id
              when MB-IGNORE
                   move id-ignore     to control-id
              when MB-CONTINUE
                   move id-continue   to control-id
              when MB-RETRY
                   move id-retry      to control-id
              end-evaluate
              move msgbox-btn-default to time-out-rc
           end-if
           move 4 to accept-control

           perform until crt-status = 99 or
                         crt-status = 27 or 
                         close-win = 1
              if msgbox-timeout > 0
                 accept Mask before time msgbox-timeout
                    on exception 
                       continue 
                 end-accept
              else
                 accept Mask 
                    on exception 
                       continue 
                 end-accept
              end-if 
              evaluate crt-status
              when 99 
                   move time-out-rc   to rc
              when MB-YES
              when MB-NO
              when MB-CANCEL
              when MB-RETRY
              when MB-IGNORE
              when MB-CONTINUE
              when MB-ABORT
                   move crt-status to rc
                   move 1 to close-win
              end-evaluate
           end-perform 
 
           destroy Mask
           destroy hWin
           goback rc
           .

       LOAD-FONT.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           initialize wfont-data
           call "W$FONT" using WFONT-DESCRIBE-FONT
                               control-font
                               wfont-data

           add 3 to wfont-size
           call "W$FONT" using wfont-get-font 
                               control-font 
                               wfont-data
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
