      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. RIBBON.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       77  hRibbon                 handle of ribbon.
       77  hBmpRB                  pic s9(9) comp-4.
       77  hBmpPaste               pic s9(9) comp-4.
       77  hEf                     handle of entry-field.
       77  hFontTimes10            handle of font.
       77  hFontTimes11            handle of font.
       77  hFontTimes12            handle of font.
       77  hFontCourier10          handle of font.
       77  hFontCourier11          handle of font.
       77  hFontCourier12          handle of font.

       78  78-id-cb-font-name      value 101.
       78  78-id-cb-font-size      value 102.

       01  ef-custom-data.
           05 ef-font-name         pic x(15).
           05 ef-font-size         pic 99.

       01  new-custom-data.
           05 new-font-name        pic x(15).
           05 new-font-size        pic 99.

       77  wrk-Times-New-Roman     pic x any length.
       77  wrk-Courier-New         pic x any length.

       77  h-win-ribbon            handle of window.

       77  floating-column         pic 9(3)v999.
       77  ef-value                pic x any length.
       77  save-control-id         pic xx comp-x.

       78  78-rgb-yellow           value -16777088.
       78  78-rgb-blue             value -33023.
       78  78-rgb-red              value -16711680.
       78  78-rgb-green            value -8454016.

       78  78-grb-bar-b            value -16777215.
       78  78-grb-bar-f            value -13290186.

       01                          pic X.
           88 change-background    value "B".
           88 change-foreground    value "F".


       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              size                 8 cells
              title                "Title:"
              .
           03 Ef1 
              entry-field
              line                 2
              col                  12
              size                 54 cells
              id                   1
              custom-data          ef-custom-data
              font                 hFontTimes11
              before               BEFORE-EF
              .    
           03 label
              line                 4 
              col                  2
              size                 8 cells
              title                "Length:"
              .
           03 Ef2
              entry-field
              line                 4
              col                  12
              size                 54 cells
              id                   2   
              custom-data          ef-custom-data
              font                 hFontTimes11
              before               BEFORE-EF
              .       
           03 label
              line                 6
              col                  2
              size                 8 cells
              title                "Artist:"
              custom-data          ef-custom-data
              .
           03 Ef3
              entry-field
              line                 6
              col                  12
              size                 54 cells
              id                   3     
              custom-data          ef-custom-data
              font                 hFontTimes11
              before               BEFORE-EF
              .
           03 label
              line                 8
              col                  2
              size                 8 cells
              title                "Genre:"
              .
           03 Ef4
              entry-field    
              line                 8
              col                  12
              size                 54 cells
              id                   4     
              custom-data          ef-custom-data
              font                 hFontTimes11
              before               BEFORE-EF
              .
           03 label
              line                 10
              col                  2
              size                 8 cells
              title                "Label:"
              .
           03 Ef5
              entry-field
              line                 10
              col                  12
              size                 54 cells
              id                   5
              custom-data          ef-custom-data
              font                 hFontTimes11
              before               BEFORE-EF
              .
           03 label
              line                 12
              col                  2
              size                 8 cells
              title                "Year:"
              .
           03 Ef6
              entry-field
              line                 12
              col                  12
              size                 54 cells
              id                   6     
              custom-data          ef-custom-data
              font                 hFontTimes11
              before               BEFORE-EF
              .
           03 Pb-exit  
              push-button
              line                 15 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
  
       01  Ribbon-page-1.
           03 Push-Button
              line 1.3
              column 1
              size 36
              lines 38
              id 6
              flat
              self-act
              title "Paste"
              bitmap-handle        hBmpPaste
              bitmap-number        1
              on-header
              exception-value      103
              .
           03 Push-Button
              line                 1.1
              column               8
              size                 50
              lines                16
              flat
              self-act
              title "Cut"
              bitmap-handle        hBmpRB
              bitmap-number        1
              bitmap-width         16
              title-position       2
              on-header
              exception-value      101
              .
           03 Push-Button
              line 3.2
              column 9
              size 48
              lines 16
              flat
              self-act
              title "Copy"
              bitmap-handle        hBmpRB
              bitmap-number        2
              bitmap-width         16
              title-position       2
              exception-value      102
              on-header
              .
           03 Bar
              line                 1.1
              column               + 2
              lines                4 cells 
              background-color     78-grb-bar-b 
              foreground-color     78-grb-bar-f
              .
           03 cb-font-name
              Combo-Box
              drop-list
              line                 1.3
              column               21
              size                 18 cells 
              lines                3 cells 
              id                   78-id-cb-font-name
              item-to-add         (wrk-Courier-New, wrk-Times-New-Roman)
              notify-selchange
              event procedure      EVENT-CB-FONT-NAME
              .
           03 cb-font-size
              Combo-Box
              drop-list
              line                 1.3
              column               + 1
              size                 7 cells 
              lines                5 cells 
              id                   78-id-cb-font-size
              item-to-add          ("10", "11", "12")
              notify-selchange
              event procedure      EVENT-CB-FONT-SIZE
              .
           03 Push-Button
              line                 1.3
              column               + 1.5
              size                 16
              lines                16
              flat
              self-act
              title                "Enlarge character"
              bitmap-handle        hBmpRB
              bitmap-number        3
              exception-value      105
              .
           03 Push-Button
              line                 1.3
              column               + 1
              size                 16
              lines                16
              flat
              self-act
              title                "Reduce character"
              bitmap-handle        hBmpRB
              bitmap-number        4
              exception-value      106
              .
           03 Bar
              line                 1.3
              column               + 1.5
              lines                4 cells 
              background-color     78-grb-bar-b 
              foreground-color     78-grb-bar-f
              .
           03 pb-change-case
              Push-Button
              line                 3.2
              column               21
              size                 16
              lines                16
              flat
              self-act
              title                "upper/lower case"
              bitmap-handle        hBmpRB
              bitmap-number        5
              exception-value      107
              .
           03 Push-Button
              line                 3.2
              column               + 1
              size                 16
              lines                16
              flat
              self-act
              bitmap-handle        hBmpRB
              bitmap-number        9
              exception-value      107
              .
           03 Bar
              line                 3.2
              column               + 1.1
              lines                2.1 cells 
              background-color     78-grb-bar-b 
              foreground-color     78-grb-bar-f
              .
           03 pb-foreground-color
              Push-Button
              line                 3.2
              column               + 1.1
              size                 16
              lines                16
              flat
              self-act
              title                "Background color"
              bitmap-handle        hBmpRB
              bitmap-number        6
              exception-value      108
              .
           03 Push-Button
              line                 3.2
              column               + 0.9
              size                 16
              lines                16
              flat
              self-act
              bitmap-handle        hBmpRB
              bitmap-number        9
              exception-value      108
              .
           03 Push-Button
              line                 3.2
              column               + 1
              size                 16
              lines                16
              flat
              self-act
              title                "Foreground color"
              bitmap-handle        hBmpRB
              bitmap-number        7
              exception-value      109
              .
           03 Push-Button
              line                 3.2
              column               + 1
              size                 16
              lines                16
              flat
              self-act
              bitmap-handle        hBmpRB
              bitmap-number        9
              exception-value      109
              .

       01  Ribbon-page-2.
           03 push-button 
              title                "Your Function"
              title-position       2
              hint                 "Execute Your Function"
              self-act
              line                 1.5
              col                  2  
              lines                16 
              size                 16 cells
              bitmap 
              bitmap-handle        hBmpRB
              bitmap-number        8
              bitmap-width         16
              exception-value      104
              .

       01  screen-change-case.
           03 Bar
              line                 1
              column               3
              lines                5 cells 
              background-color     78-grb-bar-b 
              foreground-color     78-grb-bar-f
              .
           03 Push-Button
              line                 1
              column               4
              size                 15 cells 
              lines                2 cells 
              flat
              self-act
              title                "Lower Case"
              exception-value      201
              .
           03 Push-Button
              line                 3
              column               4
              size                 15 cells 
              lines                2 cells 
              flat
              self-act
              title                "Upper Case"
              exception-value      202
              .
       01  screen-change-color.
           03 Frame
              line                 1
              column               1.1 
              size                 3
              lines                2 
              full-height
              fill-color           78-rgb-yellow
              .
           03 Frame
              line                 3
              column               1.1
              size                 3 cells 
              lines                2 cells 
              full-height
              fill-color           78-rgb-blue
              .
           03 Frame
              line                 5
              column               1.1
              size                 3 cells 
              lines                2 cells 
              full-height
              fill-color           78-rgb-red
              .
           03 Frame
              line                 7
              column               1.1
              size                 3 cells 
              lines                2 cells 
              full-height
              fill-color           78-rgb-green
              .
           03 Bar
              line                 1
              column               5
              lines                8 cells 
              background-color     78-grb-bar-b 
              foreground-color     78-grb-bar-f
              .
           03 Push-Button
              line                 1
              column               6
              size                 15 cells 
              lines                2 cells 
              flat
              self-act
              title                "Yellow"
              exception-value      301
              .
           03 Push-Button
              line                 3
              column               6
              size                 15 cells 
              lines                2 cells 
              flat
              self-act
              title                "Blue"
              exception-value      302
              .
           03 Push-Button
              line                 5
              column               6
              size                 15 cells 
              lines                2 cells 
              flat
              self-act
              title                "Red"
              exception-value      303
              .
           03 Push-Button
              line                 7
              column               6
              size                 15 cells 
              lines                2 cells 
              flat
              self-act
              title                "Green"
              exception-value      304
              .

       PROCEDURE DIVISION.
       MAIN.
           call "W$BITMAP" using wbitmap-load, "files/ribbontool.png"
                          giving hBmpRB.

           call "W$BITMAP" using wbitmap-load, "files/ribbonpaste.png"
                          giving hBmpPaste.

           perform LOAD-FONT.

           move wrk-Times-New-Roman to ef-font-name
           move 11                 to ef-font-size

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "RIBBON Control"
                   control font control-font
                   lines 16 
                   min-lines 16
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           modify hWin mass-update 1

           display Mask

           display ribbon
                   lines 5
                   handle  hRibbon
                   upon hWin
                   HEADER-ALIGN = 1

           modify hRibbon, tab-to-add = ("Page 1", "Page 2" )

           display Ribbon-page-1 upon hRibbon(1).
           display Ribbon-page-2 upon hRibbon(2).

           modify hWin mass-update 0

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception 
                    continue
              end-accept
              move control-handle to hEf
              evaluate crt-status
              when 101 
                   perform CUT-TEXT
              when 102 
                   perform COPY-TEXT
              when 103 
                   perform PASTE-TEXT
              when 104
                   display message box "Your function"
              when 105
                   perform PLUS-CRT
              when 106
                   perform SUB-CRT
              when 107
                   perform CHANGE-CASE
              when 108
                   set change-background to true
                   perform CHANGE-COLOR
              when 109
                   set change-foreground to true
                   perform CHANGE-COLOR
              when 96 
                   evaluate event-control-id
                   when 78-id-cb-font-name
                   when 78-id-cb-font-size
                        perform CHANGE-FONT
                   end-evaluate
              end-evaluate
              move 4 to accept-control
           end-perform

           destroy Mask
           destroy hRibbon
           destroy hWin
           destroy control-font
           destroy hFontCourier10
           destroy hFontCourier11
           destroy hFontCourier12
           destroy hFontTimes10
           destroy hFontTimes11
           destroy hFontTimes12
           call "W$BITMAP" using wbitmap-destroy, hBmpRB
           call "W$BITMAP" using wbitmap-destroy, hBmpPaste
           goback
           .
        
       COPY-TEXT.
           modify hEf action action-copy
           .

       CUT-TEXT.
           modify hEf action action-cut
           .

       PASTE-TEXT.
           modify hEf action action-paste
           .
            
       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       EVENT-CB-FONT-NAME.
           evaluate event-type
      *> set focus for the ribbon
           when cmd-goto
              accept cb-font-name
           end-evaluate.

       EVENT-CB-FONT-SIZE.
           evaluate event-type
      *> set focus for the ribbon
           when cmd-goto
              accept cb-font-size
           end-evaluate.
       
       CHANGE-FONT.
           inquire cb-font-name value new-font-name 
           inquire cb-font-size value new-font-size 

           evaluate new-font-name also new-font-size
           when wrk-Courier-New also 10
                modify hEf font hFontCourier10 
           when wrk-Courier-New also 11
                modify hEf font hFontCourier11 
           when wrk-Courier-New also 12
                modify hEf font hFontCourier12 
           when wrk-Times-New-Roman also 10
                modify hEf font hFontTimes10  
           when wrk-Times-New-Roman also 11
                modify hEf font hFontTimes11  
           when wrk-Times-New-Roman also 12
                modify hEf font hFontTimes12  
           end-evaluate.

           move new-custom-data to ef-custom-data.
           modify hEf CUSTOM-DATA ef-custom-data.

       LOAD-FONT.
           call "w$createfont" using "files/times.ttf" 
                                     wrk-Times-New-Roman
           call "w$createfont" using "files/cour.ttf" 
                                    wrk-Courier-New

           initialize wfont-data

           set wfdevice-console       to true.
           move wrk-Times-New-Roman   to wfont-name
           move 10                    to wfont-size

           CALL "W$FONT" USING WFONT-GET-FONT
                               hFontTimes10
                               WFONT-DATA

           move 11             to wfont-size
           CALL "W$FONT" USING WFONT-GET-FONT
                               hFontTimes11
                               WFONT-DATA

           move 12             to wfont-size
           CALL "W$FONT" USING WFONT-GET-FONT
                               hFontTimes12
                               WFONT-DATA


           move wrk-Courier-New to wfont-name
           move 10              to wfont-size
           CALL "W$FONT" USING WFONT-GET-FONT
                               hFontCourier10
                               WFONT-DATA

           move 11             to wfont-size
           CALL "W$FONT" USING WFONT-GET-FONT
                               hFontCourier11
                               WFONT-DATA

           move 12             to wfont-size
           CALL "W$FONT" USING WFONT-GET-FONT
                               hFontCourier12
                               WFONT-DATA.

       BEFORE-EF.
           move control-handle to hEf
           inquire hEf CUSTOM-DATA ef-custom-data
           move ef-custom-data  to new-custom-data
           modify cb-font-name value new-font-name 
           modify cb-font-size value new-font-size. 
       
       PLUS-CRT.
           if ef-font-size < 12
              add 1 to ef-font-size 
              modify hEf custom-data ef-custom-data
              modify cb-font-size value ef-font-size
              perform CHANGE-FONT
           end-if.
           
       SUB-CRT.
           if ef-font-size > 10
              subtract 1 from ef-font-size 
              modify hEf custom-data ef-custom-data
              modify cb-font-size value ef-font-size
              perform CHANGE-FONT
           end-if.

       CHANGE-CASE.
           move control-id   to save-control-id

           inquire pb-change-case col floating-column
           add 0.7 to floating-column

           display floating  graphical window
                   line 8.1
                   column floating-column
                   size 18
                   lines 4
                   modeless
                   user-gray
                   user-white
                   handle h-win-ribbon
                   control font control-font
                   .

           display screen-change-case upon h-win-ribbon.

           accept screen-change-case 
              on exception
                 continue
           end-accept
           destroy h-win-ribbon.
           
           evaluate crt-status 
           when 201
                inquire hEf value ef-value
                modify hEf value function lower-case (ef-value)
           when 202
                inquire hEf value ef-value
                modify hEf value function upper-case (ef-value) 
           end-evaluate.

           move save-control-id   to control-id.
           move zero               to crt-status.

       CHANGE-COLOR.
           move control-id   to save-control-id

           inquire pb-foreground-color col floating-column
           add 0.7 to floating-column

           display floating  graphical window
                   line 8.1
                   column floating-column
                   size 20
                   lines 8.1
                   modeless
                   user-gray
                   user-white
                   handle h-win-ribbon
                   control font control-font
                   height-in-cells
                   width-in-cells
                   .

           display screen-change-color upon h-win-ribbon.

           accept screen-change-color 
              on exception
                 continue
           end-accept
           destroy h-win-ribbon.
           
           evaluate true
           when change-background 
                evaluate crt-status 
                when 301
                     modify hEf background-color 78-rgb-yellow 
                when 302
                     modify hEf background-color 78-rgb-blue  
                when 303
                     modify hEf background-color 78-rgb-red 
                when 304
                     modify hEf background-color 78-rgb-green 
                end-evaluate
           when change-foreground 
                evaluate crt-status 
                when 301
                     modify hEf foreground-color 78-rgb-yellow 
                when 302
                     modify hEf foreground-color 78-rgb-blue  
                when 303
                     modify hEf foreground-color 78-rgb-red 
                when 304
                     modify hEf foreground-color 78-rgb-green 
                end-evaluate
           end-evaluate.

           move save-control-id   to control-id.
           move zero              to crt-status.
