      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. slider.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  close-win               pic 9    value 0.
       77  control-font            handle of font.

       77  sl-value                pic 9(5) value 0.
       77  sel-bg-color            pic s9(9).

       SCREEN SECTION.
       01  Mask. 
           03 Sl1 
              slider 
              show-ticks 
              show-labels
              horizontal 
              line                 2 
              col                  2 
              lines                3 cells 
              size                 68 cells
              event                SL-EVT
              .
           03 Fr1
              frame
              line                 5
              col                  2
              lines                2  cells
              size                 68 cells
              fill-color           sel-bg-color
              fill-percent         0
              .
           03 frame
              title                "value:"
              line                 9
              engraved
              col                  2
              lines                4  cells
              size                 68 cells
              .
           03 Lb1 
              label
              line                 11
              col 3
              size                 66 cells
              centered
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "J$GETFROMLAF" using jget-laf-color
                                     "List.selectionBackground"
                                     sel-bg-color
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "SLIDER Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception 
                    continue
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .
       
       SL-EVT.    
           evaluate event-type
           when msg-sl-thumb
                inquire Sl1 value sl-value
                modify  Lb1 title sl-value
                modify Fr1 fill-percent sl-value
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
