      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. tab-std.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  hInd                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       77  page1-visible           pic 9 value 1.
       77  page2-visible           pic 9 value 0.
       77  page3-visible           pic 9 value 0.

       01  tab-album.
      ***
           03 filler pic x(30) value "Let It Be".
           03 filler pic x(20) value "Beatles".
      ***
           03 filler pic x(30) value "Yellow Submarine".
           03 filler pic x(20) value "Beatles".
      ***
           03 filler pic x(30) value "Help!".
           03 filler pic x(20) value "Beatles".
      ***
           03 filler pic x(30) value "Yesterday".
           03 filler pic x(20) value "Beatles".
      ***
           03 filler pic x(30) value "Angie".
           03 filler pic x(20) value "The Rolling Stones".
      ***
           03 filler pic x(30) value "Start Me Up".
           03 filler pic x(20) value "The Rolling Stones".
      ***
           03 filler pic x(30) value "Satisfaction".
           03 filler pic x(20) value "The Rolling Stones".
      ***
           03 filler pic x(30) value "Rain Fall Down".
           03 filler pic x(20) value "The Rolling Stones".
      ***
           03 filler pic x(30) value "Maria Maria".
           03 filler pic x(20) value "Santana".
      ***
           03 filler pic x(30) value "Oye como va".
           03 filler pic x(20) value "Santana".
      ***
           03 filler pic x(30) value "Lightning in the sky".
           03 filler pic x(20) value "Santana".
      ***
           03 filler pic x(30) value "Foo Foo".
           03 filler pic x(20) value "Santana".
      ***
           03 filler pic x(30) value "Money for Nothing".
           03 filler pic x(20) value "Eric Clapton".
      ***
           03 filler pic x(30) value "After Midnight".
           03 filler pic x(20) value "Eric Clapton".
      ***
           03 filler pic x(30) value "Bad Love".
           03 filler pic x(20) value "Eric Clapton".
      ***
           03 filler pic x(30) value "Next Time You See Her".
           03 filler pic x(20) value "Eric Clapton".
      ***
           03 filler pic x(30) value "Albachiara".
           03 filler pic x(20) value "Vasco Rossi".
      ***
           03 filler pic x(30) value "Tango".
           03 filler pic x(20) value "Vasco Rossi".
      ***
           03 filler pic x(30) value "C'e' chi dice no". 
           03 filler pic x(20) value "Vasco Rossi".
      ***
           03 filler pic x(30) value "Bollicine".
           03 filler pic x(20) value "Vasco Rossi".

       01  tab-album-red     redefines tab-album.
           03 ta-item        occurs 20.
              05 ta-title    pic x(30).
              05 ta-Artist   pic x(20).
              
       77  cont              pic 9(2).

       SCREEN SECTION.

       01  Mask.
           03 Tb1-std 
              tab-control
              line                 2 
              col                  2
              lines                17 cells
              size                 68 cells
              event                TAB-EVT
              .
           03 Tb1-std-Pages.
              05 TB1-std-PAGE1 
                 visible           page1-visible
                 .
                 07 label 
                    line           4
                    col            4
                    title          "This is the first page"
                    .
                 07 ef1-std 
                    entry-field
                    line           6
                    col            4
                    .
              05 TB1-STD-PAGE2 
                 visible           page2-visible
                 .
                 07 label
                    line           4
                    col            4 
                    title          "This is the second page"
                    .
                 07 cb1-std
                    combo-box
                    line           6
                    col            4
                    .
              05 tb1-std-page3 
                 visible           page3-visible
                 .
                 07 label
                    line           4
                    col            4 
                    title          "This is the third page"
                    .
                 07 LS1-std
                    list-box
                    line            6
                    col             4
                    size            61
                    lines           12
                    display-columns (1, 31)
                    data-columns    (1, 31)
                    alignment       ("L", "L")
                    separation      (0, 0)
                    dividers        (1, 1)
                    .
           03 push-button
              line                 20
              col                  2
              size                 20 cells
              title                "View &Source [F2]"
              exception-value      2
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept base-sorg-path from environment "home_source".
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "TAB Control standard"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 min-size 70
                   handle hWin
                   event  WIN-EVT

           move 1 to page1-visible
           move 0 to page2-visible
           move 0 to page3-visible

           display Mask

           modify Tb1-std tab-to-add ("Page1", "Page2", "Songs")

           modify Cb1-std item-to-add ("item1", "item2")

           perform varying cont from 1 by 1 until cont > 20
              modify ls1-std item-to-add ta-item(cont)
           end-perform

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception
                    continue
              end-accept
              if crt-status = 2
                 perform VIEW-SORG
              end-if
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin 
           destroy control-font
           goback
           .

       TAB-EVT.
           if event-type = cmd-tabchanged
              evaluate event-data-1
              when 1 
                   move 1 to page1-visible
                   move 0 to page2-visible
                   move 0 to page3-visible
              when 2 
                   move 0 to page1-visible
                   move 1 to page2-visible
                   move 0 to page3-visible
              when 3
                   move 0 to page1-visible
                   move 0 to page2-visible
                   move 1 to page3-visible
              end-evaluate
              display Tb1-std-Pages
           end-if
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path   delimited by trailing space
                  "s-gui"          delimited by space
                  "/TAB-STD.cbl"   delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.
