      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    dynamic-screen.  
       
       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status                special-names crt status pic 9(5).
       77  hWin                      usage handle of window.
       77  close-win                 pic 9 value 0.
       77  control-font              handle of font.

       78  78Push-button             value "Push-button". 
       78  78Entry-field             value "Entry-field".
       78  78Label                   value "Label".
       78  78Check-box               value "Check-box".

       77  w-c-control-type          pic x(15) value 78Push-button. 
       77  w-d-col                   pic 9(3).
       77  w-d-line                  pic 9(3).
       77  w-d-col-2                 pic 9(3).
       77  w-d-line-2                pic 9(3).
 
       77  dynamic-control           usage handle.
       77  w-row-control             pic 99.
       77  wrk-last-row              pic 9(3).

       01  rec-grid-control.
           05 rgc-type               pic x(15).
           05 rgc-handle             pic z(8).
           05 rcg-visible            pic x.

       77  e-dynamic-control-button  pic 9 value zero.

       SCREEN SECTION.
       01  Mask.
           05 Frame
              col 2
              line 1
              size 28
              lines 8 
              engraved
              title "Control to add"
              height-in-cells
              width-in-cells
              .
           05 Label
              line 2.5
              col 3
              size 10 
              title "Type"
              .
           05 c-control-type 
              Combo-Box
              line 2.5
              col 11
              size 14
              lines 4 
              drop-list
              unsorted
              value 78Push-button
              item-to-add (78Push-button, 78Entry-field, 
                           78Label, 78Check-box)
              .
           05 Label
              line 4.5
              col 3
              size 14 
              title "Pos: col"
              .
           05 Entry-Field
              line                 4.5
              col                  11
              size                 4
              numeric
              right
              value                w-d-col
              .
           05 Label
              line                 4.5
              col                  19
              size                 4
              title                "line"
              .
           05 Entry-Field
              line                 4.5
              col                  23
              size                 4
              numeric
              right
              value                w-d-line
              .
           05 Push-Button
              line                 6.5
              col                  11
              size                 18 cells
              title                "Add"
              exception-value      101
              self-act 
              .
           05 Frame
              col                  31
              line                 1
              size                 39
              lines                8 
              engraved
              title                "List of Controls"
              height-in-cells
              width-in-cells
              .
           05 gr-list-control 
              grid
              line                 2.5
              column               32
              size                 26 cells
              vpadding             60
              lines                5.5 cells
              data-columns         (1, 16, 24)
              display-columns      (1, 12, 18)
              alignment            ( "L", "R", "C")
              data-types           ( "X", "Z", "X")
              color                513
              cursor-frame-width   -1
              vscroll
              tiled-headings
              column-headings
              centered-headings 
              heading-color        257
              heading-font         control-font
              use-tab
              border-color         rgb x#ACACAC
              boxed
              protection           1
              boxed
              Row-Background-Color-Pattern (0, rgb x#DFEDEE)
              .
           05 pb-dynamic-remove
              Push-Button
              line                 2.5
              column               59
              size                 9
              lines                1
              title                "Remove"
              exception-value      102
              enabled              e-dynamic-control-button
              self-act 
              .
           05 pb-dynamic-visible
              Push-Button
              line                 4.5
              column               59
              size                 9
              lines                1 
              title                "Visible"
              exception-value      103
              enabled              e-dynamic-control-button
              self-act
              .
           05 pb-dynamic-invisible
              Push-Button
              line                 6.5
              column               59
              size                 9 
              lines                1 
              title                "Invisible"
              exception-value      104
              enabled              e-dynamic-control-button
              self-act 
              .
           05 Frame
              line                 9.5
              column               2
              size                 68
              lines                10
              engraved
              title                "New control area"
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "Dynamic Screen"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask
           modify gr-list-control(1, 1) cell-data "Type"
           modify gr-list-control(1, 2) cell-data "Handle".
           modify gr-list-control(1, 3) cell-data "Vis.".

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception 
                    continue
              end-accept
              perform EXCPETION-HANDLE
              move 4   to accept-control
           end-perform.

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .
      
       EXCPETION-HANDLE.
           evaluate crt-status
           when 101
                perform ADD-DYNAMIC-CONTROL
           when 102 
                perform REMOVE-DYNAMIC-CONTROL
           when 103
                perform MAKE-VISIBLE-DYNAMIC-CONTROL
           when 104
                perform MAKE-INVISIBLE-DYNAMIC-CONTROL
           end-evaluate.
      
       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       ADD-DYNAMIC-CONTROL.
           if w-d-col > 52 or w-d-line > 6
              display message 
                 "The new control is outside the visible area"
           else   
              inquire c-control-type value w-c-control-type
              add 3  to w-d-col  giving w-d-col-2
              add 11 to w-d-line giving w-d-line-2
              evaluate w-c-control-type
              when 78Push-button
                   display push-button 
                           title "new button" 
                           handle dynamic-control
                           line w-d-line-2 
                           col w-d-col-2
                           size 12
                           upon mask
                   move 78Push-button   to rgc-type
              when 78Entry-field
                   display entry-field  
                           handle dynamic-control
                           line w-d-line-2 
                           col w-d-col-2
                           size 12
                           upon mask
                   move 78Entry-field   to rgc-type
              when 78Label
                   display label 
                           title "new label" 
                           handle dynamic-control
                           line w-d-line-2 
                           col w-d-col-2
                           size 12
                           upon mask
                   move 78Label   to rgc-type
              when 78Check-box
                   display Check-box
                           title "new Check" 
                           handle dynamic-control
                           line w-d-line-2 
                           col w-d-col-2
                           size 12
                           upon mask
                   move 78Check-box  to rgc-type
              end-evaluate
              move "Y"         to rcg-visible
              set rgc-handle   to dynamic-control
              modify gr-list-control record-to-add rec-grid-control
              if e-dynamic-control-button = zero
                 move 1 to e-dynamic-control-button
                 modify pb-dynamic-remove     
                                     enabled e-dynamic-control-button
                 modify pb-dynamic-visible    
                                     enabled e-dynamic-control-button
                 modify pb-dynamic-invisible  
                                     enabled e-dynamic-control-button
              end-if
           end-if.

       REMOVE-DYNAMIC-CONTROL.
           perform VALORIZE-HANDLE-DYNAMIC-CONTROL
           if w-row-control not = 1
              destroy dynamic-control upon mask
              modify gr-list-control record-to-delete w-row-control 
              modify gr-list-control cursor-y = 2
              inquire gr-list-control last-row wrk-last-row
              if wrk-last-row = 1
                 move 0 to e-dynamic-control-button
                 modify pb-dynamic-remove     
                                     enabled e-dynamic-control-button
                 modify pb-dynamic-visible    
                                     enabled e-dynamic-control-button
                 modify pb-dynamic-invisible  
                                     enabled e-dynamic-control-button
              end-if
           end-if.
  
       MAKE-VISIBLE-DYNAMIC-CONTROL.
           perform VALORIZE-HANDLE-DYNAMIC-CONTROL
           if w-row-control not = 1
              modify dynamic-control visible 1
              modify gr-list-control(w-row-control, 3) cell-data = "Y"
           end-if.
          
       MAKE-INVISIBLE-DYNAMIC-CONTROL.
           perform VALORIZE-HANDLE-DYNAMIC-CONTROL
           if w-row-control not = 1
              modify dynamic-control visible 0
              modify gr-list-control(w-row-control, 3) cell-data = "N"
           end-if.
          
       VALORIZE-HANDLE-DYNAMIC-CONTROL.
           inquire gr-list-control cursor-y w-row-control
           inquire gr-list-control(w-row-control, 2) 
                                             cell-data = rgc-handle
           set dynamic-control  to rgc-handle.
           