      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. LOG-FEATURE.

       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "iscrt.def".
       copy "isopensave.def".
       copy "isprint.def".
       copy "isfonts.def".

       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       77  p-logfile               pic x any length.
       77  p-tracelevel            pic 9(5) value 15.
       77  p-thread-info           pic 9 value 1.
       77  p-log-number            pic 9(2) value 2.
       77  e-log-number            pic 9 value 0.
       77  p-log-size              pic 9(8) value 1048576.
       77  e-log-size              pic 9 value 0.
       77  p-cb-log-size           pic 9 value 0.
       77  p-cb-log-number         pic 9 value 0.
       77  p-log-append            pic 9 value 0.
       77  v-local                 pic 9.
       
       SCREEN SECTION.

       01  Mask.
           03 label
              line                 2
              col                  3
              size                 10 cells
              title                "Trace level:"
              .
           03 entry-field
              line                 2
              col                  21.5
              size                 7 cells
              numeric
              right
              value                p-tracelevel
              .
           03 label
              line                 4
              col                  3
              size                 10 cells
              title                "log file:"
              .
           03 ef-logfile
              entry-field
              line                 4
              col                  21.5
              size                 45.5 cells
              value                p-logfile
              .
           03 push-button 
              title                "..." 
              line                 4 
              lines                0.9
              col                  67
              size                 3  cells
              exception-value      201
              visible              v-local
              self-act
              .
           03 check-box
              title                "Thread information:"
              line                 6
              col                  3
              size                 21 cells
              left-text
              left-text-alignment  1
              value                p-thread-info
              .
           03 frame
              engraved
              title                "Log rotation:"
              line                 8
              col                  2
              lines                8
              size                 68
              .
           03 cb-log-number
              check-box
              title                "Log files number:"
              line                 10
              col                  3
              size                 21 cells
              left-text
              left-text-alignment  1
              value                p-cb-log-number
              exception-value      101
              .
           03 ef-log-number
              entry-field
              line                 10
              col                  25
              size                 10 cells
              numeric
              right
              value                p-log-number
              enabled              e-log-number
              .
           03 cb-log-size
              check-box
              title                "Log files size (bytes):"
              line                 12
              col                  3
              size                 21 cells
              left-text
              left-text-alignment  1
              value                p-cb-log-size
              exception-value      102
              .
           03 ef-log-size
              entry-field
              line                 12
              col                  25
              size                 10 cells
              numeric
              right
              value                p-log-size
              enabled              e-log-size
              .
           03 check-box
              title                "Append:"
              line                 14
              col                  3
              size                 21 cells
              left-text
              left-text-alignment  1
              value                p-log-append
              .
           03 push-button
              line                 17 
              col                  3
              size                 16 cells
              title                "Start Processing" 
              exception-value      301
              .
           03 Pb-exit
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.

           accept terminal-abilities from terminal-info.
           if is-remote
              move zero   to v-local
           else
              move 1      to v-local
           end-if

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "Log feature"
                   handle hWin
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   event  WIN-EVT

           perform INTIAL-SETTINGS
           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              evaluate crt-status
              when 101
                   perform ENABLED-LOG-NUM-FILES 
              when 102
                   perform ENABLED-LOG-SIZE 
              when 201
                   perform SEARCH-LOG-FILE
              when 301  
                   perform ELABORATION
              end-evaluate
              move 4 to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           GOBACK
           .

       ELABORATION.
           set environment "tracelevel"        to p-tracelevel
           set environment "logfile"           to p-logfile 
           set environment "logfile.thread"    to p-thread-info

           if e-log-number not = 0
              set environment "logfile.number" to p-log-number
           else
              call "C$UNSET" using "logfile.number"
           end-if
           if e-log-size not = 0
              set environment "logfile.maxlen" to p-log-size
           else
              call "C$UNSET" using "logfile.maxlen"
           end-if

           set environment "logfile.append"    to p-log-append

           call "LOG-PROG-A"
           cancel "LOG-PROG-A"
           set environment "tracelevel"        to "0"
           call "C$EASYOPEN" using p-logfile
                                   1
           .

       ENABLED-LOG-NUM-FILES.
           inquire cb-log-number value p-cb-log-number
           move p-cb-log-number to e-log-number
           modify ef-log-number enabled e-log-number
           .

       ENABLED-LOG-SIZE.
           inquire cb-log-size value p-cb-log-size
           move p-cb-log-size to e-log-size
           modify ef-log-size enabled e-log-size
           .

       SEARCH-LOG-FILE.
           initialize opensave-data
           string "LOG Files (*.log)|*.log|"
                  "TXT Files (*.txt)|*.txt|"
                  "ALL Files (*.*)|*.*"
                  delimited by size
                  into opnsav-filters.

           initialize opensave-data
           call "C$OPENSAVEBOX" using opensave-save-box, 
                                      opensave-data.
           if opnsav-basename not = spaces
              move opnsav-filename   to p-logfile
              modify ef-logfile value p-logfile
           end-if
           .

       INTIAL-SETTINGS.
           call "C$GETENV" USING "user.home"
                                 p-logfile

           string p-logfile        delimited by trailing spaces
                  "/iscobol.log"   delimited by size
                                   into p-logfile
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
