      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. RESPONSIVE.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.    
       77  hWinHamburger           handle of window.
       77  close-win               pic 9 value 0.     
       77  control-font            handle of font.

       77  hToolBar                handle of window.
       77  hBmpTB                  pic s9(9) comp-4.
       77  hEf                     handle of entry-field.

       77  responsive-layout handle of layout-manager, lm-responsive 
              "xsmall=1 cells, small=14 cells, medium=40 cells," &  
              "large=69 cells" .

       SCREEN SECTION.
       01  Mask.
           03 label
              line         2
              col          2
              size         8 cells
              title        "Title:"
              layout-data  "line-small 2 " &
                           "resize-x-small " &
                           "line-medium 2 " &
                           "resize-x-medium"
              .
           03 Ef1 
              entry-field    
              line         2
              lines        1.3
              col          12
              size         54 cells
              id           1 
              layout-data  "line-small 3.5 cells " &
                           "col-small 2 cells " &
                           "size-small 14 cells " & 
                           "resize-x-small " &
                           "line-medium 3.5 cells " &
                           "col-medium 2 cells " & 
                           "size-medium 38 cells " &
                           "resize-x-medium"
              .
           03 label
              line         4 
              col          2
              size         8 cells
              title        "Length:"
              layout-data  "line-small 5.5 " &
                           "resize-x-small " &
                           "line-medium 5.5 " &
                           "resize-x-medium"
              .         
           03 Ef2
              entry-field    
              line         4
              lines        1.3
              col          12
              size         54 cells
              id           2
              layout-data  "line-small 7.0 cells " &
                           "col-small 2 cells " &
                           "size-small 14 cells " &
                           "resize-x-small " &
                           "line-medium 7.0 cells " &
                           "col-medium 2 cells " &
                           "size-medium 38 cells " &
                           "resize-x-medium"
              .
           03 label
              line         6
              lines        1.3
              col          2
              size         8 cells
              title        "Artist:"
              layout-data  "line-small 9 " &
                           "resize-x-small " &
                           "line-medium 9 " &
                           "resize-x-medium"
              .
           03 Ef3
              entry-field    
              line         6
              lines        1.3
              col          12
              size         54 cells
              id           3
              layout-data  "line-small 10.5 cells " &
                           "col-small 2 cells " &
                           "size-small 14 cells " &
                           "resize-x-small " &
                           "line-medium 10.5 cells " &
                           "col-medium 2 cells " &
                           "size-medium 38 cells " &
                           "resize-x-medium"
              .
           03 label
              line         8
              lines        1.3
              col          2
              size         8 cells
              title        "Genre:"
              layout-data  "line-small 12.5 " &
                           "resize-x-small " &
                           "line-medium 12.5 " &
                           "resize-x-medium"
              .
           03 Ef4
              entry-field    
              line         8
              lines        1.3
              col          12
              size         54 cells
              id           4     
              layout-data  "line-small 14 cells " &
                           "col-small 2 cells " &
                           "size-small 14 cells " &
                           "resize-x-small " &
                           "line-medium 14 cells " &
                           "col-medium 2 cells " &
                           "size-medium 38 cells " &
                           "resize-x-medium"
              .
           03 label
              line         10
              lines        1.3
              col          2
              size         8 cells
              title        "Label:"
              layout-data  "line-small 16 " &
                           "resize-x-small " &
                           "line-medium 16 " &
                           "resize-x-medium"
              .
           03 Ef5
              entry-field
              line         10
              lines        1.3
              col          12
              size         54 cells
              id           5     
              layout-data  "line-small 17.5 cells " &
                           "col-small 2 cells " &
                           "size-small 14 cells " &
                           "resize-x-small " &
                           "line-medium 17.5 cells " &
                           "col-medium 2 cells " &
                           "size-medium 38 cells " &
                           "resize-x-medium"
              .
           03 Pb-exit
              push-button
              line                 20 
              col                  2 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              layout-data          "move-y"
              .
  
       01  Mask-Tool.
           03 push-button 
              title                "Exit"
              title-position       1
              hint                 "Esc"
              self-act
              line                 2 
              col                  2    
              lines                16 
              size                 10 cells
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        1
              bitmap-width         16
              exception-value      27
              layout-data          "hidden-small " &
                                   "no-scale"
              .
           03 bar
              col                  + 1
              lines                2 
              width                2
              color                16
              shading              (-1, 1)
              layout-data          "hidden-small " &
                                   "no-scale"
              .
           03 push-button 
              title                "Cut"
              self-act
              line                 2 
              col                  + 1    
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        2
              bitmap-width         16
              exception-value      101
              layout-data          "hidden-small " &
                                   "no-scale"
              .
           03 push-button 
              title                "Copy"
              self-act
              line                 2
              col                  + 1
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        3
              bitmap-width         16
              exception-value      102
              layout-data          "hidden-small " &
                                   "no-scale"
              .
           03 push-button 
              title                "Paste"
              self-act
              line                 2 
              col                  + 1  
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        4
              bitmap-width         16
              exception-value      103
              layout-data          "hidden-small " &
                                   "no-scale"
              .
           03 bar
              col                  + 1
              lines                2 
              width                2
              color                16
              shading              (-1, 1)
              layout-data          "hidden-small " &
                                   "no-scale"
              .
           03 push-button 
              title                "Maximize"
              title-position       2
              hint                 "Maximize the Window"
              self-act
              line                 2 
              col                  + 1  
              lines                16 
              size                 16 cells
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        5
              bitmap-width         16
              exception-value      104
              layout-data          "hidden-small " &
                                   "no-scale"
              .
           03 push-button 
              title                "menu"
              self-act
              line                 2 
              col                  2    
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        6
              bitmap-width         16
              exception-value      105
              layout-data          "visible-small " &
                                   "no-scale"
              .
       01  hamburger-Tool.
           03 push-button 
              title                "Exit"
              title-position       1
              hint                 "Esc"
              self-act
              line                 1.3
              col                  2
              lines                16 
              size                 12 cells
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        1
              bitmap-width         16
              exception-value      27
              .
           03 push-button 
              title                "Cut"
              self-act
              line                 3.3
              col                  2
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        2
              bitmap-width         16
              exception-value      101
              .
           03 push-button 
              title                "Copy"
              self-act
              col                  + 1
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        3
              bitmap-width         16
              exception-value      102
              .
           03 push-button 
              title                "Paste"
              self-act
              col                  + 1  
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        4
              bitmap-width         16
              exception-value      103
              .
           03 push-button 
              title                "Maximize"
              title-position       2
              hint                 "Maximize the Window"
              self-act
              line                 5.1
              col                  2
              lines                16 
              size                 12 cells
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        5
              bitmap-width         16
              exception-value      104
              .

       PROCEDURE DIVISION.
       MAIN.
           call "W$BITMAP" using wbitmap-load, "files/tools.gif"
                          giving hBmpTB.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager responsive-layout 
                   line 2
                   col 65
                   title  "Responsive"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 10
                   handle hWin
                   event  WIN-EVT

           display Mask
           
           display tool-bar control font control-font 
                   layout-manager responsive-layout 
                    handle hToolBar.
           display Mask-Tool upon hToolBar.
              
           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              move control-handle to hEf
              perform EXCEPTION-HANDLE 
              move 4 to accept-control
           end-perform

           destroy Mask
           destroy Mask-Tool
           destroy hToolBar
           destroy hWin
           destroy control-font
           call "W$BITMAP" using wbitmap-destroy, hBmpTB
           goback
           .

       EXCEPTION-HANDLE.
           evaluate crt-status
           when 101 
                perform CUT-TEXT
           when 102 
                perform COPY-TEXT
           when 103 
                perform PASTE-TEXT
           when 104 
                perform MAXIMIZE-WINDOW
           when 105
                perform HAMBURGER-MENU
           end-evaluate
           .

       COPY-TEXT.
           modify hEf action action-copy
           .

       CUT-TEXT.
           modify hEf action action-cut
           .

       PASTE-TEXT.
           modify hEf action action-paste
           .

       MAXIMIZE-WINDOW.
           modify hWin action action-maximize.

       HAMBURGER-MENU.
           display floating graphical window
                   line 1 
                   column 1 
                   size 14 
                   lines 6
                   modeless
                   user-white
                   user-gray
                   handle hWinHamburger
                   control font control-font
                   .

           display hamburger-Tool upon hWinHamburger.

           accept hamburger-Tool 
              on exception
                 continue
           end-accept
           destroy hWinHamburger.

           perform EXCEPTION-HANDLE
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
