      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. window-massupdate.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       77  hToolBar                handle of window.
       77  hBmpTB                  pic s9(9) comp-4.
       77  hEf                     handle of entry-field.

       77  var-mass-update         pic 9 value 1.
           88 use-mass-update      value 1 false 0.

       77  var-tool-bar            pic 9 value 1.
       77  var-menu                pic 9 value 1.

       77                          pic 9 value 0.
           88 tool-bar-on-video    value 1 false 0.

       77                          pic 9 value 0.
           88 menu-on-video        value 1 false 0.

       01  ef-handle-occurs.
           05 ef-handle            handle of entry-field
                                   occurs dynamic capacity num-ef.

       77  idx                     pic 9(3).
       77  idx-value               pic 9(3) value 0.
       77  w-d-col                 pic 9(3).
       77  w-d-line                pic 9(3).

       77  e-pb-add-control        pic 9 value 1.
       77  e-pb-modify-control     pic 9 value 0.
       77  e-pb-destroy-control    pic 9 value 0.

       SCREEN SECTION.
       01  Mask.     
           03 Cb-mass-update 
              check-box            
              line                 2 
              col                  3
              title                "Mass-update"
              value                var-mass-update
              . 
           03 push-button
              line                 4
              col                  3 
              size                 20 cells
              title                "Show" 
              exception-value      10
              .
           03 Cb-toll-bar 
              check-box            
              line                 4.2 
              col                  25
              title                "Tool-bar"
              value                var-tool-bar
              . 
           03 Cb-menu 
              check-box            
              line                 4.2 
              col                  37
              title                "Menu bar"
              value                var-menu
              . 
           03 pb-add-control
              push-button
              line                 6
              col                  3 
              size                 20 cells
              title                "Add controls"
              enabled              e-pb-add-control 
              exception-value      11
              .
           03 pb-modify-control
              push-button
              line                 6
              col                  25 
              size                 20 cells
              title                "Modify value controls" 
              enabled              e-pb-modify-control 
              exception-value      12
              .
           03 pb-destroy-control
              push-button
              line                 6
              col                  47
              size                 20 cells
              title                "Destroy controls" 
              enabled              e-pb-destroy-control 
              exception-value      13
              .
           03 Pb-exit
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
  
       01  Mask-Tool.
           03 push-button 
              title                "Exit"
              title-position       1
              hint                 "Esc"
              self-act
              line                 2 
              col                  2    
              lines                16 
              size                 10 cells
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        1
              bitmap-width         16
              exception-value      27
              .
           03 bar
              col                  + 1
              lines                2 
              width                2
              color                16
              shading              (-1, 1)
              .
           03 push-button 
              title                "Cut"
              self-act
              line                 2 
              col                  + 1    
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        2
              bitmap-width         16
              exception-value      101
              .
           03 push-button 
              title                "Copy"
              self-act
              line                 2
              col                  + 1
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        3
              bitmap-width         16
              exception-value      102
              .
           03 push-button 
              title                "Paste"
              self-act
              line                 2 
              col                  + 1  
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        4
              bitmap-width         16
              exception-value      103
              .
           03 bar
              col                  + 1
              lines                2 
              width                2
              color                16
              shading              (-1, 1)
              .
           03 push-button 
              title                "Your Function"
              title-position       2
              hint                 "Execute Your Function"
              self-act
              line                 2 
              col                  + 1  
              lines                16 
              size                 16 cells
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        5
              bitmap-width         16
              exception-value      104
              .

       PROCEDURE DIVISION.
       MAIN.
           call "W$BITMAP" using wbitmap-load, "files/tools.gif"
                          giving hBmpTB.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "WINDOW MASS-UPDATE"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask
           
           perform DISPLAY-TOOLBAR-MENU

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    move control-handle to hEf
                    evaluate crt-status
                    when 10
                         perform DISPLAY-TOOLBAR-MENU
                    when 11
                         perform ADD-DYNAMIC-CONTROL
                    when 12
                         perform MODIFY-VALUE-DYNAMIC-CONTROL
                    when 13
                         perform REMOVE-DYNAMIC-CONTROL
                    end-evaluate
              end-accept
              move 4 to accept-control
           end-perform

           destroy Mask
           destroy Mask-Tool
           destroy hToolBar
           destroy hWin
           destroy control-font
           call "W$BITMAP" using wbitmap-destroy, hBmpTB
           goback
           .
        
       ACTIVATE-MASSUPDATE.
           if use-mass-update
              modify hWin mass-update 1
           end-if
           .

       DEACTIVATE-MASSUPDATE.
           if use-mass-update
              modify hWin mass-update 0
           end-if
           .

       DISPLAY-TOOLBAR-MENU.
           perform ACTIVATE-MASSUPDATE

           if menu-on-video and var-menu = 0
              perform DESTROY-MENU
              set menu-on-video to false
           end-if

           if tool-bar-on-video and var-tool-bar = 0
              perform DESTROY-TOOLBAR
              set tool-bar-on-video   to false
           end-if

           if not menu-on-video and var-menu = 1
              perform SHOW-MENU
              set menu-on-video to true
           end-if

           if not tool-bar-on-video and var-tool-bar = 1
              perform DISPLAY-TOOLBAR
              set tool-bar-on-video   to true
           end-if

           perform DEACTIVATE-MASSUPDATE
           .

       ADD-DYNAMIC-CONTROL.
           perform ACTIVATE-MASSUPDATE

           initialize ef-handle-occurs
           
           move 6  to w-d-line
           move 72  to w-d-col
           move 0   to idx

           perform until 1 = 2
              if w-d-col > 65
                 add 2    to w-d-line
                 move 3   to w-d-col
              else
                 add 4    to w-d-col
              end-if
              
              if w-d-line > 18
                 exit perform
              end-if
              
              add 1 to idx

              display entry-field  
                      handle ef-handle(idx)
                      line w-d-line 
                      col w-d-col
                      size 3 cells
           end-perform

           move 0   to e-pb-add-control
           modify pb-add-control enabled e-pb-add-control 
           move 1   to e-pb-modify-control
                       e-pb-destroy-control 
           modify pb-modify-control enabled e-pb-modify-control 
           modify pb-destroy-control enabled e-pb-destroy-control 

           perform DEACTIVATE-MASSUPDATE
           .

       MODIFY-VALUE-DYNAMIC-CONTROL.
           perform ACTIVATE-MASSUPDATE
           add 1 to idx-value
           perform varying idx from 1 by 1 until idx > num-ef
              modify ef-handle(idx) value idx-value 
           end-perform
           perform DEACTIVATE-MASSUPDATE
           .

       REMOVE-DYNAMIC-CONTROL.
           perform ACTIVATE-MASSUPDATE
           perform varying idx from 1 by 1 until idx > num-ef
              destroy ef-handle(idx) 
           end-perform
           initialize ef-handle-occurs 
           move 0   to idx-value

           move 1   to e-pb-add-control
           modify pb-add-control enabled e-pb-add-control 
           move 0   to e-pb-modify-control
                       e-pb-destroy-control 
           modify pb-modify-control enabled e-pb-modify-control 
           modify pb-destroy-control enabled e-pb-destroy-control 
           perform DEACTIVATE-MASSUPDATE
           .

       DISPLAY-TOOLBAR.
           display tool-bar control font control-font 
                    handle hToolBar
           display Mask-Tool upon hToolBar
           .

       DESTROY-TOOLBAR.
           destroy Mask-Tool
           destroy hToolBar
           .

       SHOW-MENU.
           perform BUILD-MENU
           call "w$menu" using wmenu-show 
                               menu-handle
           .

       DESTROY-MENU.
           call "w$menu" using wmenu-destroy 
                               menu-handle
           .

       BUILD-MENU. 
           call "w$menu" using wmenu-new giving menu-handle
      
           call "w$menu" using wmenu-new giving sub-handle-1
           
           call "w$menu" using wmenu-add, menu-handle, 0, 0,
                               "&File", 0, sub-handle-1
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0,
                               "&New", 101
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 101 hBmpTB 3 16
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0,
                               "&Open", 102
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 102 hBmpTB 9 16
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0,
                               "&Save", 103
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 103 hBmpTB 10 16
           call "w$menu" using wmenu-add, sub-handle-1, 0, w-separator
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0,
                               "E&xit", 27
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 27 hBmpTB 1 16

           call "w$menu" using wmenu-new giving sub-handle-2

           call "w$menu" using wmenu-add, menu-handle, 0, 0,
                               "&Edit", 0, sub-handle-2
           call "w$menu" using wmenu-add, sub-handle-2, 0, 0,
                               "&Cut", 104
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 104 hBmpTB 2 16
           call "w$menu" using wmenu-add, sub-handle-2, 0, 0,
                               "&Copy", 105
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 105 hBmpTB 3 16
           call "w$menu" using wmenu-add, sub-handle-2, 0, 0,
                               "&Paste", 106
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 106 hBmpTB 4 16
           call "w$menu" using wmenu-add, sub-handle-2, 0, w-separator
           call "w$menu" using wmenu-add, sub-handle-2, 0, w-disabled,
                               " w-disabled", 70
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 70 hBmpTB 5 16
           call "w$menu" using wmenu-add, sub-handle-2, 0, w-checked,
                               " w-checked", 80
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 80 hBmpTB 8 16
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
