      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. COBSHELL.
       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.

       REPOSITORY.
           class cobshell as "com.iscobol.cobshell.CobShell"
           .

       INPUT-OUTPUT SECTION.

       DATA DIVISION.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  joe                     object reference cobshell.
       77  joe-result              pic x any length.

       SCREEN SECTION.
       01  Mask.
           03 push-button              
              line                 5 
              col                  2
              size                 30 cells
              title                "Execute JOE script"
              exception-value      100
              .                    
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CobShell Objects"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    if crt-status = 100
                       perform EXECUTE-JOE
                    end-if
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       EXECUTE-JOE.
      *     set script-loaded to true
           try
              set joe = cobshell:>new ("./files/cobshell.joe")
           catch exception
              display message exception-object
           end-try.
       
           try

           set joe-result to joe:>execBlock ( "JoeBlock")
              display message joe-result
           catch exception
              display message exception-object
           end-try.