      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. LOGGER.
       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.

       REPOSITORY.
           class IsRuntime as "com.iscobol.logger.LoggerFactory"
           class MyLogger as "com.iscobol.logger.Logger"
           .

       INPUT-OUTPUT SECTION.

       DATA DIVISION.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  logfilename             pic x(256).
       77  log-string              pic x any length.

       77  mylog                   object reference MyLogger.

       SCREEN SECTION.
       01  Mask.
           03 label                
              line                 2
              col                  2
              title                "Log file name: "
              .
           03 label
              line                 2
              col                  + 2
              title                logfilename
              .
           03 push-button              
              line                 5 
              col                  2
              size                 30 cells
              title                "print custom information into logfil
      -                            "e"
              exception-value      100
              self-act
              .
           03 label
              line                 10
              col                  2
              title                "Check the log with a text editor aft
      -                            "er clicking on the above button"
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.

           call "C$GETENV" USING "user.home"
                                 logfilename

           string logfilename delimited by trailing spaces
                  "/log.txt"  delimited by size
                              into logfilename

           accept system-information from system-info

           set environment "logfile"    to logfilename
           set environment "tracelevel" to "1"

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable layout-manager lm-zoom
                   line 2
                   col 65
                   title  "Logger Objects"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception
                    if crt-status = 100
                       perform INVOKE-LOGGER
                    end-if
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       INVOKE-LOGGER.
           initialize log-string 
           
           string "The operating system is: "
                  operating-system
                  ". The User-id is: "
                  user-id
                  into log-string.

           set mylog to IsRuntime:>getCurrLog()
           if mylog = null
              display message "log not available"
           else
              mylog:>info(log-string)
              mylog:>warning("This is a warning.")
              mylog:>severe("This is a severe error.")
           end-if.
