      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    ASHANDLING.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  usrlist                 handle.
       77  locklist                handle.
       77  th-id                   pic 9(5).
       77  th-id-ed                pic z(5).
       77  usr-id                  pic s9(5).
       77  usr-name                pic x(32).
       77  usr-addr                pic x(32).
       77  usr-pcname              pic x(32).
       77  usr-tid                 pic x(32).
       77  usr-prog                pic x(32).
       77  usr-type                pic 9.
       01  usr-logon-time.
           05 usr-logon-aaaa       pic 9(4).
           05 usr-logon-mm         pic 9(2).
           05 usr-logon-dd         pic 9(2).
           05 usr-logon-hh         pic 9(2).
           05 usr-logon-minutes    pic 9(2).
           05 usr-logon-filler     pic 9(4).
       77  usr-cust-info           pic x(40).
       77  usr-count               pic 9(5).
       77  lock-count              pic 9(5).
       77  lock-filename           pic x(50).
       77  lock-tid                pic 9(5).
       77  lock-open-mode          pic 9(5).
       77  lock-mode               pic 9(5).
       77  lock-key-val            pic x(256).
       77  lock-key-len            pic 9(3).

       77  v-note                  pic 9.

       77  wrk-logon               pic x any length.

       01  rec-grid-user.
           05  rgu-tid             pic x(32).
           05  rgu-id              pic x(3).
           05  rgu-name            pic x(32).
           05  rgu-addr            pic x(32).
           05  rgu-pcname          pic x(32).
           05  rgu-prog            pic x(32).
           05  rgu-type            pic x(32).
           05  rgu-logon-date      pic 9(8).
           05  rgu-logon-time      pic x(5).
           05  rgu-cust-info       pic x(40).

       01  rec-grid-lock.
           05  rgl-tid             pic z(5).
           05  rgl-filename        pic x(50).
           05  rgl-open-mode       pic x(20).
           05  rgl-name            pic x(32).
           05  rgl-prog            pic x(32).

       77  wrk-selection           pic x any length.
       77  wrk-row                 pic 9(3).
       77  unstring-pointer        pic 9(5).
       77  wrk-size                pic 9(5).
       77  wrk-tid                 pic 9(5).
       77  wrk-message             pic x any length.

       SCREEN SECTION.
       01  Mask.
           03 Tb-as
              tab-control
              line                 1 
              col                  2
              lines                19.5 cells
              size                 68 cells
              allow-container
              .
           03 Tb-as-page1 
              tab-group Tb-as tab-group-value 1.
              05 label
                 line              2
                 col               3
                 size              30 cells
                 title             "Thread ID:"
                 .
              05 lb-tid
                 label
                 line              2
                 col               32
                 size              10 cells  
                 .
              05 label 
                 line              4
                 col               3 
                 size              30 cells
                 title             "User name:"
                 .
              05 lb-uname
                 label
                 line              4
                 col               32
                 size              40 cells 
                 .
              05 label 
                 line              6
                 col               3 
                 size              30 cells
                 title             "Admin user:"
                 .
              05 lb-admin
                 label
                 line              6
                 col               32
                 size              40 cells 
                 .
              05 label 
                 line              8
                 col               3 
                 size              30 cells
                 title             "Address:"
                 .
              05 lb-uaddr
                 label
                 line              8
                 col               32
                 size              40 cells 
                 .
              05 label 
                 line              10
                 col               3 
                 size              30 cells
                 title             "Machine name:"
                 .
              05 lb-ucomp
                 label
                 line              10
                 col               32
                 size              40 cells 
                 .
              05 label 
                 line              12
                 col               3 
                 size              30 cells
                 title             "Launched program:"
                 .    
              05 lb-uprog
                 label
                 line              12
                 col               32
                 size              40 cells 
                 .          
              05 label 
                 line              14
                 col               3 
                 size              30 cells
                 title             "Type:"
                 .
              05 lb-type
                 label
                 line              14
                 col               32
                 size              40 cells 
                 .
              05 label 
                 line              16
                 col               3 
                 size              30 cells
                 title             "Logon time (UTC):"
                 .
              05 lb-logon-time
                 label
                 line              16
                 col               32
                 size              40 cells 
                 .
              05 label 
                 line              18
                 col               3 
                 size              30 cells
                 title             "Custom info:"
                 .
              05 lb-cust-info
                 label
                 line              18
                 col               32
                 size              40 cells 
                 .
           03 Tb-as-page2 
              tab-group Tb-as tab-group-value 2.
              05 label
                 line              4
                 col               3  
                 size              30 cells
                 title             "Number of connected users:"
                 .
              05 lb-ucount
                 label
                 line              4
                 col               32
                 size              40 cells
                 .
              05 gd-client
                 grid 
                 line              6
                 col               3
                 lines             6
                 size              65 cells
                 display-columns   (6, 10, 20, 31, 43, 56, 66, 76, 
                                    86)
                 data-columns      (record-position of rgu-tid
                                    record-position of rgu-id
                                    record-position of rgu-name
                                    record-position of rgu-addr
                                    record-position of rgu-pcname
                                    record-position of rgu-prog
                                    record-position of rgu-type
                                    record-position of rgu-logon-date
                                    record-position of rgu-logon-time
                                    record-position of rgu-cust-info)
                 alignment         ("C", "L", "L", "L", "L", "L", "L", 
                                    "L", "L", "L")
                 data-types        ("X", "X", "X", "X", "X", "X", "X",
                                    "X", "X", "X") 
                 protection        1
                 Row-Background-Color-Pattern (0, -14675438)
                 Vscroll
                 hscroll
                 column-dividers   (1, 1, 1, 1, 1, 1, 1, 1)
                 heading-color     257
                 border-color rgb  x#ACACAC
                 boxed
                 selection-mode    12
                 row-selected-foreground-color rgb x#9CB0E3
                 row-selected-background-color rgb x#2D4D9F
                 column-headings 
                 centered-headings
                 virtual-width     110
                 .
              05 push-button
                 line              17
                 col               3
                 size              8 cells
                 title             "Refresh" 
                 exception-value   101
                 .
              05 push-button
                 line              17
                 col               12
                 size              27 cells
                 title             "Send Message to selected client" 
                 exception-value   102
                 .
              05 lb-note
                 label
                 line              17
                 col               40
                 title             "* = is running in a in separate JVM"
                 visible           v-note
                 .
           03 Tb-as-page3  
              tab-group Tb-as tab-group-value 3.
              05 label
                 line              4
                 col               3  
                 size              30 cells
                 title             "Number of active locks:"
                 .    
              05 lb-lcount
                 label
                 line              4
                 col               32
                 size              40 cells  
                 .   
              05 Gd-lock
                 grid 
                 line              6
                 col               3
                 lines             6
                 size              65 cells
                 display-columns   (1, 6, 20, 30, 40)
                 data-columns      (record-position of rgl-tid
                                    record-position of rgl-filename
                                    record-position of rgl-open-mode
                                    record-position of rgl-name
                                    record-position of rgl-prog)
                 alignment         ("C", "L", "L", "L", "L")
                 data-types        ("X", "X", "X", "X", "X") 
                 protection        1
                 Row-Background-Color-Pattern (0, -14675438)
                 Vscroll
                 hscroll
                 column-dividers   (1, 1, 1, 1, 1, 1)
                 heading-color     257
                 border-color rgb  x#ACACAC
                 boxed
                 column-headings 
                 centered-headings
                 virtual-width     61
                 .
              05 push-button
                 line              17
                 col               3
                 size              8 cells
                 title             "Refresh" 
                 exception-value   201
                 .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.       
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "Application server info"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           accept terminal-abilities from terminal-info
           if not is-remote
              display message 
              "This sample works only in Application Server environment"
                      icon mb-warning-icon
              destroy hWin
              goback
           end-if

           display Mask
           modify tb-as tab-to-add ("My client info", 
                                    "Connected users", 
                                    "Active Locks")
           modify gd-client(1, 1) cell-data "TID"
           modify gd-client(1, 2) cell-data "Admin"
           modify gd-client(1, 3) cell-data "User Name"
           modify gd-client(1, 4) cell-data "Address"
           modify gd-client(1, 5) cell-data "Machine name"
           modify gd-client(1, 6) cell-data "Program"
           modify gd-client(1, 7) cell-data "Type"
           modify gd-client(1, 8) cell-data "Logon Date"
           modify gd-client(1, 9) cell-data "Time (UTC)"
           modify gd-client(1, 10) cell-data "Cust. info"

           modify gd-lock(1, 1) cell-data "TID"
           modify gd-lock(1, 2) cell-data "File"
           modify gd-lock(1, 3) cell-data "Open mode"
           modify gd-lock(1, 4) cell-data "User Name"
           modify gd-lock(1, 5) cell-data "Program"
           
           perform GET-INFO

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception
                    continue
              end-accept
              evaluate crt-status
              when 101
                   perform GET-USERS-LIST
              when 102
                   perform SEND-MESSAGE-LOOP
              when 201
                   perform GET-LOCKS-LIST
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       GET-INFO.
           call "A$GETTHREAD" giving th-id
           modify lb-tid title th-id.

           call "A$CURRENT-USER" using usr-id
                                       usr-name
                                       usr-addr
                                       usr-pcname
                                       th-id
                                       usr-prog
                                       usr-type
                                       usr-logon-time
                                       usr-cust-info
           modify lb-uname title usr-name
           if usr-id = 0
              modify lb-admin title "Yes"
           else
              modify lb-admin title "No"
           end-if
           modify lb-uaddr title usr-addr
           modify lb-ucomp title usr-pcname
           modify lb-uprog title usr-prog

           evaluate usr-type 
           when 0
                modify lb-type title "Thin"
           when 1
                modify lb-type title "WebClient"
           when 2 
                modify lb-type title "Thin in separate JVM"
           when 3
                modify lb-type title "WebClient in separate JVM"
           end-evaluate

           initialize wrk-logon
           string usr-logon-aaaa      delimited by size
                  usr-logon-mm        delimited by size
                  usr-logon-dd        delimited by size
                  " - "               delimited by size
                  usr-logon-hh        delimited by size
                  ":"                 delimited by size
                  usr-logon-minutes   delimited by size
                  into wrk-logon

           modify lb-logon-time title wrk-logon
           
           modify lb-cust-info  title usr-cust-info 

           perform GET-USERS-LIST

           perform GET-LOCKS-LIST
           .

       GET-USERS-LIST.
           modify gd-client reset-grid 3
           move zero   to v-note

           call "A$LIST-USERS" using listusr-open
                              giving usrlist
           if usrlist < 1
              modify lb-ucount title "Error on users count"
              exit paragraph
           end-if
           move 0 to usr-count
           perform until 1 = 2
              call "A$LIST-USERS" using listusr-next
                                        usrlist
                                        usr-id
                                        usr-name 
                                        usr-addr 
                                        usr-pcname
                                        usr-tid
                                        usr-prog
                                        usr-type
                                        usr-logon-time
                                        usr-cust-info 
              if return-code = 0
                 exit perform
              end-if
              add 1 to usr-count
              if usr-id = 0
                 move "Yes"  to rgu-id
              else
                 move "No"   to rgu-id
              end-if
              move usr-name     to rgu-name
              move usr-addr     to rgu-addr
              move usr-pcname   to rgu-pcname
              move usr-tid      to rgu-tid
              move usr-prog     to rgu-prog
              evaluate usr-type 
              when 0
                   move "Thin"  to rgu-type
              when 1
                   move "Web"   to rgu-type
              when 2 
                   move "Thin*" to rgu-type
                   move 1       to v-note 
              when 3
                   move "Web*"  to rgu-type
                   move 1       to v-note 
              end-evaluate
              perform FORMAT-LOGON-DATE
              move usr-cust-info to rgu-cust-info
              modify gd-client record-to-add rec-grid-user
           end-perform
           call "A$LIST-USERS" using listusr-close
                                     usrlist
           modify lb-ucount title usr-count
           modify lb-note   visible v-note
           .

       SEND-MESSAGE-LOOP.
           inquire gd-client rows-selected wrk-selection
           if wrk-selection = space
              display message "Select one or more clients"
                              x"0D0A"
                              "before send message"
           else
              call "C$JUSTIFY" using wrk-selection "L"
              move 1   to unstring-pointer
              set wrk-size   to size of wrk-selection
              perform until 1 = 2
                 unstring wrk-selection delimited by space
                          into wrk-row
                          pointer unstring-pointer
                 perform SEND-MESSAGE
                 if unstring-pointer >= wrk-size
                    exit perform
                 end-if
              end-perform
           end-if
           .

       SEND-MESSAGE.
           inquire gd-client(wrk-row) record-data rec-grid-user
           move rgu-tid   to wrk-tid with convert
           
           initialize wrk-message
           move th-id  to th-id-ed
           
           string "This is a sample message for you from TID # "
                   function trim(th-id-ed)
                   into wrk-message

           call "A$SEND_MESSAGE" using wrk-tid 
                                       wrk-message
                      GIVING return-code

           evaluate return-code
           when -1
                display message "TID " wrk-tid
                                x"0D0A" "Wrong number of parameters"
           when -2
                if rgu-type = "Thin*"
                   display message "TID " wrk-tid
                                   x"0D0A" 
                                  "Client specified not found"
                                   " or is running in a in separate JVM" 
                else
                   display message "TID " wrk-tid
                                   x"0D0A" 
                                   "Client specified not found "
                end-if
           when -3
                display message "TID " wrk-tid
                                x"0D0A"
                                "Communication error sending the "
                                "message to the client" 
           end-evaluate
           .

       FORMAT-LOGON-DATE.
           initialize rgu-logon-date
           string usr-logon-aaaa   delimited by size
                  usr-logon-mm     delimited by size
                  usr-logon-dd     delimited by size
                  into rgu-logon-date

           initialize rgu-logon-time
           string usr-logon-hh        delimited by size
                  ":"                 delimited by size
                  usr-logon-minutes   delimited by size
                  into rgu-logon-time
           .

       GET-LOCKS-LIST.
           modify Gd-lock reset-grid 3.
           
           initialize lock-filename lock-tid
           call "A$LIST-LOCKS" using listlock-open
                                     null
                                     lock-filename
                                     lock-tid
                              giving locklist

           if locklist < 1
              modify lb-lcount title 
                     "0 (verify iscobol.file.lock_manager)"
              exit paragraph
           end-if
           move 0 to lock-count
           perform until 1 = 2
              call "A$LIST-LOCKS" using listlock-next
                                        locklist
                                        lock-filename
                                        lock-tid
                                        lock-open-mode
                                        lock-mode
                                        lock-key-val
                                        lock-key-len
              if return-code = 0
                 exit perform
              end-if
              add 1 to lock-count
              | to get user infos from lock-tid
              call "A$GET-USER" using lock-tid
                                      usr-id
                                      usr-name
                                      usr-addr
                                      usr-pcname
                                      usr-prog

              move lock-tid        to rgl-tid
              move lock-filename   to rgl-filename

              evaluate lock-open-mode
              when 1
                   move "Input" to rgl-open-mode
               

              when 2
                   move "Output" to rgl-open-mode

              when 3
                   move "I-O" to rgl-open-mode

              when 6
                   move "Extend" to rgl-open-mode

              when 8
                   move "Transaction" to rgl-open-mode
              end-evaluate
              move usr-name  to rgl-name
              move usr-prog  to rgl-prog
              
              modify gd-lock record-to-add rec-grid-lock 
 
           end-perform
           call "A$LIST-LOCKS" using listlock-close
                                     locklist
           modify lb-lcount title lock-count
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win 
           end-if
           .