      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CBLSPLITNAME.

       CONFIGURATION SECTION.
       SPECIAL-NAMES.
           decimal-point is comma.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       COPY "isopensave.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
        
       77  opensave-status         pic 999.
       77  file-name               pic x(256).
       77  wstatus                 PIC X(2) COMP-5.

       01  cblt-splitjoin-buf.
           03 cblte-sj-param-length            pic x(2) comp-x.
           03 cblte-sj-split-join-flag1        pic x comp-x.
           03 cblte-sj-split-join-flag2        pic x comp-x.
           03 cblte-sj-device-offset           pic x(2) comp-x.
           03 cblte-sj-device-length           pic x(2) comp-x.
           03 cblte-sj-basename-offset         pic x(2) comp-x.
           03 cblte-sj-basename-length         pic x(2) comp-x.
           03 cblte-sj-extension-offset        pic x(2) comp-x.
           03 cblte-sj-extension-length        pic x(2) comp-x.
           03 cblte-sj-total-length            pic x(2) comp-x.
           03 cblte-sj-split-buf-len           pic x(2) comp-x.
           03 cblte-sj-join-buf-len            pic x(2) comp-x.
           03 cblte-sj-first-component-length  pic x(2) comp-x.

       77  wrk-path                            pic x any length.
       77  wrk-basename                        pic x any length.
       77  wrk-extension                       pic x any length.
       77  wrk-drive                           pic x any length.

       SCREEN SECTION.
       01  Mask.
           03 label       
              line                 4 
              col                  2       
              size                 4 cells
              title                "File"
              .
           03 file-inf
              entry-field
              line                 6
              col                  2
              value                file-name
              size                 63 cells
              max-text             256
              .
           03 pb-choose
              push-button
              line                 6 
              col                  + 2
              title                "..."
              size                 3
              exception-value      101
              self-act
              .
           03 push-button
              line                 8  
              col                  2
              title                "&Split Name"
              size                 10
              exception-value      102
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CBL_SPLIT_FILENAME Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask 

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101
                perform CHOOSE-FILE
           when 102
                perform SPLIT-FILE-NAME
           end-evaluate.

       CHOOSE-FILE.
           move 1 to opnsav-default-filter
           move "All Files (*.*)" to opnsav-filters
           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data
                                giving opensave-status
           if opensave-status > 0
              modify file-inf value opnsav-filename
           end-if
           .

       SPLIT-FILE-NAME.
           inquire file-inf value in file-name
           set cblte-sj-param-length     to size of cblt-splitjoin-buf
           set cblte-sj-split-buf-len    to size of file-name
           move b#10                     to cblte-sj-split-join-flag1
           call "CBL_SPLIT_FILENAME" using cblt-splitjoin-buf
                                           file-name
                                 returning wstatus

           initialize wrk-path
                      wrk-basename
                      wrk-extension
                      wrk-drive

           evaluate wstatus
           when 0
                if cblte-sj-device-length > 0
                   move file-name 
                       (cblte-sj-device-offset:cblte-sj-device-length)
                                    to wrk-path
                end-if
                if cblte-sj-basename-length > 0
                    move file-name
                     (cblte-sj-basename-offset:cblte-sj-basename-length)
                                    to wrk-basename
                end-if
                if cblte-sj-extension-length > 0
                   move file-name
                   (cblte-sj-extension-offset:cblte-sj-extension-length)
                                    to wrk-extension
                end-if
                evaluate cblte-sj-first-component-length
                when 0
                     continue
                when 1
                     move "Network" to wrk-drive
                     if file-name(2:1) = "\"
                        move "Network" to wrk-drive
                     else
                        move 
                          file-name(1:cblte-sj-first-component-length)
                                    to wrk-drive
                     end-if 
                when other
                     move file-name(1:cblte-sj-first-component-length)
                                    to wrk-drive
                end-evaluate

                display message "Path: "      wrk-path
                                x"0d0a"
                                "Basename: "  wrk-basename
                                x"0d0a"
                                "Extension: " wrk-extension
                                x"0d0a"
                                "Drive: "     wrk-drive 
                         icon   mb-default-icon
                         title  "Splitted file name"
           when 4
                display message "Illegal File name" 
                        icon    mb-warning-icon
           end-evaluate
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .