      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    CCODESET.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status                 special-names crt status pic 9(4).
       77  hWin                          handle of window.
       77  control-font                  handle of font.  
       77  close-win                     pic 9 value 0.
       77  the-ascii-string              pic x(100).
       77  the-ebcdic-string             pic x any length.
       77  the-ebcdic-hex-format-string  pic x any length.
       77  str-len                       pic 9(3).

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  3
              size                 15 cells
              title                "Ascii String:"
              . 
           03 entry-field
              line                 2
              col                  18
              size                 50 cells
              max-text             100
              value                the-ascii-string
              .
           03 push-button
              line                 4
              col                  2
              size                 12 cells
              title                "Convert"
              exception-value      101
              .
           03 frame
              line                 6
              lines                6
              col                  2
              size                 68 cells
              title                "EBCDIC String:"
              .
           03 label
              line                 8
              col                  3
              size                 15 cells
              title                "ASCII format:"
              .
           03 ef-ebcdic
              entry-field
              line                 8
              col                  18
              size                 50 cells
              read-only
              .
           03 label
              line                 10
              col                  3
              size                 15 cells
              title                "HEX format:"
              .
           03 ef-ebcdic-hex
              entry-field
              line                 10
              col                  18
              size                 50 cells
              read-only
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$CODESET Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT
                       
           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              if crt-status = 101
                 perform CODESET
              end-if
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       CODESET.
           move 0 to str-len
           inspect the-ascii-string tallying str-len 
                   for characters before initial trailing spaces
           move the-ascii-string   to the-ebcdic-string
           call "C$CODESET" using 1, str-len, the-ebcdic-string

           if return-code = 0
              modify ef-ebcdic value the-ebcdic-string
              perform CONVERT-TO-HEX
              modify ef-ebcdic-hex value the-ebcdic-hex-format-string 
           else
              display message "An error occurred!" icon mb-warning-icon
           end-if
           .

       CONVERT-TO-HEX.
           call "ASCII2HEX" using the-ebcdic-string, 
                                  the-ebcdic-hex-format-string.


       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if.